/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentBatch;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class CreateBankStatementFromPaymentBatch
extends SvrProcess {
    private int C_PaymentBatch_ID = 0;
    private String p_DocAction = null;
    private Timestamp p_StatementDate = null;

    protected void prepare() {
        this.C_PaymentBatch_ID = this.getProcessInfo().getRecord_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("StatementDate")) {
                    this.p_StatementDate = para[i].getParameterAsTimestamp();
                } else if (name.equals("DocAction")) {
                    this.p_DocAction = para[i].getParameterAsString();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        MBankStatement m_bankStatement;
        StringBuilder sql;
        ResultSet rs;
        CPreparedStatement pstmt;
        int count;
        MPaymentBatch paymentBatch;
        block13: {
            if (this.p_StatementDate == null) {
                return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"StatementDate");
            }
            paymentBatch = new MPaymentBatch(this.getCtx(), this.C_PaymentBatch_ID, this.get_TrxName());
            if (paymentBatch.get_ColumnIndex("JP_BankStatement_ID") != -1 && paymentBatch.get_ValueAsInt("JP_BankStatement_ID") > 0) {
                return Msg.getMsg((Properties)this.getCtx(), (String)"JP_PaymentBatchWrittenBS");
            }
            count = 0;
            pstmt = null;
            rs = null;
            sql = new StringBuilder("SELECT p.* ").append(" FROM C_Payment p").append(" WHERE p.C_PaymentBatch_ID = ? AND p.IsReconciled = 'N' ").append(" ORDER BY p.DocumentNo").append(";");
            boolean isHeaderExists = false;
            m_bankStatement = null;
            MPayment m_Payment = null;
            pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            pstmt.setInt(1, this.C_PaymentBatch_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                m_Payment = new MPayment(this.getCtx(), rs, this.get_TrxName());
                if (m_Payment.getPayAmt().equals(Env.ZERO) || !m_Payment.getDocStatus().equals("CO") && !m_Payment.getDocStatus().equals("CL") || m_Payment.isReconciled()) continue;
                if (!isHeaderExists) {
                    m_bankStatement = new MBankStatement(this.getCtx(), 0, this.get_TrxName());
                    MBankAccount bankAccount = MBankAccount.get((Properties)this.getCtx(), (int)m_Payment.getC_BankAccount_ID());
                    m_bankStatement.setC_BankAccount_ID(bankAccount.getC_BankAccount_ID());
                    m_bankStatement.setBeginningBalance(bankAccount.getCurrentBalance());
                    m_bankStatement.setAD_Org_ID(paymentBatch.getAD_Org_ID());
                    m_bankStatement.setDocAction("CO");
                    m_bankStatement.setDocStatus("DR");
                    m_bankStatement.setStatementDate(this.p_StatementDate);
                    m_bankStatement.setDateAcct(this.p_StatementDate);
                    m_bankStatement.setName(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"C_PaymentBatch_ID")) + " : " + paymentBatch.getDocumentNo());
                    m_bankStatement.setIsManual(false);
                    m_bankStatement.saveEx(this.get_TrxName());
                    isHeaderExists = true;
                } else if (m_bankStatement.getC_BankAccount_ID() != m_Payment.getC_BankAccount_ID()) {
                    String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"C_BankStatement_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"C_BankAccount_ID");
                    String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"C_Payment_ID", (boolean)paymentBatch.get_ValueAsBoolean("IsReceiptJP"))) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"C_BankAccount_ID");
                    String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1});
                    this.log.log(Level.SEVERE, msg);
                    this.addBufferLog(0, null, null, String.valueOf(m_Payment.getDocumentNo()) + " " + msg, 335, m_Payment.getC_Payment_ID());
                    continue;
                }
                MBankStatementLine bankStatementLine = new MBankStatementLine(m_bankStatement);
                bankStatementLine.setStatementLineDate(this.p_StatementDate);
                bankStatementLine.setPayment(m_Payment);
                bankStatementLine.saveEx(this.get_TrxName());
                ++count;
            }
            if (count != 0) break block13;
            String string = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NoPaymentNeedToWriteBS");
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            return string;
        }
        try {
            try {
                if (!Util.isEmpty((String)this.p_DocAction) && !m_bankStatement.processIt(this.p_DocAction)) {
                    throw new Exception(m_bankStatement.getProcessMsg());
                }
                m_bankStatement.saveEx(this.get_TrxName());
                this.addBufferLog(0, null, null, m_bankStatement.getDocumentInfo(), m_bankStatement.get_Table_ID(), m_bankStatement.getC_BankStatement_ID());
                if (paymentBatch.get_ColumnIndex("JP_BankStatement_ID") != -1) {
                    paymentBatch.set_ValueNoCheck("JP_BankStatement_ID", (Object)m_bankStatement.getC_BankStatement_ID());
                }
                paymentBatch.setProcessed(true);
                paymentBatch.saveEx(this.get_TrxName());
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_RegistrationQty")) + " : " + String.valueOf(count);
    }
}

