/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MContractAcct;
import jpiere.base.plugin.org.adempiere.model.MContractBPAcct;
import jpiere.base.plugin.org.adempiere.model.MContractChargeAcct;
import jpiere.base.plugin.org.adempiere.model.MContractProductAcct;
import jpiere.base.plugin.org.adempiere.model.MContractTaxAcct;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class CopyContractAcct
extends SvrProcess {
    private int p_JP_Contract_Acct_ID_From = 0;
    private int p_JP_Contract_Acct_ID_To = 0;
    private int p_C_AcctSchema_ID = 0;
    private String p_JP_CopyContractAcct = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("JP_Contract_Acct_ID")) {
                    this.p_JP_Contract_Acct_ID_From = para[i].getParameterAsInt();
                } else if (name.equals("C_AcctSchema_ID")) {
                    this.p_C_AcctSchema_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_CopyContractAcct")) {
                    this.p_JP_CopyContractAcct = para[i].getParameterAsString();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_JP_Contract_Acct_ID_To = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MContractAcct from = MContractAcct.get(this.getCtx(), this.p_JP_Contract_Acct_ID_From);
        MContractAcct to = MContractAcct.get(this.getCtx(), this.p_JP_Contract_Acct_ID_To);
        if (this.p_JP_CopyContractAcct.equals("BP")) {
            this.copyBPAcct(from, to);
        } else if (this.p_JP_CopyContractAcct.equals("PD")) {
            this.copyProductAcct(from, to);
        } else if (this.p_JP_CopyContractAcct.equals("CH")) {
            this.copyChargeAcct(from, to);
        } else if (this.p_JP_CopyContractAcct.equals("TX")) {
            this.copyTaxAcct(from, to);
        } else if (this.p_JP_CopyContractAcct.equals("AL")) {
            this.copyBPAcct(from, to);
            this.copyProductAcct(from, to);
            this.copyChargeAcct(from, to);
            this.copyTaxAcct(from, to);
        }
        return "OK";
    }

    private String copyBPAcct(MContractAcct from, MContractAcct to) {
        HashMap<Integer, MContractBPAcct> bpAcctFromMaps = from.getAllContractBPAccts(true);
        MContractBPAcct bpAcctFrom = null;
        for (Map.Entry<Integer, MContractBPAcct> entryFrom : bpAcctFromMaps.entrySet()) {
            bpAcctFrom = entryFrom.getValue();
            if (bpAcctFrom.getC_AcctSchema_ID() != this.p_C_AcctSchema_ID) continue;
            HashMap<Integer, MContractBPAcct> bpAcctToMaps = to.getAllContractBPAccts(true);
            boolean isOk = false;
            for (Map.Entry<Integer, MContractBPAcct> entryTo : bpAcctToMaps.entrySet()) {
                if (bpAcctFrom.getC_AcctSchema_ID() != entryTo.getKey().intValue()) continue;
                MContractBPAcct bpAcctTo = entryTo.getValue();
                PO.copyValues((PO)bpAcctFrom, (PO)bpAcctTo);
                bpAcctTo.setJP_Contract_Acct_ID(this.p_JP_Contract_Acct_ID_To);
                bpAcctTo.saveEx(this.get_TrxName());
                isOk = true;
                break;
            }
            if (isOk) continue;
            MContractBPAcct newBPAcct = new MContractBPAcct(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)bpAcctFrom, (PO)newBPAcct);
            newBPAcct.setJP_Contract_Acct_ID(this.p_JP_Contract_Acct_ID_To);
            newBPAcct.saveEx(this.get_TrxName());
        }
        return "OK";
    }

    private String copyProductAcct(MContractAcct from, MContractAcct to) {
        HashMap<String, MContractProductAcct> productAcctFromMaps = from.getAllContractProductAccts(true);
        MContractProductAcct productAcctFrom = null;
        for (Map.Entry<String, MContractProductAcct> entryFrom : productAcctFromMaps.entrySet()) {
            productAcctFrom = entryFrom.getValue();
            if (productAcctFrom.getC_AcctSchema_ID() != this.p_C_AcctSchema_ID) continue;
            HashMap<String, MContractProductAcct> productAcctToMaps = to.getAllContractProductAccts(true);
            MContractProductAcct productAcctTo = null;
            boolean isOk = false;
            for (Map.Entry<String, MContractProductAcct> entryTo : productAcctToMaps.entrySet()) {
                productAcctTo = entryTo.getValue();
                if (productAcctFrom.getC_AcctSchema_ID() != productAcctTo.getC_AcctSchema_ID() || productAcctFrom.getM_Product_Category_ID() != productAcctTo.getM_Product_Category_ID()) continue;
                PO.copyValues((PO)productAcctFrom, (PO)productAcctTo);
                productAcctTo.setJP_Contract_Acct_ID(this.p_JP_Contract_Acct_ID_To);
                productAcctTo.saveEx(this.get_TrxName());
                isOk = true;
                break;
            }
            if (isOk) continue;
            MContractProductAcct newProductAcct = new MContractProductAcct(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)productAcctFrom, (PO)newProductAcct);
            newProductAcct.setJP_Contract_Acct_ID(this.p_JP_Contract_Acct_ID_To);
            newProductAcct.saveEx(this.get_TrxName());
        }
        return "OK";
    }

    private String copyChargeAcct(MContractAcct from, MContractAcct to) {
        HashMap<String, MContractChargeAcct> chargeAcctFromMaps = from.getAllContractChargeAccts(true);
        MContractChargeAcct chargeAcctFrom = null;
        for (Map.Entry<String, MContractChargeAcct> entryFrom : chargeAcctFromMaps.entrySet()) {
            chargeAcctFrom = entryFrom.getValue();
            if (chargeAcctFrom.getC_AcctSchema_ID() != this.p_C_AcctSchema_ID) continue;
            HashMap<String, MContractChargeAcct> chargeAcctToMaps = to.getAllContractChargeAccts(true);
            MContractChargeAcct chargeAcctTo = null;
            boolean isOk = false;
            for (Map.Entry<String, MContractChargeAcct> entryTo : chargeAcctToMaps.entrySet()) {
                chargeAcctTo = entryTo.getValue();
                if (chargeAcctFrom.getC_AcctSchema_ID() != chargeAcctTo.getC_AcctSchema_ID() || chargeAcctFrom.getC_Charge_ID() != chargeAcctTo.getC_Charge_ID()) continue;
                PO.copyValues((PO)chargeAcctFrom, (PO)chargeAcctTo);
                chargeAcctTo.setJP_Contract_Acct_ID(this.p_JP_Contract_Acct_ID_To);
                chargeAcctTo.saveEx(this.get_TrxName());
                isOk = true;
                break;
            }
            if (isOk) continue;
            MContractChargeAcct newChargeAcct = new MContractChargeAcct(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)chargeAcctFrom, (PO)newChargeAcct);
            newChargeAcct.setJP_Contract_Acct_ID(this.p_JP_Contract_Acct_ID_To);
            newChargeAcct.saveEx(this.get_TrxName());
        }
        return "OK";
    }

    private String copyTaxAcct(MContractAcct from, MContractAcct to) {
        HashMap<String, MContractTaxAcct> taxAcctFromMaps = from.getAllContractTaxAccts(true);
        MContractTaxAcct taxAcctFrom = null;
        for (Map.Entry<String, MContractTaxAcct> entryFrom : taxAcctFromMaps.entrySet()) {
            taxAcctFrom = entryFrom.getValue();
            if (taxAcctFrom.getC_AcctSchema_ID() != this.p_C_AcctSchema_ID) continue;
            HashMap<String, MContractTaxAcct> taxAcctToMaps = to.getAllContractTaxAccts(true);
            MContractTaxAcct taxAcctTo = null;
            boolean isOk = false;
            for (Map.Entry<String, MContractTaxAcct> entryTo : taxAcctToMaps.entrySet()) {
                taxAcctTo = entryTo.getValue();
                if (taxAcctFrom.getC_AcctSchema_ID() != taxAcctTo.getC_AcctSchema_ID() || taxAcctFrom.getC_Tax_ID() != taxAcctTo.getC_Tax_ID()) continue;
                PO.copyValues((PO)taxAcctFrom, (PO)taxAcctTo);
                taxAcctTo.setJP_Contract_Acct_ID(this.p_JP_Contract_Acct_ID_To);
                taxAcctTo.saveEx(this.get_TrxName());
                isOk = true;
                break;
            }
            if (isOk) continue;
            MContractTaxAcct newTaxAcct = new MContractTaxAcct(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)taxAcctFrom, (PO)newTaxAcct);
            newTaxAcct.setJP_Contract_Acct_ID(this.p_JP_Contract_Acct_ID_To);
            newTaxAcct.saveEx(this.get_TrxName());
        }
        return "OK";
    }
}

