/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MContract;
import jpiere.base.plugin.org.adempiere.model.MContractCancelTerm;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MContractExtendPeriod;
import jpiere.base.plugin.org.adempiere.model.MContractLog;
import jpiere.base.plugin.org.adempiere.model.MContractLogDetail;
import org.compiere.model.MClient;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class ContractStatusUpdate
extends SvrProcess {
    private int p_AD_Org_ID = 0;
    private int p_JP_ContractCategoryL2_ID = 0;
    private int p_JP_ContractCategoryL1_ID = 0;
    private int p_JP_ContractCategory_ID = 0;
    static volatile HashMap<Integer, Boolean> processingNow = null;
    private Trx conractLogTrx = null;
    private MContractLog m_ContractLog = null;
    private String p_JP_ContractProcessTraceLevel = "TBC";
    private boolean p_IsRecordCommitJP = false;
    LocalDateTime now_LocalDateTime = null;
    Timestamp now_Timestamp = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_ContractCategoryL2_ID")) {
                    this.p_JP_ContractCategoryL2_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_ContractCategoryL1_ID")) {
                    this.p_JP_ContractCategoryL1_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_ContractCategory_ID")) {
                    this.p_JP_ContractCategory_ID = para[i].getParameterAsInt();
                } else if (name.equals("IsRecordCommitJP")) {
                    this.p_IsRecordCommitJP = para[i].getParameterAsBoolean();
                } else if (name.equals("JP_ContractProcessTraceLevel")) {
                    this.p_JP_ContractProcessTraceLevel = para[i].getParameterAsString();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        if (processingNow == null) {
            processingNow = new HashMap();
            MClient[] clients = MClient.getAll((Properties)this.getCtx());
            int i = 0;
            while (i < clients.length) {
                processingNow.put(clients[i].getAD_Client_ID(), false);
                ++i;
            }
        }
        String msg = "";
        try {
            try {
                if (processingNow.get(this.getAD_Client_ID()).booleanValue()) {
                    throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_ContractProcessRunningNow"));
                }
                processingNow.put(this.getAD_Client_ID(), true);
                if (!this.p_JP_ContractProcessTraceLevel.equals("NON")) {
                    String trxName = Trx.createTrxName((String)"ConStUp");
                    this.conractLogTrx = Trx.get((String)trxName, (boolean)false);
                    this.m_ContractLog = new MContractLog(this.getCtx(), 0, this.conractLogTrx.getTrxName());
                    this.m_ContractLog.setJP_ContractProcessTraceLevel(this.p_JP_ContractProcessTraceLevel);
                    this.m_ContractLog.setAD_PInstance_ID(this.getAD_PInstance_ID());
                    this.m_ContractLog.saveEx(this.conractLogTrx.getTrxName());
                    int JP_ContractLog_ID = this.m_ContractLog.getJP_ContractLog_ID();
                    this.addBufferLog(0, null, null, String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_DetailLog")) + " -> " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractLog_ID"), MContractLog.Table_ID, JP_ContractLog_ID);
                    this.conractLogTrx.commit();
                }
                msg = this.doContractStatusUpdate();
            }
            catch (Exception e) {
                if (this.conractLogTrx != null) {
                    msg = this.p_IsRecordCommitJP ? "--Rollback--" : "";
                    this.m_ContractLog.setDescription(String.valueOf(msg) + " Error : " + e.getMessage());
                    this.m_ContractLog.saveEx(this.conractLogTrx.getTrxName());
                    this.conractLogTrx.commit();
                }
                throw e;
            }
        }
        finally {
            processingNow.put(this.getAD_Client_ID(), false);
            if (this.conractLogTrx != null) {
                this.conractLogTrx.close();
                this.conractLogTrx = null;
            }
        }
        return msg;
    }

    private String doContractStatusUpdate() throws Exception {
        this.now_LocalDateTime = new Timestamp(System.currentTimeMillis()).toLocalDateTime();
        this.now_LocalDateTime = this.now_LocalDateTime.minusDays(1L);
        this.now_Timestamp = Timestamp.valueOf(this.now_LocalDateTime);
        MContract[] contracts = this.getContracts();
        MContract contract = null;
        int i = 0;
        while (i < contracts.length) {
            contract = contracts[i];
            if (contract.getJP_ContractStatus().equals("PR") && contract.getJP_ContractPeriodDate_From().compareTo(this.now_Timestamp) >= 0) {
                contract.setJP_ContractStatus("UC");
                contract.saveEx(this.get_TrxName());
            } else if (contract.getJP_ContractPeriodDate_To() != null) {
                if (contract.isAutomaticUpdateJP()) {
                    if (contract.getJP_ContractCancelDate() == null) {
                        if (contract.getJP_ContractCancelDeadline().compareTo(this.now_Timestamp) <= 0) {
                            this.automaticUpdate(contract);
                        }
                        this.checkContractProcStatus(contract);
                    } else if (contract.getJP_ContractPeriodDate_To().compareTo(this.now_Timestamp) <= 0) {
                        this.cancelContract(contract);
                    } else {
                        this.checkContractProcStatus(contract);
                    }
                } else if (contract.getJP_ContractPeriodDate_To() != null) {
                    if (contract.getJP_ContractPeriodDate_To().compareTo(this.now_Timestamp) <= 0) {
                        this.cancelContract(contract);
                    } else {
                        this.checkContractProcStatus(contract);
                    }
                }
            }
            ++i;
        }
        return "OK";
    }

    private MContract[] getContracts() {
        ArrayList<MContract> list;
        block18: {
            list = new ArrayList<MContract>();
            StringBuilder sql = new StringBuilder("SELECT * FROM JP_Contract c WHERE c.DocStatus = 'CO' AND c.JP_ContractStatus IN ('PR' ,'UC')");
            if (this.p_AD_Org_ID > 0) {
                sql.append(" AND c.AD_Org_ID = ? ");
            }
            if (this.p_JP_ContractCategory_ID > 0) {
                sql.append(" AND c.JP_ContractCategory_ID  = ? ");
            } else if (this.p_JP_ContractCategoryL1_ID > 0) {
                sql.append(" AND c.JP_ContractCategoryL1_ID  = ? ");
            } else if (this.p_JP_ContractCategoryL2_ID > 0) {
                sql.append(" AND c.JP_ContractCategoryL2_ID  = ? ");
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), null);
                    int i = 1;
                    if (this.p_AD_Org_ID > 0) {
                        pstmt.setInt(i++, this.p_AD_Org_ID);
                    }
                    if (this.p_JP_ContractCategory_ID > 0) {
                        pstmt.setInt(i++, this.p_JP_ContractCategory_ID);
                    } else if (this.p_JP_ContractCategoryL1_ID > 0) {
                        pstmt.setInt(i++, this.p_JP_ContractCategoryL1_ID);
                    } else if (this.p_JP_ContractCategoryL2_ID > 0) {
                        pstmt.setInt(i++, this.p_JP_ContractCategoryL2_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MContract(this.getCtx(), rs, null));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.toString());
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block18;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        MContract[] contracts = new MContract[list.size()];
        list.toArray(contracts);
        return contracts;
    }

    private void automaticUpdate(MContract contract) {
        LocalDateTime local_ContractPeriodDate_To = contract.getJP_ContractPeriodDate_To().toLocalDateTime();
        MContractExtendPeriod extendPeriod = MContractExtendPeriod.get(this.getCtx(), contract.getJP_ContractExtendPeriod_ID());
        local_ContractPeriodDate_To = local_ContractPeriodDate_To.plusYears(extendPeriod.getJP_Year()).plusMonths(extendPeriod.getJP_Month()).plusDays(extendPeriod.getJP_Day());
        contract.setJP_ContractPeriodDate_To(Timestamp.valueOf(local_ContractPeriodDate_To));
        MContractCancelTerm cancelTerm = MContractCancelTerm.get(this.getCtx(), contract.getJP_ContractCancelTerm_ID());
        LocalDateTime local_ContractCancelDeadline = local_ContractPeriodDate_To.minusYears(cancelTerm.getJP_Year()).minusMonths(cancelTerm.getJP_Month()).minusDays(cancelTerm.getJP_Day());
        contract.setJP_ContractCancelDeadline(Timestamp.valueOf(local_ContractCancelDeadline));
        contract.saveEx(this.get_TrxName());
        MContractLogDetail contractlog = new MContractLogDetail(this.getCtx(), 0, this.m_ContractLog.get_TrxName());
        contractlog.setJP_ContractLog_ID(this.m_ContractLog.getJP_ContractLog_ID());
        contractlog.setJP_ContractLogMsg("S3");
        contractlog.setJP_ContractProcessTraceLevel("TBC");
        contractlog.setJP_Contract_ID(contract.getJP_Contract_ID());
        contractlog.saveEx(this.m_ContractLog.get_TrxName());
    }

    private void cancelContract(MContract contract) {
        String JP_ConstractStatus_From = contract.getJP_ContractStatus();
        contract.setJP_ContractStatus("EC");
        contract.saveEx(this.get_TrxName());
        MContractLogDetail contractlog = new MContractLogDetail(this.getCtx(), 0, this.m_ContractLog.get_TrxName());
        contractlog.setJP_ContractLog_ID(this.m_ContractLog.getJP_ContractLog_ID());
        contractlog.setJP_ContractLogMsg("S1");
        contractlog.setJP_ContractProcessTraceLevel("TBC");
        contractlog.setJP_Contract_ID(contract.getJP_Contract_ID());
        contractlog.setJP_ContractStatus_From(JP_ConstractStatus_From);
        contractlog.setJP_ContractStatus_To("EC");
        contractlog.saveEx(this.m_ContractLog.get_TrxName());
        MContractContent[] contents = contract.getContractContents();
        String JP_ConstractProcStatus_From = null;
        int i = 0;
        while (i < contents.length) {
            if (!contents[i].getJP_ContractProcStatus().equals("PD")) {
                JP_ConstractProcStatus_From = contents[i].getJP_ContractProcStatus();
                contents[i].setJP_ContractProcStatus("PD");
                contents[i].saveEx(this.get_TrxName());
                MContractLogDetail contentLog = new MContractLogDetail(this.getCtx(), 0, this.m_ContractLog.get_TrxName());
                contentLog.setJP_ContractLog_ID(this.m_ContractLog.getJP_ContractLog_ID());
                contentLog.setJP_ContractLogMsg("S2");
                contentLog.setJP_ContractProcessTraceLevel("TBC");
                contentLog.setJP_Contract_ID(contract.getJP_Contract_ID());
                contentLog.setJP_ContractContent_ID(contents[i].getJP_ContractContent_ID());
                contentLog.setJP_ContractProcStatus_From(JP_ConstractProcStatus_From);
                contentLog.setJP_ContractProcStatus_To("PD");
                contentLog.saveEx(this.m_ContractLog.get_TrxName());
            }
            ++i;
        }
    }

    private void checkContractProcStatus(MContract contract) {
        MContractContent[] contents = contract.getContractContents();
        String JP_ConstractProcStatus_From = null;
        int i = 0;
        while (i < contents.length) {
            if (contents[i].getJP_ContractProcDate_To() != null && contents[i].getJP_ContractProcDate_To().compareTo(this.now_Timestamp) <= 0 && !(JP_ConstractProcStatus_From = contents[i].getJP_ContractProcStatus()).equals("PD")) {
                contents[i].setJP_ContractProcStatus("PD");
                contents[i].saveEx(this.get_TrxName());
                MContractLogDetail contentLog = new MContractLogDetail(this.getCtx(), 0, this.m_ContractLog.get_TrxName());
                contentLog.setJP_ContractLog_ID(this.m_ContractLog.getJP_ContractLog_ID());
                contentLog.setJP_ContractLogMsg("S2");
                contentLog.setJP_ContractProcessTraceLevel("TBC");
                contentLog.setJP_Contract_ID(contract.getJP_Contract_ID());
                contentLog.setJP_ContractContent_ID(contents[i].getJP_ContractContent_ID());
                contentLog.setJP_ContractProcStatus_From(JP_ConstractProcStatus_From);
                contentLog.setJP_ContractProcStatus_To("PD");
                contentLog.saveEx(this.m_ContractLog.get_TrxName());
            }
            ++i;
        }
    }
}

