/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MContract;
import jpiere.base.plugin.org.adempiere.model.MContractCalender;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MContractLog;
import jpiere.base.plugin.org.adempiere.model.MContractLogDetail;
import jpiere.base.plugin.org.adempiere.model.MContractProcPeriod;
import jpiere.base.plugin.org.adempiere.model.MContractProcess;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.util.IProcessUI;
import org.adempiere.util.ProcessUtil;
import org.compiere.model.MColumn;
import org.compiere.model.MDocType;
import org.compiere.model.MRefList;
import org.compiere.model.MSession;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;

public class CallContractProcess
extends SvrProcess {
    private String p_JP_ContractProcessUnit = null;
    private int p_JP_ContractProcPeriodG_ID = 0;
    private int p_JP_ContractProcPeriod_ID = 0;
    private String p_JP_ContractProcessValue = null;
    private Timestamp p_DateAcct = null;
    private Timestamp p_DateDoc = null;
    private int p_AD_Org_ID = 0;
    private int p_JP_ContractCategoryL2_ID = 0;
    private int p_JP_ContractCategoryL1_ID = 0;
    private int p_JP_ContractCategory_ID = 0;
    private int p_C_DocType_ID = 0;
    private String p_DocBaseType = null;
    private boolean p_IsCreateBaseDocJP = false;
    private boolean p_IsRecordCommitJP = false;
    private String p_JP_ContractProcessTraceLevel = "WAR";
    private String p_JP_IndirectContractProcType = "AVC";
    private int p_JP_Contract_ID = 0;
    private int p_JP_ContractContent_ID = 0;
    private String p_JP_ContractProcessMethod = null;
    private String p_JP_ContractProcessType = "CD";
    private String p_JP_ContractAutoRenewClass = null;
    private String p_JP_ContractStatusUpdateClass = null;
    private Trx contractLogTrx = null;
    private MContractLog m_ContractLog = null;
    private int successNum = 0;
    private int failureNum = 0;
    private int processContractContentNum = 0;
    private int processContractLineNum = 0;
    private IProcessUI processUI = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("JP_ContractProcessUnit")) {
                    this.p_JP_ContractProcessUnit = para[i].getParameterAsString();
                } else if (name.equals("JP_ContractProcPeriodG_ID")) {
                    this.p_JP_ContractProcPeriodG_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_ContractProcPeriod_ID")) {
                    this.p_JP_ContractProcPeriod_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_ContractProcessValue")) {
                    this.p_JP_ContractProcessValue = para[i].getParameterAsString();
                } else if (name.equals("DateAcct")) {
                    this.p_DateAcct = para[i].getParameterAsTimestamp();
                } else if (name.equals("DateDoc")) {
                    this.p_DateDoc = para[i].getParameterAsTimestamp();
                } else if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_ContractCategoryL2_ID")) {
                    this.p_JP_ContractCategoryL2_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_ContractCategoryL1_ID")) {
                    this.p_JP_ContractCategoryL1_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_ContractCategory_ID")) {
                    this.p_JP_ContractCategory_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_DocType_ID")) {
                    this.p_C_DocType_ID = para[i].getParameterAsInt();
                } else if (name.equals("DocBaseType")) {
                    this.p_DocBaseType = para[i].getParameterAsString();
                } else if (name.equals("IsCreateBaseDocJP")) {
                    this.p_IsCreateBaseDocJP = para[i].getParameterAsBoolean();
                } else if (name.equals("IsRecordCommitJP")) {
                    this.p_IsRecordCommitJP = para[i].getParameterAsBoolean();
                } else if (name.equals("JP_ContractProcessTraceLevel")) {
                    this.p_JP_ContractProcessTraceLevel = para[i].getParameterAsString();
                } else if (name.equals("JP_Contract_ID")) {
                    this.p_JP_Contract_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_ContractContent_ID")) {
                    this.p_JP_ContractContent_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_ContractProcessMethod")) {
                    this.p_JP_ContractProcessMethod = para[i].getParameterAsString();
                } else if (name.equals("JP_IndirectContractProcType")) {
                    this.p_JP_IndirectContractProcType = para[i].getParameterAsString();
                } else if (name.equals("JP_ContractProcessType")) {
                    this.p_JP_ContractProcessType = para[i].getParameterAsString();
                } else if (name.equals("JP_ContractAutoRenewClass")) {
                    this.p_JP_ContractAutoRenewClass = para[i].getParameterAsString();
                } else if (name.equals("JP_ContractStatusUpdateClass")) {
                    this.p_JP_ContractStatusUpdateClass = para[i].getParameterAsString();
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        String msg = "";
        try {
            try {
                if (this.isProcessRunning()) {
                    msg = "@Error@ : " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_ContractProcessRunningNow");
                    throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_ContractProcessRunningNow"));
                }
                if (!this.p_JP_ContractProcessTraceLevel.equals("NON")) {
                    String trxName = Trx.createTrxName((String)"Contract");
                    this.contractLogTrx = Trx.get((String)trxName, (boolean)false);
                    this.m_ContractLog = new MContractLog(this.getCtx(), 0, this.contractLogTrx.getTrxName());
                    this.m_ContractLog.setJP_ContractProcessTraceLevel(this.p_JP_ContractProcessTraceLevel);
                    this.m_ContractLog.setAD_PInstance_ID(this.getAD_PInstance_ID());
                    this.m_ContractLog.setJP_ContractProcessUnit(this.p_JP_ContractProcessUnit);
                    this.m_ContractLog.saveEx(this.contractLogTrx.getTrxName());
                    int JP_ContractLog_ID = this.m_ContractLog.getJP_ContractLog_ID();
                    this.addBufferLog(0, null, null, String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_DetailLog")) + " -> " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractLog_ID"), MContractLog.Table_ID, JP_ContractLog_ID);
                    this.contractLogTrx.commit();
                }
                msg = this.doContractProcess();
            }
            catch (Exception e) {
                if (this.contractLogTrx != null) {
                    msg = this.p_IsRecordCommitJP ? "-- Stop Process for Error --  " : "-- ALL Rollback--   Error : " + e.getMessage();
                    this.m_ContractLog.setDescription(String.valueOf(msg) + " Error : " + e.getMessage());
                    this.m_ContractLog.saveEx(this.contractLogTrx.getTrxName());
                    this.contractLogTrx.commit();
                }
                if (!this.p_IsRecordCommitJP) {
                    this.rollback();
                }
                if (this.contractLogTrx != null) {
                    this.contractLogTrx.close();
                    this.contractLogTrx = null;
                }
            }
        }
        finally {
            if (this.contractLogTrx != null) {
                this.contractLogTrx.close();
                this.contractLogTrx = null;
            }
        }
        return msg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String doContractProcess() throws Exception {
        if (this.p_JP_ContractProcessUnit == null && (this.p_JP_ContractProcessType.equals("CD") || this.p_JP_ContractProcessType.equals("RE"))) {
            String msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcessUnit");
            if (this.contractLogTrx == null) throw new Exception(msg);
            this.m_ContractLog.setDescription(msg);
            this.m_ContractLog.saveEx(this.contractLogTrx.getTrxName());
            this.contractLogTrx.commit();
            throw new Exception(msg);
        }
        if (this.p_JP_ContractProcessType.equals("CD")) {
            if (this.p_JP_ContractProcessUnit.equals("PCC")) {
                int Table_ID = this.getTable_ID();
                int Record_ID = this.getRecord_ID();
                if (Table_ID <= 0) return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotCallContractProcess")) + " Table_ID = 0 or Record_ID = 0";
                if (Record_ID <= 0) {
                    return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotCallContractProcess")) + " Table_ID = 0 or Record_ID = 0";
                }
                MTable m_Table = MTable.get((int)Table_ID);
                this.processContractContentNum = 1;
                if (m_Table != null && m_Table.getTableName().equals("C_Order")) {
                    ArrayList<MContractProcPeriod> contractProcPeriodList;
                    PO m_Order = m_Table.getPO(Record_ID, this.get_TrxName());
                    int C_DocType_ID = m_Order.get_ValueAsInt("C_DocTypeTarget_ID");
                    MDocType m_DocType = MDocType.get((int)C_DocType_ID);
                    if (!"SO".equals(m_DocType.getDocSubTypeSO())) {
                        return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotCallContractProcess")) + Msg.getElement((Properties)this.getCtx(), (String)"DocSubTypeSO") + " - " + MRefList.getListName((Properties)this.getCtx(), (int)148, (String)m_DocType.getDocSubTypeSO());
                    }
                    int JP_ContractContent_ID = m_Order.get_ValueAsInt("JP_ContractContent_ID");
                    if (JP_ContractContent_ID <= 0) {
                        return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotCallContractProcess")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractContent_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Null");
                    }
                    String docStatus = m_Order.get_ValueAsString("DocStatus");
                    if (!docStatus.equals("CO")) {
                        return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotCallContractProcess")) + Msg.getElement((Properties)this.getCtx(), (String)"DocStatus") + " - " + MRefList.getListName((Properties)this.getCtx(), (int)131, (String)docStatus);
                    }
                    MContractContent contractContent = new MContractContent(this.getCtx(), JP_ContractContent_ID, this.get_TrxName());
                    if (!contractContent.getParent().getJP_ContractType().equals("PDC")) {
                        MColumn column = MColumn.get((Properties)this.getCtx(), (String)"JP_Contract", (String)"JP_ContractType");
                        return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotCallContractProcess")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractType") + " - " + MRefList.getListName((Properties)this.getCtx(), (int)column.getAD_Reference_Value_ID(), (String)contractContent.getParent().getJP_ContractType());
                    }
                    if (contractContent.getJP_CreateDerivativeDocPolicy().equals("MA")) {
                        MColumn column = MColumn.get((Properties)this.getCtx(), (String)"JP_ContractContent", (String)"JP_CreateDerivativeDocPolicy");
                        return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotCallContractProcess")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_CreateDerivativeDocPolicy") + " - " + MRefList.getListName((Properties)this.getCtx(), (int)column.getAD_Reference_Value_ID(), (String)contractContent.getJP_CreateDerivativeDocPolicy());
                    }
                    if (!contractContent.getDocStatus().equals("CO") && !contractContent.getDocStatus().equals("CL")) {
                        MColumn column = MColumn.get((Properties)this.getCtx(), (String)"JP_ContractContent", (String)"DocStatus");
                        return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotCallContractProcess")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractContent") + " - " + Msg.getElement((Properties)this.getCtx(), (String)"DocStatus") + " - " + MRefList.getListName((Properties)this.getCtx(), (int)column.getAD_Reference_Value_ID(), (String)contractContent.getDocStatus());
                    }
                    boolean isOSTrx = m_Order.get_ValueAsBoolean("IsSOTrx");
                    if (contractContent.getJP_CreateDerivativeDocPolicy().equals("IO") || contractContent.getJP_CreateDerivativeDocPolicy().equals("BT")) {
                        this.p_DocBaseType = isOSTrx ? "MMS" : "MMR";
                        contractProcPeriodList = this.getInOutContractProcPeriodListFromOrderContractProcPeriod(contractContent, m_Order);
                        for (MContractProcPeriod period : contractProcPeriodList) {
                            this.p_JP_ContractProcPeriod_ID = period.getJP_ContractProcPeriod_ID();
                            if ("DC".equals(contractContent.getJP_ContractProcessMethod())) {
                                this.callCreateDerivativeDocDirectly(contractContent, period);
                                continue;
                            }
                            if (!"IC".equals(contractContent.getJP_ContractProcessMethod())) return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotCallContractProcess")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractContent") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_ContractProcessMethod") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_UnexpectedError");
                            this.callCreateDerivativeDocIndirectly(contractContent, period);
                        }
                    }
                    if (contractContent.getJP_CreateDerivativeDocPolicy().equals("IV") || contractContent.getJP_CreateDerivativeDocPolicy().equals("BT")) {
                        this.p_DocBaseType = isOSTrx ? "ARI" : "API";
                        contractProcPeriodList = this.getInvoiceContractProcPeriodListFromOrderContractProcPeriod(contractContent, m_Order);
                        for (MContractProcPeriod period : contractProcPeriodList) {
                            this.p_JP_ContractProcPeriod_ID = period.getJP_ContractProcPeriod_ID();
                            if ("DC".equals(contractContent.getJP_ContractProcessMethod())) {
                                this.callCreateDerivativeDocDirectly(contractContent, period);
                                continue;
                            }
                            if (!"IC".equals(contractContent.getJP_ContractProcessMethod())) return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotCallContractProcess")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractContent") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_ContractProcessMethod") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_UnexpectedError");
                            this.callCreateDerivativeDocIndirectly(contractContent, period);
                        }
                    }
                } else {
                    if (m_Table == null || !m_Table.getTableName().equals("JP_ContractContent")) return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotCallContractProcess")) + Msg.getElement((Properties)this.getCtx(), (String)"AD_Table_ID") + " - " + (m_Table == null ? Msg.getMsg((Properties)this.getCtx(), (String)"JP_Null") : m_Table.getTableName());
                    MContractContent contractContent = new MContractContent(this.getCtx(), Record_ID, this.get_TrxName());
                    this.processContractLineNum += contractContent.getLines().length;
                    if (this.p_JP_ContractProcessMethod.equals("DC")) {
                        if (contractContent.getParent().getJP_ContractType().equals("STC")) {
                            this.callCreateBaseDocDirectly(contractContent, null);
                        }
                        if (contractContent.getParent().getJP_ContractType().equals("PDC")) {
                            MContractProcPeriod period = null;
                            if (this.p_JP_ContractProcPeriod_ID == 0) {
                                MContractCalender calender = MContractCalender.get(this.getCtx(), contractContent.getJP_ContractCalender_ID());
                                period = calender.getContractProcessPeriod(this.getCtx(), this.p_DateAcct);
                                this.p_JP_ContractProcPeriod_ID = period.getJP_ContractProcPeriod_ID();
                            } else {
                                period = MContractProcPeriod.get(this.getCtx(), this.p_JP_ContractProcPeriod_ID);
                            }
                            if (this.p_IsCreateBaseDocJP) {
                                this.callCreateBaseDocDirectly(contractContent, period);
                            } else {
                                this.callCreateDerivativeDocDirectly(contractContent, period);
                            }
                        }
                    } else {
                        if (!this.p_JP_ContractProcessMethod.equals("IC")) return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotCallContractProcess")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractContent") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_ContractProcessMethod") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_UnexpectedError");
                        if (this.p_DocBaseType.equals("JCS")) {
                            this.callCreateContractProcSchdule(contractContent, null);
                        } else {
                            ArrayList<MContractProcPeriod> contractProcPeriodList = this.getContractProcPeriodList();
                            for (MContractProcPeriod procPeriod : contractProcPeriodList) {
                                if (this.p_IsCreateBaseDocJP) {
                                    this.callCreateBaseDocIndirectly(contractContent, procPeriod);
                                    continue;
                                }
                                this.callCreateDerivativeDocIndirectly(contractContent, procPeriod);
                            }
                        }
                    }
                }
            } else {
                ArrayList<MContractProcPeriod> contractProcPeriodList = this.getContractProcPeriodList();
                for (MContractProcPeriod procPeriod : contractProcPeriodList) {
                    ArrayList<MContractContent> contractContentList = this.getContractContentList(procPeriod);
                    this.processContractContentNum += contractContentList.size();
                    for (MContractContent contractContent : contractContentList) {
                        this.processContractLineNum += contractContent.getLines().length;
                        if (this.p_JP_ContractProcessMethod.equals("DC")) {
                            if (this.p_IsCreateBaseDocJP) {
                                this.callCreateBaseDocDirectly(contractContent, procPeriod);
                                continue;
                            }
                            this.callCreateDerivativeDocDirectly(contractContent, procPeriod);
                            continue;
                        }
                        if (!this.p_JP_ContractProcessMethod.equals("IC")) return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotCallContractProcess")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractContent") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_ContractProcessMethod") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_UnexpectedError");
                        if (this.p_DocBaseType.equals("JCS")) {
                            this.callCreateContractProcSchdule(contractContent, procPeriod);
                            continue;
                        }
                        if (this.p_IsCreateBaseDocJP) {
                            this.callCreateBaseDocIndirectly(contractContent, procPeriod);
                            continue;
                        }
                        this.callCreateDerivativeDocIndirectly(contractContent, procPeriod);
                    }
                }
            }
        } else if (!this.p_JP_ContractProcessType.equals("RE")) {
            if (this.p_JP_ContractProcessType.equals("AR")) {
                ArrayList<MContract> autoRenewContractList = this.getAutoRenewContractList();
                for (MContract autoRenewContract : autoRenewContractList) {
                    this.callAutoRenewContractProcess(autoRenewContract);
                }
            } else if (this.p_JP_ContractProcessType.equals("CS")) {
                ArrayList<MContract> contractStatusUpdateList = this.getContractStatusUpdateList();
                for (MContract contract : contractStatusUpdateList) {
                    this.callContractStatusUpdateProcess(contract);
                }
            }
        }
        if (this.p_JP_ContractProcessTraceLevel.equals("NON")) {
            return "";
        }
        StringBuilder returnMsg = new StringBuilder("");
        if (this.p_JP_ContractProcessType.equals("CD")) {
            returnMsg.append(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CreateDocNum")).append(":").append(this.m_ContractLog.createDocNum).append(" / ");
            returnMsg.append(Msg.getMsg((Properties)this.getCtx(), (String)"JP_ToBeConfirmed")).append(":").append(this.m_ContractLog.confirmNum).append(" / ");
            returnMsg.append(Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfWarnings")).append(":").append(this.m_ContractLog.warnNum).append(" / ");
            returnMsg.append(Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfErrors")).append(":").append(this.m_ContractLog.errorNum).append(" / ");
            returnMsg.append(Msg.getMsg((Properties)this.getCtx(), (String)"JP_SkipNum_ContractContent")).append(":").append(this.m_ContractLog.skipContractContentNum).append(" / ");
            returnMsg.append(Msg.getMsg((Properties)this.getCtx(), (String)"JP_SkipNum_ContractLine")).append(":").append(this.m_ContractLog.skipContractLineNum).append("  ");
        } else if (!this.p_JP_ContractProcessType.equals("RE")) {
            if (this.p_JP_ContractProcessType.equals("AR")) {
                returnMsg.append(Msg.getMsg((Properties)this.getCtx(), (String)"JP_ToBeConfirmed")).append(":").append(this.m_ContractLog.confirmNum).append(" / ");
                returnMsg.append(Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfWarnings")).append(":").append(this.m_ContractLog.warnNum).append(" / ");
                returnMsg.append(Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfErrors")).append(":").append(this.m_ContractLog.errorNum).append(" / ");
            } else if (this.p_JP_ContractProcessType.equals("CS")) {
                returnMsg.append(Msg.getMsg((Properties)this.getCtx(), (String)"JP_ToBeConfirmed")).append(":").append(this.m_ContractLog.confirmNum).append(" / ");
                returnMsg.append(Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfWarnings")).append(":").append(this.m_ContractLog.warnNum).append(" / ");
                returnMsg.append(Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfErrors")).append(":").append(this.m_ContractLog.errorNum).append(" / ");
            }
        }
        StringBuilder systemProcessLog = new StringBuilder("");
        if (this.p_JP_ContractProcessType.equals("CD")) {
            systemProcessLog.append(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success")).append(":").append(this.successNum).append(" / ");
            systemProcessLog.append(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure")).append(":").append(this.failureNum).append("  / ");
            systemProcessLog.append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractContent_ID")).append(":").append(this.processContractContentNum).append(" / ");
            systemProcessLog.append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractLine_ID")).append(":").append(this.processContractLineNum).append(" ");
        } else if (!this.p_JP_ContractProcessType.equals("RE")) {
            if (this.p_JP_ContractProcessType.equals("AR")) {
                systemProcessLog.append(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success")).append(":").append(this.successNum).append(" / ");
                systemProcessLog.append(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure")).append(":").append(this.failureNum).append("  / ");
            } else if (this.p_JP_ContractProcessType.equals("CS")) {
                systemProcessLog.append(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success")).append(":").append(this.successNum).append(" / ");
                systemProcessLog.append(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure")).append(":").append(this.failureNum).append("  / ");
            }
        }
        if (this.contractLogTrx == null) return returnMsg.toString();
        if (Util.isEmpty((String)this.m_ContractLog.getDescription())) {
            this.m_ContractLog.setDescription(String.valueOf(returnMsg.toString()) + " [ *** System Process Log *** " + systemProcessLog.toString() + " ]");
        } else {
            this.m_ContractLog.setDescription(String.valueOf(this.m_ContractLog.getDescription()) + "   " + returnMsg.toString() + " [ " + systemProcessLog.toString() + " ]");
        }
        this.m_ContractLog.save(this.contractLogTrx.getTrxName());
        this.contractLogTrx.commit();
        this.contractLogTrx.close();
        this.contractLogTrx = null;
        return returnMsg.toString();
    }

    private ArrayList<MContractProcPeriod> getContractProcPeriodList() throws Exception {
        ArrayList<MContractProcPeriod> contractProcPeriodList = new ArrayList<MContractProcPeriod>();
        if (this.p_JP_ContractProcessUnit.equals("DDT")) {
            String getProcPeriodSql = "SELECT * FROM JP_ContractProcPeriod WHERE AD_Client_ID = ? AND DateDoc = ?  AND IsActive='Y' ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)getProcPeriodSql, null);
                    pstmt.setInt(1, this.getAD_Client_ID());
                    pstmt.setTimestamp(2, this.p_DateDoc);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        contractProcPeriodList.add(new MContractProcPeriod(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    throw new Exception(e);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        } else if (this.p_JP_ContractProcessUnit.equals("DAT")) {
            String getProcPeriodSql = "SELECT * FROM JP_ContractProcPeriod WHERE AD_Client_ID = ? AND DateAcct = ? AND IsActive='Y' ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)getProcPeriodSql, null);
                    pstmt.setInt(1, this.getAD_Client_ID());
                    pstmt.setTimestamp(2, this.p_DateAcct);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        contractProcPeriodList.add(new MContractProcPeriod(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    throw new Exception(e);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        } else if (this.p_JP_ContractProcessUnit.equals("CPP")) {
            contractProcPeriodList.add(new MContractProcPeriod(this.getCtx(), this.p_JP_ContractProcPeriod_ID, this.get_TrxName()));
        } else if (this.p_JP_ContractProcessUnit.equals("CPV")) {
            String getProcPeriodSql = "SELECT * FROM JP_ContractProcPeriod WHERE AD_Client_ID = ? AND JP_ContractProcessValue = ? AND IsActive='Y' ORDER BY StartDate ASC, DateAcct ASC ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)getProcPeriodSql, null);
                    pstmt.setInt(1, this.getAD_Client_ID());
                    pstmt.setString(2, this.p_JP_ContractProcessValue);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        contractProcPeriodList.add(new MContractProcPeriod(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    throw new Exception(e);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        } else if (this.p_JP_ContractProcessUnit.equals("GPP")) {
            String getProcPeriodSql = "SELECT * FROM JP_ContractProcPeriod WHERE AD_Client_ID = ? AND JP_ContractProcPeriodG_ID = ? AND IsActive='Y' ORDER BY StartDate ASC, DateAcct ASC  ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)getProcPeriodSql, null);
                    pstmt.setInt(1, this.getAD_Client_ID());
                    pstmt.setInt(2, this.p_JP_ContractProcPeriodG_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        contractProcPeriodList.add(new MContractProcPeriod(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    throw new Exception(e);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        } else if (this.p_JP_ContractProcessUnit.equals("GPV")) {
            String getProcPeriodSql = "SELECT c.* FROM JP_ContractProcPeriod c INNER JOIN JP_ContractProcPeriodG g ON (c.JP_ContractProcPeriodG_ID = g.JP_ContractProcPeriodG_ID)  WHERE c.AD_Client_ID = ? AND g.JP_ContractProcessValue = ? AND c.IsActive='Y' AND g.IsActive='Y' ORDER BY c.StartDate ASC , c.DateAcct ASC ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)getProcPeriodSql, null);
                    pstmt.setInt(1, this.getAD_Client_ID());
                    pstmt.setString(2, this.p_JP_ContractProcessValue);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        contractProcPeriodList.add(new MContractProcPeriod(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    throw new Exception(e);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            Object var3_11 = null;
        }
        return contractProcPeriodList;
    }

    private ArrayList<MContractProcPeriod> getInOutContractProcPeriodListFromOrderContractProcPeriod(MContractContent contractContent, PO m_Order) throws Exception {
        ArrayList<MContractProcPeriod> contractProcPeriodList;
        block6: {
            int JP_ContractProcPeriod_ID = m_Order.get_ValueAsInt("JP_ContractProcPeriod_ID");
            MContractProcPeriod orderContractProcPeriod = MContractProcPeriod.get(this.getCtx(), JP_ContractProcPeriod_ID);
            Timestamp startdate = null;
            startdate = contractContent.getJP_ContractProcDate_To() == null ? orderContractProcPeriod.getEndDate() : (contractContent.getJP_ContractProcDate_To().compareTo(orderContractProcPeriod.getEndDate()) > 0 ? orderContractProcPeriod.getEndDate() : contractContent.getJP_ContractProcDate_To());
            Timestamp endDate = null;
            endDate = contractContent.getJP_ContractProcDate_From().compareTo(orderContractProcPeriod.getStartDate()) > 0 ? contractContent.getJP_ContractProcDate_From() : orderContractProcPeriod.getStartDate();
            contractProcPeriodList = new ArrayList<MContractProcPeriod>();
            StringBuilder sql = new StringBuilder("SELECT DISTINCT cpp.* FROM JP_ContractProcPeriod cpp ").append(" INNER JOIN adempiere.JP_ContractCalender cc ON (cpp.JP_ContractCalender_ID=cc.JP_ContractCalender_ID) ").append(" INNER JOIN adempiere.JP_ContractLine cl ON (cc.JP_ContractCalender_ID=cl.JP_ContractCalender_InOut_ID) ").append(" WHERE cpp.StartDate <= ? AND cpp.EndDate >= ? AND cl.JP_ContractContent_ID=? ");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), null);
                    pstmt.setTimestamp(1, startdate);
                    pstmt.setTimestamp(2, endDate);
                    pstmt.setInt(3, contractContent.getJP_ContractContent_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        contractProcPeriodList.add(new MContractProcPeriod(this.getCtx(), rs, null));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.toString());
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return contractProcPeriodList;
    }

    private ArrayList<MContractProcPeriod> getInvoiceContractProcPeriodListFromOrderContractProcPeriod(MContractContent contractContent, PO m_Order) throws Exception {
        ArrayList<MContractProcPeriod> contractProcPeriodList;
        block6: {
            int JP_ContractProcPeriod_ID = m_Order.get_ValueAsInt("JP_ContractProcPeriod_ID");
            MContractProcPeriod orderContractProcPeriod = MContractProcPeriod.get(this.getCtx(), JP_ContractProcPeriod_ID);
            Timestamp startdate = null;
            startdate = contractContent.getJP_ContractProcDate_To() == null ? orderContractProcPeriod.getEndDate() : (contractContent.getJP_ContractProcDate_To().compareTo(orderContractProcPeriod.getEndDate()) > 0 ? orderContractProcPeriod.getEndDate() : contractContent.getJP_ContractProcDate_To());
            Timestamp endDate = null;
            endDate = contractContent.getJP_ContractProcDate_From().compareTo(orderContractProcPeriod.getStartDate()) > 0 ? contractContent.getJP_ContractProcDate_From() : orderContractProcPeriod.getStartDate();
            contractProcPeriodList = new ArrayList<MContractProcPeriod>();
            StringBuilder sql = new StringBuilder("SELECT DISTINCT cpp.* FROM JP_ContractProcPeriod cpp ").append(" INNER JOIN adempiere.JP_ContractCalender cc ON (cpp.JP_ContractCalender_ID=cc.JP_ContractCalender_ID) ").append(" INNER JOIN adempiere.JP_ContractLine cl ON (cc.JP_ContractCalender_ID=cl.JP_ContractCalender_Inv_ID) ").append(" WHERE cpp.StartDate <= ? AND cpp.EndDate >= ? AND cl.JP_ContractContent_ID=? ");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), null);
                    pstmt.setTimestamp(1, startdate);
                    pstmt.setTimestamp(2, endDate);
                    pstmt.setInt(3, contractContent.getJP_ContractContent_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        contractProcPeriodList.add(new MContractProcPeriod(this.getCtx(), rs, null));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.toString());
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return contractProcPeriodList;
    }

    private ArrayList<MContract> getAutoRenewContractList() throws Exception {
        ArrayList<MContract> list;
        block14: {
            list = new ArrayList<MContract>();
            StringBuilder sql = new StringBuilder("SELECT c.* FROM JP_Contract c ").append(" INNER JOIN JP_ContractCategory cc ON (c.JP_ContractCategory_ID=cc.JP_ContractCategory_ID) ").append(" LEFT OUTER JOIN JP_ContractCategoryL1 l1 ON (cc.JP_ContractCategoryL1_ID=l1.JP_ContractCategoryL1_ID) ").append(" WHERE c.DocStatus = 'CO' AND c.JP_ContractStatus IN ('PR' ,'UC') ").append(" AND c.IsAutomaticUpdateJP='Y' ").append(" AND c.JP_ContractCancelDate IS NULL AND c.JP_ContractCancelDeadline < ?  ");
            LocalDateTime now_LocalDateTime = new Timestamp(System.currentTimeMillis()).toLocalDateTime();
            now_LocalDateTime = now_LocalDateTime.minusDays(1L);
            Timestamp now_Timestamp = Timestamp.valueOf(now_LocalDateTime);
            if (this.p_AD_Org_ID > 0) {
                sql.append(" AND c.AD_Org_ID = ? ");
            }
            if (this.p_JP_ContractCategoryL2_ID > 0) {
                sql.append(" AND l1.JP_ContractCategoryL2_ID  = ? ");
                if (this.p_JP_ContractCategoryL1_ID > 0) {
                    sql.append(" AND cc.JP_ContractCategoryL1_ID  = ? ");
                    if (this.p_JP_ContractCategory_ID > 0) {
                        sql.append(" AND c.JP_ContractCategory_ID  = ? ");
                    }
                }
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), null);
                    int i = 1;
                    pstmt.setTimestamp(i++, now_Timestamp);
                    if (this.p_AD_Org_ID > 0) {
                        pstmt.setInt(i++, this.p_AD_Org_ID);
                    }
                    if (this.p_JP_ContractCategoryL2_ID > 0) {
                        pstmt.setInt(i++, this.p_JP_ContractCategoryL2_ID);
                        if (this.p_JP_ContractCategoryL1_ID > 0) {
                            pstmt.setInt(i++, this.p_JP_ContractCategoryL1_ID);
                            if (this.p_JP_ContractCategory_ID > 0) {
                                pstmt.setInt(i++, this.p_JP_ContractCategory_ID);
                            }
                        }
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MContract(this.getCtx(), rs, null));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.toString());
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block14;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return list;
    }

    private ArrayList<MContract> getContractStatusUpdateList() throws Exception {
        ArrayList<MContract> list;
        block14: {
            list = new ArrayList<MContract>();
            StringBuilder sql = new StringBuilder("SELECT c.* FROM JP_Contract c").append(" INNER JOIN JP_ContractCategory cc ON (c.JP_ContractCategory_ID=cc.JP_ContractCategory_ID) ").append(" LEFT OUTER JOIN JP_ContractCategoryL1 l1 ON (cc.JP_ContractCategoryL1_ID=l1.JP_ContractCategoryL1_ID) ").append(" WHERE c.DocStatus = 'CO' AND c.JP_ContractStatus IN ('PR' ,'UC') ");
            if (this.p_AD_Org_ID > 0) {
                sql.append(" AND c.AD_Org_ID = ? ");
            }
            if (this.p_JP_ContractCategoryL2_ID > 0) {
                sql.append(" AND l1.JP_ContractCategoryL2_ID  = ? ");
                if (this.p_JP_ContractCategoryL1_ID > 0) {
                    sql.append(" AND cc.JP_ContractCategoryL1_ID  = ? ");
                    if (this.p_JP_ContractCategory_ID > 0) {
                        sql.append(" AND c.JP_ContractCategory_ID  = ? ");
                    }
                }
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), null);
                    int i = 1;
                    if (this.p_AD_Org_ID > 0) {
                        pstmt.setInt(i++, this.p_AD_Org_ID);
                    }
                    if (this.p_JP_ContractCategoryL2_ID > 0) {
                        pstmt.setInt(i++, this.p_JP_ContractCategoryL2_ID);
                        if (this.p_JP_ContractCategoryL1_ID > 0) {
                            pstmt.setInt(i++, this.p_JP_ContractCategoryL1_ID);
                            if (this.p_JP_ContractCategory_ID > 0) {
                                pstmt.setInt(i++, this.p_JP_ContractCategory_ID);
                            }
                        }
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MContract(this.getCtx(), rs, null));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.toString());
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block14;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return list;
    }

    private ArrayList<MContractContent> getContractContentList(MContractProcPeriod procPeriod) throws Exception {
        if (this.p_JP_ContractProcessMethod.equals("DC")) {
            return this.getContractContentList_DirectContractProcess(procPeriod);
        }
        if (this.p_JP_ContractProcessMethod.equals("IC")) {
            if (this.p_JP_IndirectContractProcType.equals("VCI")) {
                return this.getContractContentList_ValidContractProcessScheduleInValidContractDoc(procPeriod);
            }
            if (this.p_JP_IndirectContractProcType.equals("AVC")) {
                return this.getContractContentList_AllValidContractProcessSchedule(procPeriod);
            }
        }
        return null;
    }

    private ArrayList<MContractContent> getContractContentList_DirectContractProcess(MContractProcPeriod procPeriod) throws Exception {
        StringBuilder getContractContentSQL = new StringBuilder("");
        if (this.p_IsCreateBaseDocJP) {
            getContractContentSQL.append("SELECT cc.* FROM JP_ContractContent cc  INNER JOIN JP_Contract c ON (cc.JP_Contract_ID = C.JP_Contract_ID) WHERE cc.AD_Client_ID = ? AND c.JP_ContractType = 'PDC' AND c.DocStatus = 'CO' AND c.JP_ContractStatus IN ('PR','UC') AND cc.DocStatus = 'CO' AND cc.JP_ContractProcStatus IN ('UN','IP') AND cc.JP_ContractCalender_ID = ? AND cc.JP_ContractProcDate_From <=? AND (cc.JP_ContractProcDate_To is null or cc.JP_ContractProcDate_To >=?) ");
        } else if (this.p_DocBaseType.equals("MMS") || this.p_DocBaseType.equals("MMR")) {
            getContractContentSQL.append("SELECT DISTINCT cc.* FROM JP_ContractContent cc  INNER JOIN JP_Contract c ON (cc.JP_Contract_ID = C.JP_Contract_ID) INNER JOIN JP_ContractLine cl ON (cc.JP_ContractContent_ID = Cl.JP_ContractContent_ID) WHERE cc.AD_Client_ID = ? AND c.JP_ContractType = 'PDC' AND c.DocStatus = 'CO' AND c.JP_ContractStatus IN ('PR','UC') AND cc.DocStatus = 'CO' AND cc.JP_ContractProcStatus = 'IP'  AND cl.JP_ContractCalender_InOut_ID = ? AND cc.JP_ContractProcDate_From <=? AND (cc.JP_ContractProcDate_To is null or cc.JP_ContractProcDate_To >=?) AND cc.JP_CreateDerivativeDocPolicy IN ('BT','IO') ");
        } else if (this.p_DocBaseType.equals("ARI") || this.p_DocBaseType.equals("API")) {
            getContractContentSQL.append("SELECT DISTINCT cc.* FROM JP_ContractContent cc  INNER JOIN JP_Contract c ON (cc.JP_Contract_ID = C.JP_Contract_ID) INNER JOIN JP_ContractLine cl ON (cc.JP_ContractContent_ID = Cl.JP_ContractContent_ID) WHERE cc.AD_Client_ID = ? AND c.JP_ContractType = 'PDC' AND c.DocStatus = 'CO' AND c.JP_ContractStatus IN ('PR','UC') AND cc.DocStatus = 'CO' AND cc.JP_ContractProcStatus = 'IP'  AND cl.JP_ContractCalender_Inv_ID = ? AND cc.JP_ContractProcDate_From <=? AND (cc.JP_ContractProcDate_To is null or cc.JP_ContractProcDate_To >=?) AND cc.JP_CreateDerivativeDocPolicy IN ('BT','IV') ");
        }
        if (this.p_AD_Org_ID > 0) {
            getContractContentSQL.append(" AND cc.AD_Org_ID = ? ");
        }
        if (this.p_JP_ContractCategory_ID > 0) {
            getContractContentSQL.append(" AND c.JP_ContractCategory_ID = ? ");
        }
        if (this.p_C_DocType_ID > 0) {
            getContractContentSQL.append(" AND cc.C_DocType_ID = ? ");
        }
        if (this.p_JP_Contract_ID > 0) {
            getContractContentSQL.append(" AND c.JP_Contract_ID = ? ");
        }
        if (this.p_JP_ContractContent_ID > 0) {
            getContractContentSQL.append(" AND cc.JP_ContractContent_ID = ? ");
        }
        if (this.p_IsCreateBaseDocJP) {
            getContractContentSQL.append(" AND cc.DocBaseType = ? ");
        } else if (this.p_DocBaseType.equals("MMS") || this.p_DocBaseType.equals("ARI")) {
            getContractContentSQL.append(" AND cc.DocBaseType ='SOO' ");
        } else if (this.p_DocBaseType.equals("MMR") || this.p_DocBaseType.equals("API")) {
            getContractContentSQL.append(" AND cc.DocBaseType ='POO' ");
        }
        getContractContentSQL.append(" AND cc.JP_ContractProcessMethod ='DC' ");
        ArrayList<MContractContent> contractContentList = new ArrayList<MContractContent>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)getContractContentSQL.toString(), null);
                int i = 1;
                pstmt.setInt(i++, this.getAD_Client_ID());
                pstmt.setInt(i++, procPeriod.getJP_ContractCalender_ID());
                pstmt.setTimestamp(i++, procPeriod.getEndDate());
                pstmt.setTimestamp(i++, procPeriod.getStartDate());
                if (this.p_AD_Org_ID > 0) {
                    pstmt.setInt(i++, this.p_AD_Org_ID);
                }
                if (this.p_JP_ContractCategory_ID > 0) {
                    pstmt.setInt(i++, this.p_JP_ContractCategory_ID);
                }
                if (this.p_C_DocType_ID > 0) {
                    pstmt.setInt(i++, this.p_C_DocType_ID);
                }
                if (this.p_JP_Contract_ID > 0) {
                    pstmt.setInt(i++, this.p_JP_Contract_ID);
                }
                if (this.p_JP_ContractContent_ID > 0) {
                    pstmt.setInt(i++, this.p_JP_ContractContent_ID);
                }
                if (this.p_IsCreateBaseDocJP) {
                    pstmt.setString(i++, this.p_DocBaseType);
                }
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    contractContentList.add(new MContractContent(this.getCtx(), rs, this.get_TrxName()));
                }
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return contractContentList;
    }

    private ArrayList<MContractContent> getContractContentList_ValidContractProcessScheduleInValidContractDoc(MContractProcPeriod procPeriod) throws Exception {
        StringBuilder getContractContentSQL = new StringBuilder("");
        if (this.p_IsCreateBaseDocJP || this.p_DocBaseType.equals("JCS")) {
            getContractContentSQL.append("SELECT cc.* FROM JP_ContractContent cc  INNER JOIN JP_Contract c ON (cc.JP_Contract_ID = C.JP_Contract_ID) WHERE cc.AD_Client_ID = ? AND c.JP_ContractType = 'PDC' AND c.DocStatus = 'CO' AND c.JP_ContractStatus IN ('PR','UC') AND cc.DocStatus = 'CO' AND cc.JP_ContractProcStatus IN ('UN','IP') AND cc.JP_ContractCalender_ID = ? AND cc.JP_ContractProcDate_From <=? AND (cc.JP_ContractProcDate_To is null or cc.JP_ContractProcDate_To >=?) ");
        } else if (this.p_DocBaseType.equals("MMS") || this.p_DocBaseType.equals("MMR")) {
            getContractContentSQL.append("SELECT DISTINCT cc.* FROM JP_ContractContent cc  INNER JOIN JP_Contract c ON (cc.JP_Contract_ID = C.JP_Contract_ID) INNER JOIN JP_ContractLine cl ON (cc.JP_ContractContent_ID = Cl.JP_ContractContent_ID) WHERE cc.AD_Client_ID = ? AND c.JP_ContractType = 'PDC' AND c.DocStatus = 'CO' AND c.JP_ContractStatus IN ('PR','UC') AND cc.DocStatus = 'CO' AND cc.JP_ContractProcStatus = 'IP'  AND cl.JP_ContractCalender_InOut_ID = ? AND cc.JP_ContractProcDate_From <=? AND (cc.JP_ContractProcDate_To is null or cc.JP_ContractProcDate_To >=?) AND cc.JP_CreateDerivativeDocPolicy IN ('BT','IO') ");
        } else if (this.p_DocBaseType.equals("ARI") || this.p_DocBaseType.equals("API")) {
            getContractContentSQL.append("SELECT DISTINCT cc.* FROM JP_ContractContent cc  INNER JOIN JP_Contract c ON (cc.JP_Contract_ID = C.JP_Contract_ID) INNER JOIN JP_ContractLine cl ON (cc.JP_ContractContent_ID = Cl.JP_ContractContent_ID) WHERE cc.AD_Client_ID = ? AND c.JP_ContractType = 'PDC' AND c.DocStatus = 'CO' AND c.JP_ContractStatus IN ('PR','UC') AND cc.DocStatus = 'CO' AND cc.JP_ContractProcStatus = 'IP'  AND cl.JP_ContractCalender_Inv_ID = ? AND cc.JP_ContractProcDate_From <=? AND (cc.JP_ContractProcDate_To is null or cc.JP_ContractProcDate_To >=?) AND cc.JP_CreateDerivativeDocPolicy IN ('BT','IV') ");
        }
        if (this.p_AD_Org_ID > 0) {
            getContractContentSQL.append(" AND cc.AD_Org_ID = ? ");
        }
        if (this.p_JP_ContractCategory_ID > 0) {
            getContractContentSQL.append(" AND c.JP_ContractCategory_ID = ? ");
        }
        if (this.p_C_DocType_ID > 0) {
            getContractContentSQL.append(" AND cc.C_DocType_ID = ? ");
        }
        if (this.p_JP_Contract_ID > 0) {
            getContractContentSQL.append(" AND c.JP_Contract_ID = ? ");
        }
        if (this.p_JP_ContractContent_ID > 0) {
            getContractContentSQL.append(" AND cc.JP_ContractContent_ID = ? ");
        }
        if (!this.p_DocBaseType.equals("JCS")) {
            if (this.p_IsCreateBaseDocJP) {
                getContractContentSQL.append(" AND cc.DocBaseType = ? ");
            } else if (this.p_DocBaseType.equals("MMS") || this.p_DocBaseType.equals("ARI")) {
                getContractContentSQL.append(" AND cc.DocBaseType ='SOO' ");
            } else if (this.p_DocBaseType.equals("MMR") || this.p_DocBaseType.equals("API")) {
                getContractContentSQL.append(" AND cc.DocBaseType ='POO' ");
            }
        }
        getContractContentSQL.append(" AND cc.JP_ContractProcessMethod ='IC' ");
        ArrayList<MContractContent> contractContentList = new ArrayList<MContractContent>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)getContractContentSQL.toString(), null);
                int i = 1;
                pstmt.setInt(i++, this.getAD_Client_ID());
                pstmt.setInt(i++, procPeriod.getJP_ContractCalender_ID());
                pstmt.setTimestamp(i++, procPeriod.getEndDate());
                pstmt.setTimestamp(i++, procPeriod.getStartDate());
                if (this.p_AD_Org_ID > 0) {
                    pstmt.setInt(i++, this.p_AD_Org_ID);
                }
                if (this.p_JP_ContractCategory_ID > 0) {
                    pstmt.setInt(i++, this.p_JP_ContractCategory_ID);
                }
                if (this.p_C_DocType_ID > 0) {
                    pstmt.setInt(i++, this.p_C_DocType_ID);
                }
                if (this.p_JP_Contract_ID > 0) {
                    pstmt.setInt(i++, this.p_JP_Contract_ID);
                }
                if (this.p_JP_ContractContent_ID > 0) {
                    pstmt.setInt(i++, this.p_JP_ContractContent_ID);
                }
                if (!this.p_DocBaseType.equals("JCS") && this.p_IsCreateBaseDocJP) {
                    pstmt.setString(i++, this.p_DocBaseType);
                }
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    contractContentList.add(new MContractContent(this.getCtx(), rs, this.get_TrxName()));
                }
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return contractContentList;
    }

    private ArrayList<MContractContent> getContractContentList_AllValidContractProcessSchedule(MContractProcPeriod procPeriod) throws Exception {
        StringBuilder getContractContentSQL = new StringBuilder("");
        if (this.p_DocBaseType.equals("JCS")) {
            getContractContentSQL.append("SELECT cc.* FROM JP_ContractContent cc  INNER JOIN JP_Contract c ON (cc.JP_Contract_ID = C.JP_Contract_ID) WHERE cc.AD_Client_ID = ? AND c.JP_ContractType = 'PDC' AND c.DocStatus = 'CO' AND c.JP_ContractStatus IN ('PR','UC') AND cc.DocStatus = 'CO' AND cc.JP_ContractProcStatus IN ('UN') AND cc.IsScheduleCreatedJP = 'N'  AND cc.JP_ContractCalender_ID = ? AND cc.JP_ContractProcDate_From <=? AND (cc.JP_ContractProcDate_To is null or cc.JP_ContractProcDate_To >=?) AND cc.JP_ContractProcessMethod ='IC'  ");
        } else if (this.p_IsCreateBaseDocJP) {
            getContractContentSQL.append("SELECT cc.* FROM JP_ContractContent cc  INNER JOIN JP_Contract c ON (cc.JP_Contract_ID = c.JP_Contract_ID) INNER JOIN JP_ContractProcSchedule cps ON (cc.JP_ContractContent_ID = cps.JP_ContractContent_ID) WHERE cc.AD_Client_ID = ? AND c.JP_ContractType = 'PDC' AND cps.DocStatus = 'CO'  AND cps.IsFactCreatedJP = 'N'  AND cps.JP_ContractCalender_ID = ? AND cps.JP_ContractProcPeriod_ID = ? ");
        } else if (this.p_DocBaseType.equals("MMS") || this.p_DocBaseType.equals("MMR")) {
            getContractContentSQL.append("SELECT DISTINCT cc.* FROM JP_ContractContent cc  INNER JOIN JP_Contract c ON (cc.JP_Contract_ID = C.JP_Contract_ID) INNER JOIN JP_ContractProcSchedule cps ON (cc.JP_ContractContent_ID = cps.JP_ContractContent_ID) INNER JOIN JP_ContractPSInOutLine cpsl ON (cps.JP_ContractProcSchedule_ID = cpsl.JP_ContractProcSchedule_ID) WHERE cc.AD_Client_ID = ? AND c.JP_ContractType = 'PDC' AND cps.DocStatus = 'CO'  AND cpsl.IsFactCreatedJP = 'N'  AND cpsl.JP_ContractCalender_InOut_ID = ? AND cpsl.JP_ContractProcPeriod_ID = ? AND cps.JP_CreateDerivativeDocPolicy IN ('BT','IO') ");
        } else if (this.p_DocBaseType.equals("ARI") || this.p_DocBaseType.equals("API")) {
            getContractContentSQL.append("SELECT DISTINCT cc.* FROM JP_ContractContent cc  INNER JOIN JP_Contract c ON (cc.JP_Contract_ID = C.JP_Contract_ID) INNER JOIN JP_ContractProcSchedule cps ON (cc.JP_ContractContent_ID = cps.JP_ContractContent_ID) INNER JOIN JP_ContractPSInvoiceLine cpsl ON (cps.JP_ContractProcSchedule_ID = cpsl.JP_ContractProcSchedule_ID) WHERE cc.AD_Client_ID = ? AND c.JP_ContractType = 'PDC' AND cps.DocStatus = 'CO'  AND cpsl.IsFactCreatedJP = 'N'  AND cpsl.JP_ContractCalender_Inv_ID = ? AND cpsl.JP_ContractProcPeriod_ID = ? AND cps.JP_CreateDerivativeDocPolicy IN ('BT','IO') ");
        }
        if (this.p_AD_Org_ID > 0) {
            getContractContentSQL.append(" AND cps.AD_Org_ID = ? ");
        }
        if (this.p_JP_ContractCategory_ID > 0) {
            getContractContentSQL.append(" AND c.JP_ContractCategory_ID = ? ");
        }
        if (this.p_C_DocType_ID > 0) {
            getContractContentSQL.append(" AND cc.C_DocType_ID = ? ");
        }
        if (this.p_JP_Contract_ID > 0) {
            getContractContentSQL.append(" AND c.JP_Contract_ID = ? ");
        }
        if (this.p_JP_ContractContent_ID > 0) {
            getContractContentSQL.append(" AND cc.JP_ContractContent_ID = ? ");
        }
        if (!this.p_DocBaseType.equals("JCS")) {
            if (this.p_IsCreateBaseDocJP) {
                getContractContentSQL.append(" AND cps.DocBaseType = ? ");
            } else if (this.p_DocBaseType.equals("MMS") || this.p_DocBaseType.equals("ARI")) {
                getContractContentSQL.append(" AND cc.DocBaseType ='SOO' ");
            } else if (this.p_DocBaseType.equals("MMR") || this.p_DocBaseType.equals("API")) {
                getContractContentSQL.append(" AND cc.DocBaseType ='POO' ");
            }
        }
        ArrayList<MContractContent> contractContentList = new ArrayList<MContractContent>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)getContractContentSQL.toString(), null);
                int i = 1;
                pstmt.setInt(i++, this.getAD_Client_ID());
                pstmt.setInt(i++, procPeriod.getJP_ContractCalender_ID());
                if (this.p_DocBaseType.equals("JCS")) {
                    pstmt.setTimestamp(i++, procPeriod.getEndDate());
                    pstmt.setTimestamp(i++, procPeriod.getStartDate());
                } else {
                    pstmt.setInt(i++, procPeriod.getJP_ContractProcPeriod_ID());
                }
                if (this.p_AD_Org_ID > 0) {
                    pstmt.setInt(i++, this.p_AD_Org_ID);
                }
                if (this.p_JP_ContractCategory_ID > 0) {
                    pstmt.setInt(i++, this.p_JP_ContractCategory_ID);
                }
                if (this.p_C_DocType_ID > 0) {
                    pstmt.setInt(i++, this.p_C_DocType_ID);
                }
                if (this.p_JP_Contract_ID > 0) {
                    pstmt.setInt(i++, this.p_JP_Contract_ID);
                }
                if (this.p_JP_ContractContent_ID > 0) {
                    pstmt.setInt(i++, this.p_JP_ContractContent_ID);
                }
                if (!this.p_DocBaseType.equals("JCS") && this.p_IsCreateBaseDocJP) {
                    pstmt.setString(i++, this.p_DocBaseType);
                }
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    contractContentList.add(new MContractContent(this.getCtx(), rs, this.get_TrxName()));
                }
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return contractContentList;
    }

    private void callCreateBaseDocDirectly(MContractContent contractContent, MContractProcPeriod procPeriod) throws Exception {
        ProcessInfo pi = new ProcessInfo("CreateBaseDoc", 0);
        String className = null;
        if (this.p_DocBaseType.equals("SOO") || this.p_DocBaseType.equals("POO")) {
            className = Util.isEmpty((String)MContractProcess.get(this.getCtx(), contractContent.getJP_ContractProcess_ID()).getClassname()) ? "jpiere.base.plugin.org.adempiere.process.DefaultContractProcessCreateBaseOrder" : contractContent.getJP_ContractProcess().getClassname();
        }
        if (this.p_DocBaseType.equals("ARI") || this.p_DocBaseType.equals("API")) {
            className = Util.isEmpty((String)MContractProcess.get(this.getCtx(), contractContent.getJP_ContractProcess_ID()).getClassname()) ? "jpiere.base.plugin.org.adempiere.process.DefaultContractProcessCreateBaseInvoice" : contractContent.getJP_ContractProcess().getClassname();
        }
        pi.setClassName(className);
        pi.setAD_Client_ID(this.getAD_Client_ID());
        pi.setAD_User_ID(this.getAD_User_ID());
        pi.setAD_PInstance_ID(this.getAD_PInstance_ID());
        pi.setRecord_ID(contractContent.getJP_ContractContent_ID());
        ArrayList<ProcessInfoParameter> list = new ArrayList<ProcessInfoParameter>();
        list.add(new ProcessInfoParameter("JP_ContractProcess_ID", (Object)contractContent.getJP_ContractProcess_ID(), null, null, null));
        list.add(new ProcessInfoParameter("JP_ContractLog", (Object)this.m_ContractLog, null, null, null));
        this.setProcessInfoParameter(pi, list, procPeriod);
        if (this.startProcess(pi)) {
            ++this.successNum;
        } else {
            ++this.failureNum;
        }
    }

    private void callCreateDerivativeDocDirectly(MContractContent contractContent, MContractProcPeriod procPeriod) throws Exception {
        MContractProcess[] contractProcesses = null;
        if (this.p_DocBaseType.equals("MMS") || this.p_DocBaseType.equals("MMR")) {
            contractProcesses = contractContent.getContractProcessDerivativeInOutByCalender(procPeriod.getJP_ContractCalender_ID());
        } else if (this.p_DocBaseType.equals("ARI") || this.p_DocBaseType.equals("API")) {
            contractProcesses = contractContent.getContractProcessDerivativeInvoiceByCalender(procPeriod.getJP_ContractCalender_ID());
        }
        this.processContractLineNum += contractProcesses.length;
        int i = 0;
        while (i < contractProcesses.length) {
            String className = null;
            if (Util.isEmpty((String)contractProcesses[i].getClassname())) {
                if (this.p_DocBaseType.equals("MMS") || this.p_DocBaseType.equals("MMR")) {
                    className = "jpiere.base.plugin.org.adempiere.process.DefaultContractProcessCreateDerivativeInOut";
                } else if (this.p_DocBaseType.equals("ARI") || this.p_DocBaseType.equals("API")) {
                    className = "jpiere.base.plugin.org.adempiere.process.DefaultContractProcessCreateDerivativeInvoice";
                }
            } else {
                className = contractProcesses[i].getClassname();
            }
            ProcessInfo pi = new ProcessInfo("CreateDerivativeDoc", 0);
            pi.setClassName(className);
            pi.setAD_Client_ID(this.getAD_Client_ID());
            pi.setAD_User_ID(this.getAD_User_ID());
            pi.setAD_PInstance_ID(this.getAD_PInstance_ID());
            pi.setRecord_ID(contractContent.getJP_ContractContent_ID());
            pi.setTable_ID(this.getTable_ID());
            ArrayList<ProcessInfoParameter> list = new ArrayList<ProcessInfoParameter>();
            list.add(new ProcessInfoParameter("JP_ContractProcess_ID", (Object)contractProcesses[i].getJP_ContractProcess_ID(), null, null, null));
            list.add(new ProcessInfoParameter("JP_ContractLog", (Object)this.m_ContractLog, null, null, null));
            this.setProcessInfoParameter(pi, list, procPeriod);
            if (this.startProcess(pi)) {
                ++this.successNum;
            } else {
                ++this.failureNum;
            }
            ++i;
        }
    }

    private void callCreateContractProcSchdule(MContractContent contractContent, MContractProcPeriod procPeriod) throws Exception {
        ProcessInfo pi = new ProcessInfo("CreateContractProcessSchdule", 0);
        String className = null;
        className = Util.isEmpty((String)MContractProcess.get(this.getCtx(), contractContent.getJP_ContractProcess_ID()).getJP_CreateContractPSClass()) ? "jpiere.base.plugin.org.adempiere.process.DefaultContractProcessCreateSchedule" : contractContent.getJP_ContractProcess().getJP_CreateContractPSClass();
        pi.setClassName(className);
        pi.setAD_Client_ID(this.getAD_Client_ID());
        pi.setAD_User_ID(this.getAD_User_ID());
        pi.setAD_PInstance_ID(this.getAD_PInstance_ID());
        pi.setRecord_ID(contractContent.getJP_ContractContent_ID());
        ArrayList<ProcessInfoParameter> list = new ArrayList<ProcessInfoParameter>();
        list.add(new ProcessInfoParameter("JP_ContractProcess_ID", (Object)contractContent.getJP_ContractProcess_ID(), null, null, null));
        list.add(new ProcessInfoParameter("JP_ContractLog", (Object)this.m_ContractLog, null, null, null));
        this.setProcessInfoParameter(pi, list, procPeriod);
        if (this.startProcess(pi)) {
            ++this.successNum;
        } else {
            ++this.failureNum;
        }
    }

    private void callCreateBaseDocIndirectly(MContractContent contractContent, MContractProcPeriod procPeriod) throws Exception {
        ProcessInfo pi = new ProcessInfo("CreateBaseDoc", 0);
        String className = null;
        if (this.p_DocBaseType.equals("SOO") || this.p_DocBaseType.equals("POO")) {
            className = Util.isEmpty((String)MContractProcess.get(this.getCtx(), contractContent.getJP_ContractProcess_ID()).getJP_IndirectContractProcClass()) ? "jpiere.base.plugin.org.adempiere.process.DefaultContractProcessCreateBaseOrderIndirectly" : contractContent.getJP_ContractProcess().getJP_IndirectContractProcClass();
        }
        if (this.p_DocBaseType.equals("ARI") || this.p_DocBaseType.equals("API")) {
            className = Util.isEmpty((String)MContractProcess.get(this.getCtx(), contractContent.getJP_ContractProcess_ID()).getJP_IndirectContractProcClass()) ? "jpiere.base.plugin.org.adempiere.process.DefaultContractProcessCreateBaseInvoiceIndirectly" : contractContent.getJP_ContractProcess().getJP_IndirectContractProcClass();
        }
        pi.setClassName(className);
        pi.setAD_Client_ID(this.getAD_Client_ID());
        pi.setAD_User_ID(this.getAD_User_ID());
        pi.setAD_PInstance_ID(this.getAD_PInstance_ID());
        pi.setRecord_ID(contractContent.getJP_ContractContent_ID());
        ArrayList<ProcessInfoParameter> list = new ArrayList<ProcessInfoParameter>();
        list.add(new ProcessInfoParameter("JP_ContractProcess_ID", (Object)contractContent.getJP_ContractProcess_ID(), null, null, null));
        list.add(new ProcessInfoParameter("JP_ContractLog", (Object)this.m_ContractLog, null, null, null));
        this.setProcessInfoParameter(pi, list, procPeriod);
        if (this.startProcess(pi)) {
            ++this.successNum;
        } else {
            ++this.failureNum;
        }
    }

    private void callCreateDerivativeDocIndirectly(MContractContent contractContent, MContractProcPeriod procPeriod) throws Exception {
        MContractProcess[] contractProcesses = null;
        if (this.p_DocBaseType.equals("MMS") || this.p_DocBaseType.equals("MMR")) {
            contractProcesses = contractContent.getContractProcessDerivativeInOutByCalender(procPeriod.getJP_ContractCalender_ID());
        } else if (this.p_DocBaseType.equals("ARI") || this.p_DocBaseType.equals("API")) {
            contractProcesses = contractContent.getContractProcessDerivativeInvoiceByCalender(procPeriod.getJP_ContractCalender_ID());
        }
        this.processContractLineNum += contractProcesses.length;
        int i = 0;
        while (i < contractProcesses.length) {
            String className = null;
            if (Util.isEmpty((String)contractProcesses[i].getJP_IndirectContractProcClass())) {
                if (this.p_DocBaseType.equals("MMS") || this.p_DocBaseType.equals("MMR")) {
                    className = "jpiere.base.plugin.org.adempiere.process.DefaultContractProcessCreateDerivativeInOutIndirectly";
                } else if (this.p_DocBaseType.equals("ARI") || this.p_DocBaseType.equals("API")) {
                    className = "jpiere.base.plugin.org.adempiere.process.DefaultContractProcessCreateDerivativeInvoiceIndirectly";
                }
            } else {
                className = contractProcesses[i].getJP_IndirectContractProcClass();
            }
            ProcessInfo pi = new ProcessInfo("CreateDerivativeDoc", 0);
            pi.setClassName(className);
            pi.setAD_Client_ID(this.getAD_Client_ID());
            pi.setAD_User_ID(this.getAD_User_ID());
            pi.setAD_PInstance_ID(this.getAD_PInstance_ID());
            pi.setRecord_ID(contractContent.getJP_ContractContent_ID());
            ArrayList<ProcessInfoParameter> list = new ArrayList<ProcessInfoParameter>();
            list.add(new ProcessInfoParameter("JP_ContractProcess_ID", (Object)contractProcesses[i].getJP_ContractProcess_ID(), null, null, null));
            list.add(new ProcessInfoParameter("JP_ContractLog", (Object)this.m_ContractLog, null, null, null));
            this.setProcessInfoParameter(pi, list, procPeriod);
            if (this.startProcess(pi)) {
                ++this.successNum;
            } else {
                ++this.failureNum;
            }
            ++i;
        }
    }

    private void callAutoRenewContractProcess(MContract autoRenewContract) throws Exception {
        String className = null;
        className = Util.isEmpty((String)this.p_JP_ContractAutoRenewClass) ? "jpiere.base.plugin.org.adempiere.process.DefaultAutoRenewContractProcess" : this.p_JP_ContractAutoRenewClass;
        ProcessInfo pi = new ProcessInfo("CreateDerivativeDoc", 0);
        pi.setClassName(className);
        pi.setAD_Client_ID(this.getAD_Client_ID());
        pi.setAD_User_ID(this.getAD_User_ID());
        pi.setAD_PInstance_ID(this.getAD_PInstance_ID());
        pi.setRecord_ID(0);
        ArrayList<ProcessInfoParameter> list = new ArrayList<ProcessInfoParameter>();
        list.add(new ProcessInfoParameter("JP_Contract", (Object)autoRenewContract, null, null, null));
        list.add(new ProcessInfoParameter("JP_ContractLog", (Object)this.m_ContractLog, null, null, null));
        this.setProcessInfoParameter(pi, list, null);
        if (this.startProcess(pi)) {
            ++this.successNum;
        } else {
            ++this.failureNum;
        }
    }

    private void callContractStatusUpdateProcess(MContract contract) throws Exception {
        String className = null;
        className = Util.isEmpty((String)this.p_JP_ContractStatusUpdateClass) ? "jpiere.base.plugin.org.adempiere.process.DefaultContractStatusUpdateProcess" : this.p_JP_ContractAutoRenewClass;
        ProcessInfo pi = new ProcessInfo("Contract status Update", 0);
        pi.setClassName(className);
        pi.setAD_Client_ID(this.getAD_Client_ID());
        pi.setAD_User_ID(this.getAD_User_ID());
        pi.setAD_PInstance_ID(this.getAD_PInstance_ID());
        pi.setRecord_ID(0);
        ArrayList<ProcessInfoParameter> list = new ArrayList<ProcessInfoParameter>();
        list.add(new ProcessInfoParameter("JP_Contract", (Object)contract, null, null, null));
        list.add(new ProcessInfoParameter("JP_ContractLog", (Object)this.m_ContractLog, null, null, null));
        this.setProcessInfoParameter(pi, list, null);
        if (this.startProcess(pi)) {
            ++this.successNum;
        } else {
            ++this.failureNum;
        }
    }

    private void setProcessInfoParameter(ProcessInfo pi, ArrayList<ProcessInfoParameter> list, MContractProcPeriod procPeriod) throws Exception {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            if (para[i].getParameterName().equals("JP_ContractCalender_ID")) {
                if (procPeriod == null) {
                    list.add(new ProcessInfoParameter("JP_ContractCalender_ID", para[i].getParameter(), para[i].getParameter_To(), para[i].getInfo(), para[i].getInfo_To()));
                } else {
                    list.add(new ProcessInfoParameter("JP_ContractCalender_ID", (Object)procPeriod.getJP_ContractCalender_ID(), null, para[i].getInfo(), para[i].getInfo_To()));
                }
            } else if (para[i].getParameterName().equals("JP_ContractProcPeriod_ID")) {
                if (procPeriod == null) {
                    list.add(new ProcessInfoParameter("JP_ContractProcPeriod_ID", para[i].getParameter(), para[i].getParameter_To(), para[i].getInfo(), para[i].getInfo_To()));
                } else {
                    list.add(new ProcessInfoParameter("JP_ContractProcPeriod_ID", (Object)procPeriod.getJP_ContractProcPeriod_ID(), null, para[i].getInfo(), para[i].getInfo_To()));
                }
            } else {
                list.add(new ProcessInfoParameter(para[i].getParameterName(), para[i].getParameter(), para[i].getParameter_To(), para[i].getInfo(), para[i].getInfo_To()));
            }
            ++i;
        }
        ProcessInfoParameter[] pars = new ProcessInfoParameter[list.size()];
        list.toArray(pars);
        pi.setParameter(pars);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean startProcess(ProcessInfo pi) throws Exception {
        boolean success;
        if (this.processUI == null) {
            this.processUI = Env.getProcessUI((Properties)this.getCtx());
        }
        if (success = ProcessUtil.startJavaProcess((Properties)this.getCtx(), (ProcessInfo)pi, (Trx)Trx.get((String)this.get_TrxName(), (boolean)true), (boolean)false, (IProcessUI)this.processUI)) {
            if (this.p_IsRecordCommitJP) {
                this.commitEx();
                if (this.contractLogTrx == null) return success;
                this.contractLogTrx.commit();
                return success;
            } else {
                if (this.contractLogTrx == null) return success;
                this.contractLogTrx.commit();
            }
            return success;
        }
        if (this.contractLogTrx != null) {
            MContractLogDetail logDetail = new MContractLogDetail(this.getCtx(), 0, this.m_ContractLog.get_TrxName());
            logDetail.setJP_ContractLog_ID(this.m_ContractLog.getJP_ContractLog_ID());
            logDetail.setJP_ContractLogMsg("ZZ");
            logDetail.setJP_ContractProcessTraceLevel("ERR");
            logDetail.setDescription(pi.getSummary());
            if (pi.getRecord_ID() > 0) {
                logDetail.setJP_ContractContent_ID(pi.getRecord_ID());
            }
            logDetail.saveEx(this.m_ContractLog.get_TrxName());
            this.contractLogTrx.commit();
        }
        if (!this.p_IsRecordCommitJP) throw new AdempiereException(pi.getSummary());
        this.rollback();
        return success;
    }

    private boolean isProcessRunning() {
        Timestamp lastRebootDate = this.getLastServerRebootDate();
        if (lastRebootDate == null) {
            return false;
        }
        List processInstanceList = new Query(Env.getCtx(), "AD_PInstance", " AD_Process_ID=? AND IsProcessing='Y' AND record_ID = ? AND Created > ? ", null).setParameters(new Object[]{this.getProcessInfo().getAD_Process_ID(), this.getRecord_ID(), lastRebootDate}).setClient_ID().setOnlyActiveRecords(true).list();
        if (processInstanceList == null || processInstanceList.isEmpty()) {
            return false;
        }
        return processInstanceList.size() > 1;
    }

    private Timestamp getLastServerRebootDate() {
        MSession currentSession = MSession.get((Properties)Env.getCtx());
        if (currentSession == null) {
            return null;
        }
        MSession lastServerSession = (MSession)new Query(Env.getCtx(), "AD_Session", " serverName=? AND websession=?", null).setParameters(new Object[]{currentSession.getServerName(), "Server"}).setOrderBy("AD_Session_ID desc").setOnlyActiveRecords(true).first();
        return lastServerSession.getCreated();
    }
}

