/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MRecognition;
import org.adempiere.util.ProcessUtil;
import org.compiere.model.MColumn;
import org.compiere.model.MPeriod;
import org.compiere.model.MProcess;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.wf.MWFActivity;
import org.compiere.wf.MWFProcess;

public class BulkUpdateRecognitionDocStatus
extends SvrProcess {
    private Timestamp p_DateAcct_From = null;
    private Timestamp p_DateAcct_To = null;
    private int p_AD_Org_ID = 0;
    private int p_C_DocTypeTarget_ID = 0;
    private int p_JP_Contract_ID = 0;
    private int p_JP_ContractContent_ID = 0;
    private boolean p_IsSOTrx = true;
    private String p_DocAction = "CO";
    private Timestamp p_JP_OverwriteDateAcct = null;
    private String p_JP_Process_Value = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DateAcct")) {
                    this.p_DateAcct_From = para[i].getParameterAsTimestamp();
                    this.p_DateAcct_To = para[i].getParameter_ToAsTimestamp();
                } else if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_DocTypeTarget_ID")) {
                    this.p_C_DocTypeTarget_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_Contract_ID")) {
                    this.p_JP_Contract_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_ContractContent_ID")) {
                    this.p_JP_ContractContent_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_OverwriteDateAcct")) {
                    this.p_JP_OverwriteDateAcct = para[i].getParameterAsTimestamp();
                } else if (name.equals("DocAction")) {
                    this.p_DocAction = para[i].getParameterAsString();
                } else if (name.equals("JP_Process_Value")) {
                    this.p_JP_Process_Value = para[i].getParameterAsString();
                } else if (name.equals("IsSOTrx")) {
                    this.p_IsSOTrx = para[i].getParameterAsBoolean();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        MRecognition[] list = this.getRecognition();
        if (list == null) {
            return "ok";
        }
        int successNo = 0;
        int failureNo = 0;
        String success = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success");
        String failure = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure");
        ProcessInfo pInfo = this.getProcessInfo();
        MColumn docActionColumn = MColumn.get((Properties)this.getCtx(), (String)"JP_Recognition", (String)"DocAction");
        MProcess process = MProcess.get((int)docActionColumn.getAD_Process_ID());
        MRecognition[] mRecognitionArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            MRecognition recog = mRecognitionArray[n2];
            if (!recog.isProcessed()) {
                int C_Period_ID;
                if (this.p_JP_OverwriteDateAcct != null && (C_Period_ID = MPeriod.getC_Period_ID((Properties)this.getCtx(), (Timestamp)this.p_JP_OverwriteDateAcct, (int)recog.getAD_Org_ID())) == 0) {
                    String msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"PeriodNotFound")) + " : " + DisplayType.getDateFormat().format(this.p_JP_OverwriteDateAcct) + " - " + recog.getDocumentNo();
                    throw new Exception(msg);
                }
                if (this.p_JP_OverwriteDateAcct != null) {
                    recog.setDateAcct(this.p_JP_OverwriteDateAcct);
                }
                try {
                    String wfStatus = MWFActivity.getActiveInfo((Properties)Env.getCtx(), (int)MRecognition.Table_ID, (int)recog.getJP_Recognition_ID());
                    if (Util.isEmpty((String)wfStatus)) {
                        if ("CO".equals(this.p_DocAction)) {
                            if (this.p_JP_OverwriteDateAcct != null) {
                                recog.saveEx(this.get_TrxName());
                            }
                            pInfo.setPO((PO)recog);
                            pInfo.setRecord_ID(recog.getJP_Recognition_ID());
                            pInfo.setTable_ID(MRecognition.Table_ID);
                            MWFProcess wfProcess = ProcessUtil.startWorkFlow((Properties)Env.getCtx(), (ProcessInfo)pInfo, (int)process.getAD_Workflow_ID());
                            if (wfProcess.getWFState().equals("CT")) {
                                ++failureNo;
                                recog.saveEx(this.get_TrxName());
                                this.addBufferLog(0, null, null, String.valueOf(failure) + ":" + recog.getDocumentNo(), MRecognition.Table_ID, recog.getJP_Recognition_ID());
                            } else {
                                ++successNo;
                                recog.saveEx(this.get_TrxName());
                                this.addBufferLog(0, null, null, String.valueOf(success) + ":" + recog.getDocumentNo(), MRecognition.Table_ID, recog.getJP_Recognition_ID());
                            }
                        } else if ("PR".equals(this.p_DocAction)) {
                            if (recog.processIt(this.p_DocAction)) {
                                ++successNo;
                                recog.saveEx(this.get_TrxName());
                                this.addBufferLog(0, null, null, String.valueOf(success) + ":" + recog.getDocumentNo(), MRecognition.Table_ID, recog.getJP_Recognition_ID());
                            } else {
                                ++failureNo;
                                recog.saveEx(this.get_TrxName());
                                this.addBufferLog(0, null, null, String.valueOf(failure) + ":" + recog.getDocumentNo(), MRecognition.Table_ID, recog.getJP_Recognition_ID());
                            }
                        }
                    } else {
                        ++failureNo;
                        this.addBufferLog(0, null, null, String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"WFActiveForRecord")) + ":" + recog.getDocumentNo(), MRecognition.Table_ID, recog.getJP_Recognition_ID());
                    }
                }
                catch (Exception e) {
                    ++failureNo;
                    this.addBufferLog(0, null, null, String.valueOf(failure) + ":" + recog.getDocumentNo(), MRecognition.Table_ID, recog.getJP_Recognition_ID());
                }
            }
            ++n2;
        }
        return String.valueOf(success) + " : " + successNo + "  /  " + failure + " " + failureNo;
    }

    private MRecognition[] getRecognition() throws Exception {
        if ("Y".equals(this.p_JP_Process_Value)) {
            StringBuilder whereClause = new StringBuilder("AD_Client_ID = ? AND Processed = 'N' AND IsSOTrx = " + (this.p_IsSOTrx ? "'Y'" : "'N'"));
            ArrayList<Comparable<Integer>> docListParams = new ArrayList<Comparable<Integer>>();
            docListParams.add(Integer.valueOf(this.getAD_Client_ID()));
            if (this.p_AD_Org_ID != 0) {
                whereClause.append(" AND AD_Org_ID = ? ");
                docListParams.add(Integer.valueOf(this.p_AD_Org_ID));
            }
            if (this.p_DateAcct_From != null) {
                whereClause.append(" AND DateAcct >= ? ");
                docListParams.add(this.p_DateAcct_From);
            }
            if (this.p_DateAcct_To != null) {
                whereClause.append(" AND DateAcct <= ? ");
                docListParams.add(this.p_DateAcct_To);
            }
            if (this.p_C_DocTypeTarget_ID != 0) {
                whereClause.append(" AND C_DocTypeTarget_ID = ? ");
                docListParams.add(Integer.valueOf(this.p_C_DocTypeTarget_ID));
            }
            if (this.p_JP_Contract_ID != 0) {
                whereClause.append(" AND JP_Contract_ID = ? ");
                docListParams.add(Integer.valueOf(this.p_JP_Contract_ID));
            }
            if (this.p_JP_ContractContent_ID != 0) {
                whereClause.append(" AND JP_ContractContent_ID = ? ");
                docListParams.add(Integer.valueOf(this.p_JP_ContractContent_ID));
            }
            List list = new Query(this.getCtx(), "JP_Recognition", whereClause.toString(), this.get_TrxName()).setParameters(docListParams).list();
            MRecognition[] recogs = list.toArray(new MRecognition[list.size()]);
            return recogs;
        }
        ArrayList<MRecognition> list = new ArrayList<MRecognition>();
        String sql = "SELECT r.* FROM JP_Recognition r  INNER JOIN T_Selection ts ON (r.JP_Recognition_ID = ts.T_Selection_ID AND ts.AD_PInstance_ID=?)";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setInt(1, this.getAD_PInstance_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.add(new MRecognition(this.getCtx(), rs, this.get_TrxName()));
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        MRecognition[] recogs = list.toArray(new MRecognition[list.size()]);
        return recogs;
    }
}

