/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class BankTransferEasyWay
extends SvrProcess {
    private int p_From_C_BankAccount_ID = 0;
    private int p_To_C_BankAccount_ID = 0;
    private int p_C_Charge_ID = 0;
    private BigDecimal p_Amount = Env.ZERO;
    private int p_HandlingCharge_ID = 0;
    private BigDecimal p_HandlingChargeAmt = Env.ZERO;
    private int p_HandlingChargeTax_ID = 0;
    private String p_Name = "";
    private String p_Description = "";
    private Timestamp p_StatementDate = null;
    private Timestamp p_DateAcct = null;
    private String p_DocAction = null;
    private MBankAccount mBankAccountFrom = null;
    private MBankAccount mBankAccountTo = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("From_C_BankAccount_ID")) {
                this.p_From_C_BankAccount_ID = para[i].getParameterAsInt();
            } else if (name.equals("To_C_BankAccount_ID")) {
                this.p_To_C_BankAccount_ID = para[i].getParameterAsInt();
            } else if (name.equals("C_Charge_ID")) {
                this.p_C_Charge_ID = para[i].getParameterAsInt();
            } else if (name.equals("Amount")) {
                this.p_Amount = (BigDecimal)para[i].getParameter();
            } else if (name.equals("HandlingCharge_ID")) {
                this.p_HandlingCharge_ID = para[i].getParameterAsInt();
            } else if (name.equals("HandlingChargeAmt")) {
                this.p_HandlingChargeAmt = (BigDecimal)para[i].getParameter();
            } else if (name.equals("HandlingChargeTax_ID")) {
                this.p_HandlingChargeTax_ID = para[i].getParameterAsInt();
            } else if (name.equals("Name")) {
                this.p_Name = (String)para[i].getParameter();
            } else if (name.equals("Description")) {
                this.p_Description = (String)para[i].getParameter();
            } else if (name.equals("StatementDate")) {
                this.p_StatementDate = (Timestamp)para[i].getParameter();
            } else if (name.equals("DateAcct")) {
                this.p_DateAcct = (Timestamp)para[i].getParameter();
            } else if (name.equals("DocAction")) {
                this.p_DocAction = (String)para[i].getParameter();
            } else {
                this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        if (this.p_To_C_BankAccount_ID == 0 || this.p_From_C_BankAccount_ID == 0) {
            throw new AdempiereUserError(Msg.parseTranslation((Properties)this.getCtx(), (String)"@FillMandatory@: @To_C_BankAccount_ID@, @From_C_BankAccount_ID@"));
        }
        if (this.p_To_C_BankAccount_ID == this.p_From_C_BankAccount_ID) {
            throw new AdempiereUserError(Msg.getMsg((Properties)this.getCtx(), (String)"BankFromToMustDiffer"));
        }
        if (this.p_C_Charge_ID == 0) {
            throw new AdempiereUserError(Msg.parseTranslation((Properties)this.getCtx(), (String)"@FillMandatory@ @C_Charge_ID@"));
        }
        if (this.p_Amount.signum() == 0) {
            throw new AdempiereUserError(Msg.parseTranslation((Properties)this.getCtx(), (String)"@FillMandatory@ @Amount@"));
        }
        if (this.p_StatementDate == null) {
            this.p_StatementDate = Env.getContextAsDate((Properties)this.getCtx(), (String)"#Date");
        }
        if (this.p_StatementDate == null) {
            this.p_StatementDate = new Timestamp(System.currentTimeMillis());
        }
        if (this.p_DateAcct == null) {
            this.p_DateAcct = this.p_StatementDate;
        }
        this.mBankAccountFrom = new MBankAccount(this.getCtx(), this.p_From_C_BankAccount_ID, this.get_TrxName());
        this.mBankAccountTo = new MBankAccount(this.getCtx(), this.p_To_C_BankAccount_ID, this.get_TrxName());
        if (this.mBankAccountFrom.getC_Currency_ID() != this.mBankAccountTo.getC_Currency_ID()) {
            String msg = String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"C_BankAccount_ID")) + " : " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_DifferentCurrency");
            throw new AdempiereUserError(msg);
        }
        if (this.mBankAccountFrom.getAD_Org_ID() == 0) {
            throw new AdempiereUserError(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_BankTransfer_BankAccount")) + " : " + this.mBankAccountFrom.getName());
        }
        if (this.mBankAccountTo.getAD_Org_ID() == 0) {
            throw new AdempiereUserError(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_BankTransfer_BankAccount")) + " : " + this.mBankAccountTo.getName());
        }
        if (this.p_HandlingChargeAmt != null && this.p_HandlingChargeAmt.compareTo(Env.ZERO) != 0 && this.p_HandlingCharge_ID == 0) {
            throw new AdempiereUserError(Msg.getMsg((Properties)this.getCtx(), (String)"JP_BankTransfer_HandlingCharge"));
        }
        if (this.p_HandlingChargeAmt != null && this.p_HandlingChargeAmt.compareTo(Env.ZERO) != 0 && this.p_HandlingChargeTax_ID == 0) {
            throw new AdempiereUserError(Msg.getMsg((Properties)this.getCtx(), (String)"JP_BankTransfer_HandlingChargeTax"));
        }
        this.generateBankTransfer();
        return "@Success@";
    }

    private void generateBankTransfer() {
        MBankStatement mBSfrom = new MBankStatement(this.getCtx(), 0, this.get_TrxName());
        mBSfrom.setAD_Org_ID(this.mBankAccountFrom.getAD_Org_ID());
        mBSfrom.setC_BankAccount_ID(this.p_From_C_BankAccount_ID);
        mBSfrom.setName(this.p_Name);
        mBSfrom.setDescription(this.p_Description);
        mBSfrom.setStatementDate(this.p_StatementDate);
        mBSfrom.setDateAcct(this.p_DateAcct);
        mBSfrom.saveEx(this.get_TrxName());
        MBankStatementLine mBSLineFrom = new MBankStatementLine(mBSfrom);
        mBSLineFrom.setLine(10);
        mBSLineFrom.setC_Currency_ID(this.mBankAccountFrom.getC_Currency_ID());
        mBSLineFrom.setStmtAmt(this.p_Amount.negate());
        mBSLineFrom.setTrxAmt(Env.ZERO);
        mBSLineFrom.setChargeAmt(this.p_Amount.negate());
        mBSLineFrom.setC_Charge_ID(this.p_C_Charge_ID);
        mBSLineFrom.setInterestAmt(Env.ZERO);
        mBSLineFrom.saveEx(this.get_TrxName());
        if (this.p_HandlingCharge_ID != 0 && this.p_HandlingChargeAmt != null && this.p_HandlingChargeAmt.compareTo(Env.ZERO) != 0) {
            MBankStatementLine mBSLineHandlingCharge = new MBankStatementLine(mBSfrom);
            mBSLineHandlingCharge.setLine(20);
            mBSLineHandlingCharge.setC_Currency_ID(this.mBankAccountFrom.getC_Currency_ID());
            mBSLineHandlingCharge.setStmtAmt(this.p_HandlingChargeAmt.negate());
            mBSLineHandlingCharge.setTrxAmt(Env.ZERO);
            mBSLineHandlingCharge.setChargeAmt(this.p_HandlingChargeAmt.negate());
            mBSLineHandlingCharge.setC_Charge_ID(this.p_HandlingCharge_ID);
            mBSLineHandlingCharge.setInterestAmt(Env.ZERO);
            if (this.p_HandlingChargeTax_ID > 0) {
                mBSLineHandlingCharge.set_ValueNoCheck("C_Tax_ID", (Object)this.p_HandlingChargeTax_ID);
                mBSLineHandlingCharge.set_ValueNoCheck("JP_SOPOType", (Object)"P");
            }
            mBSLineHandlingCharge.saveEx(this.get_TrxName());
        }
        if (!Util.isEmpty((String)this.p_DocAction) && ("CO".equals(this.p_DocAction) || "PR".equals(this.p_DocAction))) {
            mBSfrom.processIt(this.p_DocAction);
            mBSfrom.saveEx(this.get_TrxName());
        }
        this.addBufferLog(0, null, null, String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"C_BankStatement_ID")) + " : " + this.mBankAccountFrom.getName(), 392, mBSLineFrom.getC_BankStatement_ID());
        MBankStatement mBSto = new MBankStatement(this.getCtx(), 0, this.get_TrxName());
        mBSto.setAD_Org_ID(this.mBankAccountTo.getAD_Org_ID());
        mBSto.setC_BankAccount_ID(this.p_To_C_BankAccount_ID);
        mBSto.setName(this.p_Name);
        mBSto.setDescription(this.p_Description);
        mBSto.setStatementDate(this.p_StatementDate);
        mBSto.setDateAcct(this.p_DateAcct);
        mBSto.saveEx(this.get_TrxName());
        MBankStatementLine mBSLineTo = new MBankStatementLine(mBSto);
        mBSLineTo.setLine(10);
        mBSLineTo.setC_Currency_ID(this.mBankAccountTo.getC_Currency_ID());
        mBSLineTo.setStmtAmt(this.p_Amount);
        mBSLineTo.setTrxAmt(Env.ZERO);
        mBSLineTo.setChargeAmt(this.p_Amount);
        mBSLineTo.setC_Charge_ID(this.p_C_Charge_ID);
        mBSLineTo.setInterestAmt(Env.ZERO);
        mBSLineTo.saveEx(this.get_TrxName());
        if (!Util.isEmpty((String)this.p_DocAction) && ("CO".equals(this.p_DocAction) || "PR".equals(this.p_DocAction))) {
            mBSto.processIt(this.p_DocAction);
            mBSto.saveEx(this.get_TrxName());
        }
        this.addBufferLog(0, null, null, String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"C_BankStatement_ID")) + " : " + this.mBankAccountTo.getName(), 392, mBSLineTo.getC_BankStatement_ID());
    }
}

