/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class AccessUpdateRoleOrg
extends SvrProcess {
    private int p_AD_Org_ID = 0;
    private Timestamp today = null;
    private int activeNum = 0;
    private int inActiveNum = 0;

    protected void prepare() {
        this.today = Timestamp.valueOf(LocalDateTime.of(LocalDate.now(), LocalTime.MIN));
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        this.doActive();
        this.doInActive();
        this.addLog(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_UpdateActive")) + " : " + this.activeNum);
        this.addLog(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_UpdateInActive")) + " : " + this.inActiveNum);
        return "@OK@";
    }

    private void doActive() {
        StringBuilder sql = new StringBuilder("Update AD_Role_OrgAccess").append(" SET IsActive = 'Y' ").append(" WHERE (JP_ValidFrom IS NULL OR  JP_ValidFrom <= ?) ").append(" AND (JP_ValidTo IS NULL OR  JP_ValidTo >= ?) ").append(" AND AD_Client_ID = ? AND IsActive = 'N' ");
        if (this.p_AD_Org_ID == 0) {
            this.activeNum = DB.executeUpdate((String)sql.toString(), (Object[])new Object[]{this.today, this.today, this.getAD_Client_ID()}, (boolean)false, (String)this.get_TrxName(), (int)0);
        } else {
            sql = sql.append(" AND AD_Org_ID = ?");
            this.activeNum = DB.executeUpdate((String)sql.toString(), (Object[])new Object[]{this.today, this.today, this.getAD_Client_ID(), this.p_AD_Org_ID}, (boolean)false, (String)this.get_TrxName(), (int)0);
        }
    }

    private void doInActive() {
        StringBuilder sql = new StringBuilder("Update AD_Role_OrgAccess").append(" SET IsActive = 'N' ").append(" WHERE ( JP_ValidFrom > ? OR JP_ValidTo < ? ) ").append(" AND AD_Client_ID = ? AND IsActive = 'Y' ");
        if (this.p_AD_Org_ID == 0) {
            this.inActiveNum = DB.executeUpdate((String)sql.toString(), (Object[])new Object[]{this.today, this.today, this.getAD_Client_ID()}, (boolean)false, (String)this.get_TrxName(), (int)0);
        } else {
            sql = sql.append(" AND AD_Org_ID = ?");
            this.inActiveNum = DB.executeUpdate((String)sql.toString(), (Object[])new Object[]{this.today, this.today, this.getAD_Client_ID(), this.p_AD_Org_ID}, (boolean)false, (String)this.get_TrxName(), (int)0);
        }
    }
}

