/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.X_JP_WF_AutoForward;
import org.compiere.model.MUser;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.wf.MWFActivity;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWorkflow;

public class MWFAutoForward
extends X_JP_WF_AutoForward {
    private static CCache<String, MWFAutoForward> s_cache = new CCache("JP_WF_AutoForward", 100, 60);
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    public MWFAutoForward(Properties ctx, int JP_WF_AutoForward_ID, String trxName) {
        super(ctx, JP_WF_AutoForward_ID, trxName);
    }

    public MWFAutoForward(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        block22: {
            if (this.getJP_WF_User_From_ID() == this.getJP_WF_User_To_ID()) {
                this.log.saveError("Error", String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_WF_User_From_ID")) + " = " + Msg.getElement((Properties)this.getCtx(), (String)"JP_WF_User_To_ID"));
                return false;
            }
            if (newRecord && this.is_ValueChanged("AD_Workflow_ID")) {
                if (this.getAD_Workflow_ID() == 0) {
                    this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)this.getCtx(), (String)"AD_Workflow_ID"));
                    return false;
                }
                MWorkflow m_wf = MWorkflow.get((int)this.getAD_Workflow_ID());
                if (!"P".equals(m_wf.getWorkflowType()) && !"V".equals(m_wf.getWorkflowType())) {
                    this.log.saveError("Error", "JP_WF_Check_WFType");
                    return false;
                }
            }
            if (newRecord && this.is_ValueChanged("AD_WF_Node_ID")) {
                if (this.getAD_WF_Node_ID() == 0) {
                    this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)this.getCtx(), (String)"AD_WF_Node_ID"));
                    return false;
                }
                MWFNode m_wfNode = MWFNode.get((int)this.getAD_WF_Node_ID());
                if (!"C".equals(m_wfNode.getAction()) && !"W".equals(m_wfNode.getAction())) {
                    this.log.saveError("Error", "JP_WF_Check_Node_Action");
                    return false;
                }
            }
            if (newRecord) {
                String sql = null;
                sql = this.get_Value("AD_WF_Node_ID") == null ? (this.get_Value("JP_WF_Org_ID") == null ? "SELECT * FROM JP_WF_AutoForward WHERE AD_Client_ID=? AND JP_WF_User_From_ID=? AND AD_WF_Node_ID IS NULL AND JP_WF_Org_ID IS NULL AND ValidFrom = ? " : "SELECT * FROM JP_WF_AutoForward WHERE AD_Client_ID=? AND JP_WF_User_From_ID=? AND AD_WF_Node_ID IS NULL AND JP_WF_Org_ID = ? AND ValidFrom = ? ") : (this.get_Value("JP_WF_Org_ID") == null ? "SELECT * FROM JP_WF_AutoForward WHERE AD_Client_ID=? AND JP_WF_User_From_ID=? AND AD_WF_Node_ID = ? AND JP_WF_Org_ID IS NULL AND ValidFrom = ? " : "SELECT * FROM JP_WF_AutoForward WHERE AD_Client_ID=? AND JP_WF_User_From_ID=? AND AD_WF_Node_ID = ? AND JP_WF_Org_ID = ? AND ValidFrom = ? ");
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, this.getAD_Client_ID());
                    pstmt.setInt(2, this.getJP_WF_User_From_ID());
                    if (this.get_Value("AD_WF_Node_ID") == null) {
                        if (this.get_Value("JP_WF_Org_ID") == null) {
                            pstmt.setTimestamp(3, this.getValidFrom());
                        } else {
                            pstmt.setInt(3, this.getJP_WF_Org_ID());
                            pstmt.setTimestamp(4, this.getValidFrom());
                        }
                    } else if (this.get_Value("JP_WF_Org_ID") == null) {
                        pstmt.setInt(3, this.getAD_WF_Node_ID());
                        pstmt.setTimestamp(4, this.getValidFrom());
                    } else {
                        pstmt.setInt(3, this.getAD_WF_Node_ID());
                        pstmt.setInt(4, this.getJP_WF_Org_ID());
                        pstmt.setTimestamp(5, this.getValidFrom());
                    }
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_AlreadyRegistered"));
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        return false;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    break block22;
                }
                finally {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                Object var3_3 = null;
            }
        }
        if (newRecord || this.is_ValueChanged("AD_Workflow_ID") || this.is_ValueChanged("AD_WF_Node_ID") || this.is_ValueChanged("ValidFrom") || this.is_ValueChanged("JP_WF_Org_ID") || this.is_ValueChanged("JP_WF_User_From_ID") || this.is_ValueChanged("JP_WF_User_To_ID") || this.is_ValueChanged("IsActive")) {
            s_cache.reset();
        }
        return true;
    }

    protected boolean beforeDelete() {
        s_cache.reset();
        return true;
    }

    public static MWFAutoForward get(MWFActivity wfActivity) throws Exception {
        return MWFAutoForward.get(wfActivity.getAD_Client_ID(), wfActivity.getAD_User_ID(), wfActivity.getAD_WF_Node_ID(), wfActivity.getAD_Org_ID(), wfActivity.getCreated(), null, wfActivity.get_TrxName());
    }

    public static MWFAutoForward get(int AD_Client_ID, int AD_User_ID, int AD_WF_Node_ID, int AD_Org_ID, Timestamp Date2, String trxName) throws Exception {
        return MWFAutoForward.get(AD_Client_ID, AD_User_ID, AD_WF_Node_ID, AD_Org_ID, Date2, null, trxName);
    }

    private static MWFAutoForward get(int AD_Client_ID, int AD_User_ID, int AD_WF_Node_ID, int AD_Org_ID, Timestamp Date2, ArrayList<Integer> list_Forward_User_ID, String trxName) throws Exception {
        MWFAutoForward autoForward;
        String key;
        block11: {
            if (list_Forward_User_ID == null) {
                list_Forward_User_ID = new ArrayList();
                list_Forward_User_ID.add(AD_User_ID);
            }
            key = AD_Client_ID + "_" + AD_User_ID + "_" + AD_WF_Node_ID + "_" + AD_Org_ID + "_" + sdf.format(Date2);
            autoForward = null;
            if (s_cache.containsKey((Object)key)) {
                autoForward = (MWFAutoForward)s_cache.get((Object)key);
                return autoForward;
            }
            String sql = "SELECT * FROM JP_WF_AutoForward WHERE AD_Client_ID=? AND JP_WF_User_From_ID = ?  AND (AD_WF_Node_ID = ? OR AD_WF_Node_ID IS NULL) AND (JP_WF_Org_ID = ? OR JP_WF_Org_ID IS NULL) AND ValidFrom <= ? AND IsActive = 'Y' ORDER BY AD_WF_Node_ID NULLS LAST, JP_WF_Org_ID NULLS LAST, ValidFrom DESC";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)"SELECT * FROM JP_WF_AutoForward WHERE AD_Client_ID=? AND JP_WF_User_From_ID = ?  AND (AD_WF_Node_ID = ? OR AD_WF_Node_ID IS NULL) AND (JP_WF_Org_ID = ? OR JP_WF_Org_ID IS NULL) AND ValidFrom <= ? AND IsActive = 'Y' ORDER BY AD_WF_Node_ID NULLS LAST, JP_WF_Org_ID NULLS LAST, ValidFrom DESC", (String)trxName);
                    pstmt.setInt(1, AD_Client_ID);
                    pstmt.setInt(2, AD_User_ID);
                    pstmt.setInt(3, AD_WF_Node_ID);
                    pstmt.setInt(4, AD_Org_ID);
                    pstmt.setTimestamp(5, Date2);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        autoForward = new MWFAutoForward(Env.getCtx(), rs, trxName);
                    }
                }
                catch (Exception exception) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (autoForward != null) {
            for (Integer forward_User_ID : list_Forward_User_ID) {
                if (forward_User_ID.intValue() != autoForward.getJP_WF_User_To_ID()) continue;
                throw new Exception(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_WF_CirculationAutoForward")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_WF_User_From_ID") + " : " + MUser.getNameOfUser((int)autoForward.getJP_WF_User_From_ID()) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_WF_User_To_ID") + " : " + MUser.getNameOfUser((int)autoForward.getJP_WF_User_To_ID()) + " (" + "JP_WF_AutoForward_ID" + " = " + autoForward.getJP_WF_AutoForward_ID() + ")");
            }
            list_Forward_User_ID.add(autoForward.getJP_WF_User_To_ID());
            MWFAutoForward reForward = MWFAutoForward.get(AD_Client_ID, autoForward.getJP_WF_User_To_ID(), AD_WF_Node_ID, AD_Org_ID, Date2, list_Forward_User_ID, trxName);
            if (reForward != null) {
                autoForward = reForward;
            }
        }
        s_cache.put((Object)key, (Object)autoForward);
        return autoForward;
    }
}

