/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MWFAutoAddUser;
import jpiere.base.plugin.org.adempiere.model.X_JP_WF_AutoAddApprovers;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.wf.MWFActivity;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWorkflow;

public class MWFAutoAddApprovers
extends X_JP_WF_AutoAddApprovers {
    private MWFAutoAddUser[] autoAddUsers = null;
    private static CCache<String, MWFAutoAddApprovers> s_cache = new CCache("JP_WF_AutoAddApprovers", 100, 60);
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    public MWFAutoAddApprovers(Properties ctx, int JP_WF_AutoAddApprovers_ID, String trxName) {
        super(ctx, JP_WF_AutoAddApprovers_ID, trxName);
    }

    public MWFAutoAddApprovers(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        block17: {
            if (newRecord && this.is_ValueChanged("AD_Workflow_ID")) {
                if (this.getAD_Workflow_ID() == 0) {
                    this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)this.getCtx(), (String)"AD_Workflow_ID"));
                    return false;
                }
                MWorkflow m_wf = MWorkflow.get((int)this.getAD_Workflow_ID());
                if (!"P".equals(m_wf.getWorkflowType()) && !"V".equals(m_wf.getWorkflowType())) {
                    this.log.saveError("Error", "JP_WF_Check_WFType");
                    return false;
                }
            }
            if (newRecord && this.is_ValueChanged("AD_WF_Node_ID")) {
                if (this.getAD_WF_Node_ID() == 0) {
                    this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)this.getCtx(), (String)"AD_WF_Node_ID"));
                    return false;
                }
                MWFNode m_wfNode = MWFNode.get((int)this.getAD_WF_Node_ID());
                if (!"C".equals(m_wfNode.getAction()) && !"W".equals(m_wfNode.getAction())) {
                    this.log.saveError("Error", "JP_WF_Check_Node_Action");
                    return false;
                }
            }
            if (newRecord) {
                String sql = null;
                sql = this.get_Value("JP_WF_Org_ID") == null ? "SELECT * FROM JP_WF_AutoAddApprovers WHERE AD_Client_ID=? AND AD_WF_Node_ID = ? AND JP_WF_Org_ID IS NULL AND ValidFrom = ? " : "SELECT * FROM JP_WF_AutoAddApprovers WHERE AD_Client_ID=? AND AD_WF_Node_ID = ? AND JP_WF_Org_ID = ? AND ValidFrom = ? ";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, this.getAD_Client_ID());
                    pstmt.setInt(2, this.getAD_WF_Node_ID());
                    if (this.get_Value("JP_WF_Org_ID") == null) {
                        pstmt.setTimestamp(3, this.getValidFrom());
                    } else {
                        pstmt.setInt(3, this.getJP_WF_Org_ID());
                        pstmt.setTimestamp(4, this.getValidFrom());
                    }
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        MWFAutoAddApprovers wfAAA = new MWFAutoAddApprovers(this.getCtx(), rs, this.get_TrxName());
                        this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_AlreadyRegistered")) + " - " + Msg.getElement((Properties)this.getCtx(), (String)"Value") + " : " + wfAAA.getValue());
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        return false;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    break block17;
                }
                finally {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                Object var3_3 = null;
            }
        }
        if (newRecord || this.is_ValueChanged("AD_Workflow_ID") || this.is_ValueChanged("AD_WF_Node_ID") || this.is_ValueChanged("ValidFrom") || this.is_ValueChanged("JP_WF_Org_ID") || this.is_ValueChanged("IsActive")) {
            s_cache.reset();
        }
        return true;
    }

    protected boolean beforeDelete() {
        s_cache.reset();
        return true;
    }

    public MWFAutoAddUser[] getAutoAddUsers(boolean reload) {
        ArrayList<MWFAutoAddUser> list;
        block7: {
            if (!reload && this.autoAddUsers != null && this.autoAddUsers.length != 0) {
                return this.autoAddUsers;
            }
            list = new ArrayList<MWFAutoAddUser>();
            String sql = "SELECT * FROM JP_WF_AutoAddUser WHERE JP_WF_AutoAddApprovers_ID=? AND IsActive = 'Y' ORDER BY AD_User_ID";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)"SELECT * FROM JP_WF_AutoAddUser WHERE JP_WF_AutoAddApprovers_ID=? AND IsActive = 'Y' ORDER BY AD_User_ID", (String)this.get_TrxName());
                    pstmt.setInt(1, this.getJP_WF_AutoAddApprovers_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MWFAutoAddUser(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "SELECT * FROM JP_WF_AutoAddUser WHERE JP_WF_AutoAddApprovers_ID=? AND IsActive = 'Y' ORDER BY AD_User_ID", (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        this.autoAddUsers = new MWFAutoAddUser[list.size()];
        list.toArray(this.autoAddUsers);
        return this.autoAddUsers;
    }

    public static MWFAutoAddApprovers get(MWFActivity wfActivity) {
        MWFAutoAddApprovers approvers;
        String key;
        block7: {
            key = wfActivity.getAD_Client_ID() + "_" + wfActivity.getAD_WF_Node_ID() + "_" + wfActivity.getAD_Org_ID() + "_" + sdf.format(wfActivity.getCreated());
            approvers = null;
            if (s_cache.containsKey((Object)key)) {
                approvers = (MWFAutoAddApprovers)s_cache.get((Object)key);
                return approvers;
            }
            String sql = "SELECT * FROM JP_WF_AutoAddApprovers WHERE AD_Client_ID=? AND AD_WF_Node_ID = ? AND (JP_WF_Org_ID = ? OR JP_WF_Org_ID IS NULL) AND ValidFrom <= ? AND IsActive = 'Y' ORDER BY JP_WF_Org_ID NULLS LAST, ValidFrom DESC";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)"SELECT * FROM JP_WF_AutoAddApprovers WHERE AD_Client_ID=? AND AD_WF_Node_ID = ? AND (JP_WF_Org_ID = ? OR JP_WF_Org_ID IS NULL) AND ValidFrom <= ? AND IsActive = 'Y' ORDER BY JP_WF_Org_ID NULLS LAST, ValidFrom DESC", (String)wfActivity.get_TrxName());
                    pstmt.setInt(1, wfActivity.getAD_Client_ID());
                    pstmt.setInt(2, wfActivity.getAD_WF_Node_ID());
                    pstmt.setInt(3, wfActivity.getAD_Org_ID());
                    pstmt.setTimestamp(4, wfActivity.getCreated());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        approvers = new MWFAutoAddApprovers(wfActivity.getCtx(), rs, wfActivity.get_TrxName());
                    }
                }
                catch (Exception exception) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        s_cache.put((Object)key, (Object)approvers);
        return approvers;
    }

    public static int cacheCrear() {
        return s_cache.reset();
    }
}

