/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.X_JP_Tax_History;
import org.compiere.model.MTax;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MTaxHistory
extends X_JP_Tax_History {
    private static CCache<Integer, MTaxHistory[]> s_cache = new CCache("JP_Tax_History", 100, 10);

    public MTaxHistory(Properties ctx, int JP_Tax_History_ID, String trxName) {
        super(ctx, JP_Tax_History_ID, trxName);
    }

    public MTaxHistory(Properties ctx, int JP_Tax_History_ID, String trxName, String ... virtualColumns) {
        super(ctx, JP_Tax_History_ID, trxName, virtualColumns);
    }

    public MTaxHistory(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getC_Tax_ID() == 0) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"C_Tax_ID = 0"));
            return false;
        }
        if (this.getAD_Client_ID() == 0) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"AD_Client_ID = 0"));
            return false;
        }
        if (newRecord || this.is_ValueChanged("DateFrom") || this.is_ValueChanged("DateTo")) {
            if (this.getDateFrom().compareTo(this.getDateTo()) > 0) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"DateFrom")) + " > " + Msg.getElement((Properties)this.getCtx(), (String)"DateTo"))));
                return false;
            }
            MTaxHistory[] m_Histories = this.getOtherHistories();
            int i = 0;
            while (i < m_Histories.length) {
                if (this.getDateFrom().compareTo(m_Histories[i].getDateTo()) <= 0 && m_Histories[i].getDateFrom().compareTo(this.getDateTo()) <= 0) {
                    this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_OverlapPeriod"));
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private MTaxHistory[] getOtherHistories() {
        ArrayList<MTaxHistory> list;
        MTaxHistory[] m_Histories;
        block6: {
            m_Histories = null;
            list = new ArrayList<MTaxHistory>();
            String sql = "SELECT * FROM JP_Tax_History WHERE C_Tax_ID=? AND JP_Tax_History_ID <> ?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, this.getC_Tax_ID());
                    pstmt.setInt(2, this.getJP_Tax_History_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MTaxHistory(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        m_Histories = new MTaxHistory[list.size()];
        list.toArray(m_Histories);
        return m_Histories;
    }

    public static MTaxHistory[] getHistories(Properties ctx, int C_Tax_ID, String trxName) {
        MTaxHistory[] m_Histories = (MTaxHistory[])s_cache.get((Object)C_Tax_ID);
        if (m_Histories != null) {
            return m_Histories;
        }
        String whereClause = "C_Tax_ID=?";
        List list = new Query(ctx, "JP_Tax_History", "C_Tax_ID=?", trxName).setParameters(new Object[]{C_Tax_ID}).setOrderBy("DateFrom DESC").list();
        m_Histories = new MTaxHistory[list.size()];
        list.toArray(m_Histories);
        s_cache.put((Object)C_Tax_ID, (Object)m_Histories);
        return m_Histories;
    }

    public static MTaxHistory getHistory(Properties ctx, int C_Tax_ID, Timestamp date, String trxName) {
        MTaxHistory m_History = null;
        MTaxHistory[] m_Histories = MTaxHistory.getHistories(ctx, C_Tax_ID, trxName);
        int i = 0;
        while (i < m_Histories.length) {
            if (m_Histories[i].getDateFrom().compareTo(date) <= 0 && m_Histories[i].getDateTo().compareTo(date) >= 0) {
                m_History = m_Histories[i];
                break;
            }
            ++i;
        }
        return m_History;
    }

    public static String getHistoryName(Properties ctx, int C_Tax_ID, Timestamp date, String trxName) {
        MTaxHistory m_History = MTaxHistory.getHistory(ctx, C_Tax_ID, date, trxName);
        if (m_History == null) {
            return MTax.get((Properties)ctx, (int)C_Tax_ID).getName();
        }
        return m_History.getName();
    }
}

