/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.X_PA_ReportCubeJP;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MPeriod;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;

public class MReportCubeJP
extends X_PA_ReportCubeJP {
    private static final long serialVersionUID = -4771117572936231607L;

    public MReportCubeJP(Properties ctx, int PA_ReportCubeJP_ID, String trxName) {
        super(ctx, PA_ReportCubeJP_ID, trxName);
    }

    public MReportCubeJP(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String update(boolean reset, boolean force) {
        String result;
        block43: {
            Object[] objectArray;
            String lockSQL;
            int locked;
            long elapsed;
            long start;
            result = String.valueOf(this.getName()) + ": ";
            Timestamp ts = null;
            String where = " WHERE PA_ReportCubeJP_ID = " + this.getPA_ReportCubeJP_ID();
            String periods = " (-1) ";
            if (this.getLastRecalculated() != null && !reset) {
                StringBuilder periodList = new StringBuilder();
                StringBuilder periodNames = new StringBuilder();
                String sql = "SELECT DISTINCT p.C_Period_ID, p.Name FROM C_Period p INNER JOIN C_Year y ON (y.C_Year_ID=p.C_Year_ID) INNER JOIN PA_ReportCubeJP c ON (c.C_Calendar_ID = y.C_Calendar_ID) INNER JOIN Fact_Acct fact ON (fact.dateacct between p.startdate and p.enddate                       and fact.ad_client_id = c.ad_client_id) WHERE c.PA_ReportCubeJP_ID = ? AND fact.updated > c.LastRecalculated";
                this.log.log(Level.FINE, sql);
                start = System.currentTimeMillis();
                KeyNamePair[] changedPeriods = DB.getKeyNamePairs((String)sql, (boolean)false, (Object[])new Object[]{this.getPA_ReportCubeJP_ID()});
                elapsed = (System.currentTimeMillis() - start) / 1000L;
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.log(Level.FINE, "Selecting changed periods took:" + elapsed + "s");
                }
                if (changedPeriods != null && changedPeriods.length > 0) {
                    periodList.append(" (");
                    KeyNamePair[] keyNamePairArray = changedPeriods;
                    int n = changedPeriods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        KeyNamePair p = keyNamePairArray[n2];
                        periodList.append(String.valueOf(p.getID()) + ", ");
                        periodNames.append(String.valueOf(p.getName()) + ", ");
                        ++n2;
                    }
                    periodList.delete(periodList.length() - 2, periodList.length());
                    periodList.append(" )");
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.log(Level.FINE, "Periods requiring update: " + periodNames.toString());
                    }
                } else {
                    return "Nothing to update in " + this.getName();
                }
                periods = periodList.toString();
                where = String.valueOf(where) + " AND C_Period_ID IN " + periods;
            }
            if (!force && (locked = DB.executeUpdateEx((String)(lockSQL = "UPDATE PA_ReportCubeJP SET Processing = 'Y' WHERE Processing = 'N' AND PA_ReportCubeJP_ID = " + this.getPA_ReportCubeJP_ID()), (String)this.get_TrxName())) != 1) {
                throw new AdempiereException("Unable to lock cube for update:" + this.getName());
            }
            try {
                try {
                    String delSQL = "DELETE FROM Fact_Acct_SummaryJP fas " + where;
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.log(Level.FINE, "Delete sql: " + delSQL);
                    }
                    start = System.currentTimeMillis();
                    int deleted = DB.executeUpdateEx((String)delSQL, (String)this.get_TrxName());
                    elapsed = (System.currentTimeMillis() - start) / 1000L;
                    result = String.valueOf(result) + "Deleted " + deleted + " in " + elapsed + " s;";
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.log(Level.FINE, result);
                    }
                    StringBuilder insert = new StringBuilder("INSERT INTO FACT_ACCT_SUMMARYJP (PA_ReportCubeJP_ID , AD_Client_ID, AD_Org_ID, Created, CreatedBy, Updated, UpdatedBy, IsActive, C_AcctSchema_ID, Account_ID, PostingType, GL_Budget_ID, C_Period_ID, DateAcct, AmtAcctDr, AmtAcctCr, Qty");
                    StringBuilder select = new StringBuilder(" ) SELECT ?, f.AD_CLIENT_ID, f.AD_ORG_ID, max(f.Created), max(f.CreatedBy), max(f.Updated), max(f.UpdatedBy), 'Y', f.C_ACCTSCHEMA_ID, f.ACCOUNT_ID, f.POSTINGTYPE, GL_Budget_ID, p.c_period_id,\tp.StartDate, COALESCE(SUM(AmtAcctDr),0), COALESCE(SUM(AmtAcctCr),0), COALESCE(SUM(Qty),0)");
                    String from = " FROM fact_acct f  INNER JOIN C_Period p ON ( f.C_Period_ID = p.C_Period_ID )  INNER JOIN C_Year y ON ( p.C_Year_ID = y.C_Year_ID )  WHERE y.C_Calendar_ID = ? AND f.AD_Client_ID = ? ";
                    if (this.getLastRecalculated() != null && !reset) {
                        from = String.valueOf(from) + "AND  p.C_Period_ID IN " + periods;
                    }
                    StringBuilder groups = new StringBuilder(" GROUP BY f.AD_CLIENT_ID, f.AD_ORG_ID, f.C_ACCTSCHEMA_ID, f.ACCOUNT_ID, f.POSTINGTYPE, GL_Budget_ID, p.c_period_id, p.StartDate ");
                    ArrayList<String> values = new ArrayList<String>();
                    if (this.isProductDim()) {
                        values.add("M_Product_ID");
                    }
                    if (this.isBPartnerDim()) {
                        values.add("C_BPartner_ID");
                    }
                    if (this.isProjectDim()) {
                        values.add("C_Project_ID");
                    }
                    if (this.isOrgTrxDim()) {
                        values.add("AD_OrgTrx_ID");
                    }
                    if (this.isSalesRegionDim()) {
                        values.add("C_SalesRegion_ID");
                    }
                    if (this.isActivityDim()) {
                        values.add("C_Activity_ID");
                    }
                    if (this.isCampaignDim()) {
                        values.add("C_Campaign_ID");
                    }
                    if (this.isLocToDim()) {
                        values.add("C_LocTo_ID");
                    }
                    if (this.isLocFromDim()) {
                        values.add("C_LocFrom_ID");
                    }
                    if (this.isUser1Dim()) {
                        values.add("User1_ID");
                    }
                    if (this.isUser2Dim()) {
                        values.add("User2_ID");
                    }
                    if (this.isUserElement1Dim()) {
                        values.add("UserElement1_ID");
                    }
                    if (this.isUserElement2Dim()) {
                        values.add("UserElement2_ID");
                    }
                    if (this.isSubAcctDim()) {
                        values.add("C_SubAcct_ID");
                    }
                    if (this.isProjectPhaseDim()) {
                        values.add("C_ProjectPhase_ID");
                    }
                    if (this.isProjectTaskDim()) {
                        values.add("C_ProjectTask_ID");
                    }
                    if (this.isContractDimJP()) {
                        values.add("JP_Contract_ID");
                        values.add("JP_ContractContent_ID");
                        values.add("JP_ContractProcPeriod_ID");
                    }
                    for (String dim : values) {
                        insert.append(", " + dim);
                        select.append(", f." + dim);
                        groups.append(", f." + dim);
                    }
                    String sql = insert.append(select.toString()).append(from).append(groups.toString()).toString();
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.log(Level.FINE, sql);
                    }
                    Object[] params = new Object[]{this.getPA_ReportCubeJP_ID(), this.getC_Calendar_ID(), this.getAD_Client_ID()};
                    start = System.currentTimeMillis();
                    int rows = DB.executeUpdateEx((String)sql, (Object[])params, (String)this.get_TrxName());
                    long seconds = (System.currentTimeMillis() - start) / 1000L;
                    String insertResult = "Inserted " + rows + " in " + seconds + " s.";
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.log(Level.FINE, insertResult);
                    }
                    result = String.valueOf(result) + insertResult;
                    String tsSQL = "SELECT max(fas.Updated) FROM Fact_Acct_SummaryJP fas WHERE fas.PA_ReportCubeJP_ID = " + this.getPA_ReportCubeJP_ID();
                    ts = DB.getSQLValueTS((String)this.get_TrxName(), (String)tsSQL, (Object[])new Object[0]);
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.log(Level.FINE, "Last updated: " + ts);
                    }
                }
                catch (DBException e) {
                    Object[] objectArray2;
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.log(Level.FINE, String.valueOf(this.getName()) + " update failed:" + e.getMessage());
                    }
                    String unlockSQL = "UPDATE PA_ReportCubeJP SET Processing = 'N', LastRecalculated = " + (ts == null ? "null" : "?") + " WHERE PA_ReportCubeJP_ID = " + this.getPA_ReportCubeJP_ID();
                    if (ts == null) {
                        objectArray2 = new Object[]{};
                    } else {
                        Object[] objectArray3 = new Object[1];
                        objectArray2 = objectArray3;
                        objectArray3[0] = ts;
                    }
                    Object[] parameters = objectArray2;
                    DB.executeUpdateEx((String)unlockSQL, (Object[])parameters, (String)this.get_TrxName());
                    break block43;
                }
            }
            catch (Throwable throwable) {
                Object[] objectArray4;
                String unlockSQL = "UPDATE PA_ReportCubeJP SET Processing = 'N', LastRecalculated = " + (ts == null ? "null" : "?") + " WHERE PA_ReportCubeJP_ID = " + this.getPA_ReportCubeJP_ID();
                if (ts == null) {
                    objectArray4 = new Object[]{};
                } else {
                    Object[] objectArray5 = new Object[1];
                    objectArray4 = objectArray5;
                    objectArray5[0] = ts;
                }
                Object[] parameters = objectArray4;
                DB.executeUpdateEx((String)unlockSQL, (Object[])parameters, (String)this.get_TrxName());
                throw throwable;
            }
            String unlockSQL = "UPDATE PA_ReportCubeJP SET Processing = 'N', LastRecalculated = " + (ts == null ? "null" : "?") + " WHERE PA_ReportCubeJP_ID = " + this.getPA_ReportCubeJP_ID();
            if (ts == null) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray6 = new Object[1];
                objectArray = objectArray6;
                objectArray6[0] = ts;
            }
            Object[] parameters = objectArray;
            DB.executeUpdateEx((String)unlockSQL, (Object[])parameters, (String)this.get_TrxName());
        }
        return result;
    }

    public String updateBS(int C_AcctSchema_ID, int C_Calendar_ID, int C_Year_ID, MPeriod m_Period, boolean isDeleteDataOnlyJP) {
        String result;
        block23: {
            long start;
            block22: {
                result = null;
                start = System.currentTimeMillis();
                String delSQL = "DELETE FROM Fact_Acct_BS_JP WHERE PA_ReportCubeJP_ID = ? AND C_AcctSchema_ID = ? AND C_Period_ID = ?";
                Object[] deleteParams = new Object[]{this.getPA_ReportCubeJP_ID(), C_AcctSchema_ID, m_Period.getC_Period_ID()};
                DB.executeUpdateEx((String)delSQL, (Object[])deleteParams, (String)this.get_TrxName());
                if (!isDeleteDataOnlyJP) break block22;
                return "";
            }
            try {
                StringBuilder insert = new StringBuilder("INSERT INTO FACT_ACCT_BS_JP (PA_ReportCubeJP_ID , AD_Client_ID, AD_Org_ID, Created, CreatedBy, Updated, UpdatedBy, IsActive, C_AcctSchema_ID, Account_ID, PostingType, GL_Budget_ID, C_Period_ID, DateAcct, AmtAcctDr, AmtAcctCr, Qty");
                StringBuilder select = new StringBuilder(" ) SELECT ?, f.AD_CLIENT_ID, f.AD_ORG_ID, max(f.Created), max(f.CreatedBy), max(f.Updated), max(f.UpdatedBy), 'Y', f.C_ACCTSCHEMA_ID, f.ACCOUNT_ID, f.POSTINGTYPE, GL_Budget_ID, ?,\t?, COALESCE(SUM(AmtAcctDr),0), COALESCE(SUM(AmtAcctCr),0), COALESCE(SUM(Qty),0)");
                String from = " FROM Fact_Acct_SummaryJP f  INNER JOIN C_ElementValue ev ON ( f.Account_ID = ev.C_ElementValue_ID )  WHERE f.C_AcctSchema_ID = ? AND f.PA_ReportCubeJP_ID = ? AND f.DateAcct <= ?  AND ev.AccountType IN ('A','L','O')";
                StringBuilder groups = new StringBuilder(" GROUP BY f.AD_CLIENT_ID, f.AD_ORG_ID, f.C_ACCTSCHEMA_ID, f.ACCOUNT_ID, f.POSTINGTYPE, f.GL_Budget_ID");
                ArrayList<String> values = new ArrayList<String>();
                if (this.isProductDim()) {
                    values.add("M_Product_ID");
                }
                if (this.isBPartnerDim()) {
                    values.add("C_BPartner_ID");
                }
                if (this.isProjectDim()) {
                    values.add("C_Project_ID");
                }
                if (this.isOrgTrxDim()) {
                    values.add("AD_OrgTrx_ID");
                }
                if (this.isSalesRegionDim()) {
                    values.add("C_SalesRegion_ID");
                }
                if (this.isActivityDim()) {
                    values.add("C_Activity_ID");
                }
                if (this.isCampaignDim()) {
                    values.add("C_Campaign_ID");
                }
                if (this.isLocToDim()) {
                    values.add("C_LocTo_ID");
                }
                if (this.isLocFromDim()) {
                    values.add("C_LocFrom_ID");
                }
                if (this.isUser1Dim()) {
                    values.add("User1_ID");
                }
                if (this.isUser2Dim()) {
                    values.add("User2_ID");
                }
                if (this.isUserElement1Dim()) {
                    values.add("UserElement1_ID");
                }
                if (this.isUserElement2Dim()) {
                    values.add("UserElement2_ID");
                }
                if (this.isSubAcctDim()) {
                    values.add("C_SubAcct_ID");
                }
                if (this.isProjectPhaseDim()) {
                    values.add("C_ProjectPhase_ID");
                }
                if (this.isProjectTaskDim()) {
                    values.add("C_ProjectTask_ID");
                }
                if (this.isContractDimJP()) {
                    values.add("JP_Contract_ID");
                    values.add("JP_ContractContent_ID");
                    values.add("JP_ContractProcPeriod_ID");
                }
                for (String dim : values) {
                    insert.append(", " + dim);
                    select.append(", f." + dim);
                    groups.append(", f." + dim);
                }
                String sql = insert.append(select.toString()).append(from).append(groups.toString()).toString();
                Object[] params = new Object[]{this.getPA_ReportCubeJP_ID(), m_Period.getC_Period_ID(), m_Period.getStartDate(), C_AcctSchema_ID, this.getPA_ReportCubeJP_ID(), m_Period.getEndDate()};
                int rows = DB.executeUpdateEx((String)sql, (Object[])params, (String)this.get_TrxName());
                long seconds = (System.currentTimeMillis() - start) / 1000L;
                result = "Inserted " + rows + " in " + seconds + " seconds.";
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.log(Level.FINE, result);
                }
            }
            catch (DBException e) {
                if (!this.log.isLoggable(Level.FINE)) break block23;
                this.log.log(Level.FINE, String.valueOf(this.getName()) + " update failed:" + e.getMessage());
            }
        }
        return result;
    }
}

