/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MCharge;
import org.compiere.model.MRMALine;
import org.compiere.model.MRMATax;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MRMATaxJP
extends MRMATax {
    private static CLogger s_log = CLogger.getCLogger(MRMATaxJP.class);

    public MRMATaxJP(Properties ctx, int ignored, String trxName) {
        super(ctx, ignored, trxName);
    }

    public MRMATaxJP(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MRMATax get(MRMALine line, int precision, boolean oldTax, String trxName) {
        boolean isOldTax;
        MRMATaxJP retValue;
        block17: {
            retValue = null;
            if (line == null || line.getM_RMA_ID() == 0) {
                s_log.fine("No RMA");
                return null;
            }
            int C_Tax_ID = line.getC_Tax_ID();
            boolean bl = isOldTax = oldTax && line.is_ValueChanged("C_Tax_ID");
            if (isOldTax) {
                Object old = line.get_ValueOld("C_Tax_ID");
                if (old == null) {
                    s_log.fine("No Old Tax");
                    return null;
                }
                C_Tax_ID = (Integer)old;
            }
            if (C_Tax_ID == 0) {
                s_log.fine("No Tax");
                return null;
            }
            String sql = "SELECT * FROM M_RMATax WHERE M_RMA_ID=? AND C_Tax_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)trxName);
                    pstmt.setInt(1, line.getM_RMA_ID());
                    pstmt.setInt(2, C_Tax_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = new MRMATaxJP(line.getCtx(), rs, trxName);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block17;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue != null) {
            retValue.setPrecision(precision);
            retValue.set_TrxName(trxName);
            if (s_log.isLoggable(Level.FINE)) {
                s_log.fine("(old=" + oldTax + ") " + (Object)((Object)retValue));
            }
            return retValue;
        }
        if (isOldTax) {
            return null;
        }
        retValue = new MRMATaxJP(line.getCtx(), 0, trxName);
        retValue.set_TrxName(trxName);
        retValue.setClientOrg((PO)line);
        retValue.setM_RMA_ID(line.getM_RMA_ID());
        retValue.setC_Tax_ID(line.getC_Tax_ID());
        retValue.setPrecision(precision);
        retValue.setIsTaxIncluded(line.getParent().isTaxIncluded());
        if (line.getC_Charge_ID() != 0) {
            MCharge charge = MCharge.get((Properties)Env.getCtx(), (int)line.getC_Charge_ID());
            if (!charge.isSameTax()) {
                retValue.setIsTaxIncluded(charge.isTaxIncluded());
            } else {
                retValue.setIsTaxIncluded(line.getParent().isTaxIncluded());
            }
        }
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("(new) " + (Object)((Object)retValue));
        }
        return retValue;
    }
}

