/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.X_JP_Product_History;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MProductHistory
extends X_JP_Product_History {
    private static CCache<Integer, MProductHistory[]> s_cache = new CCache("JP_Product_History", 100, 10);

    public MProductHistory(Properties ctx, int JP_Product_History_ID, String trxName) {
        super(ctx, JP_Product_History_ID, trxName);
    }

    public MProductHistory(Properties ctx, int JP_Product_History_ID, String trxName, String ... virtualColumns) {
        super(ctx, JP_Product_History_ID, trxName, virtualColumns);
    }

    public MProductHistory(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getM_Product_ID() == 0) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"M_Product_ID = 0"));
            return false;
        }
        if (this.getAD_Client_ID() == 0) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"AD_Client_ID = 0"));
            return false;
        }
        if (newRecord || this.is_ValueChanged("DateFrom") || this.is_ValueChanged("DateTo")) {
            if (this.getDateFrom().compareTo(this.getDateTo()) > 0) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"DateFrom")) + " > " + Msg.getElement((Properties)this.getCtx(), (String)"DateTo"))));
                return false;
            }
            MProductHistory[] m_Histories = this.getOtherHistories();
            int i = 0;
            while (i < m_Histories.length) {
                if (this.getDateFrom().compareTo(m_Histories[i].getDateTo()) <= 0 && m_Histories[i].getDateFrom().compareTo(this.getDateTo()) <= 0) {
                    this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_OverlapPeriod"));
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private MProductHistory[] getOtherHistories() {
        ArrayList<MProductHistory> list;
        MProductHistory[] m_Histories;
        block6: {
            m_Histories = null;
            list = new ArrayList<MProductHistory>();
            String sql = "SELECT * FROM JP_Product_History WHERE M_Product_ID=? AND JP_Product_History_ID <> ?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, this.getM_Product_ID());
                    pstmt.setInt(2, this.getJP_Product_History_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MProductHistory(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        m_Histories = new MProductHistory[list.size()];
        list.toArray(m_Histories);
        return m_Histories;
    }

    public static MProductHistory[] getHistories(Properties ctx, int M_Product_ID, String trxName) {
        MProductHistory[] m_Histories = (MProductHistory[])s_cache.get((Object)M_Product_ID);
        if (m_Histories != null) {
            return m_Histories;
        }
        String whereClause = "M_Product_ID=?";
        List list = new Query(ctx, "JP_Product_History", "M_Product_ID=?", trxName).setParameters(new Object[]{M_Product_ID}).setOrderBy("DateFrom DESC").list();
        m_Histories = new MProductHistory[list.size()];
        list.toArray(m_Histories);
        s_cache.put((Object)M_Product_ID, (Object)m_Histories);
        return m_Histories;
    }

    public static MProductHistory getHistory(Properties ctx, int M_Product_ID, Timestamp date, String trxName) {
        MProductHistory m_History = null;
        MProductHistory[] m_Histories = MProductHistory.getHistories(ctx, M_Product_ID, trxName);
        int i = 0;
        while (i < m_Histories.length) {
            if (m_Histories[i].getDateFrom().compareTo(date) <= 0 && m_Histories[i].getDateTo().compareTo(date) >= 0) {
                m_History = m_Histories[i];
                break;
            }
            ++i;
        }
        return m_History;
    }

    public static String getHistoryName(Properties ctx, int M_Product_ID, Timestamp date, String trxName) {
        MProductHistory m_History = MProductHistory.getHistory(ctx, M_Product_ID, date, trxName);
        if (m_History == null) {
            return MProduct.get((Properties)ctx, (int)M_Product_ID).getName();
        }
        return m_History.getName();
    }
}

