/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import jpiere.base.plugin.org.adempiere.model.MPPDocT;
import jpiere.base.plugin.org.adempiere.model.MPPPlanLineT;
import jpiere.base.plugin.org.adempiere.model.X_JP_PP_PlanT;
import org.compiere.model.MProduct;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUOM;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MPPPlanT
extends X_JP_PP_PlanT {
    private MPPDocT m_PPDocT = null;
    private MPPPlanLineT[] m_PPPlanLineTs = null;

    public MPPPlanT(Properties ctx, int JP_PP_PlanT_ID, String trxName) {
        super(ctx, JP_PP_PlanT_ID, trxName);
    }

    public MPPPlanT(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPPDocT getParent() {
        if (this.m_PPDocT == null) {
            this.m_PPDocT = new MPPDocT(this.getCtx(), this.getJP_PP_DocT_ID(), this.get_TrxName());
        } else {
            this.m_PPDocT.set_TrxName(this.get_TrxName());
        }
        return this.m_PPDocT;
    }

    protected boolean beforeSave(boolean newRecord) {
        MProduct product;
        if (newRecord) {
            this.setAD_Org_ID(this.getParent().getAD_Org_ID());
        }
        if ((newRecord || this.is_ValueChanged("C_UOM_ID") || this.getC_UOM_ID() == 0) && (product = MProduct.get((int)this.getM_Product_ID())).getC_UOM_ID() != this.getC_UOM_ID()) {
            this.setC_UOM_ID(product.getC_UOM_ID());
        }
        if (newRecord || this.is_ValueChanged("ProductionQty")) {
            boolean isStdPrecision = MSysConfig.getBooleanValue((String)"JP_PP_UOM_STDPRECISION", (boolean)true, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
            MUOM uom = MUOM.get((int)this.getC_UOM_ID());
            this.setProductionQty(this.getProductionQty().setScale(isStdPrecision ? uom.getStdPrecision() : uom.getCostingPrecision(), RoundingMode.HALF_UP));
        }
        if ((newRecord || this.is_ValueChanged("JP_ProductionDays")) && this.getJP_ProductionDays() < 0) {
            this.log.saveError("Error", String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_ProductionDays")) + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"Minus"));
            return false;
        }
        if ((newRecord || this.is_ValueChanged("JP_DayOffset")) && this.getJP_DayOffset() < 0) {
            this.log.saveError("Error", String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_DayOffset")) + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"Minus"));
            return false;
        }
        if ((newRecord || this.is_ValueChanged("C_DocType_ID")) && !this.getC_DocType().getDocBaseType().equals("JDP")) {
            this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_DifferentDocType")) + " : JDP");
            return false;
        }
        if ((newRecord || this.is_ValueChanged("C_DocTypeTarget_ID")) && !this.getC_DocTypeTarget().getDocBaseType().equals("JDF")) {
            this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_DifferentDocType")) + " : JDF");
            return false;
        }
        this.setName(this.getJP_Name());
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return false;
        }
        if (!newRecord && this.is_ValueChanged("ProductionQty")) {
            MPPPlanLineT[] lines;
            boolean isStdPrecision = MSysConfig.getBooleanValue((String)"JP_PP_UOM_STDPRECISION", (boolean)true, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
            MUOM uom = null;
            BigDecimal newQty = this.getProductionQty();
            BigDecimal oldQty = (BigDecimal)this.get_ValueOld("ProductionQty");
            BigDecimal rate = Env.ONE;
            if (oldQty != null && oldQty.compareTo(Env.ZERO) != 0) {
                rate = newQty.divide(oldQty, 4, RoundingMode.HALF_UP);
            }
            MPPPlanLineT[] mPPPlanLineTArray = lines = this.getPPPlanLineTs(true, null);
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                MPPPlanLineT line = mPPPlanLineTArray[n2];
                if (line.isEndProduct()) {
                    line.setPlannedQty(this.getProductionQty());
                    line.setQtyUsed(null);
                    line.setMovementQty(this.getProductionQty());
                } else {
                    uom = MUOM.get((int)line.getC_UOM_ID());
                    oldQty = line.getPlannedQty();
                    newQty = oldQty.multiply(rate).setScale(isStdPrecision ? uom.getStdPrecision() : uom.getCostingPrecision(), RoundingMode.HALF_UP);
                    line.setPlannedQty(newQty);
                    line.setQtyUsed(newQty);
                    line.setMovementQty(newQty.negate());
                }
                if (!line.save(this.get_TrxName())) {
                    String msg = String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_PP_PlanLineT_ID")) + " - " + Msg.getElement((Properties)this.getCtx(), (String)"Line") + " : " + line.getLine();
                    this.log.saveError("SaveError", msg);
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public MPPPlanLineT[] getPPPlanLineTs(String whereClause, String orderClause) {
        StringBuilder whereClauseFinal = new StringBuilder("JP_PP_PlanT_ID=? ");
        if (!Util.isEmpty((String)whereClause, (boolean)true)) {
            whereClauseFinal.append(whereClause);
        }
        if (orderClause.length() == 0) {
            orderClause = "Line";
        }
        List list = new Query(this.getCtx(), "JP_PP_PlanLineT", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).setOrderBy(orderClause).list();
        return list.toArray(new MPPPlanLineT[list.size()]);
    }

    public MPPPlanLineT[] getPPPlanLineTs(boolean requery, String orderBy) {
        if (this.m_PPPlanLineTs != null && !requery) {
            MPPPlanT.set_TrxName((PO[])this.m_PPPlanLineTs, (String)this.get_TrxName());
            return this.m_PPPlanLineTs;
        }
        String orderClause = "";
        orderClause = orderBy != null && orderBy.length() > 0 ? String.valueOf(orderClause) + orderBy : String.valueOf(orderClause) + "Line";
        this.m_PPPlanLineTs = this.getPPPlanLineTs(" AND IsActive='Y' ", orderClause);
        return this.m_PPPlanLineTs;
    }

    public MPPPlanLineT[] getPPPlanLineTs() {
        return this.getPPPlanLineTs(false, null);
    }
}

