/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import jpiere.base.plugin.org.adempiere.model.MPPPlan;
import jpiere.base.plugin.org.adempiere.model.MPPPlanLineQT;
import jpiere.base.plugin.org.adempiere.model.MPPPlanLineT;
import jpiere.base.plugin.org.adempiere.model.MPPPlanLineTQT;
import jpiere.base.plugin.org.adempiere.model.X_JP_PP_PlanLine;
import org.compiere.model.MProduct;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUOM;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MPPPlanLine
extends X_JP_PP_PlanLine {
    protected MPPPlan parent = null;
    private MPPPlanLineQT[] m_PPPlanLineQTs = null;

    public MPPPlanLine(Properties ctx, int JP_PP_PlanLine_ID, String trxName) {
        super(ctx, JP_PP_PlanLine_ID, trxName);
    }

    public MPPPlanLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        MProduct product;
        if (newRecord) {
            this.setAD_Org_ID(this.getParent().getAD_Org_ID());
        }
        if (newRecord && this.getParent().isProcessed()) {
            this.log.saveError("Error", Msg.getElement((Properties)this.getCtx(), (String)"Processed"));
            return false;
        }
        if ((newRecord || this.is_ValueChanged("C_UOM_ID") || this.getC_UOM_ID() == 0) && (product = MProduct.get((int)this.getM_Product_ID())).getC_UOM_ID() != this.getC_UOM_ID()) {
            this.setC_UOM_ID(product.getC_UOM_ID());
        }
        if (this.getParent().getM_Product_ID() == this.getM_Product_ID() && (this.getParent().getProductionQty().signum() == this.getPlannedQty().signum() || this.getParent().getProductionQty().compareTo(Env.ZERO) == 0 || this.getPlannedQty().compareTo(Env.ZERO) == 0)) {
            this.setIsEndProduct(true);
        } else {
            this.setIsEndProduct(false);
        }
        if (this.isEndProduct()) {
            if (newRecord || this.is_ValueChanged("PlannedQty")) {
                boolean isStdPrecision = MSysConfig.getBooleanValue((String)"JP_PP_UOM_STDPRECISION", (boolean)true, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
                MUOM uom = MUOM.get((int)this.getC_UOM_ID());
                this.setPlannedQty(this.getPlannedQty().setScale(isStdPrecision ? uom.getStdPrecision() : uom.getCostingPrecision(), RoundingMode.HALF_UP));
                this.setQtyUsed(null);
                this.setJP_QtyUsedFact(null);
                this.setMovementQty(this.getPlannedQty());
                if (newRecord) {
                    this.setJP_MovementQtyFact(Env.ZERO);
                }
            }
        } else if (newRecord || this.is_ValueChanged("PlannedQty")) {
            boolean isStdPrecision = MSysConfig.getBooleanValue((String)"JP_PP_UOM_STDPRECISION", (boolean)true, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
            MUOM uom = MUOM.get((int)this.getC_UOM_ID());
            this.setPlannedQty(this.getPlannedQty().setScale(isStdPrecision ? uom.getStdPrecision() : uom.getCostingPrecision(), RoundingMode.HALF_UP));
            this.setQtyUsed(this.getPlannedQty());
            this.setMovementQty(this.getQtyUsed().negate());
            if (newRecord) {
                this.setJP_QtyUsedFact(Env.ZERO);
                this.setJP_MovementQtyFact(Env.ZERO);
            }
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        block6: {
            int no;
            if (!success) {
                return false;
            }
            if (this.isEndProduct() && (newRecord || this.is_ValueChanged("PlannedQty") || this.is_ValueChanged("IsActive")) && (no = this.updateParentProductionQty(this.get_TrxName())) != 1) {
                this.log.saveError("DBExecuteError", "MPPPlanLine#afterSave() -> updateParentProductionQty()");
                return false;
            }
            if (!newRecord || !this.isEndProduct() || this.getIsCreated().equals("Y")) break block6;
            if (this.getJP_PP_PlanLineT_ID() != 0) {
                MPPPlanLineT ppPlanLineT = new MPPPlanLineT(this.getCtx(), this.getJP_PP_PlanLineT_ID(), this.get_TrxName());
                MPPPlanLineTQT[] qts_From = ppPlanLineT.getPPPlanLineTQTs();
                MPPPlanLineQT qt_To = null;
                MPPPlanLineTQT[] mPPPlanLineTQTArray = qts_From;
                int n = qts_From.length;
                int n2 = 0;
                while (n2 < n) {
                    MPPPlanLineTQT qt_From = mPPPlanLineTQTArray[n2];
                    qt_To = new MPPPlanLineQT(this.getCtx(), 0, this.get_TrxName());
                    PO.copyValues((PO)qt_From, (PO)qt_To);
                    qt_To.setJP_PP_PlanLine_ID(this.getJP_PP_PlanLine_ID());
                    qt_To.setJP_PP_PlanLineTQT_ID(qt_From.getJP_PP_PlanLineTQT_ID());
                    qt_To.setAD_Org_ID(this.getAD_Org_ID());
                    qt_To.setSeqNo(qt_From.getSeqNo());
                    qt_To.setM_QualityTest_ID(qt_From.getM_QualityTest_ID());
                    qt_To.setExpectedResult(qt_From.getExpectedResult());
                    qt_To.setIsActive(true);
                    qt_To.save(this.get_TrxName());
                    ++n2;
                }
            } else {
                MPPPlanLineQT ppPlanLineQT = null;
                PO[] productQTs = this.getProductQualityTest();
                int seqNo = 0;
                PO[] pOArray = productQTs;
                int n = productQTs.length;
                int n3 = 0;
                while (n3 < n) {
                    PO productQT = pOArray[n3];
                    ppPlanLineQT = new MPPPlanLineQT(this.getCtx(), 0, this.get_TrxName());
                    PO.copyValues((PO)productQT, (PO)ppPlanLineQT);
                    ppPlanLineQT.setJP_PP_PlanLine_ID(this.getJP_PP_PlanLine_ID());
                    ppPlanLineQT.setAD_Org_ID(this.getAD_Org_ID());
                    ppPlanLineQT.setSeqNo(seqNo += 10);
                    ppPlanLineQT.setM_QualityTest_ID(productQT.get_ValueAsInt("M_QualityTest_ID"));
                    ppPlanLineQT.setExpectedResult(productQT.get_ValueAsString("ExpectedResult"));
                    ppPlanLineQT.setIsActive(true);
                    ppPlanLineQT.save(this.get_TrxName());
                    ++n3;
                }
            }
        }
        return true;
    }

    protected boolean afterDelete(boolean success) {
        int no = this.updateParentProductionQty(this.get_TrxName());
        if (no != 1) {
            this.log.saveError("DBExecuteError", "MPPPlanLine#afterDelete() -> updateParentProductionQty()");
            return false;
        }
        MPPPlanLine[] lines = this.getParent().getPPPlanLines(true, null);
        if (lines.length == 0) {
            String sql = "UPDATE JP_PP_Plan SET IsCreated='N' WHERE JP_PP_Plan_ID=? ";
            no = DB.executeUpdate((String)sql, (Object[])new Object[]{this.getJP_PP_Plan_ID()}, (boolean)false, (String)this.get_TrxName(), (int)0);
            if (no != 1) {
                this.log.saveError("DBExecuteError", "MPPPlanLine#afterDelete()");
                return false;
            }
        }
        return true;
    }

    private int updateParentProductionQty(String trxName) {
        String sql = "UPDATE JP_PP_Plan SET ProductionQty=(SELECT COALESCE(SUM(MovementQty),0) FROM JP_PP_PlanLine WHERE JP_PP_Plan_ID=? AND IsEndProduct='Y' AND IsActive='Y' )  WHERE JP_PP_Plan_ID=?";
        int no = DB.executeUpdate((String)sql, (Object[])new Object[]{this.getJP_PP_Plan_ID(), this.getJP_PP_Plan_ID()}, (boolean)false, (String)trxName, (int)0);
        return no;
    }

    public MPPPlan getParent() {
        if (this.parent == null) {
            this.parent = new MPPPlan(this.getCtx(), this.getJP_PP_Plan_ID(), this.get_TrxName());
        } else {
            this.parent.set_TrxName(this.get_TrxName());
        }
        return this.parent;
    }

    public MPPPlanLineQT[] getPPPlanLineQTs(String whereClause, String orderClause) {
        StringBuilder whereClauseFinal = new StringBuilder("JP_PP_PlanLine_ID=? ");
        if (!Util.isEmpty((String)whereClause, (boolean)true)) {
            whereClauseFinal.append(whereClause);
        }
        if (orderClause.length() == 0) {
            orderClause = "SeqNo";
        }
        List list = new Query(this.getCtx(), "JP_PP_PlanLineQT", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).setOrderBy(orderClause).list();
        return list.toArray(new MPPPlanLineQT[list.size()]);
    }

    public MPPPlanLineQT[] getPPPlanLineQTs(boolean requery, String orderBy) {
        if (this.m_PPPlanLineQTs != null && !requery) {
            MPPPlanLine.set_TrxName((PO[])this.m_PPPlanLineQTs, (String)this.get_TrxName());
            return this.m_PPPlanLineQTs;
        }
        String orderClause = "";
        orderClause = orderBy != null && orderBy.length() > 0 ? String.valueOf(orderClause) + orderBy : String.valueOf(orderClause) + "SeqNo";
        this.m_PPPlanLineQTs = this.getPPPlanLineQTs(" AND IsActive='Y' ", orderClause);
        return this.m_PPPlanLineQTs;
    }

    public MPPPlanLineQT[] getPPPlanLineQTs() {
        return this.getPPPlanLineQTs(false, null);
    }

    public PO[] getProductQualityTest() {
        String where = " M_Product_ID = ? AND IsActive='Y' ";
        List list = new Query(this.getCtx(), "M_Product_QualityTest", where, this.get_TrxName()).setOnlyActiveRecords(true).setParameters(new Object[]{this.getM_Product_ID()}).list();
        return list.toArray(new PO[list.size()]);
    }
}

