/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MPPDoc;
import jpiere.base.plugin.org.adempiere.model.MPPFact;
import jpiere.base.plugin.org.adempiere.model.MPPPlanLine;
import jpiere.base.plugin.org.adempiere.model.MPPPlanT;
import jpiere.base.plugin.org.adempiere.model.X_JP_PP_Plan;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUOM;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MPPPlan
extends X_JP_PP_Plan
implements DocAction,
DocOptions {
    private MPPDoc m_PPDoc = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private MPPPlanLine[] m_PPPlanLines = null;
    private MPPFact[] m_PPFacts = null;

    public MPPPlan(Properties ctx, int JP_PP_Plan_ID, String trxName) {
        super(ctx, JP_PP_Plan_ID, trxName);
    }

    public MPPPlan(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPPDoc getParent() {
        if (this.m_PPDoc == null) {
            this.m_PPDoc = new MPPDoc(this.getCtx(), this.getJP_PP_Doc_ID(), this.get_TrxName());
        } else {
            this.m_PPDoc.set_TrxName(this.get_TrxName());
        }
        return this.m_PPDoc;
    }

    protected boolean beforeSave(boolean newRecord) {
        MUOM uom;
        MProduct product;
        MPPDoc ppDoc;
        if (newRecord) {
            this.setAD_Org_ID(this.getParent().getAD_Org_ID());
        }
        if (newRecord && (ppDoc = this.getParent()).isProcessed()) {
            this.log.saveError("Error", Msg.getElement((Properties)this.getCtx(), (String)"Processed"));
            return false;
        }
        if ((newRecord || this.is_ValueChanged("C_UOM_ID") || this.getC_UOM_ID() == 0) && (product = MProduct.get((int)this.getM_Product_ID())).getC_UOM_ID() != this.getC_UOM_ID()) {
            this.setC_UOM_ID(product.getC_UOM_ID());
        }
        if ((newRecord || this.is_ValueChanged("JP_PP_PlanT_ID")) && this.getJP_PP_PlanT_ID() != 0) {
            MPPPlanT ppPlanT = new MPPPlanT(this.getCtx(), this.getJP_PP_PlanT_ID(), this.get_TrxName());
            if (this.getM_Product_ID() != ppPlanT.getM_Product_ID()) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_PP_Plan_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"M_Product_ID");
                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_PP_PlanT_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"M_Product_ID");
                String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1});
                this.log.saveError("Error", msg);
                return false;
            }
        }
        if (newRecord || this.is_ValueChanged("ProductionQty")) {
            boolean isStdPrecision = MSysConfig.getBooleanValue((String)"JP_PP_UOM_STDPRECISION", (boolean)true, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
            uom = MUOM.get((int)this.getC_UOM_ID());
            this.setProductionQty(this.getProductionQty().setScale(isStdPrecision ? uom.getStdPrecision() : uom.getCostingPrecision(), RoundingMode.HALF_UP));
        }
        if (newRecord || this.is_ValueChanged("JP_ProductionQtyFact")) {
            boolean isStdPrecision = MSysConfig.getBooleanValue((String)"JP_PP_UOM_STDPRECISION", (boolean)true, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
            uom = MUOM.get((int)this.getC_UOM_ID());
            this.setJP_ProductionQtyFact(this.getJP_ProductionQtyFact().setScale(isStdPrecision ? uom.getStdPrecision() : uom.getCostingPrecision(), RoundingMode.HALF_UP));
        }
        if ((newRecord || this.is_ValueChanged("C_DocType_ID")) && !this.getC_DocType().getDocBaseType().equals("JDP")) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_DifferentDocType"));
            return false;
        }
        this.setName(this.getJP_Name());
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return false;
        }
        if (!newRecord && this.is_ValueChanged("ProductionQty")) {
            MPPPlanLine[] lines;
            boolean isStdPrecision = MSysConfig.getBooleanValue((String)"JP_PP_UOM_STDPRECISION", (boolean)true, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
            MUOM uom = null;
            BigDecimal newQty = this.getProductionQty();
            BigDecimal oldQty = (BigDecimal)this.get_ValueOld("ProductionQty");
            BigDecimal rate = Env.ONE;
            if (oldQty != null && oldQty.compareTo(Env.ZERO) != 0) {
                rate = newQty.divide(oldQty, 4, RoundingMode.HALF_UP);
            }
            MPPPlanLine[] mPPPlanLineArray = lines = this.getPPPlanLines(true, null);
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                MPPPlanLine line = mPPPlanLineArray[n2];
                if (line.isEndProduct()) {
                    line.setPlannedQty(this.getProductionQty());
                    line.setQtyUsed(null);
                    line.setMovementQty(this.getProductionQty());
                } else {
                    uom = MUOM.get((int)line.getC_UOM_ID());
                    oldQty = line.getPlannedQty();
                    newQty = oldQty.multiply(rate).setScale(isStdPrecision ? uom.getStdPrecision() : uom.getCostingPrecision(), RoundingMode.HALF_UP);
                    line.setPlannedQty(newQty);
                    line.setQtyUsed(newQty);
                    line.setMovementQty(newQty.negate());
                }
                if (!line.save(this.get_TrxName())) {
                    String msg = String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_PP_PlanLine_ID")) + " - " + Msg.getElement((Properties)this.getCtx(), (String)"Line") + " : " + line.getLine();
                    this.log.saveError("SaveError", msg);
                    this.m_processMsg = msg;
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    protected boolean beforeDelete() {
        MPPFact[] facts = this.getPPFacts();
        if (facts.length > 0) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_PP_CannotDeletePlan"));
            return false;
        }
        return true;
    }

    public String getDocumentInfo() {
        return String.valueOf(this.getValue()) + "_" + this.getName();
    }

    public File createPDF() {
        return null;
    }

    public File createPDF(File file) {
        return null;
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (!MPeriod.isOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (String)dt.getDocBaseType(), (int)this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public boolean approveIt() {
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        MPPFact[] ppFacts;
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        MPPFact[] mPPFactArray = ppFacts = this.getPPFacts(true, null);
        int n = ppFacts.length;
        int n2 = 0;
        while (n2 < n) {
            MPPFact ppFact = mPPFactArray[n2];
            if (!ppFact.isProcessed()) {
                this.m_processMsg = Msg.getMsg((Properties)this.getCtx(), (String)"JP_PP_NotCompletePPPlanForUnprocessedPPFact");
                return "IN";
            }
            ++n2;
        }
        this.setJP_PP_Status("CO");
        Timestamp now = Timestamp.valueOf(LocalDateTime.now());
        if (this.getJP_PP_Start() == null) {
            this.setJP_PP_Start(now);
        }
        this.setJP_PP_End(now);
        String valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    public boolean voidIt() {
        MPPFact[] ppFacts;
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        MFactAcct.deleteEx((int)Table_ID, (int)this.getJP_PP_Plan_ID(), (String)this.get_TrxName());
        this.setPosted(true);
        if (!this.getJP_PP_Status().equals("CO")) {
            this.setJP_PP_Status("VO");
        }
        MPPFact[] mPPFactArray = ppFacts = this.getPPFacts(true, null);
        int n = ppFacts.length;
        int n2 = 0;
        while (n2 < n) {
            MPPFact ppFact = mPPFactArray[n2];
            if (!ppFact.isProcessed()) {
                if (ppFact.processIt("VO")) {
                    ppFact.saveEx(this.get_TrxName());
                } else {
                    this.m_processMsg = ppFact.getProcessMsg();
                    return false;
                }
            }
            ++n2;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public boolean closeIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        MPPFact[] ppFacts = this.getPPFacts(true, null);
        boolean isOK = true;
        MPPFact[] mPPFactArray = ppFacts;
        int n = ppFacts.length;
        int n2 = 0;
        while (n2 < n) {
            MPPFact ppFact = mPPFactArray[n2];
            if (ppFact.isProcessed()) {
                if (ppFact.getDocStatus().equals("CO")) {
                    isOK = ppFact.processIt("CL");
                }
            } else {
                this.m_processMsg = Msg.getMsg((Properties)this.getCtx(), (String)"JP_PP_NotClosedPPPlanForUnprocessedPPFact");
                return false;
            }
            if (!isOK) {
                this.m_processMsg = ppFact.getProcessMsg();
                return false;
            }
            ppFact.saveEx(this.get_TrxName());
            ++n2;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 11);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public boolean reverseCorrectIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        if (!this.reverse("RC")) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 13);
        return this.m_processMsg == null;
    }

    public boolean reverseAccrualIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        if (!this.reverse("RA")) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 14);
        return this.m_processMsg == null;
    }

    private boolean reverse(String docAction) {
        MPPFact[] ppFacts = this.getPPFacts(true, null);
        boolean isOK = true;
        MPPFact[] mPPFactArray = ppFacts;
        int n = ppFacts.length;
        int n2 = 0;
        while (n2 < n) {
            MPPFact ppFact = mPPFactArray[n2];
            if (ppFact.isProcessed()) {
                if (ppFact.getDocStatus().equals("CO")) {
                    isOK = ppFact.processIt(docAction);
                }
            } else {
                isOK = ppFact.processIt("VO");
            }
            if (!isOK) {
                this.m_processMsg = ppFact.getProcessMsg();
                return false;
            }
            ppFact.saveEx(this.get_TrxName());
            ++n2;
        }
        if (!this.getJP_PP_Status().equals("CO")) {
            this.setJP_PP_Status("VO");
        }
        this.setProcessed(true);
        this.setPosted(true);
        this.setDocStatus("RE");
        this.setDocAction("--");
        return true;
    }

    public boolean reActivateIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        MFactAcct.deleteEx((int)Table_ID, (int)this.getJP_PP_Plan_ID(), (String)this.get_TrxName());
        this.setPosted(false);
        this.setIsApproved(false);
        this.setJP_PP_Status("WP");
        this.setJP_PP_End(null);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    public String getSummary() {
        return String.valueOf(this.getValue()) + "_" + this.getName();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    public BigDecimal getApprovalAmt() {
        return Env.ZERO;
    }

    public int getC_Currency_ID() {
        return 0;
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String set = "SET Processed='" + (processed ? "Y" : "N") + "' WHERE JP_PP_Plan_ID=" + this.getJP_PP_Plan_ID();
        DB.executeUpdateEx((String)("UPDATE JP_PP_PlanLine " + set), (String)this.get_TrxName());
        this.m_PPPlanLines = null;
    }

    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (docStatus.equals("DR") || docStatus.equals("IP")) {
            index = 0;
            options[index++] = "VO";
            options[index++] = "RA";
            options[index++] = "RC";
            options[index++] = "PR";
            options[index++] = "CO";
            return index;
        }
        if (docStatus.equals("CO")) {
            index = 0;
            options[index++] = "VO";
            options[index++] = "RA";
            options[index++] = "RC";
            options[index++] = "CL";
            options[index++] = "RE";
            return index;
        }
        return index;
    }

    public MPPPlanLine[] getPPPlanLines(String whereClause, String orderClause) {
        StringBuilder whereClauseFinal = new StringBuilder("JP_PP_Plan_ID=? ");
        if (!Util.isEmpty((String)whereClause, (boolean)true)) {
            whereClauseFinal.append(whereClause);
        }
        if (orderClause.length() == 0) {
            orderClause = "Line";
        }
        List list = new Query(this.getCtx(), "JP_PP_PlanLine", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).setOrderBy(orderClause).list();
        return list.toArray(new MPPPlanLine[list.size()]);
    }

    public MPPPlanLine[] getPPPlanLines(boolean requery, String orderBy) {
        if (this.m_PPPlanLines != null && !requery) {
            MPPPlan.set_TrxName((PO[])this.m_PPPlanLines, (String)this.get_TrxName());
            return this.m_PPPlanLines;
        }
        String orderClause = "";
        orderClause = orderBy != null && orderBy.length() > 0 ? String.valueOf(orderClause) + orderBy : String.valueOf(orderClause) + "Line";
        this.m_PPPlanLines = this.getPPPlanLines(" AND IsActive='Y' ", orderClause);
        return this.m_PPPlanLines;
    }

    public MPPPlanLine[] getPPPlanLines() {
        return this.getPPPlanLines(false, null);
    }

    public MPPFact[] getPPFacts(String whereClause, String orderClause) {
        StringBuilder whereClauseFinal = new StringBuilder("JP_PP_Plan_ID=? ");
        if (!Util.isEmpty((String)whereClause, (boolean)true)) {
            whereClauseFinal.append(whereClause);
        }
        if (orderClause.length() == 0) {
            orderClause = "DocumentNo";
        }
        List list = new Query(this.getCtx(), "JP_PP_Fact", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).setOrderBy(orderClause).list();
        return list.toArray(new MPPFact[list.size()]);
    }

    public MPPFact[] getPPFacts(boolean requery, String orderBy) {
        if (this.m_PPFacts != null && !requery) {
            MPPPlan.set_TrxName((PO[])this.m_PPFacts, (String)this.get_TrxName());
            return this.m_PPFacts;
        }
        String orderClause = "";
        orderClause = orderBy != null && orderBy.length() > 0 ? String.valueOf(orderClause) + orderBy : String.valueOf(orderClause) + "DocumentNo";
        this.m_PPFacts = this.getPPFacts(null, orderClause);
        return this.m_PPFacts;
    }

    public MPPFact[] getPPFacts() {
        return this.getPPFacts(false, null);
    }

    public String createFact(String trxName) {
        MPPFact[] ppFacts;
        String msg = null;
        if (!this.isHaveEndProduct()) {
            return Msg.getMsg((Properties)this.getCtx(), (String)"JP_PP_NotContainEndProduct");
        }
        MPPFact[] mPPFactArray = ppFacts = this.getPPFacts(true, null);
        int n = ppFacts.length;
        int n2 = 0;
        while (n2 < n) {
            MPPFact ppFact = mPPFactArray[n2];
            if (ppFact.getJP_PP_Status().equals("WP") || ppFact.getJP_PP_Status().equals("NY")) {
                return Msg.getMsg((Properties)this.getCtx(), (String)"JP_PP_CannotCreateFact");
            }
            ++n2;
        }
        MPPPlanLine[] ppPLines = this.getPPPlanLines(true, null);
        MPPFact ppFact = new MPPFact(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)this, (PO)ppFact);
        ppFact.setDocumentNo(null);
        ppFact.setJP_PP_Doc_ID(this.getJP_PP_Doc_ID());
        ppFact.setJP_PP_Plan_ID(this.getJP_PP_Plan_ID());
        ppFact.setValue(this.getValue());
        ppFact.setAD_Org_ID(this.getAD_Org_ID());
        if (this.getJP_PP_PlanT_ID() == 0) {
            ppFact.setC_DocType_ID(MDocType.getDocType((String)"JDF"));
        } else {
            ppFact.setC_DocType_ID(this.getJP_PP_PlanT().getC_DocTypeTarget_ID());
        }
        ppFact.setDocumentNo(null);
        ppFact.setName(this.getJP_Name());
        ppFact.setMovementDate(this.getDateAcct());
        if (ppPLines.length > 0) {
            ppFact.setIsCreated("Y");
        }
        ppFact.setProductionQty(this.getProductionQty().subtract(this.getJP_ProductionQtyFact()));
        ppFact.setM_Product_ID(this.getM_Product_ID());
        ppFact.setC_UOM_ID(this.getC_UOM_ID());
        ppFact.setJP_PP_Workload_UOM_ID(this.getJP_PP_Workload_UOM_ID());
        ppFact.setJP_PP_Workload_Fact(Env.ZERO);
        ppFact.setJP_PP_Start(null);
        ppFact.setJP_PP_End(null);
        ppFact.setDocStatus("DR");
        ppFact.setDocAction("CO");
        ppFact.setJP_PP_Status("NY");
        ppFact.setJP_Processing1("N");
        ppFact.setJP_Processing2("N");
        ppFact.setJP_Processing3("N");
        ppFact.setJP_Processing4("N");
        ppFact.setJP_Processing5("N");
        ppFact.setJP_Processing6("N");
        if (!ppFact.save(this.get_TrxName())) {
            this.m_processMsg = msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotCreate")) + " " + Msg.getMsg((Properties)this.getCtx(), (String)"SaveError") + " - " + Msg.getElement((Properties)this.getCtx(), (String)"JP_PP_Fact_ID");
            this.log.saveError("SaveError", msg);
            return msg;
        }
        msg = ppFact.createFactLineFromPlanLine(trxName);
        if (!Util.isEmpty((String)msg)) {
            return msg;
        }
        return msg;
    }

    public boolean isHaveEndProduct() {
        MPPPlanLine[] lines;
        MPPPlanLine[] mPPPlanLineArray = lines = this.getPPPlanLines();
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            MPPPlanLine line = mPPPlanLineArray[n2];
            if (line.isEndProduct()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

