/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import jpiere.base.plugin.org.adempiere.model.MPPFactLine;
import jpiere.base.plugin.org.adempiere.model.X_JP_PP_FactLineMA;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MPPFactLineMA
extends X_JP_PP_FactLineMA {
    private MPPFactLine m_PPFactLine = null;

    public MPPFactLineMA(Properties ctx, int JP_PP_FactLineMA_ID, String trxName) {
        super(ctx, JP_PP_FactLineMA_ID, trxName);
    }

    public MPPFactLineMA(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPPFactLineMA(MPPFactLine parent, int asi, BigDecimal qty, Timestamp dateMaterialPolicy) {
        super(parent.getCtx(), 0, parent.get_TrxName());
        this.setM_AttributeSetInstance_ID(asi);
        this.setJP_PP_FactLine_ID(parent.get_ID());
        this.setMovementQty(qty);
        this.setAD_Org_ID(parent.getAD_Org_ID());
        if (dateMaterialPolicy == null) {
            if (asi > 0) {
                dateMaterialPolicy = MStorageOnHand.getDateMaterialPolicy((int)parent.getM_Product_ID(), (int)asi, (String)parent.get_TrxName());
            }
            if (dateMaterialPolicy == null) {
                dateMaterialPolicy = parent.getJP_PP_Fact().getMovementDate();
            }
        }
        this.setDateMaterialPolicy(dateMaterialPolicy);
    }

    public MPPFactLineMA(MPPFactLine parent, int M_AttributeSetInstance_ID, BigDecimal MovementQty, Timestamp DateMaterialPolicy, boolean isAutoGenerated) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setJP_PP_FactLine_ID(parent.getJP_PP_FactLine_ID());
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        this.setMovementQty(MovementQty);
        if (DateMaterialPolicy == null) {
            if (M_AttributeSetInstance_ID > 0) {
                DateMaterialPolicy = MStorageOnHand.getDateMaterialPolicy((int)parent.getM_Product_ID(), (int)M_AttributeSetInstance_ID, (String)parent.get_TrxName());
            }
            if (DateMaterialPolicy == null) {
                DateMaterialPolicy = parent.getParent().getMovementDate();
            }
        }
        this.setDateMaterialPolicy(DateMaterialPolicy);
        this.setIsAutoGenerated(isAutoGenerated);
    }

    @Override
    public void setDateMaterialPolicy(Timestamp DateMaterialPolicy) {
        if (DateMaterialPolicy != null) {
            DateMaterialPolicy = Util.removeTime((Timestamp)DateMaterialPolicy);
        }
        super.setDateMaterialPolicy(DateMaterialPolicy);
    }

    public static MPPFactLineMA get(MPPFactLine parent, int asi, Timestamp dateMPolicy) {
        String where = " JP_PP_FactLine_ID = ? AND M_AttributeSetInstance_ID = ? ";
        if (dateMPolicy == null) {
            dateMPolicy = new Timestamp(new Date().getTime());
        }
        where = String.valueOf(where) + "AND DateMaterialPolicy = trunc(cast(? as date))";
        MPPFactLineMA lineMA = (MPPFactLineMA)MTable.get((Properties)parent.getCtx(), (String)"JP_PP_FactLineMA").createQuery(where, parent.get_TrxName()).setParameters(new Object[]{parent.getJP_PP_FactLine_ID(), asi, dateMPolicy}).first();
        if (lineMA != null) {
            return lineMA;
        }
        return new MPPFactLineMA(parent, asi, Env.ZERO, dateMPolicy);
    }

    public static MPPFactLineMA[] get(Properties ctx, int JP_PP_FactLine_ID, String trxName) {
        Query query = MTable.get((Properties)ctx, (String)"JP_PP_FactLineMA").createQuery("JP_PP_FactLine_ID=?", trxName);
        query.setParameters(new Object[]{JP_PP_FactLine_ID});
        List list = query.list();
        MPPFactLineMA[] retValue = list.toArray(new MPPFactLineMA[0]);
        return retValue;
    }

    public static int deletePPFactLineMA(int JP_PP_FactLine_ID, String trxName) {
        String sql = "DELETE FROM JP_PP_FactLineMA ma WHERE ma.JP_PP_FactLine_ID=? AND ma.IsAutoGenerated='Y'";
        return DB.executeUpdate((String)sql, (int)JP_PP_FactLine_ID, (String)trxName);
    }

    public static MPPFactLineMA addOrCreate(MPPFactLine line, int M_AttributeSetInstance_ID, BigDecimal MovementQty, Timestamp DateMaterialPolicy, boolean isAutoGenerated) {
        Query query = new Query(Env.getCtx(), "JP_PP_FactLineMA", "JP_PP_FactLine_ID=? AND M_AttributeSetInstance_ID=? AND DateMaterialPolicy=trunc(cast(? as date))", line.get_TrxName());
        MPPFactLineMA po = (MPPFactLineMA)query.setParameters(new Object[]{line.getJP_PP_FactLine_ID(), M_AttributeSetInstance_ID, DateMaterialPolicy}).first();
        if (po == null) {
            po = new MPPFactLineMA(line, M_AttributeSetInstance_ID, MovementQty, DateMaterialPolicy, isAutoGenerated);
        } else {
            po.setMovementQty(po.getMovementQty().add(MovementQty));
        }
        return po;
    }

    public static BigDecimal getManualQty(int JP_PP_Factine_ID, String trxName) {
        String sql = "SELECT SUM(movementqty) FROM JP_PP_FactLineMA ma WHERE ma.JP_PP_FactLine_ID=? AND ma.IsAutoGenerated='N'";
        BigDecimal totalQty = DB.getSQLValueBD((String)trxName, (String)sql, (int)JP_PP_Factine_ID);
        return totalQty == null ? Env.ZERO : totalQty;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (newRecord) {
            this.setAD_Org_ID(this.getParent().getAD_Org_ID());
            if (this.getParent().isEndProduct()) {
                this.log.saveError("Error", Msg.getElement((Properties)this.getCtx(), (String)"IsEndProduct"));
                return false;
            }
        }
        if (this.getParent().isProcessed()) {
            this.log.saveError("Error", Msg.getElement((Properties)this.getCtx(), (String)"Processed"));
            return false;
        }
        if (this.isAutoGenerated()) {
            this.log.saveError("Error", "PP Fact Line does not create instance automatically");
            return false;
        }
        return true;
    }

    public MPPFactLine getParent() {
        if (this.m_PPFactLine == null) {
            this.m_PPFactLine = new MPPFactLine(this.getCtx(), this.getJP_PP_FactLine_ID(), this.get_TrxName());
        } else {
            this.m_PPFactLine.set_TrxName(this.get_TrxName());
        }
        return this.m_PPFactLine;
    }
}

