/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import jpiere.base.plugin.org.adempiere.model.MPPFact;
import jpiere.base.plugin.org.adempiere.model.MPPFactLineMA;
import jpiere.base.plugin.org.adempiere.model.MPPFactLineQT;
import jpiere.base.plugin.org.adempiere.model.MPPPlanLine;
import jpiere.base.plugin.org.adempiere.model.MPPPlanLineQT;
import jpiere.base.plugin.org.adempiere.model.X_JP_PP_FactLine;
import org.compiere.model.MProduct;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUOM;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MPPFactLine
extends X_JP_PP_FactLine {
    protected MPPFact parent = null;
    private MPPFactLineQT[] m_PPFactLineQTs = null;

    public MPPFactLine(Properties ctx, int JP_PP_FactLine_ID, String trxName) {
        super(ctx, JP_PP_FactLine_ID, trxName);
    }

    public MPPFactLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        MProduct product;
        if (newRecord) {
            this.setAD_Org_ID(this.getParent().getAD_Org_ID());
        }
        if (newRecord && this.getParent().isProcessed()) {
            this.log.saveError("Error", Msg.getElement((Properties)this.getCtx(), (String)"Processed"));
            return false;
        }
        if ((newRecord || this.is_ValueChanged("C_UOM_ID") || this.getC_UOM_ID() == 0) && (product = MProduct.get((int)this.getM_Product_ID())).getC_UOM_ID() != this.getC_UOM_ID()) {
            this.setC_UOM_ID(product.getC_UOM_ID());
        }
        if (this.getParent().getM_Product_ID() == this.getM_Product_ID() && (this.getParent().getProductionQty().signum() == this.getMovementQty().signum() || this.getParent().getProductionQty().compareTo(Env.ZERO) == 0 || this.getMovementQty().compareTo(Env.ZERO) == 0)) {
            this.setIsEndProduct(true);
        } else {
            this.setIsEndProduct(false);
        }
        if (this.isEndProduct()) {
            if (newRecord || this.is_ValueChanged("MovementQty")) {
                boolean isStdPrecision = MSysConfig.getBooleanValue((String)"JP_PP_UOM_STDPRECISION", (boolean)true, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
                MUOM uom = MUOM.get((int)this.getC_UOM_ID());
                this.setPlannedQty(this.getPlannedQty().setScale(isStdPrecision ? uom.getStdPrecision() : uom.getCostingPrecision(), RoundingMode.HALF_UP));
                this.setQtyUsed(null);
                this.setMovementQty(this.getMovementQty().setScale(isStdPrecision ? uom.getStdPrecision() : uom.getCostingPrecision(), RoundingMode.HALF_UP));
            }
        } else if (newRecord || this.is_ValueChanged("QtyUsed")) {
            boolean isStdPrecision = MSysConfig.getBooleanValue((String)"JP_PP_UOM_STDPRECISION", (boolean)true, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
            MUOM uom = MUOM.get((int)this.getC_UOM_ID());
            this.setPlannedQty(this.getPlannedQty().setScale(isStdPrecision ? uom.getStdPrecision() : uom.getCostingPrecision(), RoundingMode.HALF_UP));
            this.setQtyUsed(this.getQtyUsed().setScale(isStdPrecision ? uom.getStdPrecision() : uom.getCostingPrecision(), RoundingMode.HALF_UP));
            this.setMovementQty(this.getQtyUsed().negate());
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        int no;
        if (!success) {
            return false;
        }
        if (this.isEndProduct() && (newRecord || this.is_ValueChanged("MovementQty")) && (no = this.updateParentProductionQty(this.get_TrxName())) != 1) {
            this.log.saveError("DBExecuteError", "MPPFactLine#afterSave() -> updateParentProductionQty()");
            return false;
        }
        if (newRecord && this.isEndProduct() && this.getJP_PP_PlanLine_ID() != 0 && !this.getIsCreated().equals("Y")) {
            MPPPlanLine ppPlanLine = new MPPPlanLine(this.getCtx(), this.getJP_PP_PlanLine_ID(), this.get_TrxName());
            MPPPlanLineQT[] qts_From = ppPlanLine.getPPPlanLineQTs();
            MPPFactLineQT qt_To = null;
            MPPPlanLineQT[] mPPPlanLineQTArray = qts_From;
            int n = qts_From.length;
            int n2 = 0;
            while (n2 < n) {
                MPPPlanLineQT qt_From = mPPPlanLineQTArray[n2];
                qt_To = new MPPFactLineQT(this.getCtx(), 0, this.get_TrxName());
                PO.copyValues((PO)qt_From, (PO)qt_To);
                qt_To.setJP_PP_FactLine_ID(this.getJP_PP_FactLine_ID());
                qt_To.setJP_PP_PlanLineQT_ID(qt_From.getJP_PP_PlanLineQT_ID());
                qt_To.setAD_Org_ID(this.getAD_Org_ID());
                qt_To.setSeqNo(qt_From.getSeqNo());
                qt_To.setM_QualityTest_ID(qt_From.getM_QualityTest_ID());
                qt_To.setExpectedResult(qt_From.getExpectedResult());
                qt_To.setIsActive(true);
                qt_To.setProcessed(false);
                qt_To.save(this.get_TrxName());
                ++n2;
            }
        }
        return true;
    }

    protected boolean afterDelete(boolean success) {
        String sql;
        int no;
        int no2;
        if (this.isEndProduct() && (no2 = this.updateParentProductionQty(this.get_TrxName())) != 1) {
            this.log.saveError("DBExecuteError", "MPPFactLine#afterDelete() -> updateParentProductionQty()");
            return false;
        }
        MPPFactLine[] lines = this.getParent().getPPFactLines(true, null);
        if (lines.length == 0 && (no = DB.executeUpdate((String)(sql = "UPDATE JP_PP_Fact SET IsCreated='N' WHERE JP_PP_Fact_ID=? "), (Object[])new Object[]{this.getJP_PP_Fact_ID()}, (boolean)false, (String)this.get_TrxName(), (int)0)) != 1) {
            this.log.saveError("DBExecuteError", "MPPFactLine#afterDelete()");
            return false;
        }
        return true;
    }

    private int updateParentProductionQty(String trxName) {
        String sql = "UPDATE JP_PP_Fact SET ProductionQty=(SELECT COALESCE(SUM(MovementQty),0) FROM JP_PP_FactLine WHERE JP_PP_Fact_ID=? AND IsEndProduct='Y')  WHERE JP_PP_Fact_ID=?";
        int no = DB.executeUpdate((String)sql, (Object[])new Object[]{this.getJP_PP_Fact_ID(), this.getJP_PP_Fact_ID()}, (boolean)false, (String)trxName, (int)0);
        return no;
    }

    public MPPFact getParent() {
        if (this.parent == null) {
            this.parent = new MPPFact(this.getCtx(), this.getJP_PP_Fact_ID(), this.get_TrxName());
        } else {
            this.parent.set_TrxName(this.get_TrxName());
        }
        return this.parent;
    }

    public MPPFactLineMA[] getPPFactLineMAs() {
        StringBuilder whereClauseFinal = new StringBuilder("JP_PP_FactLine_ID=? ");
        StringBuilder orderClause = new StringBuilder("JP_PP_FactLineMA_ID");
        List list = new Query(this.getCtx(), "JP_PP_FactLineMA", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).setOrderBy(orderClause.toString()).list();
        return list.toArray(new MPPFactLineMA[list.size()]);
    }

    public MPPFactLineQT[] getPPFactLineQTs(String whereClause, String orderClause) {
        StringBuilder whereClauseFinal = new StringBuilder("JP_PP_FactLine_ID=? ");
        if (!Util.isEmpty((String)whereClause, (boolean)true)) {
            whereClauseFinal.append(whereClause);
        }
        if (orderClause.length() == 0) {
            orderClause = "SeqNo";
        }
        List list = new Query(this.getCtx(), "JP_PP_PlanLineQT", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).setOrderBy(orderClause).list();
        return list.toArray(new MPPFactLineQT[list.size()]);
    }

    public MPPFactLineQT[] getPPFactLineQTs(boolean requery, String orderBy) {
        if (this.m_PPFactLineQTs != null && !requery) {
            MPPFactLine.set_TrxName((PO[])this.m_PPFactLineQTs, (String)this.get_TrxName());
            return this.m_PPFactLineQTs;
        }
        String orderClause = "";
        orderClause = orderBy != null && orderBy.length() > 0 ? String.valueOf(orderClause) + orderBy : String.valueOf(orderClause) + "SeqNo";
        this.m_PPFactLineQTs = this.getPPFactLineQTs(" AND IsActive='Y' ", orderClause);
        return this.m_PPFactLineQTs;
    }

    public MPPFactLineQT[] getPPFactLineQTs() {
        return this.getPPFactLineQTs(false, null);
    }

    public MProduct getProduct() {
        if (this.getM_Product_ID() != 0) {
            return MProduct.getCopy((Properties)this.getCtx(), (int)this.getM_Product_ID(), (String)this.get_TrxName());
        }
        return null;
    }
}

