/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MPPFactLine;
import jpiere.base.plugin.org.adempiere.model.MPPFactLineMA;
import jpiere.base.plugin.org.adempiere.model.MPPPlan;
import jpiere.base.plugin.org.adempiere.model.MPPPlanLine;
import jpiere.base.plugin.org.adempiere.model.X_JP_PP_Fact;
import org.adempiere.exceptions.NegativeInventoryDisallowedException;
import org.compiere.model.I_M_AttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MUOM;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MPPFact
extends X_JP_PP_Fact
implements DocAction,
DocOptions {
    private MPPPlan m_PPPlan = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private MPPFactLine[] m_PPFactLines = null;

    public MPPFact(Properties ctx, int JP_PP_Fact_ID, String trxName) {
        super(ctx, JP_PP_Fact_ID, trxName);
    }

    public MPPFact(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPPPlan getParent() {
        if (this.m_PPPlan == null) {
            this.m_PPPlan = new MPPPlan(this.getCtx(), this.getJP_PP_Plan_ID(), this.get_TrxName());
        } else {
            this.m_PPPlan.set_TrxName(this.get_TrxName());
        }
        return this.m_PPPlan;
    }

    protected boolean beforeSave(boolean newRecord) {
        MProduct product;
        if (newRecord) {
            this.setAD_Org_ID(this.getParent().getAD_Org_ID());
        }
        if (newRecord && this.getParent().isProcessed()) {
            this.log.saveError("Error", Msg.getElement((Properties)this.getCtx(), (String)"Processed"));
            return false;
        }
        if (newRecord || this.is_ValueChanged("M_Product_ID") || this.getM_Product_ID() == 0) {
            this.setM_Product_ID(this.getParent().getM_Product_ID());
        }
        if ((newRecord || this.is_ValueChanged("C_UOM_ID") || this.getC_UOM_ID() == 0) && (product = MProduct.get((int)this.getM_Product_ID())).getC_UOM_ID() != this.getC_UOM_ID()) {
            this.setC_UOM_ID(product.getC_UOM_ID());
        }
        if (newRecord || this.is_ValueChanged("JP_PP_Workload_UOM_ID") || this.getJP_PP_Workload_UOM_ID() == 0) {
            this.setJP_PP_Workload_UOM_ID(this.getParent().getJP_PP_Workload_UOM_ID());
        }
        if (newRecord || this.is_ValueChanged("ProductionQty")) {
            boolean isStdPrecision = MSysConfig.getBooleanValue((String)"JP_PP_UOM_STDPRECISION", (boolean)true, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
            MUOM uom = MUOM.get((int)this.getC_UOM_ID());
            this.setProductionQty(this.getProductionQty().setScale(isStdPrecision ? uom.getStdPrecision() : uom.getCostingPrecision(), RoundingMode.HALF_UP));
        }
        if ((newRecord || this.is_ValueChanged("C_DocType_ID")) && !this.getC_DocType().getDocBaseType().equals("JDF")) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_DifferentDocType"));
            return false;
        }
        if (!(!newRecord && !this.is_ValueChanged("JP_PP_Start") || this.getDocStatus().equals("CO") || this.getDocStatus().equals("CL") || this.getDocStatus().equals("VO") || this.getDocStatus().equals("RE"))) {
            if (this.getJP_PP_Start() == null) {
                this.setJP_PP_StartProcess("N");
                if (this.getJP_PP_End() == null) {
                    this.setJP_PP_Status("NY");
                } else {
                    this.setJP_PP_Status("CO");
                }
            } else {
                this.setJP_PP_StartProcess("Y");
                if (this.getJP_PP_End() == null) {
                    this.setJP_PP_Status("WP");
                } else {
                    this.setJP_PP_Status("CO");
                }
            }
        }
        if (!(!newRecord && !this.is_ValueChanged("JP_PP_End") || this.getDocStatus().equals("CO") || this.getDocStatus().equals("CL") || this.getDocStatus().equals("VO") || this.getDocStatus().equals("RE"))) {
            if (this.getJP_PP_End() == null) {
                this.setJP_PP_EndProcess("N");
                if (this.getJP_PP_Start() == null) {
                    this.setJP_PP_Status("NY");
                } else {
                    this.setJP_PP_Status("WP");
                }
            } else {
                this.setJP_PP_EndProcess("Y");
                if (this.getJP_PP_Status().equals("WP") || this.getJP_PP_Status().equals("NY")) {
                    this.setJP_PP_Status("CO");
                }
            }
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        int no;
        if (!success) {
            return false;
        }
        if (!newRecord && this.is_ValueChanged("ProductionQty")) {
            MPPFactLine[] lines;
            boolean isStdPrecision = MSysConfig.getBooleanValue((String)"JP_PP_UOM_STDPRECISION", (boolean)true, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
            MUOM uom = null;
            BigDecimal newQty = this.getProductionQty();
            BigDecimal oldQty = (BigDecimal)this.get_ValueOld("ProductionQty");
            BigDecimal rate = Env.ONE;
            if (oldQty != null && oldQty.compareTo(Env.ZERO) != 0) {
                rate = newQty.divide(oldQty, 4, RoundingMode.HALF_UP);
            }
            MPPFactLine[] mPPFactLineArray = lines = this.getPPFactLines(true, null);
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                MPPFactLine line = mPPFactLineArray[n2];
                if (line.isEndProduct()) {
                    line.setMovementQty(newQty);
                } else {
                    uom = MUOM.get((int)line.getC_UOM_ID());
                    oldQty = line.getQtyUsed();
                    if (oldQty.compareTo(Env.ZERO) != 0) {
                        newQty = oldQty.multiply(rate).setScale(isStdPrecision ? uom.getStdPrecision() : uom.getCostingPrecision(), RoundingMode.HALF_UP);
                        line.setQtyUsed(newQty);
                    }
                }
                line.saveEx(this.get_TrxName());
                ++n2;
            }
        }
        if ((newRecord || this.is_ValueChanged("JP_PP_Workload_Fact")) && (no = this.updateParentWorkloadFact(this.get_TrxName())) != 1) {
            this.log.saveError("DBExecuteError", "MPPFact#afterSave() -> updateParentWorkloadFact()");
            return false;
        }
        if (this.is_ValueChanged("DocStatus")) {
            no = this.updateParentProductionQtyFact(this.get_TrxName());
            if (no != 1) {
                this.m_processMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"DBExecuteError")) + " : " + "MPPFact#afterSave() -> updateParentProductionQtyFact()";
                return false;
            }
            this.updatePlanLineQtyFact(this.get_TrxName());
        }
        return true;
    }

    protected boolean afterDelete(boolean success) {
        int no = this.updateParentWorkloadFact(this.get_TrxName());
        if (no != 1) {
            this.log.saveError("DBExecuteError", "MPPFact#afterDelete() -> updateParentWorkloadFact()");
            return false;
        }
        return true;
    }

    private int updateParentWorkloadFact(String trxName) {
        String sql = "UPDATE JP_PP_Plan SET JP_PP_Workload_Fact=(SELECT COALESCE(SUM(JP_PP_Workload_Fact),0) FROM JP_PP_Fact WHERE JP_PP_Plan_ID =?)  WHERE JP_PP_Plan_ID=?";
        int no = DB.executeUpdate((String)sql, (Object[])new Object[]{this.getJP_PP_Plan_ID(), this.getJP_PP_Plan_ID()}, (boolean)false, (String)trxName, (int)0);
        return no;
    }

    private int updateParentProductionQtyFact(String trxName) {
        String sql = "UPDATE JP_PP_Plan SET JP_ProductionQtyFact = (SELECT COALESCE(SUM(fl.MovementQty),0)  FROM JP_PP_FactLine fl INNER JOIN JP_PP_Fact f ON (fl.JP_PP_Fact_ID=f.JP_PP_Fact_ID)  WHERE f.JP_PP_Plan_ID =? AND f.DocStatus in ('CO','CL') AND fl.IsEndProduct='Y' )  WHERE JP_PP_Plan_ID=?";
        int no = DB.executeUpdate((String)sql, (Object[])new Object[]{this.getJP_PP_Plan_ID(), this.getJP_PP_Plan_ID()}, (boolean)false, (String)trxName, (int)0);
        return no;
    }

    private int updatePlanLineQtyFact(String trxName) {
        String sql = "UPDATE JP_PP_PlanLine pl  SET JP_QtyUsedFact = (SELECT COALESCE(SUM(fl.QtyUsed),0)  FROM JP_PP_FactLine fl INNER JOIN JP_PP_Fact f ON (fl.JP_PP_Fact_ID=f.JP_PP_Fact_ID)  WHERE f.JP_PP_Plan_ID =? AND f.DocStatus in ('CO','CL') AND fl.JP_PP_PlanLine_ID=pl.JP_PP_PlanLine_ID AND fl.IsEndProduct='N')  WHERE pl.JP_PP_Plan_ID= ? AND pl.IsEndProduct='N' ";
        int no = DB.executeUpdate((String)sql, (Object[])new Object[]{this.getJP_PP_Plan_ID(), this.getJP_PP_Plan_ID()}, (boolean)false, (String)trxName, (int)0);
        sql = "UPDATE JP_PP_PlanLine pl  SET JP_MovementQtyFact = (SELECT COALESCE(SUM(fl.MovementQty),0)  FROM JP_PP_FactLine fl INNER JOIN JP_PP_Fact f ON (fl.JP_PP_Fact_ID=f.JP_PP_Fact_ID)  WHERE f.JP_PP_Plan_ID =? AND f.DocStatus in ('CO','CL') AND fl.JP_PP_PlanLine_ID=pl.JP_PP_PlanLine_ID)  WHERE pl.JP_PP_Plan_ID= ? ";
        no = DB.executeUpdate((String)sql, (Object[])new Object[]{this.getJP_PP_Plan_ID(), this.getJP_PP_Plan_ID()}, (boolean)false, (String)trxName, (int)0);
        return no;
    }

    public String getDocumentInfo() {
        return String.valueOf(this.getValue()) + "_" + this.getName();
    }

    public File createPDF() {
        return null;
    }

    public File createPDF(File file) {
        return null;
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (!MPeriod.isOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (String)dt.getDocBaseType(), (int)this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        if (!this.isHaveEndProduct()) {
            this.m_processMsg = Msg.getMsg((Properties)this.getCtx(), (String)"JP_PP_NotContainEndProduct");
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public boolean approveIt() {
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.setIsApproved(false);
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String completeIt() {
        int n;
        MProduct product;
        MProduct ppFactLines;
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        if (!this.isHaveEndProduct()) {
            this.m_processMsg = Msg.getMsg((Properties)this.getCtx(), (String)"JP_PP_NotContainEndProduct");
            return "IN";
        }
        MProduct mProduct = ppFactLines = this.getPPFactLines(true, null);
        int n2 = ((MPPFactLine[])mProduct).length;
        int n3 = 0;
        while (n3 < n2) {
            block50: {
                MPPFactLine line;
                block51: {
                    line = mProduct[n3];
                    product = MProduct.get((int)line.getM_Product_ID());
                    if (line.getM_AttributeSetInstance_ID() != 0 || product == null || !product.isASIMandatoryFor(null, true) || product.getAttributeSet() == null || product.getAttributeSet().excludeTableEntry(326, true)) break block50;
                    if (!line.isEndProduct()) break block51;
                    I_M_AttributeSet attributeset = product.getM_AttributeSet();
                    boolean isAutoGenerateLot = false;
                    if (attributeset != null) {
                        isAutoGenerateLot = attributeset.isAutoGenerateLot();
                    }
                    if (isAutoGenerateLot) break block50;
                }
                BigDecimal qtyDiff = line.getMovementQty();
                MPPFactLineMA[] mas = MPPFactLineMA.get(this.getCtx(), line.getJP_PP_FactLine_ID(), this.get_TrxName());
                BigDecimal qtyma = Env.ZERO;
                MPPFactLineMA[] mPPFactLineMAArray = mas;
                int n4 = mas.length;
                int n5 = 0;
                while (n5 < n4) {
                    MPPFactLineMA ma = mPPFactLineMAArray[n5];
                    if (!ma.isAutoGenerated()) {
                        qtyma = qtyma.add(ma.getMovementQty());
                    }
                    ++n5;
                }
                if (qtyma.subtract(qtyDiff).signum() != 0) {
                    String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_PP_FactLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"MovementQty");
                    String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_PP_FactLineMA_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"MovementQty");
                    String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1});
                    this.m_processMsg = String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_PP_FactLine_ID")) + " : " + line.getLine() + " - " + msg;
                    return "IN";
                }
            }
            ++n3;
        }
        StringBuilder errors = new StringBuilder();
        product = ppFactLines;
        int n6 = ((MPPFactLine[])product).length;
        n2 = 0;
        while (n2 < n6) {
            MProduct line = product[n2];
            MProduct product2 = line.getProduct();
            try {
                if (product2 != null && product2.isStocked()) {
                    BigDecimal qtyOnLineMA = MPPFactLineMA.getManualQty(line.getJP_PP_FactLine_ID(), this.get_TrxName());
                    BigDecimal movementQty = line.getMovementQty();
                    if (qtyOnLineMA.compareTo(Env.ZERO) != 0 && qtyOnLineMA.compareTo(movementQty) != 0) {
                        this.m_processMsg = "@JP_PP_DontMatchQtyASI@ " + line.getLine();
                        return "IN";
                    }
                    if (!line.isEndProduct()) {
                        if (line.getM_AttributeSetInstance_ID() == 0) {
                            MPPFactLineMA[] mas = line.getPPFactLineMAs();
                            BigDecimal movementQtyMA = Env.ZERO;
                            BigDecimal qtyOnhand = Env.ZERO;
                            MPPFactLineMA[] mPPFactLineMAArray = mas;
                            n = mas.length;
                            int n7 = 0;
                            while (n7 < n) {
                                MPPFactLineMA ma = mPPFactLineMAArray[n7];
                                MStorageOnHand storageOnHand = MStorageOnHand.get((Properties)this.getCtx(), (int)line.getM_Locator_ID(), (int)line.getM_Product_ID(), (int)ma.getM_AttributeSetInstance_ID(), (Timestamp)ma.getDateMaterialPolicy(), (String)this.get_TrxName());
                                if (storageOnHand == null) {
                                    MAttributeSetInstance asi = new MAttributeSetInstance(this.getCtx(), ma.getM_AttributeSetInstance_ID(), this.get_TrxName());
                                    this.m_processMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"InsufficientQtyAvailable")) + asi.getDescription() + " - " + Msg.getElement((Properties)this.getCtx(), (String)"DateMaterialPolicy") + " " + ma.getDateMaterialPolicy().toString().substring(0, 10) + " - " + Msg.getElement((Properties)this.getCtx(), (String)"QtyOnHand") + " " + " 0 ";
                                    return "IN";
                                }
                                movementQtyMA = movementQtyMA.add(ma.getMovementQty());
                                qtyOnhand = qtyOnhand.add(storageOnHand.getQtyOnHand());
                                ++n7;
                            }
                            if (qtyOnhand.compareTo(movementQtyMA = movementQtyMA.negate()) < 0) {
                                this.m_processMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"InsufficientQtyAvailable")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_PP_FactLine_ID") + " : " + line.getLine() + " - " + Msg.getElement((Properties)this.getCtx(), (String)"QtyOnHand") + " " + qtyOnhand.toString();
                                return "IN";
                            }
                        } else {
                            MStorageOnHand storageOnHand = MStorageOnHand.get((Properties)this.getCtx(), (int)line.getM_Locator_ID(), (int)line.getM_Product_ID(), (int)line.getM_AttributeSetInstance_ID(), null, (String)this.get_TrxName());
                            if (storageOnHand == null) {
                                MAttributeSetInstance asi = new MAttributeSetInstance(this.getCtx(), line.getM_AttributeSetInstance_ID(), this.get_TrxName());
                                this.m_processMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"InsufficientQtyAvailable")) + " - " + Msg.getElement((Properties)this.getCtx(), (String)"JP_PP_FactLine_ID") + " : " + line.getLine() + " - " + asi.getDescription() + " - " + Msg.getElement((Properties)this.getCtx(), (String)"QtyOnHand") + " 0 ";
                                return "IN";
                            }
                            if (storageOnHand.getQtyOnHand().compareTo(line.getQtyUsed()) < 0) {
                                MAttributeSetInstance asi = new MAttributeSetInstance(this.getCtx(), line.getM_AttributeSetInstance_ID(), this.get_TrxName());
                                this.m_processMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"InsufficientQtyAvailable")) + asi.getDescription() + " - " + Msg.getElement((Properties)this.getCtx(), (String)"QtyOnHand") + " " + storageOnHand.getQtyOnHand().toString();
                                return "IN";
                            }
                        }
                    }
                }
            }
            catch (NegativeInventoryDisallowedException e) {
                this.log.severe(e.getMessage());
                errors.append(Msg.getElement((Properties)this.getCtx(), (String)"Line")).append(" ").append(line.getLine()).append(": ");
                errors.append(e.getMessage()).append("\n");
            }
            ++n2;
        }
        if (errors.toString().length() > 0) {
            this.m_processMsg = errors.toString();
            return "IN";
        }
        MPPFactLineMA[] ppFactLineMAs = null;
        BigDecimal productionQty = this.getEndProductMovementQty(this.get_TrxName());
        this.setProductionQty(productionQty);
        if (this.getM_Production_ID() == 0 && ((MProduct)ppFactLines).length > 0) {
            MTable m_table_Production = MTable.get((Properties)this.getCtx(), (String)"M_Production");
            MTable m_table_ProductionLine = MTable.get((Properties)this.getCtx(), (String)"M_ProductionLine");
            MTable m_table_ProductionLineMA = MTable.get((Properties)this.getCtx(), (String)"M_ProductionLineMA");
            PO pp = m_table_Production.getPO(0, this.get_TrxName());
            PO.copyValues((PO)this, (PO)pp);
            pp.setAD_Org_ID(this.getAD_Org_ID());
            pp.set_ValueNoCheck("JP_PP_Fact_ID", (Object)this.getJP_PP_Fact_ID());
            pp.set_ValueNoCheck("DocumentNo", null);
            pp.set_ValueNoCheck("DatePromised", (Object)this.getMovementDate());
            pp.set_ValueNoCheck("MovementDate", (Object)this.getMovementDate());
            pp.set_ValueNoCheck("M_Product_ID", (Object)this.getM_Product_ID());
            pp.set_ValueNoCheck("M_Locator_ID", (Object)this.getM_Locator_ID());
            pp.set_ValueNoCheck("ProductionQty", (Object)productionQty);
            pp.set_ValueNoCheck("Name", (Object)this.getName());
            pp.set_ValueNoCheck("Description", (Object)this.getDescription());
            pp.set_ValueNoCheck("IsCreated", (Object)"Y");
            pp.setIsActive(true);
            pp.set_ValueNoCheck("Processed", (Object)"N");
            pp.set_ValueNoCheck("Posted", (Object)"N");
            pp.set_ValueNoCheck("DocStatus", (Object)"DR");
            pp.set_ValueNoCheck("DocAction", (Object)"CO");
            if (!pp.save(this.get_TrxName())) {
                this.m_processMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + " - " + Msg.getElement((Properties)this.getCtx(), (String)"M_Production_ID") + " - " + pp.get_Logger().getName();
                return "IN";
            }
            this.setM_Production_ID(pp.get_ID());
            this.setJP_PP_Status("CO");
            MProduct qtyOnhand = ppFactLines;
            int asi = ((MProduct)qtyOnhand).length;
            int storageOnHand = 0;
            while (storageOnHand < asi) {
                MProduct ppFactLine = qtyOnhand[storageOnHand];
                PO ppLine = m_table_ProductionLine.getPO(0, this.get_TrxName());
                PO.copyValues((PO)ppFactLine, (PO)ppLine);
                ppLine.set_ValueNoCheck("M_Production_ID", (Object)pp.get_ValueAsInt("M_Production_ID"));
                ppLine.setAD_Org_ID(pp.getAD_Org_ID());
                ppLine.set_ValueNoCheck("Line", (Object)ppFactLine.getLine());
                ppLine.set_ValueNoCheck("M_Product_ID", (Object)ppFactLine.getM_Product_ID());
                ppLine.set_ValueNoCheck("M_AttributeSetInstance_ID", (Object)ppFactLine.getM_AttributeSetInstance_ID());
                ppLine.set_ValueNoCheck("IsEndProduct", (Object)(ppFactLine.isEndProduct() ? "Y" : "N"));
                ppLine.set_ValueNoCheck("PlannedQty", (Object)ppFactLine.getPlannedQty());
                ppLine.set_ValueNoCheck("QtyUsed", (Object)ppFactLine.getQtyUsed());
                ppLine.set_ValueNoCheck("MovementQty", (Object)ppFactLine.getMovementQty());
                ppLine.set_ValueNoCheck("M_Locator_ID", (Object)ppFactLine.getM_Locator_ID());
                ppLine.set_ValueNoCheck("Description", (Object)ppFactLine.getDescription());
                ppLine.set_ValueNoCheck("JP_PP_FactLine_ID", (Object)ppFactLine.getJP_PP_FactLine_ID());
                if (!ppLine.save(this.get_TrxName())) {
                    this.m_processMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + " - " + Msg.getElement((Properties)this.getCtx(), (String)"M_ProductionLine_ID") + " - " + Msg.getElement((Properties)this.getCtx(), (String)"Line") + " : " + ppLine.get_ValueAsInt("Line") + " - " + ppLine.get_Logger().getName();
                    return "IN";
                }
                MPPFactLineMA[] mPPFactLineMAArray = ppFactLineMAs = ppFactLine.getPPFactLineMAs();
                int n8 = ppFactLineMAs.length;
                n = 0;
                while (n < n8) {
                    MPPFactLineMA ppFactLineMA = mPPFactLineMAArray[n];
                    PO ppLineMA = m_table_ProductionLineMA.getPO(0, this.get_TrxName());
                    PO.copyValues((PO)ppFactLineMA, (PO)ppLineMA);
                    ppLineMA.setAD_Org_ID(ppLine.getAD_Org_ID());
                    ppLineMA.set_ValueNoCheck("M_ProductionLine_ID", (Object)ppLine.get_ValueAsInt("M_ProductionLine_ID"));
                    ppLineMA.set_ValueNoCheck("M_AttributeSetInstance_ID", (Object)ppFactLineMA.getM_AttributeSetInstance_ID());
                    ppLineMA.set_ValueNoCheck("DateMaterialPolicy", (Object)ppFactLineMA.getDateMaterialPolicy());
                    ppLineMA.set_ValueNoCheck("MovementQty", (Object)ppFactLineMA.getMovementQty());
                    if (!ppLineMA.save(this.get_TrxName())) {
                        this.m_processMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + " - " + Msg.getElement((Properties)this.getCtx(), (String)"M_AttributeSetInstance_ID") + " - " + Msg.getElement((Properties)this.getCtx(), (String)"Line") + " : " + ppLine.get_ValueAsInt("Line") + " - " + ppLineMA.get_Logger().getName();
                        return "IN";
                    }
                    ++n;
                }
                ++storageOnHand;
            }
            DocAction doc = (DocAction)pp;
            try {
                if (!doc.processIt("CO")) {
                    this.m_processMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotCreate")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_Production_ID") + " - " + Msg.getElement((Properties)this.getCtx(), (String)"DocAction") + " : " + "CO" + " - " + doc.getProcessMsg();
                    return "IN";
                }
                if (!pp.save(this.get_TrxName())) {
                    this.m_processMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + " - " + Msg.getElement((Properties)this.getCtx(), (String)"M_Production_ID") + " - " + pp.get_ValueAsString("DocumentNo");
                    return "IN";
                }
            }
            catch (Exception e) {
                this.m_processMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotCreate")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_Production_ID") + " - " + Msg.getElement((Properties)this.getCtx(), (String)"DocAction") + " : " + "CO" + " - " + doc.getProcessMsg() + " - " + e.getMessage();
                return "IN";
            }
            String whereClauseFinal = "M_Production_ID=? ";
            String orderClause = "Line";
            List list = new Query(this.getCtx(), "M_ProductionLine", whereClauseFinal, this.get_TrxName()).setParameters(new Object[]{pp.get_ID()}).setOrderBy(orderClause).list();
            block10: for (PO productionLine : list) {
                MProduct mProduct2 = ppFactLines;
                int n9 = ((MProduct)mProduct2).length;
                int n10 = 0;
                while (n10 < n9) {
                    MProduct ppFactLine = mProduct2[n10];
                    if (productionLine.get_ValueAsInt("JP_PP_FactLine_ID") == ppFactLine.getJP_PP_FactLine_ID()) {
                        ppFactLine.setM_ProductionLine_ID(productionLine.get_ValueAsInt("M_ProductionLine_ID"));
                        if (ppFactLine.isEndProduct()) {
                            I_M_AttributeSet attributeset = MProduct.get((int)ppFactLine.getM_Product_ID()).getM_AttributeSet();
                            boolean isAutoGenerateLot = false;
                            if (attributeset != null) {
                                isAutoGenerateLot = attributeset.isAutoGenerateLot();
                            }
                            if (isAutoGenerateLot) {
                                ppFactLine.setM_AttributeSetInstance_ID(productionLine.get_ValueAsInt("M_AttributeSetInstance_ID"));
                            }
                        }
                        if (ppFactLine.save(this.get_TrxName())) continue block10;
                        this.m_processMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + " - " + Msg.getElement((Properties)this.getCtx(), (String)"JP_PP_FactLine_ID") + " - " + Msg.getElement((Properties)this.getCtx(), (String)"Line") + " : " + ppFactLine.getLine() + " - " + ppFactLine.get_Logger().getName();
                        return "IN";
                    }
                    ++n10;
                }
            }
        }
        Timestamp now = Timestamp.valueOf(LocalDateTime.now());
        if (this.getJP_PP_Start() == null) {
            this.setJP_PP_Start(now);
            this.setJP_PP_StartProcess("Y");
        }
        if (this.getJP_PP_End() == null) {
            this.setJP_PP_End(now);
            this.setJP_PP_EndProcess("Y");
        }
        this.setJP_PP_Status("CO");
        String valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    public boolean voidIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus()) || "CO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            this.setDocAction("--");
            return false;
        }
        MFactAcct.deleteEx((int)Table_ID, (int)this.getJP_PP_Fact_ID(), (String)this.get_TrxName());
        this.setPosted(true);
        this.setJP_PP_Status("VO");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public boolean closeIt() {
        block6: {
            MTable m_table_Production;
            PO po;
            DocAction pp;
            this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 3);
            if (this.m_processMsg != null) {
                return false;
            }
            if (this.getM_Production_ID() != 0 && (pp = (DocAction)(po = (m_table_Production = MTable.get((Properties)this.getCtx(), (String)"M_Production")).getPO(this.getM_Production_ID(), this.get_TrxName()))).getDocStatus().equals("CO")) {
                try {
                    if (pp.processIt("CL")) {
                        po.saveEx(this.get_TrxName());
                        break block6;
                    }
                    this.m_processMsg = pp.getProcessMsg();
                    return false;
                }
                catch (Exception e) {
                    this.m_processMsg = pp.getProcessMsg();
                    return false;
                }
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 11);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public boolean reverseCorrectIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        if (this.getDocStatus().equals("CO")) {
            boolean isOk = this.reverse("RC");
            if (!isOk) {
                return false;
            }
        } else if (!this.getDocStatus().equals("CL")) {
            return this.voidIt();
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public boolean reverseAccrualIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        if (this.getDocStatus().equals("CO")) {
            boolean isOk = this.reverse("RA");
            if (!isOk) {
                return false;
            }
        } else if (!this.getDocStatus().equals("CL")) {
            return this.voidIt();
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    private boolean reverse(String DocAction2) {
        if (this.getM_Production_ID() == 0) {
            return true;
        }
        MTable m_table_Production = MTable.get((Properties)this.getCtx(), (String)"M_Production");
        PO po = m_table_Production.getPO(this.getM_Production_ID(), this.get_TrxName());
        DocAction pp = (DocAction)po;
        if (pp.getDocStatus().equals("CO")) {
            try {
                pp.processIt(DocAction2);
            }
            catch (Exception e) {
                this.m_processMsg = pp.getProcessMsg();
                return false;
            }
            po.saveEx(this.get_TrxName());
            int reversal_ID = po.get_ValueAsInt("Reversal_ID");
            PO reversalPP = m_table_Production.getPO(reversal_ID, this.get_TrxName());
            reversalPP.set_ValueNoCheck("JP_PP_Fact_ID", (Object)this.getJP_PP_Fact_ID());
            reversalPP.saveEx(this.get_TrxName());
        }
        return true;
    }

    public boolean reActivateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        MFactAcct.deleteEx((int)Table_ID, (int)this.getJP_PP_Fact_ID(), (String)this.get_TrxName());
        this.setPosted(false);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return false;
    }

    public String getSummary() {
        return String.valueOf(this.getValue()) + "_" + this.getName();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    public BigDecimal getApprovalAmt() {
        return Env.ZERO;
    }

    public int getC_Currency_ID() {
        return 0;
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String set = "SET Processed='" + (processed ? "Y" : "N") + "' WHERE JP_PP_Fact_ID=" + this.getJP_PP_Fact_ID();
        DB.executeUpdateEx((String)("UPDATE JP_PP_FactLine " + set), (String)this.get_TrxName());
        this.m_PPFactLines = null;
    }

    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (docStatus.equals("DR") || docStatus.equals("IP")) {
            index = 0;
            options[index++] = "VO";
            options[index++] = "PR";
            options[index++] = "CO";
            return index;
        }
        if (docStatus.equals("IN")) {
            index = 0;
            options[index++] = "VO";
            options[index++] = "PR";
        } else if (docStatus.equals("CO")) {
            if (this.getM_Production_ID() == 0) {
                index = 0;
                options[index++] = "VO";
                options[index++] = "CL";
                options[index++] = "RE";
            } else {
                index = 0;
                options[index++] = "CL";
                options[index++] = "RA";
                options[index++] = "RC";
            }
            return index;
        }
        return index;
    }

    public MPPFactLine[] getPPFactLines(String whereClause, String orderClause) {
        StringBuilder whereClauseFinal = new StringBuilder("JP_PP_Fact_ID=? ");
        if (!Util.isEmpty((String)whereClause, (boolean)true)) {
            whereClauseFinal.append(whereClause);
        }
        if (orderClause.length() == 0) {
            orderClause = "Line";
        }
        List list = new Query(this.getCtx(), "JP_PP_FactLine", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).setOrderBy(orderClause).list();
        return list.toArray(new MPPFactLine[list.size()]);
    }

    public MPPFactLine[] getPPFactLines(boolean requery, String orderBy) {
        if (this.m_PPFactLines != null && !requery) {
            MPPFact.set_TrxName((PO[])this.m_PPFactLines, (String)this.get_TrxName());
            return this.m_PPFactLines;
        }
        String orderClause = "";
        orderClause = orderBy != null && orderBy.length() > 0 ? String.valueOf(orderClause) + orderBy : String.valueOf(orderClause) + "Line";
        this.m_PPFactLines = this.getPPFactLines(null, orderClause);
        return this.m_PPFactLines;
    }

    public MPPFactLine[] getPPFactLines() {
        return this.getPPFactLines(false, null);
    }

    public String createFactLineFromPlanLine(String trxName) {
        MPPPlan ppPlan = new MPPPlan(this.getCtx(), this.getJP_PP_Plan_ID(), trxName);
        MPPPlanLine[] ppPLines = ppPlan.getPPPlanLines();
        MPPFactLine ppFLine = null;
        BigDecimal plannedQty = Env.ZERO;
        BigDecimal qtyUsed = Env.ZERO;
        BigDecimal movementQty = Env.ZERO;
        MPPPlanLine[] mPPPlanLineArray = ppPLines;
        int n = ppPLines.length;
        int n2 = 0;
        while (n2 < n) {
            MPPPlanLine ppPLine = mPPPlanLineArray[n2];
            ppFLine = new MPPFactLine(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)ppPLine, (PO)ppFLine);
            ppFLine.setJP_PP_Fact_ID(this.getJP_PP_Fact_ID());
            ppFLine.setJP_PP_PlanLine_ID(ppPLine.getJP_PP_PlanLine_ID());
            ppFLine.setLine(ppPLine.getLine());
            ppFLine.setAD_Org_ID(this.getAD_Org_ID());
            ppFLine.setM_Product_ID(ppPLine.getM_Product_ID());
            ppFLine.setM_AttributeSetInstance_ID(ppPLine.getM_AttributeSetInstance_ID());
            ppFLine.setIsEndProduct(ppPLine.isEndProduct());
            ppFLine.setC_UOM_ID(ppPLine.getC_UOM_ID());
            if (ppPLine.isEndProduct()) {
                plannedQty = ppPLine.getPlannedQty().subtract(ppPLine.getJP_MovementQtyFact());
                if (plannedQty.signum() == 0) {
                    plannedQty = Env.ZERO;
                }
                qtyUsed = null;
                movementQty = plannedQty;
            } else {
                plannedQty = ppPLine.getPlannedQty().add(ppPLine.getJP_MovementQtyFact());
                if (plannedQty.signum() == 0) {
                    plannedQty = Env.ZERO;
                    qtyUsed = Env.ZERO;
                    movementQty = Env.ZERO;
                } else {
                    qtyUsed = plannedQty;
                    movementQty = plannedQty.negate();
                }
            }
            ppFLine.setPlannedQty(plannedQty);
            ppFLine.setQtyUsed(qtyUsed);
            ppFLine.setMovementQty(movementQty);
            ppFLine.setJP_Processing1("N");
            ppFLine.setJP_Processing2("N");
            ppFLine.setJP_Processing3("N");
            ppFLine.setIsCreated("N");
            if (!ppFLine.save(this.get_TrxName())) {
                String msg;
                this.m_processMsg = msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotCreate")) + " " + Msg.getMsg((Properties)this.getCtx(), (String)"SaveError") + " - " + Msg.getElement((Properties)this.getCtx(), (String)"JP_PP_FactLine_ID") + " - " + Msg.getElement((Properties)this.getCtx(), (String)"Line") + " : " + ppPLine.getLine();
                this.log.saveError("SaveError", msg);
                return msg;
            }
            ++n2;
        }
        return null;
    }

    public BigDecimal getEndProductMovementQty(String trxName) {
        BigDecimal productionQty;
        block6: {
            productionQty = Env.ZERO;
            String sql = "SELECT COALESCE(SUM(fl.MovementQty),0) FROM JP_PP_FactLine fl  WHERE fl.IsEndProduct='Y' AND JP_PP_Fact_ID = ? ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)trxName);
                    pstmt.setInt(1, this.getJP_PP_Fact_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        productionQty = rs.getBigDecimal(1);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return productionQty;
    }

    public boolean isHaveEndProduct() {
        MPPFactLine[] lines;
        MPPFactLine[] mPPFactLineArray = lines = this.getPPFactLines();
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            MPPFactLine line = mPPFactLineArray[n2];
            if (line.isEndProduct()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

