/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import jpiere.base.plugin.org.adempiere.model.MPPPlanT;
import jpiere.base.plugin.org.adempiere.model.X_JP_PP_DocT;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUOM;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MPPDocT
extends X_JP_PP_DocT {
    private MPPPlanT[] m_PPPlanTs = null;

    public MPPDocT(Properties ctx, int JP_PP_DocT_ID, String trxName) {
        super(ctx, JP_PP_DocT_ID, trxName);
    }

    public MPPDocT(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        if ((newRecord || this.is_ValueChanged("QtyEntered")) && Env.ONE.compareTo(this.getQtyEntered()) != 0) {
            this.log.saveError("Error", String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"QtyEntered")) + " = 1 ");
            return false;
        }
        if (newRecord || this.is_ValueChanged("ProductionQty")) {
            boolean isStdPrecision = MSysConfig.getBooleanValue((String)"JP_PP_UOM_STDPRECISION", (boolean)true, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
            MUOM uom = MUOM.get((int)this.getC_UOM_ID());
            this.setProductionQty(this.getProductionQty().setScale(isStdPrecision ? uom.getStdPrecision() : uom.getCostingPrecision(), RoundingMode.HALF_UP));
        }
        if ((newRecord || this.is_ValueChanged("JP_ProductionDays")) && this.getJP_ProductionDays() < 0) {
            this.log.saveError("Error", String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_ProductionDays")) + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"Minus"));
            return false;
        }
        return true;
    }

    public MPPPlanT[] getPPPlanTs(String whereClause, String orderClause) {
        StringBuilder whereClauseFinal = new StringBuilder("JP_PP_DocT_ID=?");
        if (!Util.isEmpty((String)whereClause, (boolean)true)) {
            whereClauseFinal.append(whereClause);
        }
        if (orderClause.length() == 0) {
            orderClause = "SeqNo";
        }
        List list = new Query(this.getCtx(), "JP_PP_PlanT", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).setOrderBy(orderClause).list();
        return list.toArray(new MPPPlanT[list.size()]);
    }

    public MPPPlanT[] getPPPlanTs(boolean requery, String orderBy) {
        if (this.m_PPPlanTs != null && !requery) {
            MPPDocT.set_TrxName((PO[])this.m_PPPlanTs, (String)this.get_TrxName());
            return this.m_PPPlanTs;
        }
        String orderClause = "";
        orderClause = orderBy != null && orderBy.length() > 0 ? String.valueOf(orderClause) + orderBy : String.valueOf(orderClause) + "SeqNo";
        this.m_PPPlanTs = this.getPPPlanTs(" AND IsActive='Y' ", orderClause);
        return this.m_PPPlanTs;
    }

    public MPPPlanT[] getPPPlanTs() {
        return this.getPPPlanTs(false, null);
    }

    public MPPPlanT getPPPlanT(int seqNo, int M_Product_ID, String value) {
        this.getPPPlanTs();
        MPPPlanT[] mPPPlanTArray = this.m_PPPlanTs;
        int n = this.m_PPPlanTs.length;
        int n2 = 0;
        while (n2 < n) {
            MPPPlanT ppPlanT = mPPPlanTArray[n2];
            if (ppPlanT.getSeqNo() == seqNo && ppPlanT.getM_Product_ID() == M_Product_ID && ppPlanT.getValue().equals(value)) {
                return ppPlanT;
            }
            ++n2;
        }
        return null;
    }

    public static MPPDocT get(Properties ctx, String Value, String trxName) {
        if (Value == null || Value.length() == 0) {
            return null;
        }
        String whereClause = "Value=? AND AD_Client_ID=?";
        MPPDocT retValue = (MPPDocT)new Query(ctx, "JP_PP_DocT", "Value=? AND AD_Client_ID=?", trxName).setParameters(new Object[]{Value, Env.getAD_Client_ID((Properties)ctx)}).firstOnly();
        return retValue;
    }
}

