/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MPPFact;
import jpiere.base.plugin.org.adempiere.model.MPPPlan;
import jpiere.base.plugin.org.adempiere.model.X_JP_PP_Doc;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MPeriod;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUOM;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MPPDoc
extends X_JP_PP_Doc
implements DocAction,
DocOptions {
    public static final String JP_PP_UOM_STDPRECISION = "JP_PP_UOM_STDPRECISION";
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private MPPPlan[] m_PPPlans = null;
    private MPPFact[] m_PPFacts = null;

    public MPPDoc(Properties ctx, int JP_PP_Doc_ID, String trxName) {
        super(ctx, JP_PP_Doc_ID, trxName);
    }

    public MPPDoc(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        if (newRecord || this.is_ValueChanged("ProductionQty")) {
            boolean isStdPrecision = MSysConfig.getBooleanValue((String)JP_PP_UOM_STDPRECISION, (boolean)true, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
            MUOM uom = MUOM.get((int)this.getC_UOM_ID());
            this.setProductionQty(this.getProductionQty().setScale(isStdPrecision ? uom.getStdPrecision() : uom.getCostingPrecision(), RoundingMode.HALF_UP));
        }
        if ((newRecord || this.is_ValueChanged("C_DocType_ID")) && !this.getC_DocType().getDocBaseType().equals("JDD")) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_DifferentDocType"));
            return false;
        }
        if (!(!newRecord && !this.is_ValueChanged("JP_PP_Start") || this.getDocStatus().equals("CO") || this.getDocStatus().equals("CL") || this.getDocStatus().equals("VO") || this.getDocStatus().equals("RE"))) {
            if (this.getJP_PP_Start() == null) {
                this.setJP_PP_StartProcess("N");
                if (this.getJP_PP_End() == null) {
                    this.setJP_PP_Status("NY");
                } else {
                    this.setJP_PP_Status("CO");
                }
            } else {
                this.setJP_PP_StartProcess("Y");
                if (this.getJP_PP_End() == null) {
                    this.setJP_PP_Status("WP");
                } else {
                    this.setJP_PP_Status("CO");
                }
            }
        }
        if (!(!newRecord && !this.is_ValueChanged("JP_PP_End") || this.getDocStatus().equals("CO") || this.getDocStatus().equals("CL") || this.getDocStatus().equals("VO") || this.getDocStatus().equals("RE"))) {
            if (this.getJP_PP_End() == null) {
                this.setJP_PP_EndProcess("N");
                if (this.getJP_PP_Start() == null) {
                    this.setJP_PP_Status("NY");
                } else {
                    this.setJP_PP_Status("WP");
                }
            } else {
                this.setJP_PP_EndProcess("Y");
                if (this.getJP_PP_Status().equals("WP") || this.getJP_PP_Status().equals("NY")) {
                    this.setJP_PP_Status("CO");
                }
            }
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        return success;
    }

    protected boolean beforeDelete() {
        MPPFact[] facts = this.getPPFacts();
        if (facts.length > 0) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_PP_CannotDeleteDoc"));
            return false;
        }
        return true;
    }

    public String getDocumentInfo() {
        return String.valueOf(this.getDocumentNo()) + "_" + this.getValue() + "_" + this.getName();
    }

    public File createPDF() {
        return null;
    }

    public File createPDF(File file) {
        return null;
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (!MPeriod.isOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (String)dt.getDocBaseType(), (int)this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        MPPPlan[] ppPlans = this.getPPPlans(true, null);
        if (ppPlans.length == 0) {
            this.m_processMsg = Msg.getMsg((Properties)this.getCtx(), (String)"JP_PP_NoPPPlan");
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public boolean approveIt() {
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String valid;
        MPPPlan[] ppPlans;
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        MPPPlan[] mPPPlanArray = ppPlans = this.getPPPlans(true, null);
        int n = ppPlans.length;
        int n2 = 0;
        while (n2 < n) {
            MPPPlan ppPlan = mPPPlanArray[n2];
            if (!ppPlan.isProcessed()) {
                this.m_processMsg = Msg.getMsg((Properties)this.getCtx(), (String)"JP_PP_NotCompletePPDocForUnprocessedPPPlan");
                return "IP";
            }
            ++n2;
        }
        Timestamp now = Timestamp.valueOf(LocalDateTime.now());
        if (this.getJP_PP_Start() == null) {
            this.setJP_PP_Start(now);
            this.setJP_PP_StartProcess("Y");
        }
        if (this.getJP_PP_End() == null) {
            this.setJP_PP_End(now);
            this.setJP_PP_EndProcess("Y");
        }
        if (!this.getJP_PP_Status().equals("CO")) {
            this.setJP_PP_Status("CO");
        }
        if ((valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9)) != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    public boolean voidIt() {
        MPPPlan[] ppPlans;
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        MFactAcct.deleteEx((int)Table_ID, (int)this.getJP_PP_Doc_ID(), (String)this.get_TrxName());
        this.setPosted(true);
        if (!this.getJP_PP_Status().equals("CO")) {
            this.setJP_PP_Status("VO");
        }
        MPPPlan[] mPPPlanArray = ppPlans = this.getPPPlans(true, null);
        int n = ppPlans.length;
        int n2 = 0;
        while (n2 < n) {
            MPPPlan ppPlan = mPPPlanArray[n2];
            if (!ppPlan.isProcessed()) {
                if (ppPlan.processIt("VO")) {
                    ppPlan.saveEx(this.get_TrxName());
                } else {
                    this.m_processMsg = ppPlan.getProcessMsg();
                    return false;
                }
            }
            ++n2;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public boolean closeIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        MPPPlan[] ppPlans = this.getPPPlans(true, null);
        boolean isOK = true;
        MPPPlan[] mPPPlanArray = ppPlans;
        int n = ppPlans.length;
        int n2 = 0;
        while (n2 < n) {
            MPPPlan ppPlan = mPPPlanArray[n2];
            if (ppPlan.isProcessed()) {
                if (ppPlan.getDocStatus().equals("CO")) {
                    isOK = ppPlan.processIt("CL");
                }
            } else {
                this.m_processMsg = Msg.getMsg((Properties)this.getCtx(), (String)"JP_PP_NotClosedPPDocForUnprocessedPPPlan");
            }
            if (!isOK) {
                this.m_processMsg = ppPlan.getProcessMsg();
                return false;
            }
            ppPlan.saveEx(this.get_TrxName());
            ++n2;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 11);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public boolean reverseCorrectIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        if (!this.getDocStatus().equals("CO")) {
            this.m_processMsg = Msg.getMsg((Properties)this.getCtx(), (String)"JP_CannotReverseForDocStatus");
            return false;
        }
        if (!this.reverse("RC")) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 13);
        return this.m_processMsg == null;
    }

    public boolean reverseAccrualIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        if (!this.getDocStatus().equals("CO")) {
            this.m_processMsg = Msg.getMsg((Properties)this.getCtx(), (String)"JP_CannotReverseForDocStatus");
            return false;
        }
        if (!this.reverse("RA")) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 14);
        return this.m_processMsg == null;
    }

    private boolean reverse(String docAction) {
        MPPPlan[] ppPlans = this.getPPPlans(true, null);
        boolean isOK = true;
        MPPPlan[] mPPPlanArray = ppPlans;
        int n = ppPlans.length;
        int n2 = 0;
        while (n2 < n) {
            MPPPlan ppPlan = mPPPlanArray[n2];
            if (!(ppPlan.getDocStatus().equals("CL") || ppPlan.getDocStatus().equals("VO") || ppPlan.getDocStatus().equals("RE"))) {
                if ("RA".equals(docAction)) {
                    if (!ppPlan.reverseCorrectIt()) {
                        isOK = false;
                    }
                } else if ("RC".equals(docAction) && !ppPlan.reverseAccrualIt()) {
                    isOK = false;
                }
                if (isOK) {
                    ppPlan.saveEx(this.get_TrxName());
                } else {
                    this.m_processMsg = ppPlan.getProcessMsg();
                    return false;
                }
            }
            ++n2;
        }
        if (!this.getJP_PP_Status().equals("CO")) {
            this.setJP_PP_Status("VO");
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public boolean reActivateIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        MFactAcct.deleteEx((int)Table_ID, (int)this.getJP_PP_Doc_ID(), (String)this.get_TrxName());
        this.setPosted(false);
        this.setIsApproved(false);
        this.setJP_PP_Status("WP");
        this.setJP_PP_End(null);
        this.setJP_PP_EndProcess("N");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    public String getSummary() {
        return String.valueOf(this.getValue()) + "_" + this.getName();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    public BigDecimal getApprovalAmt() {
        return Env.ZERO;
    }

    public int getC_Currency_ID() {
        return 0;
    }

    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (docStatus.equals("DR") || docStatus.equals("IP")) {
            index = 0;
            options[index++] = "VO";
            options[index++] = "PR";
            options[index++] = "CO";
        } else if (docStatus.equals("CO")) {
            index = 0;
            options[index++] = "RA";
            options[index++] = "RC";
            options[index++] = "CL";
            options[index++] = "RE";
        }
        return index;
    }

    public MPPPlan[] getPPPlans(String whereClause, String orderClause) {
        StringBuilder whereClauseFinal = new StringBuilder("JP_PP_Doc_ID=? ");
        if (!Util.isEmpty((String)whereClause, (boolean)true)) {
            whereClauseFinal.append(whereClause);
        }
        if (orderClause.length() == 0) {
            orderClause = "SeqNo";
        }
        List list = new Query(this.getCtx(), "JP_PP_Plan", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).setOrderBy(orderClause).list();
        return list.toArray(new MPPPlan[list.size()]);
    }

    public MPPPlan[] getPPPlans(boolean requery, String orderBy) {
        if (this.m_PPPlans != null && !requery) {
            MPPDoc.set_TrxName((PO[])this.m_PPPlans, (String)this.get_TrxName());
            return this.m_PPPlans;
        }
        String orderClause = "";
        orderClause = orderBy != null && orderBy.length() > 0 ? String.valueOf(orderClause) + orderBy : String.valueOf(orderClause) + "SeqNo";
        this.m_PPPlans = this.getPPPlans(null, orderClause);
        return this.m_PPPlans;
    }

    public MPPPlan[] getPPPlans() {
        return this.getPPPlans(false, null);
    }

    public MPPFact[] getPPFacts(String whereClause, String orderClause) {
        StringBuilder whereClauseFinal = new StringBuilder("JP_PP_Doc_ID=? ");
        if (!Util.isEmpty((String)whereClause, (boolean)true)) {
            whereClauseFinal.append(whereClause);
        }
        if (orderClause.length() == 0) {
            orderClause = "JP_PP_Fact_ID";
        }
        List list = new Query(this.getCtx(), "JP_PP_Fact", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).setOrderBy(orderClause).list();
        return list.toArray(new MPPFact[list.size()]);
    }

    public MPPFact[] getPPFacts(boolean requery, String orderBy) {
        if (this.m_PPFacts != null && !requery) {
            MPPDoc.set_TrxName((PO[])this.m_PPFacts, (String)this.get_TrxName());
            return this.m_PPFacts;
        }
        String orderClause = "";
        orderClause = orderBy != null && orderBy.length() > 0 ? String.valueOf(orderClause) + orderBy : String.valueOf(orderClause) + "JP_PP_Fact_ID";
        this.m_PPFacts = this.getPPFacts(null, orderClause);
        return this.m_PPFacts;
    }

    public MPPFact[] getPPFacts() {
        return this.getPPFacts(false, null);
    }

    public MPPPlan getPPPlan(int seqNo, int M_Product_ID, String value) {
        this.getPPPlans();
        MPPPlan[] mPPPlanArray = this.m_PPPlans;
        int n = this.m_PPPlans.length;
        int n2 = 0;
        while (n2 < n) {
            MPPPlan ppPlan = mPPPlanArray[n2];
            if (ppPlan.getSeqNo() == seqNo && ppPlan.getM_Product_ID() == M_Product_ID && ppPlan.getValue().equals(value)) {
                return ppPlan;
            }
            ++n2;
        }
        return null;
    }

    public static MPPDoc get(Properties ctx, String Value, String trxName) {
        if (Value == null || Value.length() == 0) {
            return null;
        }
        String whereClause = "Value=? AND AD_Client_ID=?";
        MPPDoc retValue = (MPPDoc)new Query(ctx, "JP_PP_Doc", "Value=? AND AD_Client_ID=?", trxName).setParameters(new Object[]{Value, Env.getAD_Client_ID((Properties)ctx)}).firstOnly();
        return retValue;
    }
}

