/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.X_JP_Org_History;
import org.compiere.model.MOrg;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MOrgHistory
extends X_JP_Org_History {
    private static CCache<Integer, MOrgHistory[]> s_cache = new CCache("JP_Org_History", 100, 10);

    public MOrgHistory(Properties ctx, int JP_Org_History_ID, String trxName) {
        super(ctx, JP_Org_History_ID, trxName);
    }

    public MOrgHistory(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getAD_Org_ID() == 0) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"AD_Org_ID = 0"));
            return false;
        }
        if (this.getAD_Client_ID() == 0) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"AD_Client_ID = 0"));
            return false;
        }
        if (newRecord || this.is_ValueChanged("DateFrom") || this.is_ValueChanged("DateTo")) {
            if (this.getDateFrom().compareTo(this.getDateTo()) > 0) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"DateFrom")) + " > " + Msg.getElement((Properties)this.getCtx(), (String)"DateTo"))));
                return false;
            }
            MOrgHistory[] m_OrgHistories = this.getOtherOrgHistory();
            int i = 0;
            while (i < m_OrgHistories.length) {
                if (this.getDateFrom().compareTo(m_OrgHistories[i].getDateTo()) <= 0 && m_OrgHistories[i].getDateFrom().compareTo(this.getDateTo()) <= 0) {
                    this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_OverlapPeriod"));
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private MOrgHistory[] getOtherOrgHistory() {
        ArrayList<MOrgHistory> list;
        MOrgHistory[] m_OrgHistories;
        block6: {
            m_OrgHistories = null;
            list = new ArrayList<MOrgHistory>();
            String sql = "SELECT * FROM JP_Org_History WHERE AD_Org_ID=? AND JP_Org_History_ID <> ?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, this.getAD_Org_ID());
                    pstmt.setInt(2, this.getJP_Org_History_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MOrgHistory(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        m_OrgHistories = new MOrgHistory[list.size()];
        list.toArray(m_OrgHistories);
        return m_OrgHistories;
    }

    public static MOrgHistory[] getOrgHistories(Properties ctx, int AD_Org_ID, String trxName) {
        MOrgHistory[] m_OrgHistoryies = (MOrgHistory[])s_cache.get((Object)AD_Org_ID);
        if (m_OrgHistoryies != null) {
            return m_OrgHistoryies;
        }
        String whereClause = "AD_Org_ID=?";
        List list = new Query(ctx, "JP_Org_History", "AD_Org_ID=?", trxName).setParameters(new Object[]{AD_Org_ID}).setOrderBy("DateFrom DESC").list();
        m_OrgHistoryies = new MOrgHistory[list.size()];
        list.toArray(m_OrgHistoryies);
        s_cache.put((Object)AD_Org_ID, (Object)m_OrgHistoryies);
        return m_OrgHistoryies;
    }

    public static MOrgHistory getOrgHistory(Properties ctx, int AD_Org_ID, Timestamp date, String trxName) {
        MOrgHistory m_OrgHistory = null;
        MOrgHistory[] m_OrgHistoryies = MOrgHistory.getOrgHistories(ctx, AD_Org_ID, trxName);
        int i = 0;
        while (i < m_OrgHistoryies.length) {
            if (m_OrgHistoryies[i].getDateFrom().compareTo(date) <= 0 && m_OrgHistoryies[i].getDateTo().compareTo(date) >= 0) {
                m_OrgHistory = m_OrgHistoryies[i];
                break;
            }
            ++i;
        }
        return m_OrgHistory;
    }

    public static String getOrgHistoryName(Properties ctx, int AD_Org_ID, Timestamp date, String trxName) {
        MOrgHistory m_OrgHistory = MOrgHistory.getOrgHistory(ctx, AD_Org_ID, date, trxName);
        if (m_OrgHistory == null) {
            return MOrg.get((Properties)ctx, (int)AD_Org_ID).getName();
        }
        return m_OrgHistory.getName();
    }
}

