/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MDocTypeCounter;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoicePaySchedule;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrderPaySchedule;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MSysConfig;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.process.DocOptions;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;

public class MOrderJP
extends MOrder
implements DocOptions {
    public MOrderJP(Properties ctx, int C_Order_ID, String trxName) {
        super(ctx, C_Order_ID, trxName);
    }

    public MOrderJP(MProject project, boolean IsSOTrx, String DocSubTypeSO) {
        super(project, IsSOTrx, DocSubTypeSO);
    }

    public MOrderJP(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (isSOTrx.equals("Y") && (orderType.equals("ON") || orderType.equals("OB"))) {
            index = 0;
            options[index++] = "PR";
            options[index++] = "VO";
            return index;
        }
        if (docStatus.equals("DR") || docStatus.equals("IP")) {
            index = 0;
            options[index++] = "VO";
            options[index++] = "PR";
            options[index++] = "CO";
            return index;
        }
        return index;
    }

    public boolean explodeBOM() {
        boolean retValue = false;
        String where = "AND IsActive='Y' AND EXISTS (SELECT * FROM M_Product p WHERE C_OrderLine.M_Product_ID=p.M_Product_ID AND\tp.IsBOM='Y' AND p.IsVerified='Y' AND p.IsStocked='N')";
        String sql = "SELECT COUNT(*) FROM C_OrderLine WHERE C_Order_ID=? " + where;
        int count = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getC_Order_ID());
        while (count != 0) {
            retValue = true;
            this.renumberLines(1000);
            MOrderLine[] lines = this.getLines(where, "Line");
            int i = 0;
            while (i < lines.length) {
                MOrderLine line = lines[i];
                MProduct product = MProduct.get((Properties)this.getCtx(), (int)line.getM_Product_ID());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(product.getName());
                }
                int lineNo = line.getLine();
                MPPProductBOM bom = MPPProductBOM.getDefault((MProduct)product, (String)this.get_TrxName());
                if (bom != null) {
                    boolean isRemain = MSysConfig.getBooleanValue((String)"JP_REMAIN_EXPLODE_PRODUCT_LINE", (boolean)false, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
                    boolean isFirstLine = true;
                    int JP_ProductExplodeBOM_ID = line.getM_Product_ID();
                    MPPProductBOMLine[] mPPProductBOMLineArray = bom.getLines();
                    int n = mPPProductBOMLineArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MPPProductBOMLine bomLine = mPPProductBOMLineArray[n2];
                        if (isRemain || !isFirstLine) {
                            MOrderLine newLine = new MOrderLine((MOrder)this);
                            newLine.setLine(++lineNo);
                            newLine.set_ValueNoCheck("JP_ProductExplodeBOM_ID", (Object)JP_ProductExplodeBOM_ID);
                            newLine.setM_Product_ID(bomLine.getM_Product_ID(), true);
                            newLine.setQty(line.getQtyOrdered().multiply(bomLine.getQtyBOM()));
                            if (bom.getDescription() != null) {
                                newLine.setDescription(bom.getDescription());
                            }
                            newLine.setPrice();
                            newLine.save(this.get_TrxName());
                        } else {
                            line.set_ValueNoCheck("JP_ProductExplodeBOM_ID", (Object)JP_ProductExplodeBOM_ID);
                            line.setM_Product_ID(bomLine.getM_Product_ID(), true);
                            line.setM_AttributeSetInstance_ID(0);
                            line.setPrice(Env.ZERO);
                            line.setPriceLimit(Env.ZERO);
                            line.setPriceList(Env.ZERO);
                            line.setLineNetAmt(Env.ZERO);
                            line.setFreightAmt(Env.ZERO);
                            line.setQty(line.getQtyOrdered().multiply(bomLine.getQtyBOM()));
                            String description = line.getDescription();
                            if (bom.getDescription() != null) {
                                line.setDescription(String.valueOf(description) + " : " + bom.getDescription());
                            }
                            line.setPrice();
                            line.save(this.get_TrxName());
                            isFirstLine = false;
                        }
                        ++n2;
                    }
                    if (isRemain) {
                        line.set_ValueNoCheck("JP_ProductExplodeBOM_ID", (Object)line.getM_Product_ID());
                        line.setM_Product_ID(0);
                        line.setM_AttributeSetInstance_ID(0);
                        line.setPrice(Env.ZERO);
                        line.setPriceLimit(Env.ZERO);
                        line.setPriceList(Env.ZERO);
                        line.setLineNetAmt(Env.ZERO);
                        line.setFreightAmt(Env.ZERO);
                        String description = product.getName();
                        if (product.getDescription() != null) {
                            description = String.valueOf(description) + " " + product.getDescription();
                        }
                        if (line.getDescription() != null) {
                            description = String.valueOf(description) + " " + line.getDescription();
                        }
                        line.setDescription(description);
                        line.save(this.get_TrxName());
                    }
                }
                ++i;
            }
            this.m_lines = null;
            count = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getC_Invoice_ID());
            this.renumberLines(10);
        }
        return retValue;
    }

    protected MInOut createShipment(MDocType dt, Timestamp movementDate) {
        MInOut shipment;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("For " + dt);
        }
        if (!(shipment = new MInOut((MOrder)this, dt.getC_DocTypeShipment_ID(), movementDate)).save(this.get_TrxName())) {
            this.m_processMsg = "Could not create Shipment";
            return null;
        }
        MOrderLine[] oLines = this.getLines(true, null);
        int i = 0;
        while (i < oLines.length) {
            MOrderLine oLine = oLines[i];
            MInOutLine ioLine = new MInOutLine(shipment);
            ioLine.set_ValueNoCheck("JP_ProductExplodeBOM_ID", oLine.get_Value("JP_ProductExplodeBOM_ID"));
            BigDecimal MovementQty = oLine.getQtyOrdered().subtract(oLine.getQtyDelivered());
            int M_Locator_ID = MStorageOnHand.getM_Locator_ID((int)oLine.getM_Warehouse_ID(), (int)oLine.getM_Product_ID(), (int)oLine.getM_AttributeSetInstance_ID(), (BigDecimal)MovementQty, (String)this.get_TrxName());
            if (M_Locator_ID == 0) {
                MWarehouse wh = MWarehouse.get((Properties)this.getCtx(), (int)oLine.getM_Warehouse_ID());
                M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
            }
            ioLine.setOrderLine(oLine, M_Locator_ID, MovementQty);
            ioLine.setQty(MovementQty);
            if (oLine.getQtyEntered().compareTo(oLine.getQtyOrdered()) != 0) {
                ioLine.setQtyEntered(MovementQty.multiply(oLine.getQtyEntered()).divide(oLine.getQtyOrdered(), 6, RoundingMode.HALF_UP));
            }
            if (!ioLine.save(this.get_TrxName())) {
                this.m_processMsg = "Could not create Shipment Line";
                return null;
            }
            ++i;
        }
        if (!shipment.processIt("CO")) {
            throw new AdempiereException("Failed when processing document - " + shipment.getProcessMsg());
        }
        shipment.saveEx(this.get_TrxName());
        if (!"CO".equals(shipment.getDocStatus())) {
            this.m_processMsg = "@M_InOut_ID@: " + shipment.getProcessMsg();
            return null;
        }
        return shipment;
    }

    protected MInvoice createInvoice(MDocType dt, MInOut shipment, Timestamp invoiceDate) {
        MInvoiceLine iLine;
        int i;
        MInvoice invoice;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(dt.toString());
        }
        if (!(invoice = new MInvoice((MOrder)this, dt.getC_DocTypeInvoice_ID(), invoiceDate)).save(this.get_TrxName())) {
            this.m_processMsg = "Could not create Invoice";
            return null;
        }
        if (shipment != null) {
            if (!"D".equals(this.getInvoiceRule())) {
                this.setInvoiceRule("D");
            }
            MInOutLine[] sLines = shipment.getLines(false);
            i = 0;
            while (i < sLines.length) {
                MInOutLine sLine = sLines[i];
                iLine = new MInvoiceLine(invoice);
                iLine.setShipLine(sLine);
                iLine.set_ValueNoCheck("JP_ProductExplodeBOM_ID", sLine.get_Value("JP_ProductExplodeBOM_ID"));
                if (sLine.sameOrderLineUOM()) {
                    iLine.setQtyEntered(sLine.getQtyEntered());
                } else {
                    iLine.setQtyEntered(sLine.getMovementQty());
                }
                iLine.setQtyInvoiced(sLine.getMovementQty());
                if (!iLine.save(this.get_TrxName())) {
                    this.m_processMsg = "Could not create Invoice Line from Shipment Line";
                    return null;
                }
                sLine.setIsInvoiced(true);
                if (!sLine.save(this.get_TrxName())) {
                    this.log.warning("Could not update Shipment line: " + sLine);
                }
                ++i;
            }
        } else {
            if (!"I".equals(this.getInvoiceRule())) {
                this.setInvoiceRule("I");
            }
            MOrderLine[] oLines = this.getLines();
            i = 0;
            while (i < oLines.length) {
                MOrderLine oLine = oLines[i];
                iLine = new MInvoiceLine(invoice);
                iLine.setOrderLine(oLine);
                iLine.set_ValueNoCheck("JP_ProductExplodeBOM_ID", oLine.get_Value("JP_ProductExplodeBOM_ID"));
                iLine.setQtyInvoiced(oLine.getQtyOrdered().subtract(oLine.getQtyInvoiced()));
                if (oLine.getQtyOrdered().compareTo(oLine.getQtyEntered()) == 0) {
                    iLine.setQtyEntered(iLine.getQtyInvoiced());
                } else {
                    iLine.setQtyEntered(iLine.getQtyInvoiced().multiply(oLine.getQtyEntered()).divide(oLine.getQtyOrdered(), 12, RoundingMode.HALF_UP));
                }
                if (!iLine.save(this.get_TrxName())) {
                    this.m_processMsg = "Could not create Invoice Line from Order Line";
                    return null;
                }
                ++i;
            }
        }
        MOrderPaySchedule[] mOrderPayScheduleArray = MOrderPaySchedule.getOrderPaySchedule((Properties)this.getCtx(), (int)this.getC_Order_ID(), (int)0, (String)this.get_TrxName());
        int n = mOrderPayScheduleArray.length;
        int n2 = 0;
        while (n2 < n) {
            MOrderPaySchedule ops = mOrderPayScheduleArray[n2];
            MInvoicePaySchedule ips = new MInvoicePaySchedule(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)ops, (PO)ips);
            ips.setC_Invoice_ID(invoice.getC_Invoice_ID());
            ips.setAD_Org_ID(ops.getAD_Org_ID());
            ips.setProcessing(ops.isProcessing());
            ips.setIsActive(ops.isActive());
            if (!ips.save()) {
                this.m_processMsg = "ERROR: creating pay schedule for invoice from : " + ops.toString();
                return null;
            }
            ++n2;
        }
        if (!invoice.processIt("CO")) {
            throw new AdempiereException("Failed when processing document - " + invoice.getProcessMsg());
        }
        invoice.saveEx(this.get_TrxName());
        this.setC_CashLine_ID(invoice.getC_CashLine_ID());
        if (!"CO".equals(invoice.getDocStatus())) {
            this.m_processMsg = "@C_Invoice_ID@: " + invoice.getProcessMsg();
            return null;
        }
        return invoice;
    }

    protected MOrder createCounterDoc() {
        if (this.getRef_Order_ID() != 0) {
            return null;
        }
        MOrg org = MOrg.get((Properties)this.getCtx(), (int)this.getAD_Org_ID());
        int counterC_BPartner_ID = org.getLinkedC_BPartner_ID(this.get_TrxName());
        if (counterC_BPartner_ID == 0) {
            return null;
        }
        MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        int counterAD_Org_ID = bp.getAD_OrgBP_ID();
        if (counterAD_Org_ID == 0) {
            return null;
        }
        MBPartner counterBP = new MBPartner(this.getCtx(), counterC_BPartner_ID, null);
        MOrgInfo counterOrgInfo = MOrgInfo.get((Properties)this.getCtx(), (int)counterAD_Org_ID, (String)this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Counter BP=" + counterBP.getName());
        }
        int C_DocTypeTarget_ID = 0;
        MDocTypeCounter counterDT = MDocTypeCounter.getCounterDocType((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (counterDT != null) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(counterDT.toString());
            }
            if (!counterDT.isCreateCounter() || !counterDT.isValid()) {
                return null;
            }
            C_DocTypeTarget_ID = counterDT.getCounter_C_DocType_ID();
        } else {
            C_DocTypeTarget_ID = MDocTypeCounter.getCounterDocType_ID((Properties)this.getCtx(), (int)this.getC_DocType_ID());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Indirect C_DocTypeTarget_ID=" + C_DocTypeTarget_ID);
            }
            if (C_DocTypeTarget_ID <= 0) {
                return null;
            }
        }
        MOrder counter = MOrderJP.copyFrom((MOrder)this, (Timestamp)this.getDateOrdered(), (int)C_DocTypeTarget_ID, (!this.isSOTrx() ? 1 : 0) != 0, (boolean)true, (boolean)false, (String)this.get_TrxName());
        counter.setAD_Org_ID(counterAD_Org_ID);
        counter.setM_Warehouse_ID(counterOrgInfo.getM_Warehouse_ID());
        counter.setDatePromised(this.getDatePromised());
        counter.setSalesRep_ID(this.getSalesRep_ID());
        counter.saveEx(this.get_TrxName());
        MOrderLine[] counterLines = counter.getLines(true, null);
        int i = 0;
        while (i < counterLines.length) {
            MOrderLine counterLine = counterLines[i];
            counterLine.setOrder(counter);
            counterLine.set_ValueNoCheck("JP_ProductExplodeBOM_ID", counterLines[i].get_Value("JP_ProductExplodeBOM_ID"));
            counterLine.setPrice();
            counterLine.setTax();
            counterLine.saveEx(this.get_TrxName());
            ++i;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(counter.toString());
        }
        if (counterDT != null && counterDT.getDocAction() != null) {
            counter.setDocAction(counterDT.getDocAction());
            if (!counter.processIt(counterDT.getDocAction())) {
                throw new AdempiereException("Failed when processing document - " + counter.getProcessMsg());
            }
            counter.saveEx(this.get_TrxName());
        }
        return counter;
    }
}

