/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import jpiere.base.plugin.org.adempiere.model.X_JP_GLJournalTax;
import org.compiere.model.MJournalLine;
import org.compiere.model.MTax;
import org.compiere.model.PO;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Util;

public class MGLJournalTax
extends X_JP_GLJournalTax {
    private MTax m_tax = null;
    private Integer m_precision = null;

    public MGLJournalTax(Properties ctx, int JP_GLJournalTax_ID, String trxName) {
        super(ctx, JP_GLJournalTax_ID, trxName);
    }

    public MGLJournalTax(Properties ctx, int JP_GLJournalTax_ID, String trxName, String ... virtualColumns) {
        super(ctx, JP_GLJournalTax_ID, trxName, virtualColumns);
    }

    public MGLJournalTax(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MGLJournalTax get(MJournalLine line, int precision, boolean oldTax, String trxName) {
        String JP_SOPOType;
        int C_Tax_ID;
        MGLJournalTax retValue;
        block16: {
            retValue = null;
            if (line == null || line.getGL_Journal_ID() == 0) {
                return null;
            }
            C_Tax_ID = line.get_ValueAsInt("C_Tax_ID");
            JP_SOPOType = line.get_ValueAsString("JP_SOPOType");
            if (C_Tax_ID == 0 || Util.isEmpty((String)JP_SOPOType)) {
                return null;
            }
            if (oldTax) {
                if (line.is_ValueChanged("C_Tax_ID")) {
                    Object old_C_Tax_ID = line.get_ValueOld("C_Tax_ID");
                    if (old_C_Tax_ID == null) {
                        return null;
                    }
                    C_Tax_ID = (Integer)old_C_Tax_ID;
                }
                if (line.is_ValueChanged("JP_SOPOType")) {
                    Object old_JP_SOPOType = line.get_ValueOld("JP_SOPOType");
                    if (old_JP_SOPOType == null) {
                        return null;
                    }
                    JP_SOPOType = (String)old_JP_SOPOType;
                }
            }
            if (C_Tax_ID == 0) {
                return null;
            }
            String sql = "SELECT * FROM JP_GLJournalTax WHERE GL_Journal_ID=? AND JP_SOPOType=? AND C_Tax_ID=? ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)trxName);
                    pstmt.setInt(1, line.getGL_Journal_ID());
                    pstmt.setString(2, JP_SOPOType);
                    pstmt.setInt(3, C_Tax_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = new MGLJournalTax(line.getCtx(), rs, trxName);
                    }
                }
                catch (Exception exception) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block16;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue != null) {
            retValue.setPrecision(precision);
            retValue.set_TrxName(trxName);
            return retValue;
        }
        if (oldTax) {
            return null;
        }
        retValue = new MGLJournalTax(line.getCtx(), 0, trxName);
        retValue.set_TrxName(trxName);
        retValue.setClientOrg((PO)line);
        retValue.setGL_Journal_ID(line.getGL_Journal_ID());
        retValue.setJP_SOPOType(JP_SOPOType);
        retValue.setC_Tax_ID(C_Tax_ID);
        retValue.setPrecision(precision);
        retValue.setIsTaxIncluded(true);
        return retValue;
    }

    private int getPrecision() {
        if (this.m_precision == null) {
            return 2;
        }
        return this.m_precision;
    }

    protected void setPrecision(int precision) {
        this.m_precision = precision;
    }
}

