/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MContract;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MContractPSInOutLine;
import jpiere.base.plugin.org.adempiere.model.MContractPSInvoiceLine;
import jpiere.base.plugin.org.adempiere.model.MContractPSLine;
import jpiere.base.plugin.org.adempiere.model.X_JP_ContractProcSchedule;
import org.compiere.model.MColumn;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;

public class MContractProcSchedule
extends X_JP_ContractProcSchedule
implements DocAction,
DocOptions {
    private static final long serialVersionUID = -7588955558162632796L;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private MContractPSLine[] m_ContractPSLines = null;
    private MContractContent parent = null;
    private MContract grandparent = null;

    public MContractProcSchedule(Properties ctx, int JP_ContractProcSchedule_ID, String trxName) {
        super(ctx, JP_ContractProcSchedule_ID, trxName);
    }

    public MContractProcSchedule(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)0);
        return String.valueOf(dt.getNameTrl()) + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(String.valueOf(this.get_TableName()) + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("unlockIt - " + this.toString());
        }
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("invalidateIt - " + this.toString());
        }
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (!MPeriod.isOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (String)dt.getDocBaseType(), (int)this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        MContractPSLine[] contractPSLines = this.getContractPSLines();
        if (contractPSLines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("approveIt - " + this.toString());
        }
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("rejectIt - " + this.toString());
        }
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String valid;
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.setDefiniteDocumentNo();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        if ((valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9)) != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        StringBuilder set = new StringBuilder("SET Processed='").append(processed ? "Y" : "N").append("' WHERE JP_ContractProcSchedule_ID=?");
        StringBuilder msgdb = new StringBuilder("UPDATE JP_ContractPSLine ").append((CharSequence)set);
        DB.executeUpdate((String)msgdb.toString(), (int)this.getJP_ContractProcSchedule_ID(), (String)this.get_TrxName());
        this.m_ContractPSLines = null;
        msgdb = new StringBuilder("UPDATE JP_ContractPSInOutLine ").append((CharSequence)set);
        DB.executeUpdate((String)msgdb.toString(), (int)this.getJP_ContractProcSchedule_ID(), (String)this.get_TrxName());
        msgdb = new StringBuilder("UPDATE JP_ContractPSInvoiceLine ").append((CharSequence)set);
        DB.executeUpdate((String)msgdb.toString(), (int)this.getJP_ContractProcSchedule_ID(), (String)this.get_TrxName());
    }

    private void setDefiniteDocumentNo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateInvoiced(TimeUtil.getDay((long)0L));
            if (this.getDateAcct().before(this.getDateInvoiced())) {
                this.setDateAcct(this.getDateInvoiced());
                MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (int)this.getC_DocType_ID(), (int)this.getAD_Org_ID());
            }
        }
        if (dt.isOverwriteSeqOnComplete()) {
            String value = null;
            int index = this.p_info.getColumnIndex("C_DocType_ID");
            if (index == -1) {
                index = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
            }
            if (index != -1) {
                value = DB.getDocumentNo((int)this.get_ValueAsInt(index), (String)this.get_TrxName(), (boolean)true);
            }
            if (value != null) {
                this.setDocumentNo(value);
            }
        }
    }

    public boolean voidIt() {
        if (this.isFactCreatedJP()) {
            this.m_processMsg = Msg.getMsg((Properties)this.getCtx(), (String)("JP_CannotVoid : " + Msg.getElement((Properties)this.getCtx(), (String)"IsFactCreatedJP")));
            return false;
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        MFactAcct.deleteEx((int)Table_ID, (int)this.getJP_ContractProcSchedule_ID(), (String)this.get_TrxName());
        this.setPosted(true);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public boolean closeIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("closeIt - " + this.toString());
        }
        this.setDocAction("--");
        return true;
    }

    public boolean reverseCorrectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("reverseCorrectIt - " + this.toString());
        }
        return false;
    }

    public boolean reverseAccrualIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("reverseAccrualIt - " + this.toString());
        }
        return false;
    }

    public boolean reActivateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        MFactAcct.deleteEx((int)Table_ID, (int)this.getJP_ContractProcSchedule_ID(), (String)this.get_TrxName());
        this.setPosted(false);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    public String getSummary() {
        return this.getDocumentNo();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    public BigDecimal getApprovalAmt() {
        return this.getTotalLines();
    }

    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (docStatus.equals("CO")) {
            index = 0;
            options[index++] = "CL";
            options[index++] = "VO";
            options[index++] = "RE";
            return index;
        }
        if (docStatus.equals("DR")) {
            index = 0;
            options[index++] = "PR";
            options[index++] = "VO";
            options[index++] = "CO";
            return index;
        }
        return index;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (!newRecord && this.isFactCreatedJP() && !this.is_ValueChanged("IsFactCreatedJP")) {
            int columnCount = this.get_ColumnCount();
            String columnName = null;
            MColumn column = null;
            boolean isOk = true;
            int i = 0;
            while (i < columnCount) {
                if (!(!this.is_ValueChanged(i) || (columnName = this.get_ColumnName(i)).equals("IsFactCreatedJP") || columnName.equals("DocStatus") || columnName.equals("DocAction") || columnName.equals("Processed") || columnName.equals("ProcessedOn") || columnName.equals("Posted") || (column = MColumn.get((Properties)this.getCtx(), (String)"JP_ContractProcSchedule", (String)columnName)).isAlwaysUpdateable())) {
                    isOk = false;
                    break;
                }
                ++i;
            }
            if (!isOk) {
                this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CannotChangeField", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)columnName)})) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"IsFactCreatedJP"));
                return false;
            }
        }
        if (newRecord) {
            if (this.getGrandparent().getJP_ContractType().equals("GLC")) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_GeneralContractContent_NotContractPS"));
                return false;
            }
            if (this.getGrandparent().getJP_ContractType().equals("STC")) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_SpotContractContent_NotContractPS"));
                return false;
            }
            if (this.getGrandparent().getDocStatus().equals("CL") || this.getParent().getDocStatus().equals("VO") || this.getParent().getDocStatus().equals("RE")) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_NotCreateContractPSForDocStatus"));
                return false;
            }
            if (!this.getParent().getJP_ContractProcessMethod().equals("IC")) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_ContractContentNoIndirectContractProcMethod"));
                return false;
            }
        }
        if (newRecord || this.is_ValueChanged("DateDoc")) {
            this.setDateInvoiced(this.getDateDoc());
            this.setDateOrdered(this.getDateDoc());
        }
        if (newRecord) {
            MContractContent contractContent = MContractContent.get(this.getCtx(), this.getJP_ContractContent_ID());
            this.setJP_Contract_ID(contractContent.getJP_Contract_ID());
            this.setJP_ContractProcess_ID(contractContent.getJP_ContractProcess_ID());
            this.setJP_ContractCalender_ID(contractContent.getJP_ContractCalender_ID());
            this.setDocBaseType(contractContent.getDocBaseType());
            this.setJP_BaseDocDocType_ID(contractContent.getJP_BaseDocDocType_ID());
            this.setJP_CreateDerivativeDocPolicy(contractContent.getJP_CreateDerivativeDocPolicy());
            this.setIsSOTrx(contractContent.isSOTrx());
            this.setOrderType(contractContent.getOrderType());
            this.setIsApproved(false);
            this.setProcessed(false);
        } else {
            Object[] objs = null;
            if (this.is_ValueChanged("JP_Contract_ID")) {
                objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_Contract_ID")};
            } else if (this.is_ValueChanged("JP_ContractContent_ID")) {
                objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractContent_ID")};
            } else if (this.is_ValueChanged("JP_ContractProcess_ID")) {
                objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcess_ID")};
            } else if (this.is_ValueChanged("JP_ContractCalender_ID")) {
                objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractCalender_ID")};
            } else if (this.is_ValueChanged("DocBaseType")) {
                objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"DocBaseType")};
            } else if (this.is_ValueChanged("JP_BaseDocDocType_ID")) {
                objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_BaseDocDocType_ID")};
            } else if (this.is_ValueChanged("JP_CreateDerivativeDocPolicy")) {
                objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_CreateDerivativeDocPolicy")};
            } else if (this.is_ValueChanged("IsSOTrx")) {
                objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"IsSOTrx")};
            } else if (this.is_ValueChanged("OrderType")) {
                objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"OrderType")};
            }
            if (objs != null) {
                String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CannotChangeField", (Object[])objs);
                this.log.saveError("Error", msg);
                return false;
            }
        }
        return true;
    }

    public MContractPSLine[] getContractPSLines(String whereClause, String orderClause) {
        StringBuilder whereClauseFinal = new StringBuilder("JP_ContractProcSchedule_ID=? ");
        if (!Util.isEmpty((String)whereClause, (boolean)true)) {
            whereClauseFinal.append(whereClause);
        }
        if (orderClause.length() == 0) {
            orderClause = "Line";
        }
        List list = new Query(this.getCtx(), "JP_ContractPSLine", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).setOrderBy(orderClause).list();
        return list.toArray(new MContractPSLine[list.size()]);
    }

    public MContractPSLine[] getContractPSLines(boolean requery, String orderBy) {
        if (this.m_ContractPSLines != null && !requery) {
            MContractProcSchedule.set_TrxName((PO[])this.m_ContractPSLines, (String)this.get_TrxName());
            return this.m_ContractPSLines;
        }
        String orderClause = "";
        orderClause = orderBy != null && orderBy.length() > 0 ? String.valueOf(orderClause) + orderBy : String.valueOf(orderClause) + "Line";
        this.m_ContractPSLines = this.getContractPSLines(null, orderClause);
        return this.m_ContractPSLines;
    }

    public MContractPSLine[] getContractPSLines() {
        return this.getContractPSLines(false, null);
    }

    public MContractPSInOutLine[] getContractPSInOutLines(int JP_ContractProcPeriod_ID, boolean isFactCreatedJP) {
        StringBuilder whereClauseFinal = new StringBuilder("JP_ContractProcSchedule_ID=? AND JP_ContractProcPeriod_ID=? AND IsFactCreatedJP=" + (isFactCreatedJP ? "'Y'" : "'N'"));
        List list = new Query(this.getCtx(), "JP_ContractPSInOutLine", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.get_ID(), JP_ContractProcPeriod_ID}).setOrderBy("Line").list();
        return list.toArray(new MContractPSInOutLine[list.size()]);
    }

    public MContractPSInOutLine[] getContractPSInOutLines(int JP_ContractProcPeriod_ID) {
        StringBuilder whereClauseFinal = new StringBuilder("JP_ContractProcSchedule_ID=? ANDJP_ContractProcPeriod_ID=?");
        List list = new Query(this.getCtx(), "JP_ContractPSInOutLine", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.get_ID(), JP_ContractProcPeriod_ID}).setOrderBy("Line").list();
        return list.toArray(new MContractPSInOutLine[list.size()]);
    }

    public MContractPSInOutLine[] getContractPSInOutLines() {
        StringBuilder whereClauseFinal = new StringBuilder("JP_ContractProcSchedule_ID=?");
        List list = new Query(this.getCtx(), "JP_ContractPSInOutLine", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).setOrderBy("Line").list();
        return list.toArray(new MContractPSInOutLine[list.size()]);
    }

    public MContractPSInvoiceLine[] getContractPSInvoiceLines(int JP_ContractProcPeriod_ID, boolean isFactCreatedJP) {
        StringBuilder whereClauseFinal = new StringBuilder("JP_ContractProcSchedule_ID=? AND JP_ContractProcPeriod_ID=? AND IsFactCreatedJP=" + (isFactCreatedJP ? "'Y'" : "'N'"));
        List list = new Query(this.getCtx(), "JP_ContractPSInvoiceLine", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.get_ID(), JP_ContractProcPeriod_ID}).setOrderBy("Line").list();
        return list.toArray(new MContractPSInvoiceLine[list.size()]);
    }

    public MContractPSInvoiceLine[] getContractPSInvoiceLines(int JP_ContractProcPeriod_ID) {
        StringBuilder whereClauseFinal = new StringBuilder("JP_ContractProcSchedule_ID=? ANDJP_ContractProcPeriod_ID=?");
        List list = new Query(this.getCtx(), "JP_ContractPSInvoiceLine", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.get_ID(), JP_ContractProcPeriod_ID}).setOrderBy("Line").list();
        return list.toArray(new MContractPSInvoiceLine[list.size()]);
    }

    public MContractPSInvoiceLine[] getContractPSInvoiceLines() {
        StringBuilder whereClauseFinal = new StringBuilder("JP_ContractProcSchedule_ID=?");
        List list = new Query(this.getCtx(), "JP_ContractPSInvoiceLine", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).setOrderBy("Line").list();
        return list.toArray(new MContractPSInvoiceLine[list.size()]);
    }

    public static MContractProcSchedule[] getMContractProcSchedules(int JP_ContractContent_ID, int JP_ContractProcPeriod_ID, String trxName) {
        StringBuilder whereClauseFinal = new StringBuilder("JP_ContractContent_ID=? AND JP_ContractProcPeriod_ID=?");
        List list = new Query(Env.getCtx(), "JP_ContractProcSchedule", whereClauseFinal.toString(), trxName).setParameters(new Object[]{JP_ContractContent_ID, JP_ContractProcPeriod_ID}).setOrderBy("DocumentNo").list();
        return list.toArray(new MContractProcSchedule[list.size()]);
    }

    public MContractContent getParent() {
        if (this.parent == null) {
            this.parent = new MContractContent(this.getCtx(), this.getJP_ContractContent_ID(), null);
        }
        return this.parent;
    }

    public MContract getGrandparent() {
        if (this.grandparent == null) {
            this.grandparent = new MContract(this.getCtx(), this.getJP_Contract_ID(), null);
        }
        return this.grandparent;
    }
}

