/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import jpiere.base.plugin.org.adempiere.model.MContractLine;
import jpiere.base.plugin.org.adempiere.model.X_JP_ContractContentTax;
import org.compiere.model.MCharge;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MContractContentTax
extends X_JP_ContractContentTax {
    private Integer m_precision = null;

    public MContractContentTax(Properties ctx, int JP_ContractContentTax_ID, String trxName) {
        super(ctx, JP_ContractContentTax_ID, trxName);
    }

    public MContractContentTax(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MContractContentTax get(MContractLine line, int precision, boolean oldTax, String trxName) {
        boolean isOldTax;
        MContractContentTax retValue;
        block16: {
            retValue = null;
            if (line == null || line.getJP_ContractContent_ID() == 0) {
                return null;
            }
            int C_Tax_ID = line.getC_Tax_ID();
            boolean bl = isOldTax = oldTax && line.is_ValueChanged("C_Tax_ID");
            if (isOldTax) {
                Object old = line.get_ValueOld("C_Tax_ID");
                if (old == null) {
                    return null;
                }
                C_Tax_ID = (Integer)old;
            }
            if (C_Tax_ID == 0) {
                if (!line.isDescription()) {
                    // empty if block
                }
                return null;
            }
            String sql = "SELECT * FROM JP_ContractContentTax WHERE JP_ContractContent_ID=? AND C_Tax_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)trxName);
                    pstmt.setInt(1, line.getJP_ContractContent_ID());
                    pstmt.setInt(2, C_Tax_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = new MContractContentTax(line.getCtx(), rs, trxName);
                    }
                }
                catch (Exception exception) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block16;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue != null) {
            retValue.setPrecision(precision);
            retValue.set_TrxName(trxName);
            return retValue;
        }
        if (isOldTax) {
            return null;
        }
        retValue = new MContractContentTax(line.getCtx(), 0, trxName);
        retValue.set_TrxName(trxName);
        retValue.setClientOrg(line);
        retValue.setJP_ContractContent_ID(line.getJP_ContractContent_ID());
        retValue.setC_Tax_ID(line.getC_Tax_ID());
        retValue.setPrecision(precision);
        retValue.setIsTaxIncluded(line.getParent().isTaxIncluded());
        if (line.getC_Charge_ID() != 0) {
            MCharge charge = MCharge.get((Properties)Env.getCtx(), (int)line.getC_Charge_ID());
            if (!charge.isSameTax()) {
                retValue.setIsTaxIncluded(charge.isTaxIncluded());
            } else {
                retValue.setIsTaxIncluded(line.getParent().isTaxIncluded());
            }
        }
        return retValue;
    }

    public int getPrecision() {
        if (this.m_precision == null) {
            return 2;
        }
        return this.m_precision;
    }

    protected void setPrecision(int precision) {
        this.m_precision = precision;
    }
}

