/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.base.IJPiereTaxProvider;
import jpiere.base.plugin.org.adempiere.model.MContract;
import jpiere.base.plugin.org.adempiere.model.MContractAcct;
import jpiere.base.plugin.org.adempiere.model.MContractCalender;
import jpiere.base.plugin.org.adempiere.model.MContractContentTax;
import jpiere.base.plugin.org.adempiere.model.MContractLine;
import jpiere.base.plugin.org.adempiere.model.MContractProcPeriod;
import jpiere.base.plugin.org.adempiere.model.MContractProcSchedule;
import jpiere.base.plugin.org.adempiere.model.MContractProcess;
import jpiere.base.plugin.org.adempiere.model.MRecognition;
import jpiere.base.plugin.org.adempiere.model.X_JP_ContractContent;
import jpiere.base.plugin.util.JPiereUtil;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPeriod;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MQuery;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTax;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.PrintInfo;
import org.compiere.model.Query;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MContractContent
extends X_JP_ContractContent
implements DocAction,
DocOptions {
    private static final long serialVersionUID = -7588955558162632796L;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private MContract parent = null;
    private MContractLine[] m_lines = null;
    private MContractProcSchedule[] m_schedules = null;
    private static CCache<Integer, MContractContent> s_cache = new CCache("JP_ContractContent", 20);
    protected MContractContentTax[] m_taxes = null;

    public MContractContent(Properties ctx, int JP_Contract_ID, String trxName) {
        super(ctx, JP_Contract_ID, trxName);
    }

    public MContractContent(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        return String.valueOf(dt.getNameTrl()) + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(String.valueOf(this.get_TableName()) + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        int m_docid = this.getJP_ContractContent_ID();
        MQuery query = new MQuery("JP_ContractContent");
        query.addRestriction("JP_ContractContent_ID", "=", (Object)m_docid);
        int AD_PrintFormat_ID = this.getC_DocType().getAD_PrintFormat_ID();
        if (AD_PrintFormat_ID == 0) {
            return null;
        }
        MPrintFormat pf = new MPrintFormat(this.getCtx(), AD_PrintFormat_ID, this.get_TrxName());
        PrintInfo info = new PrintInfo("0", 0, 0, 0);
        ReportEngine re = new ReportEngine(this.getCtx(), pf, query, info);
        if (pf.getJasperProcess_ID() > 0) {
            ProcessInfo pi = new ProcessInfo("", pf.getJasperProcess_ID());
            pi.setRecord_ID(this.getJP_ContractContent_ID());
            pi.setIsBatch(true);
            ServerProcessCtl.process((ProcessInfo)pi, null);
            return pi.getPDFReport();
        }
        return re.getPDF(file);
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("unlockIt - " + this.toString());
        }
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("invalidateIt - " + this.toString());
        }
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        String msg;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (!MPeriod.isOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (String)dt.getDocBaseType(), (int)this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        if (this.getParent().getJP_ContractType().equals("PDC") && this.getJP_ContractCalender_ID() == 0) {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractCalender_ID")};
            this.m_processMsg = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfPeriodContract")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
            return "IN";
        }
        if (this.getJP_ContractCalender_ID() > 0) {
            MContractProcPeriod end_ProcPeriod;
            MContractCalender base_Calender = MContractCalender.get(this.getCtx(), this.getJP_ContractCalender_ID(), this.get_TrxName());
            MContractProcPeriod start_ProcPeriod = base_Calender.getContractProcessPeriod(this.getCtx(), this.getJP_ContractProcDate_From());
            if (start_ProcPeriod == null) {
                this.m_processMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NotFound")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcPeriod_ID") + " - " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcDate_From");
                return "IN";
            }
            if (this.getJP_ContractProcDate_To() != null && (end_ProcPeriod = base_Calender.getContractProcessPeriod(this.getCtx(), this.getJP_ContractProcDate_To())) == null) {
                this.m_processMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NotFound")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcPeriod_ID") + " - " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcDate_To");
                return "IN";
            }
        }
        if (!Util.isEmpty((String)(msg = this.checkJP_ContractProcDate_To()))) {
            this.m_processMsg = msg;
            return "IN";
        }
        if (this.getParent().getJP_ContractType().equals("PDC")) {
            MContractLine[] lines = this.getLines();
            if (lines.length == 0) {
                this.m_processMsg = "@NoLines@";
                return "IN";
            }
            int i = 0;
            while (i < lines.length) {
                if (!lines[i].checkPeriodContractInfo(false, true)) {
                    String error = lines[i].getProcessMsg();
                    this.m_processMsg = String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"Line")) + " : " + lines[i].getLine() + "  " + error.toString();
                    return "IN";
                }
                if (this.isAutomaticUpdateJP() && !Util.isEmpty((String)this.getJP_ContractC_AutoUpdatePolicy()) && this.getJP_ContractC_AutoUpdatePolicy().equals("RE") && Util.isEmpty((String)lines[i].getJP_ContractL_AutoUpdatePolicy())) {
                    Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractL_AutoUpdatePolicy")};
                    this.m_processMsg = String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"Line")) + " : " + lines[i].getLine() + "  " + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                    return "IN";
                }
                ++i;
            }
        }
        if (!this.calculateTaxTotal()) {
            this.m_processMsg = "Error calculating tax";
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public boolean calculateTaxTotal() {
        MTax[] taxes;
        this.log.fine("");
        DB.executeUpdateEx((String)("DELETE FROM JP_ContractContentTax WHERE JP_ContractContent_ID = " + this.getJP_ContractContent_ID()), (String)this.get_TrxName());
        this.m_taxes = null;
        MTax[] mTaxArray = taxes = this.getTaxes();
        int n = taxes.length;
        int n2 = 0;
        while (n2 < n) {
            MTax tax = mTaxArray[n2];
            IJPiereTaxProvider taxCalculater = JPiereUtil.getJPiereTaxProvider(tax);
            if (taxCalculater == null) {
                throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)"TaxNoProvider"));
            }
            if (!taxCalculater.calculateContractContentTaxTotal(null, this)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public MTax[] getTaxes() {
        Hashtable<Integer, MTax> taxes = new Hashtable<Integer, MTax>();
        MContractLine[] lines = this.getLines();
        MTax tax = null;
        MContractLine[] mContractLineArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            MContractLine line = mContractLineArray[n2];
            tax = (MTax)taxes.get(line.getC_Tax_ID());
            if (tax == null) {
                tax = MTax.get((Properties)this.getCtx(), (int)line.getC_Tax_ID());
                taxes.put(tax.getC_Tax_ID(), tax);
            }
            ++n2;
        }
        MTax[] retValue = new MTax[taxes.size()];
        taxes.values().toArray(retValue);
        return retValue;
    }

    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("approveIt - " + this.toString());
        }
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("rejectIt - " + this.toString());
        }
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String valid;
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.setDefiniteDocumentNo();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        if ((valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9)) != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        this.updateContractProcStatus("CO", false);
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateAcct(new Timestamp(System.currentTimeMillis()));
            MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (int)this.getC_DocType_ID(), (int)this.getAD_Org_ID());
        }
        if (dt.isOverwriteSeqOnComplete()) {
            String value = null;
            int index = this.p_info.getColumnIndex("C_DocType_ID");
            if (index != -1) {
                value = DB.getDocumentNo((int)this.get_ValueAsInt(index), (String)this.get_TrxName(), (boolean)true);
            }
            if (value != null) {
                this.setDocumentNo(value);
            }
        }
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        StringBuilder set = new StringBuilder("SET Processed='").append(processed ? "Y" : "N").append("' WHERE JP_ContractContent_ID=?");
        StringBuilder msgdb = new StringBuilder("UPDATE JP_ContractLine ").append((CharSequence)set);
        int noLine = DB.executeUpdate((String)msgdb.toString(), (int)this.getJP_ContractContent_ID(), (String)this.get_TrxName());
        this.m_lines = null;
        msgdb = new StringBuilder("UPDATE JP_ContractContentTax ").append((CharSequence)set);
        int noTax = DB.executeUpdate((String)msgdb.toString(), (int)this.getJP_ContractContent_ID(), (String)this.get_TrxName());
        this.m_taxes = null;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("setProcessed - " + processed + " - Lines=" + noLine + ", Tax=" + noTax);
        }
    }

    public boolean voidIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        MFactAcct.deleteEx((int)Table_ID, (int)this.getJP_Contract_ID(), (String)this.get_TrxName());
        this.setPosted(true);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.updateContractProcStatus("VO", false);
        return true;
    }

    public boolean closeIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("closeIt - " + this.toString());
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.updateContractProcStatus("CL", false);
        return true;
    }

    public boolean reverseCorrectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("reverseCorrectIt - " + this.toString());
        }
        return false;
    }

    public boolean reverseAccrualIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("reverseAccrualIt - " + this.toString());
        }
        return false;
    }

    public boolean reActivateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        MFactAcct.deleteEx((int)Table_ID, (int)this.getJP_Contract_ID(), (String)this.get_TrxName());
        this.setPosted(false);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        this.updateContractProcStatus("RE", false);
        return true;
    }

    public String getSummary() {
        return this.getDocumentNo();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    public BigDecimal getApprovalAmt() {
        return this.getTotalLines();
    }

    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (docStatus.equals("CO")) {
            index = 0;
            options[index++] = "CL";
            options[index++] = "VO";
            options[index++] = "RE";
            return index;
        }
        if (docStatus.equals("DR")) {
            index = 0;
            options[index++] = "PR";
            options[index++] = "VO";
            options[index++] = "CO";
            return index;
        }
        return index;
    }

    protected boolean beforeSave(boolean newRecord) {
        int cnt;
        MContractCalender cc;
        MPriceList pricelist;
        MContractAcct acctInfo;
        int JP_Contract_Acct_ID;
        if (newRecord) {
            if (this.getParent().getJP_ContractType().equals("GLC")) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_GeneralContractContent"));
                return false;
            }
            if (this.getParent().getDocStatus().equals("CL") || this.getParent().getDocStatus().equals("VO") || this.getParent().getDocStatus().equals("RE")) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_NotCreateContractContentForDocStatus"));
                return false;
            }
        }
        if (newRecord || this.is_ValueChanged("DateDoc")) {
            this.setDateInvoiced(this.getDateDoc());
            this.setDateOrdered(this.getDateDoc());
        }
        if ((newRecord || this.is_ValueChanged("JP_ContractProcDate_From") || this.is_ValueChanged("JP_ContractProcDate_To")) && this.getJP_ContractProcDate_From() != null && this.getJP_ContractProcDate_To() != null && this.getJP_ContractProcDate_From().compareTo(this.getJP_ContractProcDate_To()) > 0) {
            this.log.saveError("Error", String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcDate_From")) + " > " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcDate_To"));
            return false;
        }
        MContract contract = this.getParent();
        if (contract.getJP_ContractType().equals("PDC") && (newRecord || this.is_ValueChanged("JP_ContractProcDate_From") || this.is_ValueChanged("JP_ContractProcDate_To")) && !this.getJP_ContractContentT().isOrverlapContractProcDateJP()) {
            MContractContent[] contractContents = contract.getContractContents();
            int i = 0;
            while (i < contractContents.length) {
                if (contractContents[i].getJP_ContractContent_ID() != this.getJP_ContractContent_ID() && contractContents[i].getJP_ContractContentT_ID() == this.getJP_ContractContentT_ID() && !contractContents[i].getJP_ContractProcStatus().equals("IN")) {
                    if (contractContents[i].getJP_ContractProcDate_To() != null && this.getJP_ContractProcDate_To() != null) {
                        if (contractContents[i].getJP_ContractProcDate_From().compareTo(this.getJP_ContractProcDate_To()) <= 0 && contractContents[i].getJP_ContractProcDate_To().compareTo(this.getJP_ContractProcDate_From()) >= 0) {
                            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_OverlapOfContractProcessDate"));
                            return false;
                        }
                    } else if (contractContents[i].getJP_ContractProcDate_To() != null) {
                        if (contractContents[i].getJP_ContractProcDate_To().compareTo(this.getJP_ContractProcDate_From()) >= 0) {
                            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_OverlapOfContractProcessDate"));
                            return false;
                        }
                    } else if (this.getJP_ContractProcDate_To() != null) {
                        if (contractContents[i].getJP_ContractProcDate_From().compareTo(this.getJP_ContractProcDate_To()) <= 0) {
                            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_OverlapOfContractProcessDate"));
                            return false;
                        }
                    } else {
                        this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_OverlapOfContractProcessDate"));
                        return false;
                    }
                }
                ++i;
            }
        }
        if (contract.getJP_ContractType().equals("PDC") && !this.getJP_ContractProcStatus().equals("UN") && (this.is_ValueChanged("DocBaseType") || this.is_ValueChanged("JP_BaseDocDocType_ID") || this.is_ValueChanged("JP_CreateDerivativeDocPolicy") || this.is_ValueChanged("JP_ContractCalender_ID") || this.is_ValueChanged("JP_ContractProcDate_From") || this.is_ValueChanged("JP_ContractProcess_ID") || this.is_ValueChanged("JP_Contract_Acct_ID") || this.is_ValueChanged("C_BPartner_ID"))) {
            StringBuilder msg = new StringBuilder(Msg.getMsg((Properties)this.getCtx(), (String)"JP_NotUpdateForContractProcessStatus"));
            if (this.is_ValueChanged("DocBaseType")) {
                msg.append(" : ").append(Msg.getElement((Properties)this.getCtx(), (String)"DocBaseType"));
            } else if (this.is_ValueChanged("JP_BaseDocDocType_ID")) {
                msg.append(" : ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_BaseDocDocType_ID"));
            } else if (this.is_ValueChanged("JP_CreateDerivativeDocPolicy")) {
                msg.append(" : ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_CreateDerivativeDocPolicy"));
            } else if (this.is_ValueChanged("JP_ContractCalender_ID")) {
                msg.append(" : ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractCalender_ID"));
            } else if (this.is_ValueChanged("JP_ContractProcDate_From")) {
                msg.append(" : ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcDate_From"));
            } else if (this.is_ValueChanged("JP_ContractProcess_ID")) {
                msg.append(" : ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcess_ID"));
            } else if (this.is_ValueChanged("JP_Contract_Acct_ID")) {
                msg.append(" : ").append(Msg.getElement((Properties)this.getCtx(), (String)"JP_Contract_Acct_ID"));
            } else if (this.is_ValueChanged("C_BPartner_ID")) {
                msg.append(" : ").append(Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_ID"));
            }
            this.log.saveError("Error", msg.toString());
            return false;
        }
        if (newRecord || this.is_ValueChanged("JP_BaseDocDocType_ID") || this.is_ValueChanged("DocBaseType") || this.is_ValueChanged("JP_CreateDerivativeDocPolicy")) {
            MDocType docType = MDocType.get((Properties)this.getCtx(), (int)this.getJP_BaseDocDocType_ID());
            this.setIsSOTrx(docType.isSOTrx());
            if (!this.getDocBaseType().equals(docType.getDocBaseType())) {
                this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_BaseDocDocType_ID"));
                return false;
            }
            if (this.getDocBaseType().equals("POO") || this.getDocBaseType().equals("SOO")) {
                String DocSubTypeSO = docType.getDocSubTypeSO();
                if (Util.isEmpty((String)DocSubTypeSO)) {
                    this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Null")) + Msg.getElement((Properties)this.getCtx(), (String)"DocSubTypeSO") + " - " + Msg.getElement((Properties)this.getCtx(), (String)"C_DocType_ID"));
                    return false;
                }
                this.setOrderType(docType.getDocSubTypeSO());
                if (!(this.getJP_CreateDerivativeDocPolicy() == null || this.getJP_CreateDerivativeDocPolicy().equals("MA") || docType.getDocSubTypeSO().equals("SO") || docType.getDocSubTypeSO().equals("OB") || docType.getDocSubTypeSO().equals("ON"))) {
                    this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_BaseDocDocType_ID") + "  :  " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_BaseDocDocType_CreateDerivativeDocPolicy"));
                    return false;
                }
                if (this.getJP_CreateDerivativeDocPolicy() != null && (this.getJP_CreateDerivativeDocPolicy().equals("IO") || this.getJP_CreateDerivativeDocPolicy().equals("BT")) && docType.getC_DocTypeShipment_ID() == 0) {
                    String msg1 = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_ToBeConfirmed")) + " - " + Msg.getElement((Properties)this.getCtx(), (String)"JP_BaseDocDocType_ID");
                    String msg2 = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Null")) + " - " + Msg.getElement((Properties)this.getCtx(), (String)"C_DocTypeShipment_ID");
                    this.log.saveError("Error", String.valueOf(msg1) + " : " + msg2);
                    return false;
                }
                if (this.getJP_CreateDerivativeDocPolicy() != null && (this.getJP_CreateDerivativeDocPolicy().equals("IV") || this.getJP_CreateDerivativeDocPolicy().equals("BT")) && docType.getC_DocTypeInvoice_ID() == 0) {
                    String msg1 = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_ToBeConfirmed")) + " - " + Msg.getElement((Properties)this.getCtx(), (String)"JP_BaseDocDocType_ID");
                    String msg2 = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Null")) + " - " + Msg.getElement((Properties)this.getCtx(), (String)"C_DocTypeInvoice_ID");
                    this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Null")) + msg1 + " : " + msg2);
                    return false;
                }
            } else {
                this.setOrderType("--");
            }
        }
        if (newRecord || this.is_ValueChanged("JP_CreateDerivativeDocPolicy")) {
            if (this.getParent().getJP_ContractType().equals("PDC") && (this.getDocBaseType().equals("SOO") || this.getDocBaseType().equals("POO"))) {
                if (Util.isEmpty((String)this.getJP_CreateDerivativeDocPolicy())) {
                    Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_CreateDerivativeDocPolicy")};
                    String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                    this.log.saveError("Error", msg);
                    return false;
                }
                if (this.getDocBaseType().equals("POO") || this.getDocBaseType().equals("SOO")) {
                    MDocType io_DocType;
                    int C_DocTypeShipment_ID;
                    if (!(this.getJP_CreateDerivativeDocPolicy().equals("MA") || this.getOrderType().equals("SO") || this.getOrderType().equals("OB") || this.getOrderType().equals("ON"))) {
                        this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"MA") + "  :  " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_BaseDocDocType_CreateDerivativeDocPolicy"));
                        return false;
                    }
                    if ((this.getJP_CreateDerivativeDocPolicy().equals("BT") || this.getJP_CreateDerivativeDocPolicy().equals("IV")) && (C_DocTypeShipment_ID = this.getJP_BaseDocDocType().getC_DocTypeShipment_ID()) > 0 && (io_DocType = MDocType.get((Properties)this.getCtx(), (int)C_DocTypeShipment_ID)).get_ValueAsBoolean("IsCreateInvoiceJP")) {
                        String msg1 = Msg.getMsg((Properties)this.getCtx(), (String)"JP_DocTypeForShipmentOfBaseDocDocType");
                        String msg2 = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_BaseDocDocType_ID"), Msg.getElement((Properties)Env.getCtx(), (String)"JP_CreateDerivativeDocPolicy")});
                        this.log.saveError("Error", String.valueOf(msg1) + " : " + msg2);
                        return false;
                    }
                }
            } else {
                this.setJP_CreateDerivativeDocPolicy(null);
            }
        }
        if (this.getParent().getJP_ContractType().equals("PDC")) {
            if (!newRecord && this.getJP_ContractProcDate_From() == null) {
                Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcDate_From")};
                String msg = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfPeriodContract")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                this.log.saveError("Error", msg);
                return false;
            }
            if (!newRecord && this.getJP_ContractProcDate_From().compareTo(this.getParent().getJP_ContractPeriodDate_From()) < 0) {
                this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_OutsidePperiod")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcDate_From"));
                return false;
            }
            if (this.getParent().isAutomaticUpdateJP() && this.isAutomaticUpdateJP()) {
                if (Util.isEmpty((String)this.getJP_ContractC_AutoUpdatePolicy())) {
                    Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractC_AutoUpdatePolicy")};
                    String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                    this.log.saveError("Error", msg);
                    return false;
                }
                if (!this.getJP_ContractProcStatus().equals("IN") && !this.getJP_ContractProcStatus().equals("--") && (this.getJP_ContractC_AutoUpdatePolicy().equals("RE") ? !this.getDocStatus().equals("CL") && !this.getDocStatus().equals("RE") && !this.getDocStatus().equals("VO") && this.isRenewedContractContentJP() : this.getJP_ContractC_AutoUpdatePolicy().equals("EX") && !this.getDocStatus().equals("CL") && !this.getDocStatus().equals("RE") && this.getDocStatus().equals("VO"))) {
                    // empty if block
                }
            } else {
                if (!this.getParent().isAutomaticUpdateJP() && this.isAutomaticUpdateJP()) {
                    this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_IsAutomaticUpdateJP_UpdateError"));
                    return false;
                }
                if (!this.isAutomaticUpdateJP()) {
                    this.setJP_ContractC_AutoUpdatePolicy(null);
                }
            }
            if (!newRecord && this.getParent().getJP_ContractPeriodDate_To() != null) {
                if (this.getJP_ContractProcDate_To() == null) {
                    this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory_JP_ContractProcDate_To"));
                    return false;
                }
                if (this.getJP_ContractProcDate_To().compareTo(this.getParent().getJP_ContractPeriodDate_To()) > 0) {
                    this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_OutsidePperiod")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcDate_To"));
                    return false;
                }
            }
        } else {
            this.setJP_ContractProcDate_From(null);
            this.setJP_ContractProcDate_To(null);
        }
        if (newRecord) {
            MContractProcess contractProcess;
            if (!(this.getJP_ContractProcess_ID() == 0 || (contractProcess = MContractProcess.get(this.getCtx(), this.getJP_ContractProcess_ID())).getDocBaseType().equals(this.getDocBaseType()) && contractProcess.isCreateBaseDocJP())) {
                this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcess_ID") + " and  " + Msg.getElement((Properties)this.getCtx(), (String)"DocBaseType"));
                return false;
            }
        } else if (this.getParent().getJP_ContractType().equals("PDC")) {
            MContractProcess contractProcess;
            if (this.getJP_ContractProcess_ID() == 0) {
                Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcess_ID")};
                String msg = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfPeriodContract")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                this.log.saveError("Error", msg);
                return false;
            }
            if (!(!this.is_ValueChanged("JP_ContractProcess_ID") || (contractProcess = MContractProcess.get(this.getCtx(), this.getJP_ContractProcess_ID())).getDocBaseType().equals(this.getDocBaseType()) && contractProcess.isCreateBaseDocJP())) {
                this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcess_ID") + " and  " + Msg.getElement((Properties)this.getCtx(), (String)"DocBaseType"));
                return false;
            }
        } else {
            this.setJP_ContractProcess_ID(0);
        }
        if ((newRecord || this.is_ValueChanged("DocBaseType") || this.is_ValueChanged("JP_CreateDerivativeDocPolicy") || this.is_ValueChanged("JP_Contract_Acct_ID") || this.is_ValueChanged("JP_BaseDocDocType_ID")) && (JP_Contract_Acct_ID = this.getJP_Contract_Acct_ID()) > 0 && (acctInfo = MContractAcct.get(this.getCtx(), JP_Contract_Acct_ID)).isPostingContractAcctJP() && acctInfo.isPostingRecognitionDocJP() && acctInfo.getJP_RecogToInvoicePolicy() != null && !acctInfo.getJP_RecogToInvoicePolicy().equals("NO")) {
            MDocType shipDoc;
            if (!this.getDocBaseType().equals("SOO") && !this.getDocBaseType().equals("POO")) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_RecogToInvoice_SOOorPOO"));
                return false;
            }
            if (!this.getJP_BaseDocDocType().getDocSubTypeSO().equals("SO") && !this.getJP_BaseDocDocType().getDocSubTypeSO().equals("WP")) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_RecogToInvoice_SOorWP"));
                return false;
            }
            if (this.getJP_BaseDocDocType().getC_DocTypeShipment_ID() > 0 && (shipDoc = MDocType.get((Properties)this.getCtx(), (int)this.getJP_BaseDocDocType().getC_DocTypeShipment_ID())).get_ValueAsBoolean("IsCreateInvoiceJP")) {
                String msg1 = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_ToBeConfirmed")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"C_DocTypeShipment_ID");
                String msg2 = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_RecogToInvoicePolicy"), Msg.getElement((Properties)Env.getCtx(), (String)"IsCreateInvoiceJP")});
                this.log.saveError("Error", String.valueOf(msg1) + " : " + msg2);
                return false;
            }
            if (this.getParent().getJP_ContractType().equals("PDC") && this.getJP_CreateDerivativeDocPolicy() != null && !this.getJP_CreateDerivativeDocPolicy().equals("MA") && !this.getJP_CreateDerivativeDocPolicy().equals("IO")) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_RecogToInvoice_MAorIO"));
                return false;
            }
        }
        if (this.getParent().getJP_ContractType().equals("PDC") && (newRecord || this.is_ValueChanged("JP_ContractProcessMethod") || this.is_ValueChanged("C_DocType_ID"))) {
            String JP_ContractProcessMethod = this.getJP_ContractProcessMethod();
            if (JP_ContractProcessMethod == null) {
                Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcessMethod")};
                this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs));
                return false;
            }
            if (!this.getJP_ContractProcStatus().endsWith("UN") && (newRecord || this.is_ValueChanged("JP_ContractProcessMethod"))) {
                Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcessMethod")};
                this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CannotChangeField", (Object[])objs)) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcStatus"));
                return false;
            }
            if (this.isScheduleCreatedJP() && (newRecord || this.is_ValueChanged("JP_ContractProcessMethod"))) {
                Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcessMethod")};
                this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CannotChangeField", (Object[])objs)) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"IsScheduleCreatedJP"));
                return false;
            }
            if (JP_ContractProcessMethod.equals("IC")) {
                if (this.getJP_ContractProcDate_To() == null) {
                    String msg1 = Msg.getMsg((Properties)this.getCtx(), (String)"JP_InCaseOfIndirectContractProcess");
                    Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcDate_To")};
                    this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs));
                    String msg2 = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                    this.log.saveError("Error", String.valueOf(msg1) + msg2);
                    return false;
                }
                MDocType contractPSDocType = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
                Object obj_ContractPSDocType_ID = contractPSDocType.get_Value("JP_ContractPSDocType_ID");
                if (obj_ContractPSDocType_ID == null) {
                    String msg0 = Msg.getElement((Properties)this.getCtx(), (String)"C_DocType_ID");
                    String msg1 = Msg.getMsg((Properties)this.getCtx(), (String)"JP_InCaseOfIndirectContractProcess");
                    Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractPSDocType_ID")};
                    String msg2 = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                    this.log.saveError("Error", String.valueOf(msg0) + ":" + msg1 + msg2);
                    return false;
                }
            }
        }
        if (!this.getParent().getJP_ContractType().equals("PDC") && (newRecord || this.is_ValueChanged("JP_ContractProcessMethod"))) {
            this.setJP_ContractProcessMethod(null);
        }
        if (!this.getParent().isAutomaticUpdateJP() && this.isAutomaticUpdateJP()) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_CheckIsAutomaticUpdateJP"));
            return false;
        }
        if (this.isAutomaticUpdateJP() && this.getParent().getJP_ContractType().equals("PDC")) {
            if (Util.isEmpty((String)this.getJP_ContractC_AutoUpdatePolicy())) {
                Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractC_AutoUpdatePolicy")};
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_Mandatory", (Object[])objs));
                return false;
            }
            if (this.getJP_ContractProcessMethod().equals("IC") && this.getJP_ContractC_AutoUpdatePolicy().equals("EX")) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_CanNotSelect_ExtendContractProcessDate"));
                return false;
            }
        } else {
            this.setIsAutomaticUpdateJP(false);
            this.setJP_ContractC_AutoUpdatePolicy(null);
        }
        if ((newRecord || this.is_ValueChanged("M_PriceList_ID") || this.is_ValueChanged("IsSOTrx")) && (pricelist = MPriceList.get((Properties)this.getCtx(), (int)this.getM_PriceList_ID(), (String)this.get_TrxName())).isSOPriceList() != this.isSOTrx()) {
            this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"M_PriceList_ID") + " and  " + Msg.getElement((Properties)this.getCtx(), (String)"IsSOTrx"));
            return false;
        }
        if (this.getJP_CounterContractContent_ID() > 0 && (newRecord || this.is_ValueChanged("JP_CounterContractContent_ID"))) {
            String msg1;
            MContractContent counterContractContent = new MContractContent(this.getCtx(), this.getJP_CounterContractContent_ID(), this.get_TrxName());
            if (this.getJP_ContractProcDate_From() != null && !this.getJP_ContractProcDate_From().equals(counterContractContent.getJP_ContractProcDate_From())) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_CounterContractContent_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcDate_From");
                msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractContent_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcDate_From");
                this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1}));
                return false;
            }
            if (this.getJP_ContractProcDate_To() != null && !this.getJP_ContractProcDate_To().equals(counterContractContent.getJP_ContractProcDate_To())) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_CounterContractContent_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcDate_To");
                msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractContent_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcDate_To");
                this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1}));
                return false;
            }
            if (this.getJP_ContractCalender_ID() != counterContractContent.getJP_ContractCalender_ID()) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_CounterContractContent_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractCalender_ID");
                msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractContent_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractCalender_ID");
                this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1}));
                return false;
            }
        }
        if (this.getJP_ContractCalender_ID() > 0 && this.is_ValueChanged("JP_ContractCalender_ID") && MSysConfig.getBooleanValue((String)"JP_RESTRICTION_OF_CONTRACT_CALENDAR", (boolean)true, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID()) && (cc = new MContractCalender(this.getCtx(), this.getJP_ContractCalender_ID(), this.get_TrxName())).getJP_Contract_ID() != 0 && cc.getJP_Contract_ID() != this.getJP_Contract_ID()) {
            this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_RestrictionErrorOfContractCalendar")) + " - " + cc.getName());
            return false;
        }
        this.updateContractProcStatus("--", newRecord);
        if (!newRecord && (this.is_ValueChanged("M_PriceList_ID") || this.is_ValueChanged("DateInvoiced")) && (cnt = DB.getSQLValueEx((String)this.get_TrxName(), (String)"SELECT COUNT(*) FROM JP_ContractLine WHERE JP_ContractContent_ID=? AND M_Product_ID>0", (Object[])new Object[]{this.getJP_ContractContent_ID()})) > 0) {
            if (this.is_ValueChanged("M_PriceList_ID")) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"CannotChangePlIn"));
                return false;
            }
            if (this.is_ValueChanged("DateInvoiced")) {
                MPriceList pList = MPriceList.get((Properties)this.getCtx(), (int)this.getM_PriceList_ID(), null);
                MPriceListVersion plOld = pList.getPriceListVersion((Timestamp)this.get_ValueOld("DateInvoiced"));
                MPriceListVersion plNew = pList.getPriceListVersion((Timestamp)this.get_Value("DateInvoiced"));
                if (plNew == null || !plNew.equals((Object)plOld)) {
                    this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"CannotChangeDateInvoiced"));
                    return false;
                }
            }
        }
        if (newRecord || this.is_ValueChanged("M_PriceList_ID")) {
            this.setM_PriceList_ID(this.getM_PriceList_ID());
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        MContractLine[] lines;
        if (this.is_ValueChanged("AD_Org_ID") || this.is_ValueChanged("C_BPartner_ID") || this.is_ValueChanged("C_BPartner_Location_ID") || this.is_ValueChanged("DateOrdered") || this.is_ValueChanged("DatePromised") || this.is_ValueChanged("M_Warehouse_ID") || this.is_ValueChanged("M_Shipper_ID") || this.is_ValueChanged("C_Currency_ID")) {
            MContractLine[] mContractLineArray = lines = this.getLines();
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                MContractLine line = mContractLineArray[n2];
                if (this.is_ValueChanged("AD_Org_ID")) {
                    line.setAD_Org_ID(this.getAD_Org_ID());
                }
                if (this.is_ValueChanged("C_BPartner_ID")) {
                    line.setC_BPartner_ID(this.getC_BPartner_ID());
                }
                if (this.is_ValueChanged("C_BPartner_Location_ID")) {
                    line.setC_BPartner_Location_ID(this.getC_BPartner_Location_ID());
                }
                if (this.is_ValueChanged("DateOrdered")) {
                    line.setDateOrdered(this.getDateOrdered());
                }
                if (this.is_ValueChanged("DatePromised")) {
                    line.setDatePromised(this.getDatePromised());
                }
                line.saveEx(this.get_TrxName());
                ++n2;
            }
        }
        if (!newRecord && this.is_ValueChanged("JP_CounterContractContent_ID")) {
            lines = this.getLines();
            int i = 0;
            while (i < lines.length) {
                lines[i].setJP_CounterContractLine_ID(0);
                lines[i].saveEx(this.get_TrxName());
                ++i;
            }
        }
        return true;
    }

    public MContract getParent() {
        if (this.parent == null) {
            this.parent = new MContract(this.getCtx(), this.getJP_Contract_ID(), this.get_TrxName());
        }
        return this.parent;
    }

    public void setParent(MContract contract) {
        this.parent = contract;
    }

    public MContractLine[] getLines(String whereClause, String orderClause) {
        StringBuilder whereClauseFinal = new StringBuilder("JP_ContractContent_ID=? ");
        if (!Util.isEmpty((String)whereClause, (boolean)true)) {
            whereClauseFinal.append(whereClause);
        }
        if (orderClause.length() == 0) {
            orderClause = "Line";
        }
        List list = new Query(this.getCtx(), "JP_ContractLine", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).setOrderBy(orderClause).list();
        return list.toArray(new MContractLine[list.size()]);
    }

    public MContractLine[] getLines(boolean requery, String orderBy) {
        if (this.m_lines != null && !requery) {
            MContractContent.set_TrxName((PO[])this.m_lines, (String)this.get_TrxName());
            return this.m_lines;
        }
        String orderClause = "";
        orderClause = orderBy != null && orderBy.length() > 0 ? String.valueOf(orderClause) + orderBy : String.valueOf(orderClause) + "Line";
        this.m_lines = this.getLines(null, orderClause);
        return this.m_lines;
    }

    public MContractLine[] getLines() {
        return this.getLines(false, null);
    }

    public MContractProcSchedule[] getContractProcSchedules(String whereClause, String orderClause) {
        StringBuilder whereClauseFinal = new StringBuilder("JP_ContractContent_ID=? ");
        if (!Util.isEmpty((String)whereClause, (boolean)true)) {
            whereClauseFinal.append(whereClause);
        }
        if (orderClause.length() == 0) {
            orderClause = "DocumentNo";
        }
        List list = new Query(this.getCtx(), "JP_ContractProcSchedule", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).setOrderBy(orderClause).list();
        return list.toArray(new MContractProcSchedule[list.size()]);
    }

    public MContractProcSchedule[] getContractProcSchedules(boolean requery, String orderBy) {
        if (this.m_schedules != null && !requery) {
            MContractContent.set_TrxName((PO[])this.m_schedules, (String)this.get_TrxName());
            return this.m_schedules;
        }
        String orderClause = "";
        orderClause = orderBy != null && orderBy.length() > 0 ? String.valueOf(orderClause) + orderBy : String.valueOf(orderClause) + "DocumentNo";
        this.m_schedules = this.getContractProcSchedules(null, orderClause);
        return this.m_schedules;
    }

    public MContractProcSchedule[] getContractProcSchedules() {
        return this.getContractProcSchedules(false, null);
    }

    public static MContractContent get(Properties ctx, int JP_ContractContent_ID) {
        Integer ii = JP_ContractContent_ID;
        MContractContent retValue = (MContractContent)s_cache.get((Object)ii);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MContractContent(ctx, JP_ContractContent_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)JP_ContractContent_ID, (Object)retValue);
        }
        return retValue;
    }

    public MContractProcSchedule[] getContractProcScheduleByContractPeriod(Properties ctx, int JP_ContractProcPeriod_ID, String trxName) {
        ArrayList<MContractProcSchedule> list;
        block6: {
            list = new ArrayList<MContractProcSchedule>();
            String sql = "SELECT * FROM JP_ContractProcSchedule WHERE JP_ContractContent_ID=? AND JP_ContractProcPeriod_ID=? AND DocStatus NOT IN ('VO','RE')";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)"SELECT * FROM JP_ContractProcSchedule WHERE JP_ContractContent_ID=? AND JP_ContractProcPeriod_ID=? AND DocStatus NOT IN ('VO','RE')", (String)trxName);
                    pstmt.setInt(1, this.get_ID());
                    pstmt.setInt(2, JP_ContractProcPeriod_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MContractProcSchedule(this.getCtx(), rs, trxName));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "SELECT * FROM JP_ContractProcSchedule WHERE JP_ContractContent_ID=? AND JP_ContractProcPeriod_ID=? AND DocStatus NOT IN ('VO','RE')", (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        MContractProcSchedule[] contractProcSchedules = new MContractProcSchedule[list.size()];
        list.toArray(contractProcSchedules);
        return contractProcSchedules;
    }

    public MOrder[] getOrderByContractPeriod(Properties ctx, int JP_ContractProcPeriod_ID, String trxName) {
        ArrayList<MOrder> list;
        block6: {
            list = new ArrayList<MOrder>();
            String sql = "SELECT * FROM C_Order WHERE JP_ContractContent_ID=? AND JP_ContractProcPeriod_ID=? AND DocStatus NOT IN ('VO','RE')";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)"SELECT * FROM C_Order WHERE JP_ContractContent_ID=? AND JP_ContractProcPeriod_ID=? AND DocStatus NOT IN ('VO','RE')", (String)trxName);
                    pstmt.setInt(1, this.get_ID());
                    pstmt.setInt(2, JP_ContractProcPeriod_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MOrder(this.getCtx(), rs, trxName));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "SELECT * FROM C_Order WHERE JP_ContractContent_ID=? AND JP_ContractProcPeriod_ID=? AND DocStatus NOT IN ('VO','RE')", (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        MOrder[] orderes = new MOrder[list.size()];
        list.toArray(orderes);
        return orderes;
    }

    public MInvoice[] getInvoiceByContractPeriod(Properties ctx, int JP_ContractProcPeriod_ID, String trxName) {
        ArrayList<MInvoice> list;
        block6: {
            list = new ArrayList<MInvoice>();
            String sql = "SELECT * FROM C_Invoice WHERE JP_ContractContent_ID=? AND JP_ContractProcPeriod_ID=? AND DocStatus NOT IN ('VO','RE')";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)"SELECT * FROM C_Invoice WHERE JP_ContractContent_ID=? AND JP_ContractProcPeriod_ID=? AND DocStatus NOT IN ('VO','RE')", (String)trxName);
                    pstmt.setInt(1, this.get_ID());
                    pstmt.setInt(2, JP_ContractProcPeriod_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MInvoice(this.getCtx(), rs, trxName));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "SELECT * FROM C_Invoice WHERE JP_ContractContent_ID=? AND JP_ContractProcPeriod_ID=? AND DocStatus NOT IN ('VO','RE')", (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        MInvoice[] invoices = new MInvoice[list.size()];
        list.toArray(invoices);
        return invoices;
    }

    public MInOut[] getInOutByContractPeriod(Properties ctx, int JP_ContractProcPeriod_ID, String trxName) {
        ArrayList<MInOut> list;
        block6: {
            list = new ArrayList<MInOut>();
            String sql = "SELECT * FROM M_InOut WHERE JP_ContractContent_ID=? AND JP_ContractProcPeriod_ID=? AND DocStatus NOT IN ('VO','RE')";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)"SELECT * FROM M_InOut WHERE JP_ContractContent_ID=? AND JP_ContractProcPeriod_ID=? AND DocStatus NOT IN ('VO','RE')", (String)trxName);
                    pstmt.setInt(1, this.get_ID());
                    pstmt.setInt(2, JP_ContractProcPeriod_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MInOut(this.getCtx(), rs, trxName));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "SELECT * FROM M_InOut WHERE JP_ContractContent_ID=? AND JP_ContractProcPeriod_ID=? AND DocStatus NOT IN ('VO','RE')", (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        MInOut[] inOuts = new MInOut[list.size()];
        list.toArray(inOuts);
        return inOuts;
    }

    public MRecognition[] getRecognitionByContractPeriod(Properties ctx, int JP_ContractProcPeriod_ID, String trxName) {
        ArrayList<MRecognition> list;
        block6: {
            list = new ArrayList<MRecognition>();
            String sql = "SELECT * FROM JP_Recognition WHERE JP_ContractContent_ID=? AND JP_ContractProcPeriod_ID=? AND DocStatus NOT IN ('VO','RE')";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)"SELECT * FROM JP_Recognition WHERE JP_ContractContent_ID=? AND JP_ContractProcPeriod_ID=? AND DocStatus NOT IN ('VO','RE')", (String)trxName);
                    pstmt.setInt(1, this.get_ID());
                    pstmt.setInt(2, JP_ContractProcPeriod_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MRecognition(this.getCtx(), rs, trxName));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "SELECT * FROM JP_Recognition WHERE JP_ContractContent_ID=? AND JP_ContractProcPeriod_ID=? AND DocStatus NOT IN ('VO','RE')", (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        MRecognition[] recog = new MRecognition[list.size()];
        list.toArray(recog);
        return recog;
    }

    public MContractProcess[] getContractProcessDerivativeInOutByCalender(int JP_ContractCalender_ID) {
        ArrayList<MContractProcess> list;
        block6: {
            list = new ArrayList<MContractProcess>();
            String sql = "SELECT DISTINCT JP_ContractProcess_InOut_ID FROM JP_ContractLine WHERE JP_ContractContent_ID=? AND JP_ContractCalender_InOut_ID = ?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)"SELECT DISTINCT JP_ContractProcess_InOut_ID FROM JP_ContractLine WHERE JP_ContractContent_ID=? AND JP_ContractCalender_InOut_ID = ?", (String)this.get_TrxName());
                    pstmt.setInt(1, this.get_ID());
                    pstmt.setInt(2, JP_ContractCalender_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(MContractProcess.get(this.getCtx(), rs.getInt(1)));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "SELECT DISTINCT JP_ContractProcess_InOut_ID FROM JP_ContractLine WHERE JP_ContractContent_ID=? AND JP_ContractCalender_InOut_ID = ?", (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        MContractProcess[] processes = new MContractProcess[list.size()];
        list.toArray(processes);
        return processes;
    }

    public MContractProcess[] getContractProcessDerivativeInvoiceByCalender(int JP_ContractCalender_ID) {
        ArrayList<MContractProcess> list;
        block6: {
            list = new ArrayList<MContractProcess>();
            String sql = "SELECT DISTINCT JP_ContractProcess_Inv_ID FROM JP_ContractLine WHERE JP_ContractContent_ID=? AND JP_ContractCalender_Inv_ID = ?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)"SELECT DISTINCT JP_ContractProcess_Inv_ID FROM JP_ContractLine WHERE JP_ContractContent_ID=? AND JP_ContractCalender_Inv_ID = ?", (String)this.get_TrxName());
                    pstmt.setInt(1, this.get_ID());
                    pstmt.setInt(2, JP_ContractCalender_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(MContractProcess.get(this.getCtx(), rs.getInt(1)));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "SELECT DISTINCT JP_ContractProcess_Inv_ID FROM JP_ContractLine WHERE JP_ContractContent_ID=? AND JP_ContractCalender_Inv_ID = ?", (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        MContractProcess[] processes = new MContractProcess[list.size()];
        list.toArray(processes);
        return processes;
    }

    public int getPrecision() {
        return MCurrency.getStdPrecision((Properties)this.getCtx(), (int)this.getC_Currency_ID());
    }

    public String updateContractProcStatus(String docAction, boolean newRecord) {
        if (this.getDocStatus().equals("CL") || this.getDocStatus().equals("VO")) {
            return this.getJP_ContractProcStatus();
        }
        if (Util.isEmpty((String)docAction)) {
            docAction = "--";
        }
        if (this.getParent().getJP_ContractType().equals("PDC")) {
            if (docAction.equals("--")) {
                if (newRecord) {
                    this.setJP_ContractProcStatus("UN");
                } else {
                    Timestamp now = new Timestamp(System.currentTimeMillis());
                    Timestamp yesterday = Timestamp.valueOf(now.toLocalDateTime().minusDays(1L));
                    if (this.getJP_ContractProcDate_To() != null && yesterday.compareTo(this.getJP_ContractProcDate_To()) > 0 && this.getDocStatus().equals("CO")) {
                        this.setJP_ContractProcStatus("PD");
                    }
                }
            } else if (docAction.equals("RE")) {
                if (this.getJP_ContractProcStatus().equals("IP")) {
                    this.setJP_ContractProcStatus("SD");
                }
            } else if (docAction.equals("CL")) {
                this.setJP_ContractProcStatus("PD");
            } else if (docAction.equals("VO")) {
                this.setJP_ContractProcStatus("IN");
            } else if (docAction.equals("CO")) {
                if (this.getJP_ContractProcStatus().equals("SD")) {
                    this.setJP_ContractProcStatus("IP");
                }
                Timestamp now = new Timestamp(System.currentTimeMillis());
                Timestamp yesterday = Timestamp.valueOf(now.toLocalDateTime().minusDays(1L));
                if (this.getJP_ContractProcDate_To() != null && yesterday.compareTo(this.getJP_ContractProcDate_To()) > 0) {
                    this.setJP_ContractProcStatus("PD");
                }
            }
        } else {
            this.setJP_ContractProcStatus("--");
        }
        return this.getJP_ContractProcStatus();
    }

    public String checkJP_ContractProcDate_To() {
        if (!this.getParent().getJP_ContractType().equals("PDC")) {
            return "";
        }
        Timestamp JP_ContractPeriodDate_To = this.getParent().getJP_ContractPeriodDate_To();
        if (JP_ContractPeriodDate_To == null) {
            return "";
        }
        if (this.getJP_ContractProcDate_To() == null) {
            return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory_JP_ContractProcDate_To");
        }
        if (this.getJP_ContractProcStatus().equals("IN") || this.getJP_ContractProcStatus().equals("--")) {
            return "";
        }
        if (this.getDocStatus().equals("CL") || this.getDocStatus().equals("RE") || this.getDocStatus().equals("VO")) {
            return "";
        }
        if (this.getParent().isAutomaticUpdateJP()) {
            if (this.isAutomaticUpdateJP()) {
                if (this.isRenewedContractContentJP()) {
                    return "";
                }
                if (this.getJP_ContractProcDate_To().compareTo(JP_ContractPeriodDate_To) != 0) {
                    String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_Contract_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractPeriodDate_To");
                    String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractContent_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcDate_To");
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1});
                }
            } else if (this.getJP_ContractProcDate_To().compareTo(JP_ContractPeriodDate_To) > 0) {
                return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_OutsidePperiod")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcDate_To");
            }
        } else if (this.getJP_ContractProcDate_To().compareTo(JP_ContractPeriodDate_To) > 0) {
            return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_OutsidePperiod")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcDate_To");
        }
        return "";
    }

    public static MContractContent[] getContractContentByEstimation(Properties ctx, int JP_Contract_ID, int JP_Estimation_ID, String trxName) {
        StringBuilder whereClauseFinal = new StringBuilder("JP_Contract_ID=? AND JP_Estimation_ID=? ");
        StringBuilder orderClause = new StringBuilder("JP_ContractContent_ID");
        List list = new Query(ctx, "JP_ContractContent", whereClauseFinal.toString(), trxName).setParameters(new Object[]{JP_Contract_ID, JP_Estimation_ID}).setOrderBy(orderClause.toString()).list();
        return list.toArray(new MContractContent[list.size()]);
    }

    public MContractContentTax[] getTaxes(boolean requery) {
        if (this.m_taxes != null && !requery) {
            return this.m_taxes;
        }
        List list = new Query(this.getCtx(), "JP_ContractContentTax", "JP_ContractContent_ID=?", this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).list();
        this.m_taxes = list.toArray(new MContractContentTax[list.size()]);
        return this.m_taxes;
    }

    @Override
    public void setM_PriceList_ID(int M_PriceList_ID) {
        MPriceList pl = MPriceList.get((Properties)this.getCtx(), (int)M_PriceList_ID, null);
        if (pl != null) {
            this.setC_Currency_ID(pl.getC_Currency_ID());
            this.setIsTaxIncluded(pl.isTaxIncluded());
            super.setM_PriceList_ID(M_PriceList_ID);
        }
    }
}

