/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MContractCancelTerm;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MContractLine;
import jpiere.base.plugin.org.adempiere.model.MContractT;
import jpiere.base.plugin.org.adempiere.model.MEstimation;
import jpiere.base.plugin.org.adempiere.model.X_JP_Contract;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MOrg;
import org.compiere.model.MPeriod;
import org.compiere.model.MQuery;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.PrintInfo;
import org.compiere.model.Query;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MContract
extends X_JP_Contract
implements DocAction,
DocOptions {
    private static final long serialVersionUID = -7588955558162632796L;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private MContractContent[] m_ContractContents = null;
    private static CCache<Integer, MContract> s_cache = new CCache("JP_Contract", 20);

    public MContract(Properties ctx, int JP_Contract_ID, String trxName) {
        super(ctx, JP_Contract_ID, trxName);
    }

    public MContract(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)0);
        return String.valueOf(dt.getNameTrl()) + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(String.valueOf(this.get_TableName()) + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        int m_docid = this.getJP_Contract_ID();
        MQuery query = new MQuery("JP_Contract");
        query.addRestriction("JP_Contract_ID", "=", (Object)m_docid);
        int AD_PrintFormat_ID = this.getC_DocType().getAD_PrintFormat_ID();
        if (AD_PrintFormat_ID == 0) {
            return null;
        }
        MPrintFormat pf = new MPrintFormat(this.getCtx(), AD_PrintFormat_ID, this.get_TrxName());
        PrintInfo info = new PrintInfo("0", 0, 0, 0);
        ReportEngine re = new ReportEngine(this.getCtx(), pf, query, info);
        if (pf.getJasperProcess_ID() > 0) {
            ProcessInfo pi = new ProcessInfo("", pf.getJasperProcess_ID());
            pi.setRecord_ID(this.getJP_Contract_ID());
            pi.setIsBatch(true);
            ServerProcessCtl.process((ProcessInfo)pi, null);
            return pi.getPDFReport();
        }
        return re.getPDF(file);
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("unlockIt - " + this.toString());
        }
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("invalidateIt - " + this.toString());
        }
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        MContractContent[] contents;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (!MPeriod.isOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (String)dt.getDocBaseType(), (int)this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        if (this.getJP_ContractType().equals("PDC")) {
            MContractContent[] contents2 = this.getContractContents();
            if (contents2.length == 0) {
                this.m_processMsg = "@NoLines@";
                return "IN";
            }
            int i = 0;
            while (i < contents2.length) {
                MContractLine[] lines = contents2[i].getLines();
                if (lines.length == 0) {
                    if (!(contents2[i].getDocStatus().equals("CL") || contents2[i].getDocStatus().equals("RE") || contents2[i].getDocStatus().equals("VO"))) {
                        this.m_processMsg = String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractContent_ID")) + " - " + Msg.getElement((Properties)this.getCtx(), (String)"DocumentNo") + " - " + contents2[i].getDocumentNo() + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"NoLines");
                        return "IN";
                    }
                } else {
                    String msg = contents2[i].checkJP_ContractProcDate_To();
                    if (!Util.isEmpty((String)msg)) {
                        this.m_processMsg = String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractContent_ID")) + " - " + Msg.getElement((Properties)this.getCtx(), (String)"DocumentNo") + " - " + contents2[i].getDocumentNo() + " - " + msg;
                        return "IN";
                    }
                }
                ++i;
            }
        } else if (this.getJP_ContractType().equals("STC") && (contents = this.getContractContents()).length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("approveIt - " + this.toString());
        }
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("rejectIt - " + this.toString());
        }
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String valid;
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.setDefiniteDocumentNo();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        if ((valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9)) != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        this.updateContractStatus("CO");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateAcct(new Timestamp(System.currentTimeMillis()));
            MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (int)this.getC_DocType_ID(), (int)this.getAD_Org_ID());
        }
        if (dt.isOverwriteSeqOnComplete()) {
            String value = null;
            int index = this.p_info.getColumnIndex("C_DocType_ID");
            if (index != -1) {
                value = DB.getDocumentNo((int)this.get_ValueAsInt(index), (String)this.get_TrxName(), (boolean)true);
            }
            if (value != null) {
                this.setDocumentNo(value);
            }
        }
    }

    public boolean voidIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        MFactAcct.deleteEx((int)MEstimation.Table_ID, (int)this.getJP_Contract_ID(), (String)this.get_TrxName());
        this.setPosted(true);
        MContractContent[] contents = this.getContractContents();
        int i = 0;
        while (i < contents.length) {
            boolean isOK = contents[i].processIt("VO");
            if (isOK) {
                contents[i].saveEx(this.get_TrxName());
            }
            ++i;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.updateContractStatus("VO");
        this.setDocAction("--");
        return true;
    }

    public boolean closeIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("closeIt - " + this.toString());
        }
        MContractContent[] contents = this.getContractContents();
        int i = 0;
        while (i < contents.length) {
            boolean isOK = contents[i].processIt("CL");
            if (isOK) {
                contents[i].saveEx(this.get_TrxName());
            }
            ++i;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.updateContractStatus("CL");
        return true;
    }

    public boolean reverseCorrectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("reverseCorrectIt - " + this.toString());
        }
        return false;
    }

    public boolean reverseAccrualIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("reverseAccrualIt - " + this.toString());
        }
        return false;
    }

    public boolean reActivateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        MFactAcct.deleteEx((int)Table_ID, (int)this.getJP_Contract_ID(), (String)this.get_TrxName());
        this.setPosted(false);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    public String getSummary() {
        return this.getDocumentNo();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    public BigDecimal getApprovalAmt() {
        return this.getJP_ContractDocAmt();
    }

    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (docStatus.equals("CO")) {
            index = 0;
            options[index++] = "CL";
            options[index++] = "VO";
            options[index++] = "RE";
            return index;
        }
        if (docStatus.equals("DR")) {
            index = 0;
            options[index++] = "PR";
            options[index++] = "VO";
            options[index++] = "CO";
            return index;
        }
        return index;
    }

    protected boolean beforeSave(boolean newRecord) {
        MContractT contractTemplate;
        if ((newRecord || this.is_ValueChanged("JP_ContractType") || this.is_ValueChanged("JP_ContractCategory_ID") || this.is_ValueChanged("JP_ContractT_ID")) && (!(contractTemplate = MContractT.get(this.getCtx(), this.getJP_ContractT_ID())).getJP_ContractType().equals(this.getJP_ContractType()) || contractTemplate.getJP_ContractCategory_ID() != this.getJP_ContractCategory_ID() || contractTemplate.getJP_ContractT_ID() != this.getJP_ContractT_ID())) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_DifferentContractTypeOrCategory"));
            return false;
        }
        if ((newRecord || this.is_ValueChanged("JP_ContractPeriodDate_To")) && this.getJP_ContractPeriodDate_To() != null) {
            if (this.getJP_ContractPeriodDate_From().compareTo(this.getJP_ContractPeriodDate_To()) > 0) {
                this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractPeriodDate_To"));
                return false;
            }
            if (this.getJP_ContractCancelDate() != null && !this.is_ValueChanged("JP_ContractCancelDate") && this.getJP_ContractCancelDate().compareTo(this.getJP_ContractPeriodDate_To()) != 0) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_ContractPeriodDate_To_UpdateError"));
                return false;
            }
        }
        if (this.getJP_ContractCancelDate() != null && newRecord || this.getJP_ContractCancelDate() != null && this.is_ValueChanged("JP_ContractCancelDate")) {
            if (this.getJP_ContractPeriodDate_To() == null) {
                this.setJP_ContractPeriodDate_To(this.getJP_ContractCancelDate());
            } else {
                if (this.getJP_ContractCancelDate().compareTo(this.getJP_ContractPeriodDate_To()) < 0) {
                    this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getMsg((Properties)this.getCtx(), (String)"JP_ContractCancelDate_UpdateError"));
                    return false;
                }
                if (this.getJP_ContractCancelDate().compareTo(this.getJP_ContractPeriodDate_To()) != 0) {
                    this.getJP_ContractCancelDate().compareTo(this.getJP_ContractPeriodDate_To());
                }
            }
        }
        if (this.isAutomaticUpdateJP()) {
            if (this.getJP_ContractPeriodDate_To() == null) {
                this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractPeriodDate_To"));
            }
            if (this.getJP_ContractCancelTerm_ID() == 0) {
                this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractCancelTerm_ID"));
            }
            if (this.getJP_ContractExtendPeriod_ID() == 0) {
                this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractExtendPeriod_ID"));
            }
            if (newRecord || this.getJP_ContractCancelDate() == null && this.is_ValueChanged("JP_ContractPeriodDate_To") || this.getJP_ContractCancelDeadline() == null) {
                MContractCancelTerm m_ContractCancelTerm = MContractCancelTerm.get(this.getCtx(), this.getJP_ContractCancelTerm_ID());
                this.setJP_ContractCancelDeadline(m_ContractCancelTerm.calculateCancelDeadLine(this.getJP_ContractPeriodDate_To()));
            }
        } else {
            this.setJP_ContractExtendPeriod_ID(0);
            this.setJP_ContractCancelDeadline(null);
        }
        if (this.is_ValueChanged("IsAutomaticUpdateJP") && !this.isAutomaticUpdateJP()) {
            MContractContent[] contents = this.getContractContents();
            int i = 0;
            while (i < contents.length) {
                if (contents[i].isAutomaticUpdateJP()) {
                    this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_ContractHasAutoRenewContractContent")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"DocumentNo") + "  " + contents[i].getDocumentNo());
                    return false;
                }
                ++i;
            }
        }
        if (this.getJP_CounterContract_ID() > 0 && (newRecord || this.is_ValueChanged("JP_CounterContract_ID"))) {
            MContract counterContract = new MContract(this.getCtx(), this.getJP_CounterContract_ID(), this.get_TrxName());
            MOrg contractOrg = MOrg.get((Properties)this.getCtx(), (int)this.getAD_Org_ID());
            int counter_C_BPartner_ID = contractOrg.getLinkedC_BPartner_ID(this.get_TrxName());
            if (counterContract.getC_BPartner_ID() != counter_C_BPartner_ID) {
                this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)Env.getCtx(), (String)"JP_CounterContract_ID"));
                return false;
            }
            MOrg counterOrg = MOrg.get((Properties)this.getCtx(), (int)counterContract.getAD_Org_ID());
            int contract_C_BPartner_ID = counterOrg.getLinkedC_BPartner_ID(this.get_TrxName());
            if (this.getC_BPartner_ID() != contract_C_BPartner_ID) {
                this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)Env.getCtx(), (String)"JP_CounterContract_ID"));
                return false;
            }
            if (!this.getJP_ContractType().equals(counterContract.getJP_ContractType())) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_CounterContract_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractType");
                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_Counter_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractType");
                this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1}));
                return false;
            }
            if (!this.getJP_ContractPeriodDate_From().equals(counterContract.getJP_ContractPeriodDate_From())) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_CounterContract_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractPeriodDate_From");
                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_Counter_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractPeriodDate_From");
                this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1}));
                return false;
            }
            if (this.getJP_ContractPeriodDate_To() != null && !this.getJP_ContractPeriodDate_To().equals(counterContract.getJP_ContractPeriodDate_To())) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_CounterContract_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractPeriodDate_To");
                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_Counter_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractPeriodDate_To");
                this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1}));
                return false;
            }
            if (!(this.isAutomaticUpdateJP() && counterContract.isAutomaticUpdateJP() || !this.isAutomaticUpdateJP() && !counterContract.isAutomaticUpdateJP())) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_CounterContract_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"IsAutomaticUpdateJP");
                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_Counter_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"IsAutomaticUpdateJP");
                this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1}));
                return false;
            }
            if (this.getJP_ContractExtendPeriod_ID() != counterContract.getJP_ContractExtendPeriod_ID()) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_CounterContract_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractExtendPeriod_ID");
                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_Counter_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractExtendPeriod_ID");
                this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1}));
                return false;
            }
        }
        this.updateContractStatus("--");
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord && success) {
            return true;
        }
        if (!newRecord && this.is_ValueChanged("JP_CounterContract_ID")) {
            MContractContent[] cc = this.getContractContents();
            int i = 0;
            while (i < cc.length) {
                cc[i].setJP_CounterContractContent_ID(0);
                cc[i].saveEx(this.get_TrxName());
                ++i;
            }
        }
        return true;
    }

    public String updateContractStatus(String docAction) {
        if (this.getDocStatus().equals("CL") || this.getDocStatus().equals("VO")) {
            return this.getJP_ContractStatus();
        }
        if (Util.isEmpty((String)docAction)) {
            docAction = "--";
        }
        if (docAction.equals("CO") || docAction.equals("--") && this.getDocStatus().equals("CO")) {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            if (now.compareTo(this.getJP_ContractPeriodDate_From()) < 0) {
                this.setJP_ContractStatus("PR");
                this.setJP_ContractStatus_UC_Date(null);
                this.setJP_ContractStatus_EC_Date(null);
            } else {
                Timestamp yesterday = Timestamp.valueOf(now.toLocalDateTime().minusDays(1L));
                if (this.getJP_ContractPeriodDate_To() != null && yesterday.compareTo(this.getJP_ContractPeriodDate_To()) > 0) {
                    this.setJP_ContractStatus("EC");
                    this.setJP_ContractStatus_EC_Date(now);
                } else {
                    if (this.getJP_ContractStatus().equals("PR")) {
                        this.setJP_ContractStatus("UC");
                        this.setJP_ContractStatus_UC_Date(now);
                    } else if (this.getJP_ContractStatus().equals("EC")) {
                        this.setJP_ContractStatus("UC");
                    }
                    this.setJP_ContractStatus_EC_Date(null);
                }
            }
        } else if (docAction.equals("CL")) {
            this.setJP_ContractStatus("EC");
            this.setJP_ContractStatus_EC_Date(new Timestamp(System.currentTimeMillis()));
        } else if (docAction.equals("VO")) {
            this.setJP_ContractStatus("IN");
            this.setJP_ContractStatus_IN_Date(new Timestamp(System.currentTimeMillis()));
        }
        return this.getJP_ContractStatus();
    }

    public MContractContent[] getContractContents(String whereClause, String orderClause) {
        StringBuilder whereClauseFinal = new StringBuilder("JP_Contract_ID=? ");
        if (!Util.isEmpty((String)whereClause, (boolean)true)) {
            whereClauseFinal.append(whereClause);
        }
        if (orderClause.length() == 0) {
            orderClause = "JP_ContractContent_ID";
        }
        List list = new Query(this.getCtx(), "JP_ContractContent", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).setOrderBy(orderClause).list();
        return list.toArray(new MContractContent[list.size()]);
    }

    public MContractContent[] getContractContents(boolean requery, String orderBy) {
        if (this.m_ContractContents != null && !requery) {
            MContract.set_TrxName((PO[])this.m_ContractContents, (String)this.get_TrxName());
            return this.m_ContractContents;
        }
        String orderClause = "";
        orderClause = orderBy != null && orderBy.length() > 0 ? String.valueOf(orderClause) + orderBy : String.valueOf(orderClause) + "JP_ContractContent_ID";
        this.m_ContractContents = this.getContractContents(null, orderClause);
        return this.m_ContractContents;
    }

    public MContractContent[] getContractContents() {
        return this.getContractContents(false, null);
    }

    public static MContract get(Properties ctx, int JP_Contract_ID) {
        Integer ii = JP_Contract_ID;
        MContract retValue = (MContract)s_cache.get((Object)ii);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MContract(ctx, JP_Contract_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)JP_Contract_ID, (Object)retValue);
        }
        return retValue;
    }

    public static MContract[] getContractByEstimation(Properties ctx, int JP_Estimation_ID, String trxName) {
        StringBuilder whereClauseFinal = new StringBuilder("JP_Estimation_ID=? ");
        StringBuilder orderClause = new StringBuilder("JP_Estimation_ID");
        List list = new Query(ctx, "JP_Contract", whereClauseFinal.toString(), trxName).setParameters(new Object[]{JP_Estimation_ID}).setOrderBy(orderClause.toString()).list();
        return list.toArray(new MContract[list.size()]);
    }

    @Override
    public String toString() {
        return "DocumentNo[" + this.getDocumentNo() + "]";
    }
}

