/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.X_JP_Charge_History;
import org.compiere.model.MCharge;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MChargeHistory
extends X_JP_Charge_History {
    private static CCache<Integer, MChargeHistory[]> s_cache = new CCache("JP_Charge_History", 100, 10);

    public MChargeHistory(Properties ctx, int JP_Charge_History_ID, String trxName) {
        super(ctx, JP_Charge_History_ID, trxName);
    }

    public MChargeHistory(Properties ctx, int JP_Charge_History_ID, String trxName, String ... virtualColumns) {
        super(ctx, JP_Charge_History_ID, trxName, virtualColumns);
    }

    public MChargeHistory(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getC_Charge_ID() == 0) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"C_Charge_ID = 0"));
            return false;
        }
        if (this.getAD_Client_ID() == 0) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"AD_Client_ID = 0"));
            return false;
        }
        if (newRecord || this.is_ValueChanged("DateFrom") || this.is_ValueChanged("DateTo")) {
            if (this.getDateFrom().compareTo(this.getDateTo()) > 0) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"DateFrom")) + " > " + Msg.getElement((Properties)this.getCtx(), (String)"DateTo"))));
                return false;
            }
            MChargeHistory[] m_Histories = this.getOtherHistories();
            int i = 0;
            while (i < m_Histories.length) {
                if (this.getDateFrom().compareTo(m_Histories[i].getDateTo()) <= 0 && m_Histories[i].getDateFrom().compareTo(this.getDateTo()) <= 0) {
                    this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_OverlapPeriod"));
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private MChargeHistory[] getOtherHistories() {
        ArrayList<MChargeHistory> list;
        MChargeHistory[] m_Histories;
        block6: {
            m_Histories = null;
            list = new ArrayList<MChargeHistory>();
            String sql = "SELECT * FROM JP_Charge_History WHERE C_Charge_ID=? AND JP_Charge_History_ID <> ?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, this.getC_Charge_ID());
                    pstmt.setInt(2, this.getJP_Charge_History_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MChargeHistory(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        m_Histories = new MChargeHistory[list.size()];
        list.toArray(m_Histories);
        return m_Histories;
    }

    public static MChargeHistory[] getHistories(Properties ctx, int C_Charge_ID, String trxName) {
        MChargeHistory[] m_Histories = (MChargeHistory[])s_cache.get((Object)C_Charge_ID);
        if (m_Histories != null) {
            return m_Histories;
        }
        String whereClause = "C_Charge_ID=?";
        List list = new Query(ctx, "JP_Charge_History", "C_Charge_ID=?", trxName).setParameters(new Object[]{C_Charge_ID}).setOrderBy("DateFrom DESC").list();
        m_Histories = new MChargeHistory[list.size()];
        list.toArray(m_Histories);
        s_cache.put((Object)C_Charge_ID, (Object)m_Histories);
        return m_Histories;
    }

    public static MChargeHistory getHistory(Properties ctx, int C_Charge_ID, Timestamp date, String trxName) {
        MChargeHistory m_History = null;
        MChargeHistory[] m_Histories = MChargeHistory.getHistories(ctx, C_Charge_ID, trxName);
        int i = 0;
        while (i < m_Histories.length) {
            if (m_Histories[i].getDateFrom().compareTo(date) <= 0 && m_Histories[i].getDateTo().compareTo(date) >= 0) {
                m_History = m_Histories[i];
                break;
            }
            ++i;
        }
        return m_History;
    }

    public static String getHistoryName(Properties ctx, int C_Charge_ID, Timestamp date, String trxName) {
        MChargeHistory m_History = MChargeHistory.getHistory(ctx, C_Charge_ID, date, trxName);
        if (m_History == null) {
            return MCharge.get((Properties)ctx, (int)C_Charge_ID).getName();
        }
        return m_History.getName();
    }
}

