/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import jpiere.base.plugin.org.adempiere.model.X_JP_BillSchema;
import org.compiere.model.I_C_DocType;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MTax;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MBillSchema
extends X_JP_BillSchema {
    private static CCache<Integer, MBillSchema> s_cache = new CCache("JP_BillSchema", 20);

    public MBillSchema(Properties ctx, int JP_BillSchema_ID, String trxName) {
        super(ctx, JP_BillSchema_ID, trxName);
    }

    public MBillSchema(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        I_C_DocType docType;
        if ((newRecord || this.is_ValueChanged("C_DocType_ID")) && !(docType = this.getC_DocType()).getDocBaseType().equals("JPB") && !docType.getDocBaseType().equals("JPP")) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_DocTypeIncorrect"));
            return false;
        }
        if (this.isTaxRecalculateJP()) {
            MTax tax;
            if (this.getJP_TaxAdjust_DocType_ID() == 0) {
                this.log.saveError("FillMandatory", Msg.getElement((Properties)this.getCtx(), (String)"JP_TaxAdjust_DocType_ID"));
                return false;
            }
            if (newRecord || this.is_ValueChanged("JP_TaxAdjust_DocType_ID")) {
                docType = MDocType.get((int)this.getJP_TaxAdjust_DocType_ID());
                if (!(this.isSOTrx() && (docType.getDocBaseType().equals("ARI") || docType.getDocBaseType().equals("ARC")) || !this.isSOTrx() && (docType.getDocBaseType().equals("API") || docType.getDocBaseType().equals("APC")))) {
                    this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_DocTypeIncorrect")) + " - " + Msg.getElement((Properties)this.getCtx(), (String)"JP_TaxAdjust_DocType_ID"));
                    return false;
                }
            }
            if (this.getJP_TaxAdjust_Tax_ID() == 0) {
                this.log.saveError("FillMandatory", Msg.getElement((Properties)this.getCtx(), (String)"JP_TaxAdjust_Tax_ID"));
                return false;
            }
            if ((newRecord || this.is_ValueChanged("JP_TaxAdjust_Tax_ID")) && (tax = MTax.get((int)this.getJP_TaxAdjust_Tax_ID())).getRate().compareTo(Env.ZERO) != 0) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_TaxAdjust_ZERO_TaxRate"));
                return false;
            }
            if (this.getJP_TaxAdjust_PriceList_ID() == 0) {
                this.log.saveError("FillMandatory", Msg.getElement((Properties)this.getCtx(), (String)"JP_TaxAdjust_PriceList_ID"));
                return false;
            }
        }
        return true;
    }

    public static MBillSchema get(int JP_BillSchema_ID) {
        Integer ii = JP_BillSchema_ID;
        MBillSchema retValue = (MBillSchema)s_cache.get((Object)ii);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MBillSchema(Env.getCtx(), JP_BillSchema_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)JP_BillSchema_ID, (Object)retValue);
        }
        return retValue;
    }

    public static MBillSchema getBillSchemaBP(int C_BPartner_ID, boolean isSOTrx) {
        if (C_BPartner_ID == 0) {
            return null;
        }
        MBPartner bp = MBPartner.get((Properties)Env.getCtx(), (int)C_BPartner_ID);
        int JP_BillSchema_ID = 0;
        JP_BillSchema_ID = isSOTrx ? bp.get_ValueAsInt("JP_BillSchema_ID") : bp.get_ValueAsInt("JP_BillSchemaPO_ID");
        if (JP_BillSchema_ID == 0) {
            return null;
        }
        return MBillSchema.get(JP_BillSchema_ID);
    }
}

