/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import jpiere.base.plugin.org.adempiere.base.IJPiereTaxProvider;
import jpiere.base.plugin.org.adempiere.model.MBill;
import jpiere.base.plugin.org.adempiere.model.X_JP_BillLine;
import jpiere.base.plugin.util.JPiereUtil;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MTax;
import org.compiere.model.MTaxProvider;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MBillLine
extends X_JP_BillLine {
    private MInvoice invoice = null;
    private MBill m_parent = null;

    public MBillLine(Properties ctx, int JP_BillLine_ID, String trxName) {
        super(ctx, JP_BillLine_ID, trxName);
    }

    public MBillLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        if (newRecord || this.is_ValueChanged("C_Invoice_ID")) {
            if (this.getC_Invoice_ID() == 0) {
                this.log.saveError("FillMandatory", Msg.getElement((Properties)this.getCtx(), (String)"C_Invoice_ID"));
                return false;
            }
            this.invoice = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
            if (!this.invoice.getDocStatus().equals("CO") && !this.invoice.getDocStatus().equals("CL")) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_Not_Completed_Document"));
                return false;
            }
            if (this.invoice.getC_Currency_ID() != this.getParent().getC_Currency_ID()) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_DifferentCurrency"));
                return false;
            }
            if (this.getJP_Subject() == null || this.getJP_Subject().isEmpty()) {
                this.setJP_Subject(this.invoice.get_ValueAsString("JP_Subject"));
            }
            if (this.getDescription() == null || this.getDescription().isEmpty()) {
                this.setDescription(this.invoice.getDescription());
            }
            if (this.getJP_Remarks() == null || this.getJP_Remarks().isEmpty()) {
                this.setJP_Remarks(this.invoice.get_ValueAsString("JP_Remarks"));
            }
            if (this.getJP_CommunicationColumn() == null || this.getJP_CommunicationColumn().isEmpty()) {
                this.setJP_CommunicationColumn(this.invoice.get_ValueAsString("JP_CommunicationColumn"));
            }
            this.setC_DocType_ID(this.invoice.getC_DocType_ID());
            this.setDateInvoiced(this.invoice.getDateInvoiced());
            this.setDateAcct(this.invoice.getDateAcct());
            this.setC_BPartner_ID(this.invoice.getC_BPartner_ID());
            this.setC_BPartner_Location_ID(this.invoice.getC_BPartner_Location_ID());
            this.setAD_User_ID(this.invoice.getAD_User_ID());
            this.setM_PriceList_ID(this.invoice.getM_PriceList_ID());
            this.setSalesRep_ID(this.invoice.getSalesRep_ID());
            this.setPaymentRule(this.invoice.getPaymentRule());
            this.setC_PaymentTerm_ID(this.invoice.getC_PaymentTerm_ID());
            this.setC_Currency_ID(this.invoice.getC_Currency_ID());
            this.setTotalLines(this.invoice.getTotalLines());
            this.setGrandTotal(this.invoice.getGrandTotal());
            BigDecimal TaxBaseAmt = Env.ZERO;
            BigDecimal TaxAmt = Env.ZERO;
            MInvoiceTax[] invTaxes = this.invoice.getTaxes(false);
            int i = 0;
            while (i < invTaxes.length) {
                TaxBaseAmt = TaxBaseAmt.add(invTaxes[i].getTaxBaseAmt());
                TaxAmt = TaxAmt.add(invTaxes[i].getTaxAmt());
                ++i;
            }
            this.setTaxBaseAmt(TaxBaseAmt);
            this.setTaxAmt(TaxAmt);
            this.setPayAmt(this.invoice.getGrandTotal().subtract(this.invoice.getOpenAmt()));
            this.setOpenAmt(this.invoice.getOpenAmt());
            MDocType invoiceDocType = MDocType.get((int)this.invoice.getC_DocTypeTarget_ID());
            if (invoiceDocType.getDocBaseType().equals("ARC") || invoiceDocType.getDocBaseType().equals("APC")) {
                this.setTotalLines(this.getTotalLines().negate());
                this.setGrandTotal(this.getGrandTotal().negate());
                this.setTaxBaseAmt(this.getTaxBaseAmt().negate());
                this.setTaxAmt(this.getTaxAmt().negate());
                this.setPayAmt(this.getPayAmt().negate());
                this.setOpenAmt(this.getOpenAmt().negate());
            }
            if (this.isTaxAdjustLineJP()) {
                if (invoiceDocType.getDocBaseType().equals("ARC") || invoiceDocType.getDocBaseType().equals("APC")) {
                    this.setTotalLines(Env.ZERO);
                    this.setGrandTotal(this.invoice.getGrandTotal().negate());
                    this.setTaxBaseAmt(Env.ZERO);
                    this.setTaxAmt(this.invoice.getGrandTotal().negate());
                    this.setPayAmt(Env.ZERO);
                    this.setOpenAmt(this.invoice.getGrandTotal().negate());
                    this.setOverUnderAmt(Env.ZERO);
                } else {
                    this.setTotalLines(Env.ZERO);
                    this.setGrandTotal(this.invoice.getGrandTotal());
                    this.setTaxBaseAmt(Env.ZERO);
                    this.setTaxAmt(this.invoice.getGrandTotal());
                    this.setPayAmt(Env.ZERO);
                    this.setOpenAmt(this.invoice.getGrandTotal());
                    this.setOverUnderAmt(Env.ZERO);
                }
            }
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord || this.is_ValueChanged("C_Invoice_ID")) {
            Integer JP_Bill_ID;
            MInvoice invoice_old;
            Integer JP_Bill_ID2;
            if (!this.updateHeaderAndTax(newRecord, success, false)) {
                return false;
            }
            if (this.invoice == null) {
                this.invoice = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
            }
            if (!newRecord && (JP_Bill_ID2 = (Integer)(invoice_old = new MInvoice(this.getCtx(), this.get_ValueOldAsInt("C_Invoice_ID"), this.get_TrxName())).get_Value("JP_Bill_ID")) != null && JP_Bill_ID2.intValue() == this.getJP_Bill_ID()) {
                invoice_old.set_ValueNoCheck("JP_Bill_ID", null);
                invoice_old.save(this.get_TrxName());
            }
            if ((JP_Bill_ID = (Integer)this.invoice.get_Value("JP_Bill_ID")) == null || JP_Bill_ID == 0) {
                this.invoice.set_ValueNoCheck("JP_Bill_ID", (Object)this.getJP_Bill_ID());
                this.invoice.save(this.get_TrxName());
            }
        }
        return true;
    }

    protected boolean afterDelete(boolean success) {
        Integer JP_Bill_ID;
        if (!this.updateHeaderAndTax(false, success, true)) {
            return false;
        }
        if (this.invoice == null) {
            this.invoice = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
        }
        if ((JP_Bill_ID = (Integer)this.invoice.get_Value("JP_Bill_ID")) != null && JP_Bill_ID.intValue() == this.getJP_Bill_ID()) {
            this.invoice.set_ValueNoCheck("JP_Bill_ID", null);
            this.invoice.save(this.get_TrxName());
        }
        return true;
    }

    private boolean updateHeaderAndTax(boolean newRecord, boolean success, boolean isDelete) {
        if (this.isTaxAdjustLineJP()) {
            MInvoiceTax[] taxes;
            if (this.invoice == null) {
                this.invoice = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
            }
            MInvoiceTax[] mInvoiceTaxArray = taxes = this.invoice.getTaxes(true);
            if (taxes.length != 0) {
                MInvoiceTax iTax = mInvoiceTaxArray[0];
                MTax m_tax = MTax.get((int)iTax.getC_Tax_ID());
                MTaxProvider provider = new MTaxProvider(m_tax.getCtx(), m_tax.getC_TaxProvider_ID(), m_tax.get_TrxName());
                IJPiereTaxProvider taxCalculater = JPiereUtil.getJPiereTaxProvider(m_tax);
                if (taxCalculater == null) {
                    throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)"TaxNoProvider"));
                }
                success = taxCalculater.updateHeaderTax(provider, this);
                if (!success) {
                    return false;
                }
            }
        } else {
            MInvoiceTax[] taxes;
            if (!newRecord && this.is_ValueChanged("C_Invoice_ID") && !isDelete) {
                MInvoiceTax[] taxes2;
                int old_C_Invoice_ID = this.get_ValueOldAsInt("C_Invoice_ID");
                MInvoice oldInvoice = new MInvoice(this.getCtx(), old_C_Invoice_ID, this.get_TrxName());
                MInvoiceTax[] mInvoiceTaxArray = taxes2 = oldInvoice.getTaxes(true);
                int taxCalculater = taxes2.length;
                int n = 0;
                while (n < taxCalculater) {
                    MInvoiceTax iTax = mInvoiceTaxArray[n];
                    MTax m_tax = MTax.get((int)iTax.getC_Tax_ID());
                    MTaxProvider provider = new MTaxProvider(m_tax.getCtx(), m_tax.getC_TaxProvider_ID(), m_tax.get_TrxName());
                    IJPiereTaxProvider taxCalculater2 = JPiereUtil.getJPiereTaxProvider(m_tax);
                    if (taxCalculater2 == null) {
                        throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)"TaxNoProvider"));
                    }
                    success = taxCalculater2.recalculateTax(provider, this, oldInvoice, iTax, true);
                    if (!success) {
                        return false;
                    }
                    ++n;
                }
            }
            if (this.invoice == null) {
                this.invoice = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
            }
            MInvoiceTax[] mInvoiceTaxArray = taxes = this.invoice.getTaxes(true);
            int n = taxes.length;
            int n2 = 0;
            while (n2 < n) {
                MInvoiceTax iTax = mInvoiceTaxArray[n2];
                MTax m_tax = MTax.get((int)iTax.getC_Tax_ID());
                MTaxProvider provider = new MTaxProvider(m_tax.getCtx(), m_tax.getC_TaxProvider_ID(), m_tax.get_TrxName());
                IJPiereTaxProvider taxCalculater = JPiereUtil.getJPiereTaxProvider(m_tax);
                if (taxCalculater == null) {
                    throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)"TaxNoProvider"));
                }
                success = taxCalculater.recalculateTax(provider, this, this.invoice, iTax, false);
                if (!success) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public MBill getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MBill(this.getCtx(), this.getJP_Bill_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public void clearParent() {
        this.m_parent = null;
    }
}

