/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MBillLine;
import jpiere.base.plugin.org.adempiere.model.MBillSchema;
import jpiere.base.plugin.org.adempiere.model.MBillTax;
import jpiere.base.plugin.org.adempiere.model.X_JP_Bill;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPayment;
import org.compiere.model.MPeriod;
import org.compiere.model.MRefList;
import org.compiere.model.MTax;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MBill
extends X_JP_Bill
implements DocAction,
DocOptions {
    private static final long serialVersionUID = -7588955558162632796L;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private MBillLine[] m_lines;
    private MBillTax[] m_taxes;

    public MBill(Properties ctx, int JP_Bill_ID, String trxName) {
        super(ctx, JP_Bill_ID, trxName);
    }

    public MBill(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        return String.valueOf(dt.getNameTrl()) + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(String.valueOf(this.get_TableName()) + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("unlockIt - " + this.toString());
        }
        return true;
    }

    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("invalidateIt - " + this.toString());
        }
        return true;
    }

    public String prepareIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (!MPeriod.isOpen((Properties)this.getCtx(), (Timestamp)this.getJPDateBilled(), (String)dt.getDocBaseType(), (int)this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        MBillLine[] lines = this.getLines(false);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        return "IP";
    }

    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("approveIt - " + this.toString());
        }
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("rejectIt - " + this.toString());
        }
        return true;
    }

    public String completeIt() {
        String valid;
        MBillTax[] taxes;
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        boolean isCreateInvoice = false;
        MBillTax[] mBillTaxArray = taxes = this.getTaxes(true);
        int n = taxes.length;
        int n2 = 0;
        while (n2 < n) {
            MBillTax tax = mBillTaxArray[n2];
            if (tax.getJP_TaxAdjust_TaxAmt().compareTo(Env.ZERO) != 0) {
                isCreateInvoice = true;
                break;
            }
            ++n2;
        }
        if (isCreateInvoice) {
            MBillSchema billSchema = MBillSchema.getBillSchemaBP(this.getC_BPartner_ID(), this.isSOTrx());
            if (billSchema == null) {
                this.m_processMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NotFound")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_BillSchema_ID", (boolean)this.isSOTrx());
                return "IN";
            }
            if (billSchema.isTaxRecalculateJP()) {
                String description = String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_Bill_ID", (boolean)this.isSOTrx())) + " : " + this.getDocumentNo();
                MInvoice invoice = new MInvoice(this.getCtx(), 0, this.get_TrxName());
                PO.copyValues((PO)this, (PO)invoice);
                invoice.setC_Invoice_ID(0);
                invoice.setAD_Org_ID(this.getAD_Org_ID());
                invoice.setSalesRep_ID(this.getSalesRep_ID());
                invoice.setC_BPartner_ID(this.getC_BPartner_ID());
                invoice.setC_BPartner_Location_ID(this.getC_BPartner_Location_ID());
                invoice.setAD_User_ID(this.getAD_User_ID());
                invoice.setDateInvoiced(this.getJPCutOffDate());
                invoice.setDateAcct(this.getDateAcct());
                invoice.setC_DocTypeTarget_ID(billSchema.getJP_TaxAdjust_DocType_ID());
                invoice.setC_DocType_ID(billSchema.getJP_TaxAdjust_DocType_ID());
                invoice.setM_PriceList_ID(billSchema.getJP_TaxAdjust_PriceList_ID());
                invoice.setDescription(String.valueOf(billSchema.getJP_TaxAdjust_Description()) + " - " + description);
                invoice.setDocumentNo(null);
                invoice.setPaymentRule(this.getPaymentRule());
                invoice.setC_PaymentTerm_ID(this.getC_PaymentTerm_ID());
                invoice.set_ValueNoCheck("JP_Bill_ID", (Object)this.getJP_Bill_ID());
                if (!invoice.save(this.get_TrxName())) {
                    this.m_processMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_TaxAdjust_Invoice_ID", (boolean)this.isSOTrx());
                    return "IN";
                }
                this.setJP_TaxAdjust_Invoice_ID(invoice.getC_Invoice_ID());
                MDocType docType = MDocType.get((int)billSchema.getJP_TaxAdjust_DocType_ID());
                int line = 10;
                MBillTax[] mBillTaxArray2 = taxes;
                int n3 = taxes.length;
                int n4 = 0;
                while (n4 < n3) {
                    MBillTax tax = mBillTaxArray2[n4];
                    if (tax.getJP_TaxAdjust_TaxAmt().compareTo(Env.ZERO) != 0) {
                        MInvoiceLine iLine = new MInvoiceLine(this.getCtx(), 0, this.get_TrxName());
                        iLine.setC_Invoice_ID(invoice.getC_Invoice_ID());
                        iLine.setInvoice(invoice);
                        iLine.setAD_Org_ID(invoice.getAD_Org_ID());
                        iLine.setLine(line);
                        iLine.setC_Charge_ID(billSchema.getJP_TaxAdjust_Charge_ID());
                        iLine.setQty(Env.ONE);
                        iLine.setC_UOM_ID(100);
                        if (docType.getDocBaseType().equals("ARC") || docType.getDocBaseType().equals("APC")) {
                            iLine.setPrice(tax.getJP_TaxAdjust_TaxAmt().negate());
                        } else {
                            iLine.setPrice(tax.getJP_TaxAdjust_TaxAmt());
                        }
                        iLine.setC_Tax_ID(billSchema.getJP_TaxAdjust_Tax_ID());
                        iLine.setDescription(String.valueOf(description) + " - " + MTax.get((int)tax.getC_Tax_ID()).getName() + " - " + Msg.getElement((Properties)this.getCtx(), (String)"IsTaxIncluded") + "=" + (tax.isTaxIncluded() ? "Y" : "N"));
                        if (!iLine.save(this.get_TrxName())) {
                            this.m_processMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_TaxAdjust_Invoice_ID", (boolean)this.isSOTrx()) + " - " + Msg.getElement((Properties)this.getCtx(), (String)"C_InvoiceLine_ID", (boolean)this.isSOTrx());
                            return "IN";
                        }
                        line += 10;
                        tax.setJP_TaxAdjust_InvoiceLine_ID(iLine.getC_InvoiceLine_ID());
                        if (!tax.save(this.get_TrxName())) {
                            this.m_processMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_TaxAdjust_InvoiceLine_ID", (boolean)this.isSOTrx());
                            return "IN";
                        }
                    }
                    ++n4;
                }
                if (invoice.processIt("CO")) {
                    if (!invoice.save(this.get_TrxName())) {
                        this.m_processMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"C_Invoice_ID", (boolean)this.isSOTrx());
                        return "IN";
                    }
                    MBillLine billLine = new MBillLine(this.getCtx(), 0, this.get_TrxName());
                    billLine.setJP_Bill_ID(this.getJP_Bill_ID());
                    billLine.setAD_Org_ID(this.getAD_Org_ID());
                    billLine.setDescription(billSchema.getJP_TaxAdjust_Description());
                    String sql = "SELECT NVL(MAX(Line),0)+10 AS DefaultValue FROM JP_BillLine WHERE JP_Bill_ID=?";
                    line = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getJP_Bill_ID());
                    billLine.setLine(line);
                    billLine.setC_Invoice_ID(invoice.getC_Invoice_ID());
                    billLine.setIsTaxAdjustLineJP(true);
                    if (!billLine.save(this.get_TrxName())) {
                        this.m_processMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"IsTaxAdjustLineJP", (boolean)this.isSOTrx());
                        return "IN";
                    }
                } else {
                    this.m_processMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"ProcessRunError")) + " - " + Msg.getElement((Properties)this.getCtx(), (String)"JP_TaxAdjust_Invoice_ID", (boolean)this.isSOTrx()) + " - " + MRefList.getListName((Properties)this.getCtx(), (int)135, (String)"CO");
                    return "IN";
                }
            }
        }
        if ((valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9)) != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    public boolean voidIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("voidIt - " + this.toString());
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            this.setDocAction("--");
            return false;
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus()) || "CO".equals(this.getDocStatus())) {
            this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 2);
            if (this.m_processMsg != null) {
                return false;
            }
            MBillLine[] lines = this.getLines(false);
            MBillLine line = null;
            MInvoice invoice = null;
            int i = 0;
            while (i < lines.length) {
                line = lines[i];
                invoice = new MInvoice(this.getCtx(), line.getC_Invoice_ID(), this.get_TrxName());
                Integer JP_Bill_ID = (Integer)invoice.get_Value("JP_Bill_ID");
                if (JP_Bill_ID != null && JP_Bill_ID.intValue() == this.getJP_Bill_ID()) {
                    invoice.set_ValueNoCheck("JP_Bill_ID", null);
                    invoice.save(this.get_TrxName());
                }
                ++i;
            }
        } else {
            return false;
        }
        this.addDescription(Msg.getMsg((Properties)this.getCtx(), (String)"Voided"));
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public boolean closeIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 11);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("--");
        return true;
    }

    public boolean reverseCorrectIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        if (!this.reverse("RC")) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public boolean reverseAccrualIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        if (!this.reverse("RA")) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean reverse(String docAction) {
        if (!this.voidIt()) {
            return false;
        }
        int C_Invoice_ID = this.getJP_TaxAdjust_Invoice_ID();
        if (C_Invoice_ID <= 0) return true;
        MInvoice invoice = new MInvoice(this.getCtx(), C_Invoice_ID, this.get_TrxName());
        if (invoice.getDocStatus().equals("CO")) {
            if (invoice.processIt(docAction)) {
                if (invoice.save(this.get_TrxName())) return true;
                this.m_processMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_TaxAdjust_Invoice_ID", (boolean)this.isSOTrx());
                return false;
            }
            this.m_processMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"ProcessRunError")) + " - " + Msg.getElement((Properties)this.getCtx(), (String)"JP_TaxAdjust_Invoice_ID", (boolean)this.isSOTrx()) + " - " + MRefList.getListName((Properties)this.getCtx(), (int)135, (String)docAction);
            return false;
        }
        if (invoice.getDocStatus().equals("CL") || invoice.getDocStatus().equals("VO") || invoice.getDocStatus().equals("RE")) {
            invoice.set_ValueNoCheck("JP_Bill_ID", (Object)this.getJP_Bill_ID());
            if (invoice.save(this.get_TrxName())) return true;
            this.m_processMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + "MInvoice#setJP_Bill_ID ";
            return false;
        }
        if (invoice.processIt("VO")) {
            invoice.set_ValueNoCheck("JP_Bill_ID", (Object)this.getJP_Bill_ID());
            if (invoice.save(this.get_TrxName())) return true;
            this.m_processMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_TaxAdjust_Invoice_ID", (boolean)this.isSOTrx());
            return false;
        }
        this.m_processMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"ProcessRunError")) + " - " + Msg.getElement((Properties)this.getCtx(), (String)"JP_TaxAdjust_Invoice_ID", (boolean)this.isSOTrx()) + " - " + MRefList.getListName((Properties)this.getCtx(), (int)135, (String)"VO");
        return true;
    }

    public boolean reActivateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("reActivateIt - " + this.toString());
        }
        return this.reverseCorrectIt();
    }

    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDocumentNo());
        return sb.toString();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    public BigDecimal getApprovalAmt() {
        return this.getGrandTotal();
    }

    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (docStatus.equals("DR")) {
            return index;
        }
        if (docStatus.equals("CO")) {
            if (this.isTaxRecalculateJP() && this.getJP_TaxAdjust_Invoice_ID() > 0) {
                options[index++] = "RA";
                options[index++] = "RC";
            } else {
                options[index++] = "VO";
            }
            return index;
        }
        return index;
    }

    protected boolean beforeSave(boolean newRecord) {
        if ((newRecord || this.is_ValueChanged("JP_LastBill_ID")) && this.getJP_LastBill_ID() != 0 && this.getJPLastBillAmt().compareTo(Env.ZERO) == 0) {
            MBill lastbill = new MBill(this.getCtx(), this.getJP_LastBill_ID(), this.get_TrxName());
            if (lastbill.getDocStatus().equals("CO") || lastbill.getDocStatus().equals("CL")) {
                this.setJPLastBillAmt(lastbill.getJPBillAmt());
            } else {
                this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_InvalidDocStatus")) + " - " + Msg.getElement((Properties)this.getCtx(), (String)"JP_LastBill_ID"));
                return false;
            }
        }
        if ((newRecord || this.is_ValueChanged("C_Payment_ID")) && this.getC_Payment_ID() != 0 && this.getJPLastPayAmt().compareTo(Env.ZERO) == 0) {
            MPayment lastPayment = new MPayment(this.getCtx(), this.getC_Payment_ID(), this.get_TrxName());
            if (lastPayment.getDocStatus().equals("CO") || lastPayment.getDocStatus().equals("CL")) {
                this.setJPLastPayAmt(lastPayment.getPayAmt());
            } else {
                this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_InvalidDocStatus")) + " - " + Msg.getElement((Properties)this.getCtx(), (String)"C_Payment_ID"));
                return false;
            }
        }
        if (newRecord || this.is_ValueChanged("C_BPartner_ID")) {
            MBillLine[] lines = this.getLines();
            if (lines.length > 0) {
                this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CannotChangeForLines")) + " - " + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_ID"));
                return false;
            }
            MBillSchema bs = MBillSchema.getBillSchemaBP(this.getC_BPartner_ID(), this.isSOTrx());
            if (bs == null || bs.getJP_BillSchema_ID() == 0) {
                this.setIsTaxRecalculateJP(false);
            } else {
                this.setIsTaxRecalculateJP(bs.isTaxRecalculateJP());
            }
        }
        this.setJPCarriedForwardAmt(this.getJPLastBillAmt().subtract(this.getJPLastPayAmt()));
        this.setJPBillAmt(this.getJPCarriedForwardAmt().add(this.getOpenAmt()));
        return true;
    }

    private MBillLine[] getLines(String whereClause) {
        String whereClauseFinal = "JP_Bill_ID=? ";
        if (whereClause != null) {
            whereClauseFinal = String.valueOf(whereClauseFinal) + whereClause;
        }
        List list = new Query(this.getCtx(), "JP_BillLine", whereClauseFinal, this.get_TrxName()).setParameters(new Object[]{this.getJP_Bill_ID()}).setOrderBy("Line").list();
        return list.toArray(new MBillLine[list.size()]);
    }

    public MBillLine[] getLines(boolean requery) {
        if (this.m_lines == null || this.m_lines.length == 0 || requery) {
            this.m_lines = this.getLines(null);
        }
        MBill.set_TrxName((PO[])this.m_lines, (String)this.get_TrxName());
        return this.m_lines;
    }

    public MBillLine[] getLines() {
        return this.getLines(false);
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            StringBuilder msgd = new StringBuilder(desc).append(" | ").append(description);
            this.setDescription(msgd.toString());
        }
    }

    public BigDecimal getCurrentOpenAmt() {
        this.getLines(true);
        BigDecimal openAmt = Env.ZERO;
        MInvoice inv = null;
        int i = 0;
        while (i < this.m_lines.length) {
            inv = new MInvoice(this.getCtx(), this.m_lines[i].getC_Invoice_ID(), this.get_TrxName());
            openAmt = openAmt.add(inv.getOpenAmt(true, null));
            ++i;
        }
        return openAmt;
    }

    public MBillTax[] getTaxes(boolean requery) {
        if (this.m_taxes != null && !requery) {
            return this.m_taxes;
        }
        String whereClause = "JP_Bill_ID=?";
        List list = new Query(this.getCtx(), "JP_BillTax", "JP_Bill_ID=?", this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).list();
        this.m_taxes = list.toArray(new MBillTax[list.size()]);
        return this.m_taxes;
    }
}

