/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MBankData;
import jpiere.base.plugin.org.adempiere.model.MBill;
import jpiere.base.plugin.org.adempiere.model.X_JP_BankDataLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MBankDataLine
extends X_JP_BankDataLine {
    private MBankData m_BankData = null;

    public MBankDataLine(Properties ctx, int JP_BankDataLine_ID, String trxName) {
        super(ctx, JP_BankDataLine_ID, trxName);
    }

    public MBankDataLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MBankData getParent() {
        if (this.m_BankData == null) {
            this.m_BankData = new MBankData(this.getCtx(), this.getJP_BankData_ID(), this.get_TrxName());
        }
        return this.m_BankData;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (newRecord && this.getStmtAmt().compareTo(Env.ZERO) != 0 && this.getTrxAmt().compareTo(Env.ZERO) == 0 && this.getChargeAmt().compareTo(Env.ZERO) == 0 && this.getInterestAmt().compareTo(Env.ZERO) == 0) {
            this.setTrxAmt(this.getStmtAmt());
        }
        if (this.is_ValueChanged("StmtAmt") || this.is_ValueChanged("TrxAmt") || this.is_ValueChanged("ChargeAmt") || this.is_ValueChanged("InterestAmt")) {
            BigDecimal amt = this.getStmtAmt();
            amt = amt.subtract(this.getTrxAmt());
            if ((amt = amt.subtract(this.getInterestAmt())).compareTo(this.getChargeAmt()) != 0) {
                this.setChargeAmt(amt);
            }
        }
        if (this.getChargeAmt().signum() != 0 && this.getC_Charge_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement((Properties)this.getCtx(), (String)"C_Charge_ID"));
            return false;
        }
        if (this.is_ValueChanged("C_Invoice_ID") && this.getC_Invoice_ID() > 0) {
            this.setJP_Bill_ID(0);
            this.setC_Payment_ID(0);
            this.setC_Order_ID(0);
            MInvoice invoice = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), null);
            if (invoice.isPaid()) {
                this.log.saveError("JP_InvoicePaid", "");
                return false;
            }
            this.setC_BPartner_ID(invoice.getC_BPartner_ID());
        }
        if (this.is_ValueChanged("JP_Bill_ID") && this.getJP_Bill_ID() > 0) {
            this.setC_Invoice_ID(0);
            this.setC_Payment_ID(0);
            this.setC_Order_ID(0);
            MBill bill = new MBill(this.getCtx(), this.getJP_Bill_ID(), null);
            BigDecimal currentOpenAmt = bill.getCurrentOpenAmt();
            if (currentOpenAmt.compareTo(Env.ZERO) <= 0) {
                this.log.saveError("JP_BillPaid", "");
                return false;
            }
            this.setC_BPartner_ID(bill.getC_BPartner_ID());
        }
        if (this.is_ValueChanged("C_Payment_ID") && this.getC_Payment_ID() > 0) {
            this.setC_Invoice_ID(0);
            this.setJP_Bill_ID(0);
            this.setC_Order_ID(0);
            MPayment payment = new MPayment(this.getCtx(), this.getC_Payment_ID(), null);
            if (payment.isReconciled()) {
                this.log.saveError("JP_PaymentReconciled", "");
                return false;
            }
            this.setC_BPartner_ID(payment.getC_BPartner_ID());
        }
        if (this.is_ValueChanged("C_Order_ID") && this.getC_Order_ID() > 0) {
            this.setC_Invoice_ID(0);
            this.setJP_Bill_ID(0);
            this.setC_Payment_ID(0);
            MOrder order = new MOrder(this.getCtx(), this.getC_Order_ID(), null);
            if (order.getC_Payment_ID() > 0) {
                this.log.saveError("JP_OrderPaid", "");
                return false;
            }
            this.setC_BPartner_ID(order.getC_BPartner_ID());
        }
        if (this.getC_Invoice_ID() > 0 || this.getJP_Bill_ID() > 0 || this.getC_Payment_ID() > 0 || this.getC_Order_ID() > 0) {
            this.setIsMatchedJP(true);
        } else {
            this.setIsMatchedJP(false);
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return false;
        }
        if (newRecord) {
            return this.updateHeader(true);
        }
        return this.updateHeader(false);
    }

    protected boolean afterDelete(boolean success) {
        if (!success) {
            return false;
        }
        return this.updateHeader(true);
    }

    private boolean updateHeader(boolean forced) {
        if (forced || this.is_ValueChanged("StmtAmt") || this.is_ValueChanged("TrxAmt") || this.is_ValueChanged("ChargeAmt") || this.is_ValueChanged("InterestAmt")) {
            String sql = "SELECT COALESCE(SUM(StmtAmt),0), COALESCE(SUM(TrxAmt),0), COALESCE(SUM(ChargeAmt),0), COALESCE(SUM(InterestAmt),0) From JP_BankDataLine WHERE JP_BankData_ID = ?";
            BigDecimal StmtAmt = Env.ZERO;
            BigDecimal TrxAmt = Env.ZERO;
            BigDecimal ChargeAmt = Env.ZERO;
            BigDecimal InterestAmt = Env.ZERO;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, this.getJP_BankData_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        StmtAmt = rs.getBigDecimal(1);
                        TrxAmt = rs.getBigDecimal(2);
                        ChargeAmt = rs.getBigDecimal(3);
                        InterestAmt = rs.getBigDecimal(4);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    return false;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            sql = "UPDATE JP_BankData SET StmtAmt=?, TrxAmt=?, ChargeAmt=?, InterestAmt=? WHERE JP_BankData_ID = ?";
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setBigDecimal(1, StmtAmt);
                pstmt.setBigDecimal(2, TrxAmt);
                pstmt.setBigDecimal(3, ChargeAmt);
                pstmt.setBigDecimal(4, InterestAmt);
                pstmt.setInt(5, this.getJP_BankData_ID());
                int no = pstmt.executeUpdate();
                if (no != 1) {
                    this.log.log(Level.SEVERE, sql);
                    return false;
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                return false;
            }
            finally {
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
        }
        return true;
    }
}

