/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.X_JP_BankAccount_History;
import org.compiere.model.MTax;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MBankAccountHistory
extends X_JP_BankAccount_History {
    private static CCache<Integer, MBankAccountHistory[]> s_cache = new CCache("JP_BankAccount_History", 100, 10);

    public MBankAccountHistory(Properties ctx, int JP_BankAccount_History_ID, String trxName) {
        super(ctx, JP_BankAccount_History_ID, trxName);
    }

    public MBankAccountHistory(Properties ctx, int JP_BankAccount_History_ID, String trxName, String ... virtualColumns) {
        super(ctx, JP_BankAccount_History_ID, trxName, virtualColumns);
    }

    public MBankAccountHistory(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getC_BankAccount_ID() == 0) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"C_BankAccount_ID = 0"));
            return false;
        }
        if (this.getAD_Client_ID() == 0) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"AD_Client_ID = 0"));
            return false;
        }
        if (newRecord || this.is_ValueChanged("DateFrom") || this.is_ValueChanged("DateTo")) {
            if (this.getDateFrom().compareTo(this.getDateTo()) > 0) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"DateFrom")) + " > " + Msg.getElement((Properties)this.getCtx(), (String)"DateTo"))));
                return false;
            }
            MBankAccountHistory[] m_Histories = this.getOtherHistories();
            int i = 0;
            while (i < m_Histories.length) {
                if (this.getDateFrom().compareTo(m_Histories[i].getDateTo()) <= 0 && m_Histories[i].getDateFrom().compareTo(this.getDateTo()) <= 0) {
                    this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_OverlapPeriod"));
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private MBankAccountHistory[] getOtherHistories() {
        ArrayList<MBankAccountHistory> list;
        MBankAccountHistory[] m_Histories;
        block6: {
            m_Histories = null;
            list = new ArrayList<MBankAccountHistory>();
            String sql = "SELECT * FROM JP_BankAccount_History WHERE C_BankAccount_ID=? AND JP_BankAccount_History_ID <> ?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, this.getC_BankAccount_ID());
                    pstmt.setInt(2, this.getJP_BankAccount_History_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MBankAccountHistory(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        m_Histories = new MBankAccountHistory[list.size()];
        list.toArray(m_Histories);
        return m_Histories;
    }

    public static MBankAccountHistory[] getHistories(Properties ctx, int C_BankAccount_ID, String trxName) {
        MBankAccountHistory[] m_Histories = (MBankAccountHistory[])s_cache.get((Object)C_BankAccount_ID);
        if (m_Histories != null) {
            return m_Histories;
        }
        String whereClause = "C_BankAccount_ID=?";
        List list = new Query(ctx, "JP_BankAccount_History", "C_BankAccount_ID=?", trxName).setParameters(new Object[]{C_BankAccount_ID}).setOrderBy("DateFrom DESC").list();
        m_Histories = new MBankAccountHistory[list.size()];
        list.toArray(m_Histories);
        s_cache.put((Object)C_BankAccount_ID, (Object)m_Histories);
        return m_Histories;
    }

    public static MBankAccountHistory getHistory(Properties ctx, int C_BankAccount_ID, Timestamp date, String trxName) {
        MBankAccountHistory m_History = null;
        MBankAccountHistory[] m_Histories = MBankAccountHistory.getHistories(ctx, C_BankAccount_ID, trxName);
        int i = 0;
        while (i < m_Histories.length) {
            if (m_Histories[i].getDateFrom().compareTo(date) <= 0 && m_Histories[i].getDateTo().compareTo(date) >= 0) {
                m_History = m_Histories[i];
                break;
            }
            ++i;
        }
        return m_History;
    }

    public static String getHistoryName(Properties ctx, int C_BankAccount_ID, Timestamp date, String trxName) {
        MBankAccountHistory m_History = MBankAccountHistory.getHistory(ctx, C_BankAccount_ID, date, trxName);
        if (m_History == null) {
            return MTax.get((Properties)ctx, (int)C_BankAccount_ID).getName();
        }
        return m_History.getName();
    }
}

