/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import jpiere.base.plugin.org.adempiere.model.MBankStatementTax;
import org.compiere.model.I_C_TaxProvider;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MTax;
import org.compiere.model.MTaxProvider;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class JPiereBankStatementTaxProvider {
    protected transient CLogger log = CLogger.getCLogger(this.getClass());
    private static CCache<Integer, MBPartner> s_cache = new CCache("C_BPartner", 40, 5);

    public boolean updateHeaderTax(MTaxProvider provider, MBankStatementLine line) {
        return true;
    }

    public boolean updateBankStatementTax(MTaxProvider provider, MBankStatementLine line) {
        MBankStatementTax tax = this.getMBankStatementTax(line, line.getC_Currency().getStdPrecision(), false, line.get_TrxName());
        if (tax != null) {
            if (!this.calculateTaxFromBankStatementLine(line, tax)) {
                return false;
            }
            if (tax.getTaxAmt().signum() != 0 || tax.getTaxBaseAmt().signum() != 0 ? !tax.save(line.get_TrxName()) : (line.isProcessed() && !line.is_ValueChanged("Processed") ? !tax.is_new() && !tax.delete(true, tax.get_TrxName()) : !tax.is_new() && !tax.delete(false, tax.get_TrxName()))) {
                return false;
            }
        }
        return true;
    }

    public boolean recalculateTax(MTaxProvider provider, MBankStatementLine line, boolean newRecord) {
        if (!newRecord && line.is_ValueChanged("C_Tax_ID") && !line.getParent().isProcessed() && !this.updateBankStatementTax(line, true)) {
            return false;
        }
        if (!this.updateBankStatementTax(provider, line)) {
            return false;
        }
        return this.updateHeaderTax(provider, line);
    }

    private boolean updateBankStatementTax(MBankStatementLine line, boolean oldTax) {
        MBankStatementTax tax = this.getMBankStatementTax(line, line.getC_Currency().getStdPrecision(), oldTax, line.get_TrxName());
        try {
            return tax.is_new() || tax.delete(false, tax.get_TrxName());
        }
        catch (Exception e) {
            return true;
        }
    }

    private boolean calculateTaxFromBankStatementLine(MBankStatementLine line, MBankStatementTax m_bankStatementTax) {
        BigDecimal taxBaseAmt = Env.ZERO;
        BigDecimal taxAmt = Env.ZERO;
        MTax tax = MTax.get((Properties)m_bankStatementTax.getCtx(), (int)m_bankStatementTax.getC_Tax_ID());
        boolean isSOTrx = false;
        Object obj_JP_SOPOType = line.get_Value("JP_SOPOType");
        if (obj_JP_SOPOType == null) {
            if (line.getChargeAmt().compareTo(Env.ZERO) > 0) {
                isSOTrx = true;
            }
            taxBaseAmt = line.getChargeAmt().abs();
        } else {
            String JP_SOPOType = (String)obj_JP_SOPOType;
            if (JP_SOPOType.equals("S")) {
                isSOTrx = true;
                taxBaseAmt = line.getChargeAmt();
            } else {
                isSOTrx = false;
                taxBaseAmt = line.getChargeAmt().negate();
            }
        }
        m_bankStatementTax.setIsSOTrx(isSOTrx);
        RoundingMode roundingMode = JPiereBankStatementTaxProvider.getRoundingMode(line.getC_BPartner_ID(), isSOTrx, tax.getC_TaxProvider());
        taxAmt = JPiereBankStatementTaxProvider.calculateTax(tax, taxBaseAmt, true, line.getC_Currency().getStdPrecision(), roundingMode);
        m_bankStatementTax.setTaxAmt(taxAmt);
        m_bankStatementTax.setTaxBaseAmt(taxBaseAmt.subtract(taxAmt));
        return true;
    }

    private MBankStatementTax getMBankStatementTax(MBankStatementLine line, int precision, boolean oldTax, String trxName) {
        boolean isOldTax;
        int C_Tax_ID;
        MBankStatementTax retValue;
        block12: {
            retValue = null;
            if (line == null || line.getC_BankStatement_ID() == 0) {
                return null;
            }
            C_Tax_ID = (Integer)line.get_Value("C_Tax_ID");
            boolean bl = isOldTax = oldTax && line.is_ValueChanged("C_Tax_ID");
            if (isOldTax) {
                Object old = line.get_ValueOld("C_Tax_ID");
                if (old == null) {
                    return null;
                }
                C_Tax_ID = (Integer)old;
            }
            if (C_Tax_ID == 0) {
                return null;
            }
            String sql = "SELECT * FROM JP_BankStatementTax WHERE C_BankStatementLine_ID=? AND C_Tax_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)trxName);
                    pstmt.setInt(1, line.getC_BankStatementLine_ID());
                    pstmt.setInt(2, C_Tax_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = new MBankStatementTax(line.getCtx(), rs, trxName);
                    }
                }
                catch (Exception exception) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block12;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue != null) {
            retValue.setPrecision(precision);
            retValue.set_TrxName(trxName);
            return retValue;
        }
        if (isOldTax) {
            return null;
        }
        retValue = new MBankStatementTax(line.getCtx(), 0, trxName);
        retValue.set_TrxName(trxName);
        retValue.setAD_Org_ID(line.getAD_Org_ID());
        retValue.setC_BankStatement_ID(line.getC_BankStatement_ID());
        retValue.setC_BankStatementLine_ID(line.getC_BankStatementLine_ID());
        retValue.setC_Tax_ID(C_Tax_ID);
        retValue.setPrecision(precision);
        retValue.setIsTaxIncluded(true);
        return retValue;
    }

    public static RoundingMode getRoundingMode(int C_BPartner_ID, boolean isSOTrx, I_C_TaxProvider provider) {
        RoundingMode roundingMode = null;
        if (C_BPartner_ID != 0) {
            Integer key = C_BPartner_ID;
            MBPartner bp = (MBPartner)s_cache.get((Object)key);
            if (bp == null) {
                bp = MBPartner.get((Properties)Env.getCtx(), (int)C_BPartner_ID);
            }
            if (bp.get_ID() != 0) {
                s_cache.put((Object)key, (Object)bp);
            }
            if (isSOTrx) {
                Object SO_TaxRounding = bp.get_Value("JP_SOTaxRounding");
                if (SO_TaxRounding != null) {
                    roundingMode = RoundingMode.valueOf(Integer.valueOf(SO_TaxRounding.toString()));
                }
            } else {
                Object PO_TaxRounding = bp.get_Value("JP_POTaxRounding");
                if (PO_TaxRounding != null) {
                    roundingMode = RoundingMode.valueOf(Integer.valueOf(PO_TaxRounding.toString()));
                }
            }
        }
        if (roundingMode == null) {
            if (provider != null && provider.getAccount() != null) {
                String roundingModeString = provider.getAccount();
                if (roundingModeString.equals("UP")) {
                    return RoundingMode.UP;
                }
                if (roundingModeString.equals("DOWN")) {
                    return RoundingMode.DOWN;
                }
                if (roundingModeString.equals("CEILING")) {
                    return RoundingMode.CEILING;
                }
                if (roundingModeString.equals("FLOOR")) {
                    return RoundingMode.FLOOR;
                }
                if (roundingModeString.equals("HALF_UP")) {
                    return RoundingMode.HALF_UP;
                }
                if (roundingModeString.equals("HALF_DOWN")) {
                    return RoundingMode.HALF_DOWN;
                }
                if (roundingModeString.equals("HALF_EVEN")) {
                    return RoundingMode.HALF_EVEN;
                }
                if (roundingModeString.equals("UNNECESSARY")) {
                    return RoundingMode.UNNECESSARY;
                }
                return RoundingMode.DOWN;
            }
            roundingMode = RoundingMode.DOWN;
        }
        return roundingMode;
    }

    public static BigDecimal calculateTax(MTax m_tax, BigDecimal amount, boolean taxIncluded, int scale, RoundingMode roundingMode) {
        if (m_tax.isZeroTax()) {
            return Env.ZERO;
        }
        BigDecimal multiplier = m_tax.getRate().divide(Env.ONEHUNDRED, 12, RoundingMode.HALF_UP);
        BigDecimal tax = null;
        if (!taxIncluded) {
            tax = amount.multiply(multiplier);
        } else {
            multiplier = multiplier.add(Env.ONE);
            BigDecimal base = amount.divide(multiplier, 12, RoundingMode.HALF_UP);
            tax = amount.subtract(base);
        }
        BigDecimal finalTax = tax.setScale(scale, roundingMode);
        return finalTax;
    }
}

