/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.impexp;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.adempiere.base.IGridTabExporter;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.MTabCustomization;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridTable;
import org.compiere.model.GridWindow;
import org.compiere.model.GridWindowVO;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MField;
import org.compiere.model.MLocation;
import org.compiere.model.MRefList;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTab;
import org.compiere.model.MTable;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Evaluator;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.supercsv.cellprocessor.FmtBool;
import org.supercsv.cellprocessor.FmtDate;
import org.supercsv.cellprocessor.FmtNumber;
import org.supercsv.cellprocessor.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.CsvMapWriter;
import org.supercsv.prefs.CsvPreference;

public class JPiereGridTabCSVExporter
implements IGridTabExporter {
    private static final CLogger log = CLogger.getCLogger(JPiereGridTabCSVExporter.class);

    public void export(GridTab gridTab, List<GridTab> childs, boolean currentRowOnly, File file, int indxDetailSelected) {
        CsvMapWriter mapWriter = null;
        HashMap<GridTab, GridField[]> tabMapDetails = new HashMap<GridTab, GridField[]>();
        MTable table = null;
        MTable tableDetail = null;
        try {
            try {
                FileOutputStream fileOut = new FileOutputStream(file);
                OutputStreamWriter oStrW = null;
                String charaCode = MSysConfig.getValue((String)"JP_EXPORT_CSV_CHARACTER_CODE", (String)String.valueOf(Ini.getCharset()), (int)Env.getAD_Client_ID((Properties)Env.getCtx()), (int)Env.getAD_Org_ID((Properties)Env.getCtx()));
                if ("UTF-8".equals(charaCode) && MSysConfig.getBooleanValue((String)"JP_EXPORT_CSV_WITH_BOM", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()))) {
                    fileOut.write(239);
                    fileOut.write(187);
                    fileOut.write(191);
                }
                oStrW = new OutputStreamWriter((OutputStream)fileOut, charaCode);
                BufferedWriter bw = new BufferedWriter(oStrW);
                mapWriter = new CsvMapWriter((Writer)bw, CsvPreference.STANDARD_PREFERENCE);
                GridTable gt = gridTab.getTableModel();
                GridField[] gridFields = this.getFields(gridTab);
                if (gridFields.length == 0) {
                    throw new AdempiereException(String.valueOf(gridTab.getName()) + ": Did not find any available field to be exported.");
                }
                ArrayList<String> headArray = new ArrayList<String>();
                ArrayList<Optional> procArray = new ArrayList<Optional>();
                table = MTable.get((Properties)Env.getCtx(), (String)gridTab.getTableName());
                int specialHDispayType = 0;
                int idxfld = 0;
                while (idxfld < gridFields.length) {
                    GridField field = gridFields[idxfld];
                    MColumn column = MColumn.get((Properties)Env.getCtx(), (int)field.getAD_Column_ID());
                    if (21 == field.getDisplayType()) {
                        specialHDispayType = 21;
                    } else if (field.isDisplayed() || field.isDisplayedGrid()) {
                        String headName = this.resolveColumnName(table, column, gridTab);
                        headArray.add(headName);
                        if (15 == field.getDisplayType()) {
                            procArray.add(new Optional((CellProcessor)new FmtDate("yyyy-MM-dd")));
                        } else if (16 == field.getDisplayType()) {
                            procArray.add(new Optional((CellProcessor)new FmtDate("yyyy-MM-dd HH:mm:ss")));
                        } else if (24 == field.getDisplayType()) {
                            procArray.add(new Optional((CellProcessor)new FmtDate("HH:mm:ss")));
                        } else if (11 == field.getDisplayType() || DisplayType.isNumeric((int)field.getDisplayType())) {
                            DecimalFormat nf = DisplayType.getNumberFormat((int)field.getDisplayType());
                            nf.setGroupingUsed(false);
                            procArray.add(new Optional((CellProcessor)new FmtNumber(nf)));
                        } else if (20 == field.getDisplayType()) {
                            procArray.add(new Optional((CellProcessor)new FmtBool("Y", "N")));
                        } else {
                            procArray.add(new Optional());
                        }
                    }
                    ++idxfld;
                }
                if (specialHDispayType > 0) {
                    for (String specialHeader : this.resolveSpecialColumnName(specialHDispayType)) {
                        headArray.add(String.valueOf(gridTab.getTableName()) + ">" + specialHeader);
                        procArray.add(null);
                    }
                }
                if (childs.size() > 0) {
                    int specialDetDispayType = 0;
                    for (GridTab detail : childs) {
                        if (!detail.isDisplayed() || detail.getDisplayLogic() != null && currentRowOnly && !Evaluator.evaluateLogic((Evaluatee)detail, (String)detail.getDisplayLogic()) || detail.getTabLevel() > 1) continue;
                        tableDetail = MTable.get((Properties)Env.getCtx(), (String)detail.getTableName());
                        GridField[] gridFieldArray = gridFields = this.getFields(detail);
                        int n = gridFields.length;
                        int nf = 0;
                        while (nf < n) {
                            GridField field = gridFieldArray[nf];
                            MColumn columnDetail = MColumn.get((Properties)Env.getCtx(), (int)field.getAD_Column_ID());
                            if (21 == field.getDisplayType()) {
                                specialDetDispayType = 21;
                            } else {
                                String headNameDetail = null;
                                headNameDetail = !MSysConfig.getBooleanValue((String)"JP_EXPORT_CSV_DISPLAY_VALUE", (boolean)true, (int)Env.getAD_Client_ID((Properties)Env.getCtx()), (int)Env.getAD_Org_ID((Properties)Env.getCtx())) ? String.valueOf(detail.getTableName()) + ">" + this.resolveColumnName(tableDetail, columnDetail, detail) : String.valueOf(detail.getName()) + ">" + this.resolveColumnName(tableDetail, columnDetail, detail);
                                headArray.add(headNameDetail);
                                if (15 == field.getDisplayType()) {
                                    procArray.add(new Optional((CellProcessor)new FmtDate("yyyy-MM-dd")));
                                } else if (16 == field.getDisplayType()) {
                                    procArray.add(new Optional((CellProcessor)new FmtDate("yyyy-MM-dd HH:mm:ss")));
                                } else if (24 == field.getDisplayType()) {
                                    procArray.add(new Optional((CellProcessor)new FmtDate("HH:mm:ss")));
                                } else if (11 == field.getDisplayType() || DisplayType.isNumeric((int)field.getDisplayType())) {
                                    DecimalFormat nf2 = DisplayType.getNumberFormat((int)field.getDisplayType());
                                    nf2.setGroupingUsed(false);
                                    procArray.add(new Optional((CellProcessor)new FmtNumber(nf2)));
                                } else if (20 == field.getDisplayType()) {
                                    procArray.add(new Optional((CellProcessor)new FmtBool("Y", "N")));
                                } else {
                                    procArray.add(new Optional());
                                }
                            }
                            ++nf;
                        }
                        if (specialDetDispayType > 0) {
                            for (String specialHeader : this.resolveSpecialColumnName(specialDetDispayType)) {
                                headArray.add(String.valueOf(detail.getTableName()) + ">" + specialHeader);
                                procArray.add(null);
                            }
                            specialDetDispayType = 0;
                        }
                        tabMapDetails.put(detail, gridFields);
                    }
                    gridFields = null;
                }
                String[] header = headArray.toArray(new String[headArray.size()]);
                CellProcessor[] processors = procArray.toArray(new CellProcessor[procArray.size()]);
                mapWriter.writeHeader(header);
                int start = 0;
                int end = 0;
                if (currentRowOnly) {
                    start = gridTab.getCurrentRow();
                    end = start + 1;
                } else {
                    end = gt.getRowCount();
                }
                int idxrow = start;
                while (idxrow < end) {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    int idxfld2 = 0;
                    int index = 0;
                    int rowDetail = 0;
                    int record_Id = 0;
                    gridTab.setCurrentRow(idxrow);
                    GridField[] gridFieldArray = this.getFields(gridTab);
                    int n = gridFieldArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        GridField field = gridFieldArray[n2];
                        MColumn column = MColumn.get((Properties)Env.getCtx(), (int)field.getAD_Column_ID());
                        Object value = null;
                        String headName = header[idxfld2];
                        if (21 == field.getDisplayType()) {
                            Object fResolved = this.resolveValue(gridTab, table, column, idxrow, column.getColumnName());
                            if (fResolved != null) {
                                record_Id = Integer.parseInt(fResolved.toString());
                            }
                        } else {
                            value = 200012 == field.getDisplayType() ? MRefList.getListName((Properties)Env.getCtx(), (int)195, (String)gridTab.getValue(idxrow, header[idxfld2]).toString()) : this.resolveValue(gridTab, table, column, idxrow, headName);
                            row.put(headName, value);
                            ++idxfld2;
                            ++index;
                        }
                        ++n2;
                    }
                    if (specialHDispayType > 0 && record_Id > 0) {
                        switch (specialHDispayType) {
                            case 21: {
                                MLocation address = new MLocation(Env.getCtx(), record_Id, null);
                                for (String specialHeader : this.resolveSpecialColumnName(specialHDispayType)) {
                                    String columnName = specialHeader.substring(specialHeader.indexOf(">") + 1, specialHeader.length());
                                    Object sValue = null;
                                    if (columnName.indexOf("[") >= 0 && columnName.endsWith("]")) {
                                        int indx = columnName.indexOf("[");
                                        String columnRef = columnName.substring(indx + 1, columnName.length() - 1);
                                        String tableRef = columnName.substring(0, indx);
                                        Object record_id = address.get_Value(tableRef);
                                        if (record_id != null) {
                                            sValue = this.queryExecute(columnRef, tableRef, record_id);
                                        }
                                    } else {
                                        sValue = address.get_Value(columnName);
                                        if (20 == MColumn.get((Properties)Env.getCtx(), (String)"C_Location", (String)columnName).getAD_Reference_ID()) {
                                            if (sValue != null && ((Boolean)sValue).booleanValue()) {
                                                sValue = "Y";
                                            } else if (sValue != null && !((Boolean)sValue).booleanValue()) {
                                                sValue = "N";
                                            }
                                        }
                                    }
                                    row.put(String.valueOf(gridTab.getTableName()) + ">" + specialHeader, sValue);
                                    ++idxfld2;
                                    ++index;
                                }
                                break;
                            }
                        }
                    }
                    if (childs.size() > 0) {
                        Map<String, Object> tmpRow;
                        for (GridTab childTab : childs) {
                            if (!childTab.isLoadComplete()) {
                                childTab.initTab(false);
                            }
                            childTab.query(false, 0, 0);
                        }
                        while ((tmpRow = this.resolveMasterDetailRow(rowDetail, tabMapDetails, headArray, index)) != null) {
                            for (Map.Entry<String, Object> details : tmpRow.entrySet()) {
                                String detailColumn = details.getKey();
                                Object value = details.getValue();
                                row.put(detailColumn, value);
                            }
                            ++rowDetail;
                            mapWriter.write(row, header, processors);
                        }
                    }
                    if (rowDetail == 0) {
                        mapWriter.write(row, header, processors);
                    }
                    idxfld2 = 0;
                    ++idxrow;
                }
            }
            catch (IOException e) {
                throw new AdempiereException((Throwable)e);
            }
        }
        finally {
            if (mapWriter != null) {
                try {
                    mapWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String isValidTabToExport(GridTab gridTab) {
        String result = null;
        MTab tab = MTab.get((int)gridTab.getAD_Tab_ID());
        if (tab.isReadOnly()) {
            result = Msg.getMsg((Properties)Env.getCtx(), (String)"FieldIsReadOnly", (Object[])new Object[]{gridTab.getName()});
        }
        return result;
    }

    private Map<String, Object> resolveMasterDetailRow(int currentDetRow, Map<GridTab, GridField[]> tabMapDetails, List<String> headArray, int idxfld) {
        HashMap<String, Object> activeRow = new HashMap<String, Object>();
        Object value = null;
        boolean hasDetails = false;
        int specialDetDispayType = 0;
        if (currentDetRow > 0) {
            int j = 0;
            while (j < idxfld) {
                activeRow.put(headArray.get(j), null);
                ++j;
            }
        }
        for (Map.Entry<GridTab, GridField[]> childTabDetail : tabMapDetails.entrySet()) {
            GridTab childTab = childTabDetail.getKey();
            HashMap<String, Object> row = new HashMap<String, Object>();
            if (childTab.getRowCount() > 0) {
                int specialRecordId = 0;
                GridField[] gridFieldArray = childTabDetail.getValue();
                int n = gridFieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GridField field = gridFieldArray[n2];
                    MColumn column = MColumn.get((Properties)Env.getCtx(), (int)field.getAD_Column_ID());
                    if (21 == column.getAD_Reference_ID()) {
                        specialDetDispayType = 21;
                        Object fResolved = this.resolveValue(childTab, MTable.get((Properties)Env.getCtx(), (String)childTab.getTableName()), column, currentDetRow, column.getColumnName());
                        if (fResolved != null) {
                            specialRecordId = Integer.parseInt(fResolved.toString());
                        }
                    } else {
                        MTable tableDetail = MTable.get((Properties)Env.getCtx(), (String)childTab.getTableName());
                        String headName = null;
                        headName = !MSysConfig.getBooleanValue((String)"JP_EXPORT_CSV_DISPLAY_VALUE", (boolean)true, (int)Env.getAD_Client_ID((Properties)Env.getCtx()), (int)Env.getAD_Org_ID((Properties)Env.getCtx())) ? headArray.get(headArray.indexOf(String.valueOf(childTab.getTableName()) + ">" + this.resolveColumnName(tableDetail, column, childTab))) : headArray.get(headArray.indexOf(String.valueOf(childTab.getName()) + ">" + this.resolveColumnName(tableDetail, column, childTab)));
                        value = this.resolveValue(childTab, MTable.get((Properties)Env.getCtx(), (String)childTab.getTableName()), column, currentDetRow, headName.substring(headName.indexOf(">") + 1, headName.length()));
                        if (200012 == field.getDisplayType() && value != null) {
                            value = MRefList.getListName((Properties)Env.getCtx(), (int)195, (String)value.toString());
                        }
                        row.put(headName, value);
                        if (value != null) {
                            hasDetails = true;
                        }
                    }
                    ++n2;
                }
                if (specialDetDispayType > 0 && specialRecordId > 0) {
                    MLocation address = new MLocation(Env.getCtx(), specialRecordId, null);
                    for (String specialHeader : this.resolveSpecialColumnName(specialDetDispayType)) {
                        String columnName = specialHeader.substring(specialHeader.indexOf(">") + 1, specialHeader.length());
                        Object sValue = null;
                        if (columnName.indexOf("[") >= 0 && columnName.endsWith("]")) {
                            int indx = columnName.indexOf("[");
                            String columnRef = columnName.substring(indx + 1, columnName.length() - 1);
                            String tableRef = columnName.substring(0, indx);
                            Object record_id = address.get_Value(tableRef);
                            if (record_id != null) {
                                sValue = this.queryExecute(columnRef, tableRef, record_id);
                            }
                        } else {
                            sValue = address.get_Value(columnName);
                            if (20 == MColumn.get((Properties)Env.getCtx(), (String)"C_Location", (String)columnName).getAD_Reference_ID()) {
                                if (sValue != null && ((Boolean)sValue).booleanValue()) {
                                    sValue = "Y";
                                } else if (sValue != null && !((Boolean)sValue).booleanValue()) {
                                    sValue = "N";
                                }
                            }
                        }
                        row.put(String.valueOf(childTab.getTableName()) + ">" + specialHeader, sValue);
                    }
                }
            }
            activeRow.putAll(row);
        }
        if (hasDetails) {
            return activeRow;
        }
        return null;
    }

    @Deprecated
    public String getWhereClause(GridTab childTab, GridTab parentGrid, int currentParentIndex) {
        String whereClau = null;
        String linkColumn = childTab.getLinkColumnName();
        whereClau = parentGrid.getKeyColumnName().equals(linkColumn) ? String.valueOf(linkColumn) + "=" + parentGrid.getKeyID(currentParentIndex) : String.valueOf(parentGrid.getKeyColumnName()) + "=" + parentGrid.getValue(currentParentIndex, parentGrid.getKeyColumnName());
        return whereClau;
    }

    private Object resolveValue(GridTab gridTab, MTable table, MColumn column, int i, String headName) {
        Object value = null;
        if (!MSysConfig.getBooleanValue((String)"JP_EXPORT_CSV_DISPLAY_VALUE", (boolean)true, (int)Env.getAD_Client_ID((Properties)Env.getCtx()), (int)Env.getAD_Org_ID((Properties)Env.getCtx()))) {
            if (headName.indexOf("[") >= 0 && headName.endsWith("]")) {
                String foreignTable = column.getReferenceTableName();
                Object idO = gridTab.getValue(i, column.getColumnName());
                if (idO != null) {
                    if (foreignTable.equals("AD_Ref_List")) {
                        String ref = (String)idO;
                        value = MRefList.getListName((Properties)Env.getCtx(), (int)column.getAD_Reference_Value_ID(), (String)ref);
                    } else {
                        int id = (Integer)idO;
                        int start = headName.indexOf("[") + 1;
                        int end = headName.length() - 1;
                        String foreignColumn = headName.substring(start, end);
                        StringBuilder select = new StringBuilder("SELECT ").append(foreignColumn).append(" FROM ").append(foreignTable).append(" WHERE ").append(foreignTable).append("_ID=?");
                        value = DB.getSQLValueStringEx(null, (String)select.toString(), (Object[])new Object[]{id});
                    }
                }
            } else {
                value = gridTab.getValue(i, headName);
            }
        } else {
            value = gridTab.getValue(i, column.getColumnName());
            if (value == null) {
                return null;
            }
            GridField f = gridTab.getField(column.getColumnName());
            Lookup lookup = f.getLookup();
            if (lookup != null) {
                value = lookup.getDisplay(value);
            }
        }
        return value;
    }

    private Object queryExecute(String selectColumn, String tableName, Object record_id) {
        StringBuilder select = new StringBuilder("SELECT ").append(selectColumn).append(" FROM ").append(tableName.substring(0, tableName.length() - 3)).append(" WHERE ").append(tableName).append("=?");
        return DB.getSQLValueStringEx(null, (String)select.toString(), (Object[])new Object[]{record_id});
    }

    private String resolveColumnName(MTable table, MColumn column, GridTab gridTab) {
        if (!MSysConfig.getBooleanValue((String)"JP_EXPORT_CSV_DISPLAY_VALUE", (boolean)true, (int)Env.getAD_Client_ID((Properties)Env.getCtx()), (int)Env.getAD_Org_ID((Properties)Env.getCtx()))) {
            StringBuilder name = new StringBuilder(column.getColumnName());
            if (DisplayType.isLookup((int)column.getAD_Reference_ID())) {
                String foreignTable = column.getReferenceTableName();
                if ("AD_EntityType".equals(foreignTable) && "AD_EntityType_ID".equals(column.getColumnName())) {
                    name.append("[EntityType]");
                } else if (!("AD_Language".equals(foreignTable) || "AD_EntityType".equals(foreignTable) || "AD_Ref_List".equals(foreignTable))) {
                    MTable fTable = MTable.get((Properties)Env.getCtx(), (String)foreignTable);
                    if ("AD_Element".equals(foreignTable)) {
                        name.append("[ColumnName]");
                    } else if (!"AD_Org".equals(foreignTable) && !"AD_User".equals(foreignTable) && fTable.getColumn("Value") != null) {
                        name.append("[Value]");
                    } else if (fTable.getColumn("Name") != null) {
                        name.append("[Name]");
                    } else if (fTable.getColumn("DocumentNo") != null) {
                        name.append("[DocumentNo]");
                    }
                }
            } else if (25 == column.getAD_Reference_ID()) {
                name.append("[Combination]");
            }
            return name.toString();
        }
        return MField.get((int)gridTab.getField(column.getColumnName()).getAD_Field_ID()).get_Translation("Name");
    }

    private ArrayList<String> resolveSpecialColumnName(int displayType) {
        ArrayList<String> specialColumnNames = new ArrayList<String>();
        if (21 == displayType) {
            GridWindowVO gWindowVO = Env.getMWindowVO((int)0, (int)121, (int)0);
            GridWindow m_mWindow = new GridWindow(gWindowVO);
            GridTab m_mTab = m_mWindow.getTab(0);
            m_mWindow.initTab(0);
            GridField[] gridFieldArray = m_mTab.getFields();
            int n = gridFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                GridField locField = gridFieldArray[n2];
                if (!"AD_Client_ID".equals(locField.getColumnName()) && !"AD_Org_ID".equals(locField.getColumnName()) && !"IsActive".equals(locField.getColumnName()) && locField.isDisplayed()) {
                    String fName = this.resolveColumnName(MTable.get((Properties)Env.getCtx(), (String)m_mTab.getTableName()), MColumn.get((Properties)Env.getCtx(), (int)locField.getAD_Column_ID()), m_mTab);
                    specialColumnNames.add(String.valueOf(m_mTab.getTableName()) + ">" + fName);
                }
                ++n2;
            }
        }
        return specialColumnNames;
    }

    public String getFileExtension() {
        return "csv";
    }

    public String getFileExtensionLabel() {
        return Msg.getMsg((Properties)Env.getCtx(), (String)"FileCSV");
    }

    public String getContentType() {
        return "application/csv";
    }

    private GridField[] getFields(GridTab gridTab) {
        GridTable tableModel = gridTab.getTableModel();
        GridField[] tmpFields = tableModel.getFields();
        MTabCustomization tabCustomization = MTabCustomization.get((Properties)Env.getCtx(), (int)Env.getAD_User_ID((Properties)Env.getCtx()), (int)gridTab.getAD_Tab_ID(), null);
        GridField[] gridFields = null;
        if (tabCustomization != null && tabCustomization.getAD_Tab_Customization_ID() > 0 && !Util.isEmpty((String)tabCustomization.getCustom(), (boolean)true)) {
            String custom = tabCustomization.getCustom().trim();
            String[] customComponent = custom.split(";");
            String[] fieldIds = customComponent[0].split("[,]");
            ArrayList<GridField> fieldList = new ArrayList<GridField>();
            String[] stringArray = fieldIds;
            int n = fieldIds.length;
            int n2 = 0;
            while (n2 < n) {
                String fieldIdStr = stringArray[n2];
                if ((fieldIdStr = fieldIdStr.trim()).length() != 0) {
                    int AD_Field_ID = Integer.parseInt(fieldIdStr);
                    GridField[] gridFieldArray = tmpFields;
                    int n3 = tmpFields.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        GridField gridField = gridFieldArray[n4];
                        if (!(gridField.getAD_Field_ID() != AD_Field_ID || gridField.isVirtualColumn() || gridField.isEncrypted() || gridField.isEncryptedColumn() || !gridField.isDisplayed() && !gridField.isDisplayedGrid() || 28 == MColumn.get((Properties)Env.getCtx(), (int)gridField.getAD_Column_ID()).getAD_Reference_ID())) {
                            fieldList.add(gridField);
                            break;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            gridFields = fieldList.toArray(new GridField[0]);
        } else {
            ArrayList<GridField> gridFieldList = new ArrayList<GridField>();
            GridField[] gridFieldArray = tmpFields;
            int n = tmpFields.length;
            int n5 = 0;
            while (n5 < n) {
                GridField field = gridFieldArray[n5];
                if (!("AD_Client_ID".equals(field.getColumnName()) || 28 == MColumn.get((Properties)Env.getCtx(), (int)field.getAD_Column_ID()).getAD_Reference_ID() || field.isVirtualColumn() || field.isEncrypted() || field.isEncryptedColumn() || !field.isDisplayed() && !field.isDisplayedGrid() || !field.isParentValue() && !field.isDisplayedGrid() && !field.isParentColumn())) {
                    gridFieldList.add(field);
                }
                ++n5;
            }
            Collections.sort(gridFieldList, new Comparator<GridField>(){

                @Override
                public int compare(GridField o1, GridField o2) {
                    return o1.getSeqNoGrid() - o2.getSeqNoGrid();
                }
            });
            gridFields = new GridField[gridFieldList.size()];
            gridFieldList.toArray(gridFields);
        }
        return gridFields;
    }

    public String getSuggestedFileName(GridTab gridTab) {
        return "Export_" + gridTab.getTableName() + "." + this.getFileExtension();
    }

    public boolean isExportableTab(GridTab detail) {
        if (!detail.isDisplayed()) {
            return false;
        }
        if (detail.getTabLevel() > 1) {
            return false;
        }
        return this.isValidTabToExport(detail) == null;
    }
}

