/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.I_JP_PP_PlanLine;
import org.compiere.model.MClient;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUOM;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class PPPlanLineModelValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(PPPlanLineModelValidator.class);
    private int AD_Client_ID = -1;
    private static final String JP_PP_UOM_STDPRECISION = "JP_PP_UOM_STDPRECISION";
    private static final boolean IS_USE_MODEL_CLASS_FOR_UPDATE_PARENT = false;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("JP_PP_PlanLine", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        I_JP_PP_PlanLine i_PO;
        if ((type == 4 || type == 5 || type == 6) && po instanceof I_JP_PP_PlanLine && (type != 5 || po.is_ValueChanged("PlannedQty")) && (i_PO = (I_JP_PP_PlanLine)po).isEndProduct()) {
            String sql;
            BigDecimal JP_MovementQtyFact;
            BigDecimal movementQty;
            MUOM uom;
            boolean isStdPrecision;
            block8: {
                isStdPrecision = MSysConfig.getBooleanValue((String)JP_PP_UOM_STDPRECISION, (boolean)true, (int)this.getAD_Client_ID(), (int)i_PO.getAD_Org_ID());
                uom = MUOM.get((int)i_PO.getC_UOM_ID());
                movementQty = Env.ZERO;
                JP_MovementQtyFact = Env.ZERO;
                sql = " SELECT COALESCE(SUM(MovementQty),0) ,COALESCE(SUM(JP_MovementQtyFact),0) FROM JP_PP_PlanLine WHERE JP_PP_Plan_ID=? AND IsEndProduct='Y' AND IsActive='Y' ";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, (String)po.get_TrxName());
                        pstmt.setInt(1, i_PO.getJP_PP_Plan_ID());
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            movementQty = rs.getBigDecimal(1);
                            JP_MovementQtyFact = rs.getBigDecimal(2);
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, sql, (Throwable)e);
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            movementQty = movementQty.setScale(isStdPrecision ? uom.getStdPrecision() : uom.getCostingPrecision(), RoundingMode.HALF_UP);
            JP_MovementQtyFact = JP_MovementQtyFact.setScale(isStdPrecision ? uom.getStdPrecision() : uom.getCostingPrecision(), RoundingMode.HALF_UP);
            sql = "UPDATE JP_PP_Plan SET NAME = JP_NAME || ' [' || ? || '/' || ? || ']' WHERE JP_PP_Plan_ID=?";
            int no = DB.executeUpdate((String)sql, (Object[])new Object[]{JP_MovementQtyFact, movementQty, i_PO.getJP_PP_Plan_ID()}, (boolean)false, (String)po.get_TrxName(), (int)0);
            if (no != 1) {
                log.saveError("DBExecuteError", "PPPlanLineModelValidator -> modelChange() -> UpdateSQL");
                return String.valueOf(Msg.getMsg((Properties)po.getCtx(), (String)"DBExecuteError")) + "PPPlanLineModelValidator -> modelChange() -> UpdateSQL";
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        return null;
    }
}

