/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Properties;
import jpiere.base.plugin.org.adempiere.model.I_JP_PP_Fact;
import jpiere.base.plugin.org.adempiere.model.I_JP_PP_Plan;
import org.compiere.model.MClient;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MUOM;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class PPFactModelValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(PPFactModelValidator.class);
    private int AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("JP_PP_Fact", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        if (type == 5 && po.is_ValueChanged("DocStatus") && po instanceof I_JP_PP_Fact) {
            I_JP_PP_Fact i_PO = (I_JP_PP_Fact)po;
            String sql = "UPDATE JP_PP_Plan p SET NAME = p.JP_NAME || ' [' || (SELECT COALESCE(SUM(fl.MovementQty),0) FROM JP_PP_FactLine fl  INNER JOIN JP_PP_Fact f ON (fl.JP_PP_Fact_ID = f.JP_PP_Fact_ID)   WHERE f.JP_PP_Plan_ID=? AND f.DocStatus in ('CO','CL') AND fl.IsEndProduct='Y')  || '/' || ? || ']'  WHERE p.JP_PP_Plan_ID=?";
            MTable m_table_PPPlan = MTable.get((Properties)po.getCtx(), (String)"JP_PP_Plan");
            I_JP_PP_Plan pp = (I_JP_PP_Plan)m_table_PPPlan.getPO(i_PO.getJP_PP_Plan_ID(), po.get_TrxName());
            BigDecimal productionQtyPlan = pp.getProductionQty();
            boolean isStdPrecision = MSysConfig.getBooleanValue((String)"JP_PP_UOM_STDPRECISION", (boolean)true, (int)i_PO.getAD_Client_ID(), (int)i_PO.getAD_Org_ID());
            MUOM uom = MUOM.get((int)i_PO.getC_UOM_ID());
            productionQtyPlan = productionQtyPlan.setScale(isStdPrecision ? uom.getStdPrecision() : uom.getCostingPrecision(), RoundingMode.HALF_UP);
            int no = DB.executeUpdate((String)sql, (Object[])new Object[]{i_PO.getJP_PP_Plan_ID(), productionQtyPlan, i_PO.getJP_PP_Plan_ID()}, (boolean)false, (String)po.get_TrxName(), (int)0);
            if (no != 1) {
                log.saveError("DBExecuteError", "PPFactModelValidator -> modelChange()");
                return String.valueOf(Msg.getMsg((Properties)po.getCtx(), (String)"DBExecuteError")) + "PPFactModelValidator -> modelChange()";
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        return null;
    }
}

