/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.io.File;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Properties;
import jpiere.base.plugin.org.adempiere.model.MWFAutoAddApprovers;
import jpiere.base.plugin.org.adempiere.model.MWFAutoAddUser;
import jpiere.base.plugin.org.adempiere.model.MWFAutoForward;
import org.compiere.model.MClient;
import org.compiere.model.MMailText;
import org.compiere.model.MNote;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.MUserRoles;
import org.compiere.model.MWFActivityApprover;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.process.DocAction;
import org.compiere.util.CLogger;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.wf.MWFActivity;
import org.compiere.wf.MWFEventAudit;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFResponsible;

public class JPiereWFActivityModelValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(JPiereWFActivityModelValidator.class);
    private int AD_Client_ID = -1;
    public static final String IS_PROCESSED_APPROVAL_REQUEST = "IsProcessedApprovalRequestJP";

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("AD_WF_Activity", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        MWFAutoAddApprovers approvers;
        MWFNode node;
        MWFActivity wfa;
        if (type == 1 || type == 2) {
            wfa = (MWFActivity)po;
            node = MWFNode.get((int)wfa.getAD_WF_Node_ID());
            if (("C".equals(node.getAction()) || "W".equals(node.getAction())) && wfa.getAD_User_ID() != 0 && !wfa.isProcessed() && "OS".equals(wfa.getWFState())) {
                MWFAutoForward autoForward = null;
                if (type == 1) {
                    autoForward = MWFAutoForward.get(wfa);
                } else if (type == 2) {
                    LocalDateTime localDateTime = LocalDateTime.now();
                    autoForward = MWFAutoForward.get(wfa.getAD_Client_ID(), wfa.getAD_User_ID(), wfa.getAD_WF_Node_ID(), wfa.getAD_Org_ID(), Timestamp.valueOf(localDateTime), wfa.get_TrxName());
                }
                if (autoForward != null) {
                    if (MSysConfig.getBooleanValue((String)"JP_WF_AUTO_FORWARD_LOG", (boolean)true, (int)wfa.getAD_Client_ID(), (int)wfa.getAD_Org_ID())) {
                        MWFEventAudit eventLog = new MWFEventAudit(wfa);
                        eventLog.setEventType("SC");
                        eventLog.setWFState("OS");
                        eventLog.setAttributeName("Auto Forward - AD_WF_Activity");
                        eventLog.setOldValue(MUser.getNameOfUser((int)wfa.getAD_User_ID()));
                        eventLog.setNewValue(MUser.getNameOfUser((int)autoForward.getJP_WF_User_To_ID()));
                        eventLog.setDescription(Msg.getElement((Properties)wfa.getCtx(), (String)"JP_WF_AutoForward_ID"));
                        eventLog.saveEx(po.get_TrxName());
                    }
                    wfa.setAD_User_ID(autoForward.getJP_WF_User_To_ID());
                }
                if (wfa.get_ColumnIndex(IS_PROCESSED_APPROVAL_REQUEST) >= 0 && !wfa.get_ValueAsBoolean(IS_PROCESSED_APPROVAL_REQUEST)) {
                    JPiereWFActivityModelValidator.sendApprovalRequestNotification(po.getCtx(), wfa, wfa.getAD_User_ID(), null, po.get_TrxName());
                    wfa.set_ValueNoCheck(IS_PROCESSED_APPROVAL_REQUEST, (Object)"Y");
                }
            }
            if ("R".equals(MWFResponsible.get((int)node.getAD_WF_Responsible_ID()).getResponsibleType()) && !wfa.isProcessed() && "OS".equals(wfa.getWFState()) && wfa.get_ColumnIndex(IS_PROCESSED_APPROVAL_REQUEST) >= 0 && !wfa.get_ValueAsBoolean(IS_PROCESSED_APPROVAL_REQUEST)) {
                MUserRoles[] userRoles;
                MWFResponsible wfr = MWFResponsible.get((int)node.getAD_WF_Responsible_ID());
                MUserRoles[] mUserRolesArray = userRoles = MUserRoles.getOfRole((Properties)po.getCtx(), (int)wfr.getAD_Role_ID());
                int n = userRoles.length;
                int n2 = 0;
                while (n2 < n) {
                    MUserRoles userRole = mUserRolesArray[n2];
                    JPiereWFActivityModelValidator.sendApprovalRequestNotification(po.getCtx(), wfa, userRole.getAD_User_ID(), null, po.get_TrxName());
                    ++n2;
                }
                wfa.set_ValueNoCheck(IS_PROCESSED_APPROVAL_REQUEST, (Object)"Y");
            }
        }
        if (type == 4 && ("C".equals((node = MWFNode.get((int)(wfa = (MWFActivity)po).getAD_WF_Node_ID())).getAction()) || "W".equals(node.getAction())) && (approvers = MWFAutoAddApprovers.get(wfa)) != null) {
            MWFAutoAddUser[] users = approvers.getAutoAddUsers(false);
            MWFActivityApprover wfApprover = null;
            MWFAutoForward autoForward = null;
            ArrayList<Integer> list_AD_User_ID = new ArrayList<Integer>();
            MWFAutoAddUser[] mWFAutoAddUserArray = users;
            int n = users.length;
            int n3 = 0;
            while (n3 < n) {
                MWFAutoAddUser user = mWFAutoAddUserArray[n3];
                wfApprover = new MWFActivityApprover(po.getCtx(), 0, po.get_TrxName());
                wfApprover.setAD_Org_ID(wfa.getAD_Org_ID());
                wfApprover.setAD_WF_Activity_ID(wfa.getAD_WF_Activity_ID());
                autoForward = MWFAutoForward.get(wfa.getAD_Client_ID(), user.getAD_User_ID(), wfa.getAD_WF_Node_ID(), wfa.getAD_Org_ID(), wfa.getCreated(), wfa.get_TrxName());
                if (autoForward != null) {
                    boolean isSkeip = false;
                    for (Integer AD_User_ID : list_AD_User_ID) {
                        if (autoForward.getJP_WF_User_To_ID() != AD_User_ID.intValue()) continue;
                        isSkeip = true;
                        if (!MSysConfig.getBooleanValue((String)"JP_WF_AUTO_FORWARD_LOG", (boolean)true, (int)wfa.getAD_Client_ID(), (int)wfa.getAD_Org_ID())) break;
                        MWFEventAudit eventLog = new MWFEventAudit(wfa);
                        eventLog.setEventType("SC");
                        eventLog.setWFState("OS");
                        eventLog.setAttributeName("Auto Forward - AD_WF_ActivityApprover - Skip - Duplicate");
                        eventLog.setOldValue(MUser.getNameOfUser((int)user.getAD_User_ID()));
                        eventLog.setNewValue(MUser.getNameOfUser((int)autoForward.getJP_WF_User_To_ID()));
                        eventLog.setDescription(Msg.getElement((Properties)wfa.getCtx(), (String)"JP_WF_AutoForward_ID"));
                        eventLog.saveEx(po.get_TrxName());
                        break;
                    }
                    if (!isSkeip) {
                        if (MSysConfig.getBooleanValue((String)"JP_WF_AUTO_FORWARD_LOG", (boolean)true, (int)wfa.getAD_Client_ID(), (int)wfa.getAD_Org_ID())) {
                            MWFEventAudit eventLog = new MWFEventAudit(wfa);
                            eventLog.setEventType("SC");
                            eventLog.setWFState("OS");
                            eventLog.setAttributeName("Auto Forward - AD_WF_ActivityApprover");
                            eventLog.setOldValue(MUser.getNameOfUser((int)user.getAD_User_ID()));
                            eventLog.setNewValue(MUser.getNameOfUser((int)autoForward.getJP_WF_User_To_ID()));
                            eventLog.setDescription(Msg.getElement((Properties)wfa.getCtx(), (String)"JP_WF_AutoForward_ID"));
                            eventLog.saveEx(po.get_TrxName());
                        }
                        wfApprover.setAD_User_ID(autoForward.getJP_WF_User_To_ID());
                        if (wfApprover.get_ColumnIndex(IS_PROCESSED_APPROVAL_REQUEST) >= 0 && !wfApprover.get_ValueAsBoolean(IS_PROCESSED_APPROVAL_REQUEST)) {
                            JPiereWFActivityModelValidator.sendAdditinalApprovalRequestNotification(po.getCtx(), wfa, wfApprover, null, po.get_TrxName());
                            wfApprover.set_ValueNoCheck(IS_PROCESSED_APPROVAL_REQUEST, (Object)"Y");
                        }
                        wfApprover.saveEx(po.get_TrxName());
                        list_AD_User_ID.add(wfApprover.getAD_User_ID());
                    }
                } else {
                    wfApprover.setAD_User_ID(user.getAD_User_ID());
                    if (wfApprover.get_ColumnIndex(IS_PROCESSED_APPROVAL_REQUEST) >= 0 && !wfApprover.get_ValueAsBoolean(IS_PROCESSED_APPROVAL_REQUEST)) {
                        JPiereWFActivityModelValidator.sendAdditinalApprovalRequestNotification(po.getCtx(), wfa, wfApprover, null, po.get_TrxName());
                        wfApprover.set_ValueNoCheck(IS_PROCESSED_APPROVAL_REQUEST, (Object)"Y");
                    }
                    wfApprover.saveEx(po.get_TrxName());
                    list_AD_User_ID.add(wfApprover.getAD_User_ID());
                }
                ++n3;
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        return null;
    }

    public static boolean sendApprovalRequestNotification(Properties ctx, MWFActivity m_WFActivity, int AD_User_ID, String comments, String trxName) {
        if (m_WFActivity == null || AD_User_ID < 0) {
            return false;
        }
        MUser user = MUser.get((Properties)ctx, (int)AD_User_ID);
        MWFNode m_node = MWFNode.get((int)m_WFActivity.getAD_WF_Node_ID());
        if (user.isNotificationEMail()) {
            JPiereWFActivityModelValidator.sendEMail(ctx, m_node, m_WFActivity, user, comments, trxName);
        }
        if (user.isNotificationNote()) {
            JPiereWFActivityModelValidator.createNote(ctx, m_node, m_WFActivity, user, comments, trxName);
        }
        return true;
    }

    public static boolean sendAdditinalApprovalRequestNotification(Properties ctx, MWFActivity m_WFActivity, MWFActivityApprover approver, String comments, String trxName) {
        if (m_WFActivity == null || approver == null) {
            return false;
        }
        MUser user = MUser.get((Properties)ctx, (int)approver.getAD_User_ID());
        MWFNode m_node = MWFNode.get((int)m_WFActivity.getAD_WF_Node_ID());
        if (user.isNotificationEMail()) {
            JPiereWFActivityModelValidator.sendEMail(ctx, m_node, m_WFActivity, user, comments, trxName);
        }
        if (user.isNotificationNote()) {
            JPiereWFActivityModelValidator.createNote(ctx, m_node, m_WFActivity, user, comments, trxName);
        }
        return true;
    }

    private static void sendEMail(Properties ctx, MWFNode m_node, MWFActivity m_WFActivity, MUser m_User, String comments, String trxName) {
        if (m_node == null || m_node.getR_MailText_ID() <= 0 || Util.isEmpty((String)m_User.getEMail())) {
            return;
        }
        MClient client = MClient.get((Properties)ctx, (int)m_WFActivity.getAD_Client_ID());
        if (Util.isEmpty((String)client.getRequestEMail()) || client.isSmtpAuthorization() && Util.isEmpty((String)client.getRequestUserPW())) {
            return;
        }
        MMailText text = new MMailText(ctx, m_node.getR_MailText_ID(), trxName);
        PO m_po = MTable.get((int)m_WFActivity.getAD_Table_ID()).getPO(m_WFActivity.getRecord_ID(), trxName);
        text.setPO(m_po, true);
        String subject = null;
        String message = null;
        File pdf = null;
        if (m_po instanceof DocAction) {
            DocAction doc = (DocAction)m_po;
            subject = String.valueOf(doc.getDocumentInfo()) + ": " + text.getMailHeader();
            message = text.getMailText(true);
        } else {
            subject = text.getMailHeader();
            message = text.getMailText(true);
        }
        if (!Util.isEmpty((String)comments)) {
            message = String.valueOf(message) + "\n\n--- " + Msg.getElement((Properties)ctx, (String)"Comments") + " ---\n" + comments;
        }
        client.sendEMail(null, m_User, subject, message, pdf, text.isHtml());
    }

    private static void createNote(Properties ctx, MWFNode m_node, MWFActivity m_WFActivity, MUser m_User, String comments, String trxName) {
        if (m_node == null || m_node.getR_MailText_ID() <= 0) {
            return;
        }
        MMailText text = new MMailText(ctx, m_node.getR_MailText_ID(), trxName);
        PO m_po = MTable.get((int)m_WFActivity.getAD_Table_ID()).getPO(m_WFActivity.getRecord_ID(), trxName);
        text.setPO(m_po, true);
        MNote note = new MNote(ctx, "JP_WFApprovalRequest", m_User.getAD_User_ID(), trxName);
        String subject = null;
        String message = null;
        if (m_po instanceof DocAction) {
            DocAction doc = (DocAction)m_po;
            subject = String.valueOf(doc.getDocumentInfo()) + ": " + text.getMailHeader();
            message = text.getMailText(true);
        } else {
            subject = text.getMailHeader();
            message = text.getMailText(true);
        }
        if (!Util.isEmpty((String)comments)) {
            message = String.valueOf(message) + "\n\n--- " + Msg.getElement((Properties)ctx, (String)"Comments") + " ---\n" + comments;
        }
        note.setAD_WF_Activity_ID(m_WFActivity.getAD_WF_Activity_ID());
        note.setReference(subject);
        note.setTextMsg(message);
        note.setRecord(m_WFActivity.getAD_Table_ID(), m_WFActivity.getRecord_ID());
        note.saveEx();
    }
}

