/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.util.JPierePaymentTerms;
import org.compiere.model.MClient;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class JPierePaymentTermModelValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(JPierePaymentTermModelValidator.class);
    private int AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("C_PaymentTerm", (ModelValidator)this);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Initialize JPierePaymentTermModelValidator");
        }
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        if (type == 1 || type == 2) {
            MPaymentTerm paymentTerm = (MPaymentTerm)po;
            Integer JP_PaymentTerms_ID = (Integer)paymentTerm.get_Value("JP_PaymentTerms_ID");
            if (JP_PaymentTerms_ID == null || JP_PaymentTerms_ID == 0) {
                return null;
            }
            if (!paymentTerm.isDueFixed()) {
                return Msg.getMsg((Properties)paymentTerm.getCtx(), (String)"JP_PaymentTermsBlank_DueFixedOff");
            }
            Boolean IsPaymentTerms = (Boolean)paymentTerm.get_Value("IsPaymentTermsJP");
            if (IsPaymentTerms.booleanValue()) {
                return Msg.getMsg((Properties)paymentTerm.getCtx(), (String)"JP_PaymentTermsBlank_DPaymentTermsOff");
            }
            MPaymentTerm[] paymentTerms = JPierePaymentTerms.getPaymentTerms(Env.getCtx(), JP_PaymentTerms_ID);
            int i = 0;
            while (i < paymentTerms.length) {
                if (paymentTerm.getFixMonthCutoff() == paymentTerms[i].getFixMonthCutoff() && paymentTerm.getC_PaymentTerm_ID() != paymentTerms[i].getC_PaymentTerm_ID()) {
                    return Msg.getMsg((Properties)paymentTerm.getCtx(), (String)"JP_SameCondition_SamePaymeTerms");
                }
                ++i;
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        return null;
    }
}

