/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.FactsValidator;
import org.compiere.model.I_C_Payment;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBankAccount;
import org.compiere.model.MClient;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class JPierePaymentModelValidator
implements ModelValidator,
FactsValidator {
    private static CLogger log = CLogger.getCLogger(JPierePaymentModelValidator.class);
    private int AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("C_Payment", (ModelValidator)this);
        engine.addDocValidate("C_Payment", (ModelValidator)this);
        engine.addFactsValidate("C_Payment", (FactsValidator)this);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Initialize JPierePaymentModelValidator");
        }
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        if (type == 1 || type == 2) {
            MPayment payment = (MPayment)po;
            MBankAccount ba = MBankAccount.get((Properties)payment.getCtx(), (int)payment.getC_BankAccount_ID());
            if (payment.getAD_Org_ID() != ba.getAD_Org_ID()) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"C_BankAccount_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"AD_Org_ID");
                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"C_Payment_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"AD_Org_ID");
                return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1});
            }
            if (payment.getC_Currency_ID() != ba.getC_Currency_ID()) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"C_BankAccount_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"C_Currency_ID");
                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"C_Payment_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"C_Currency_ID");
                return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1});
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        MPayment payment;
        if ((timing == 2 || timing == 6 || timing == 5 || timing == 10 || timing == 14 || timing == 13) && (payment = (MPayment)po).isReconciled()) {
            return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_PaymentWrittenBankStatement");
        }
        return null;
    }

    public String factsValidate(MAcctSchema schema, List<Fact> facts, PO po) {
        if (po instanceof I_C_Payment) {
            I_C_Payment i_Payment = (I_C_Payment)po;
            for (Fact fact : facts) {
                FactLine[] factLine = fact.getLines();
                int i = 0;
                while (i < factLine.length) {
                    factLine[i].set_ValueNoCheck("JP_Payment_ID", (Object)i_Payment.getC_Payment_ID());
                    if (i_Payment.getC_BankAccount_ID() > 0) {
                        factLine[i].set_ValueNoCheck("JP_BankAccount_ID", (Object)i_Payment.getC_BankAccount_ID());
                    }
                    if (i_Payment.getC_Charge_ID() > 0) {
                        factLine[i].set_ValueNoCheck("JP_Charge_ID", (Object)i_Payment.getC_Charge_ID());
                    }
                    ++i;
                }
            }
        }
        return null;
    }
}

