/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MOrder;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class JPiereMovementModelValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(JPiereMovementModelValidator.class);
    private int AD_Client_ID = -1;
    private static final String IsRecordRouteJP = "IsRecordRouteJP";
    private static final String JP_WarehouseFrom_ID = "JP_WarehouseFrom_ID";
    private static final String JP_PhysicalWarehouseFrom_ID = "JP_PhysicalWarehouseFrom_ID";
    private static final String JP_WarehouseTo_ID = "JP_WarehouseTo_ID";
    private static final String JP_PhysicalWarehouseTo_ID = "JP_PhysicalWarehouseTo_ID";
    private static final String JP_WarehouseNext_ID = "JP_WarehouseNext_ID";
    private static final String JP_PhysicalWarehouseNext_ID = "JP_PhysicalWarehouseNext_ID";
    private static final String JP_MovementDateNext = "JP_MovementDateNext";
    private static final String JP_WarehouseDep_ID = "JP_WarehouseDep_ID";
    private static final String JP_PhysicalWarehouseDep_ID = "JP_PhysicalWarehouseDep_ID";
    private static final String JP_MovementDateDep = "JP_MovementDateDep";
    private static final String JP_WarehouseDst_ID = "JP_WarehouseDst_ID";
    private static final String JP_PhysicalWarehouseDst_ID = "JP_PhysicalWarehouseDst_ID";
    private static final String JP_MovementDateDst = "JP_MovementDateDst";
    private static final String JP_MovementPre_ID = "JP_MovementPre_ID";
    private static final String JP_MovementNext_ID = "JP_MovementNext_ID";

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("M_Movement", (ModelValidator)this);
        engine.addDocValidate("M_Movement", (ModelValidator)this);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Initialize JPiereMovementModelValidator");
        }
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        if (!(type != 1 && type != 2 || po.get_ValueAsBoolean(IsRecordRouteJP))) {
            po.set_ValueNoCheck(JP_WarehouseDep_ID, null);
            po.set_ValueNoCheck(JP_PhysicalWarehouseDep_ID, null);
            po.set_ValueNoCheck(JP_MovementDateDep, null);
            po.set_ValueNoCheck(JP_WarehouseDst_ID, null);
            po.set_ValueNoCheck(JP_PhysicalWarehouseDst_ID, null);
            po.set_ValueNoCheck(JP_MovementDateDst, null);
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        block39: {
            MOrder order;
            int JP_Order_ID;
            if (timing == 3 && po instanceof MMovement && (JP_Order_ID = po.get_ValueAsInt("JP_Order_ID")) > 0 && !(order = new MOrder(po.getCtx(), JP_Order_ID, po.get_TrxName())).getDocStatus().equals("CL")) {
                return Msg.getMsg((Properties)po.getCtx(), (String)"JP_Order_MM_CloseCheck");
            }
            if (timing == 1 && po.get_ValueAsBoolean(IsRecordRouteJP)) {
                String msg0;
                MMovementLine line;
                ResultSet rs;
                CPreparedStatement pstmt;
                String sql;
                StringBuffer sb;
                int int_PhysicalWarehouseTo_ID;
                MMovement mm;
                block37: {
                    int int_WarehouseTo_ID;
                    block35: {
                        int int_PhysicalWarehouseFrom_ID;
                        block33: {
                            mm = (MMovement)po;
                            int int_WarehouseFrom_ID = mm.get_ValueAsInt(JP_WarehouseFrom_ID);
                            int_PhysicalWarehouseFrom_ID = mm.get_ValueAsInt(JP_PhysicalWarehouseFrom_ID);
                            int_WarehouseTo_ID = mm.get_ValueAsInt(JP_WarehouseTo_ID);
                            int_PhysicalWarehouseTo_ID = mm.get_ValueAsInt(JP_PhysicalWarehouseTo_ID);
                            sb = new StringBuffer();
                            if (int_WarehouseFrom_ID != 0) {
                                sql = "SELECT * FROM M_MovementLine ml INNER JOIN M_Locator loc ON (ml.M_Locator_ID = loc.M_Locator_ID)  WHERE M_Movement_ID = ? AND loc.M_Warehouse_ID <> ? ORDER BY ml.line";
                                pstmt = null;
                                rs = null;
                                try {
                                    pstmt = DB.prepareStatement((String)sql, (String)mm.get_TrxName());
                                    pstmt.setInt(1, mm.getM_Movement_ID());
                                    pstmt.setInt(2, int_WarehouseFrom_ID);
                                    rs = pstmt.executeQuery();
                                    while (rs.next()) {
                                        line = new MMovementLine(mm.getCtx(), rs, mm.get_TrxName());
                                        sb.append(line.getLine()).append(" / ");
                                    }
                                    if (!Util.isEmpty((String)sb.toString())) {
                                        msg0 = Msg.getElement((Properties)Env.getCtx(), (String)JP_WarehouseFrom_ID);
                                        String msg1 = Msg.getElement((Properties)Env.getCtx(), (String)"M_Locator_ID");
                                        String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1});
                                        String string = String.valueOf(msg) + Msg.getElement((Properties)mm.getCtx(), (String)"Line") + " : " + sb.toString();
                                        DB.close((ResultSet)rs, (Statement)pstmt);
                                        rs = null;
                                        pstmt = null;
                                        return string;
                                    }
                                }
                                catch (Exception e) {
                                    log.log(Level.SEVERE, sql, (Throwable)e);
                                    break block33;
                                }
                                finally {
                                    DB.close(rs, (Statement)pstmt);
                                    rs = null;
                                    pstmt = null;
                                }
                                DB.close((ResultSet)rs, (Statement)pstmt);
                                rs = null;
                                pstmt = null;
                            }
                        }
                        if (int_PhysicalWarehouseFrom_ID != 0) {
                            sql = "SELECT * FROM M_MovementLine ml INNER JOIN M_Locator loc ON (ml.M_Locator_ID = loc.M_Locator_ID)  WHERE M_Movement_ID = ? AND loc.JP_PhysicalWarehouse_ID <> ? ORDER BY ml.line";
                            pstmt = null;
                            rs = null;
                            try {
                                pstmt = DB.prepareStatement((String)sql, (String)mm.get_TrxName());
                                pstmt.setInt(1, mm.getM_Movement_ID());
                                pstmt.setInt(2, int_PhysicalWarehouseFrom_ID);
                                rs = pstmt.executeQuery();
                                while (rs.next()) {
                                    line = new MMovementLine(mm.getCtx(), rs, mm.get_TrxName());
                                    sb.append(line.getLine()).append(" / ");
                                }
                                if (!Util.isEmpty((String)sb.toString())) {
                                    msg0 = Msg.getElement((Properties)Env.getCtx(), (String)JP_PhysicalWarehouseFrom_ID);
                                    String msg1 = Msg.getElement((Properties)Env.getCtx(), (String)"M_Locator_ID");
                                    String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1});
                                    String string = String.valueOf(msg) + Msg.getElement((Properties)mm.getCtx(), (String)"Line") + " : " + sb.toString();
                                    DB.close((ResultSet)rs, (Statement)pstmt);
                                    rs = null;
                                    pstmt = null;
                                    return string;
                                }
                            }
                            catch (Exception e) {
                                log.log(Level.SEVERE, sql, (Throwable)e);
                                break block35;
                            }
                            finally {
                                DB.close(rs, (Statement)pstmt);
                                rs = null;
                                pstmt = null;
                            }
                            DB.close((ResultSet)rs, (Statement)pstmt);
                            rs = null;
                            pstmt = null;
                        }
                    }
                    if (int_WarehouseTo_ID != 0) {
                        sql = "SELECT * FROM M_MovementLine ml INNER JOIN M_Locator loc ON (ml.M_LocatorTo_ID = loc.M_Locator_ID)  WHERE M_Movement_ID = ? AND loc.M_Warehouse_ID <> ? ORDER BY ml.line";
                        pstmt = null;
                        rs = null;
                        try {
                            pstmt = DB.prepareStatement((String)sql, (String)mm.get_TrxName());
                            pstmt.setInt(1, mm.getM_Movement_ID());
                            pstmt.setInt(2, int_WarehouseTo_ID);
                            rs = pstmt.executeQuery();
                            while (rs.next()) {
                                line = new MMovementLine(mm.getCtx(), rs, mm.get_TrxName());
                                sb.append(line.getLine()).append(" / ");
                            }
                            if (!Util.isEmpty((String)sb.toString())) {
                                msg0 = Msg.getElement((Properties)Env.getCtx(), (String)JP_WarehouseTo_ID);
                                String msg1 = Msg.getElement((Properties)Env.getCtx(), (String)"M_LocatorTo_ID");
                                String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1});
                                String string = String.valueOf(msg) + Msg.getElement((Properties)mm.getCtx(), (String)"Line") + " : " + sb.toString();
                                DB.close((ResultSet)rs, (Statement)pstmt);
                                rs = null;
                                pstmt = null;
                                return string;
                            }
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, sql, (Throwable)e);
                            break block37;
                        }
                        finally {
                            DB.close(rs, (Statement)pstmt);
                            rs = null;
                            pstmt = null;
                        }
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                    }
                }
                if (int_PhysicalWarehouseTo_ID != 0) {
                    block38: {
                        String string;
                        sql = "SELECT * FROM M_MovementLine ml INNER JOIN M_Locator loc ON (ml.M_LocatorTo_ID = loc.M_Locator_ID)  WHERE M_Movement_ID = ? AND loc.JP_PhysicalWarehouse_ID <> ? ORDER BY ml.line";
                        pstmt = null;
                        rs = null;
                        try {
                            pstmt = DB.prepareStatement((String)sql, (String)mm.get_TrxName());
                            pstmt.setInt(1, mm.getM_Movement_ID());
                            pstmt.setInt(2, int_PhysicalWarehouseTo_ID);
                            rs = pstmt.executeQuery();
                            while (rs.next()) {
                                line = new MMovementLine(mm.getCtx(), rs, mm.get_TrxName());
                                sb.append(line.getLine()).append(" / ");
                            }
                            if (Util.isEmpty((String)sb.toString())) break block38;
                            msg0 = Msg.getElement((Properties)Env.getCtx(), (String)JP_PhysicalWarehouseTo_ID);
                            String msg1 = Msg.getElement((Properties)Env.getCtx(), (String)"M_LocatorTo_ID");
                            String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1});
                            string = String.valueOf(msg) + Msg.getElement((Properties)mm.getCtx(), (String)"Line") + " : " + sb.toString();
                        }
                        catch (Exception e) {
                            try {
                                log.log(Level.SEVERE, sql, (Throwable)e);
                            }
                            catch (Throwable throwable) {
                                DB.close(rs, (Statement)pstmt);
                                rs = null;
                                pstmt = null;
                                throw throwable;
                            }
                            DB.close((ResultSet)rs, (Statement)pstmt);
                            rs = null;
                            pstmt = null;
                            break block39;
                        }
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        return string;
                    }
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                }
            }
        }
        return null;
    }
}

