/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Msg;

public class JPiereMatchPOModelValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(JPiereMatchPOModelValidator.class);
    private int AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("M_MatchPO", (ModelValidator)this);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Initialize JPiereMatchPOModelValidator");
        }
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        if (type == 1 || type == 2 && (po.is_ValueChanged("M_InOutLine_ID") || po.is_ValueChanged("C_OrderLine_ID") || po.is_ValueChanged("C_InvoiceLine_ID"))) {
            MOrderLine ol;
            MMatchPO matchPO = (MMatchPO)po;
            if (matchPO.getM_InOutLine_ID() > 0 && matchPO.getC_OrderLine_ID() > 0) {
                MInOutLine iol = new MInOutLine(matchPO.getCtx(), matchPO.getM_InOutLine_ID(), matchPO.get_TrxName());
                ol = new MOrderLine(matchPO.getCtx(), matchPO.getC_OrderLine_ID(), matchPO.get_TrxName());
                if (ol.getParent().getC_DocTypeTarget().getDocBaseType().equals("POO")) {
                    if (!iol.getParent().getC_DocType().getDocBaseType().equals("MMR")) {
                        return String.valueOf(Msg.getMsg((Properties)ol.getCtx(), (String)"JP_Can_Not_Match_Because_DocType")) + Msg.getMsg((Properties)ol.getCtx(), (String)"JP_API_MATCH_MMR_ONLY");
                    }
                } else if (ol.getParent().getC_DocTypeTarget().getDocBaseType().equals("SOO") && !iol.getParent().getC_DocType().getDocBaseType().equals("MMS")) {
                    return String.valueOf(Msg.getMsg((Properties)ol.getCtx(), (String)"JP_Can_Not_Match_Because_DocType")) + Msg.getMsg((Properties)ol.getCtx(), (String)"JP_APC_MATCH_MMS_ONLY");
                }
            }
            if (matchPO.getC_InvoiceLine_ID() > 0 && matchPO.getC_OrderLine_ID() > 0) {
                MInvoiceLine ivl = new MInvoiceLine(matchPO.getCtx(), matchPO.getC_InvoiceLine_ID(), matchPO.get_TrxName());
                ol = new MOrderLine(matchPO.getCtx(), matchPO.getC_OrderLine_ID(), matchPO.get_TrxName());
                if (ol.getParent().getC_DocTypeTarget().getDocBaseType().equals("POO")) {
                    if (!ivl.getParent().getC_DocTypeTarget().getDocBaseType().equals("API")) {
                        return String.valueOf(Msg.getMsg((Properties)ol.getCtx(), (String)"JP_Can_Not_Match_Because_DocType")) + Msg.getMsg((Properties)ol.getCtx(), (String)"JP_API_MATCH_MMR_ONLY");
                    }
                } else if (ol.getParent().getC_DocTypeTarget().getDocBaseType().equals("SOO") && !ivl.getParent().getC_DocTypeTarget().getDocBaseType().equals("APC")) {
                    return String.valueOf(Msg.getMsg((Properties)ol.getCtx(), (String)"JP_Can_Not_Match_Because_DocType")) + Msg.getMsg((Properties)ol.getCtx(), (String)"JP_APC_MATCH_MMS_ONLY");
                }
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        return null;
    }
}

