/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MDeliveryDays;
import jpiere.base.plugin.org.adempiere.model.MInvoiceJP;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.MSysConfig;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class JPiereInOutModelValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(JPiereInOutModelValidator.class);
    private int AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("M_InOut", (ModelValidator)this);
        engine.addDocValidate("M_InOut", (ModelValidator)this);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Initialize JPiereInOutModelValidator");
        }
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        MInOut io;
        if (type == 1 || type == 2) {
            io = (MInOut)po;
            if (io.get_Value("JP_ScheduledInOutDate") == null) {
                io.set_ValueNoCheck("JP_ScheduledInOutDate", (Object)io.getMovementDate());
            }
            if (type == 1 || type == 2 && (io.is_ValueChanged("JP_ScheduledInOutDate") || io.is_ValueChanged("C_BPartner_Location_ID") || io.is_ValueChanged("M_Warehouse_ID"))) {
                String trxName = po.get_TrxName();
                MDocType ioDocType = MDocType.get((Properties)po.getCtx(), (int)io.getC_DocType_ID());
                if (ioDocType.get_ValueAsBoolean("IsInspectionInvoiceJP") && io.getC_Order_ID() > 0) {
                    MOrder order = new MOrder(po.getCtx(), io.getC_Order_ID(), trxName);
                    MDocType orderDocType = MDocType.get((Properties)po.getCtx(), (int)order.getC_DocTypeTarget_ID());
                    if (!(orderDocType.getDocSubTypeSO().equals("WI") || orderDocType.getDocSubTypeSO().equals("WR") || orderDocType.getDocSubTypeSO().equals("PR"))) {
                        Timestamp invoiceDate = MDeliveryDays.getInvoiceDate(io, ioDocType.get_ValueAsBoolean("IsHolidayNotInspectionJP"), "JP_ScheduledInOutDate");
                        io.setDateAcct(invoiceDate);
                        if (MSysConfig.getBooleanValue((String)"JP_INSPECTION_MOVEMENTDATE", (boolean)false, (int)io.getAD_Client_ID(), (int)io.getAD_Org_ID())) {
                            io.setMovementDate(invoiceDate);
                        }
                    }
                }
            }
        }
        if ((type == 1 || po.is_ValueChanged("C_Order_ID")) && (io = (MInOut)po).getC_Order_ID() > 0) {
            MOrder order = new MOrder(po.getCtx(), io.getC_Order_ID(), po.get_TrxName());
            if (Util.isEmpty((String)io.get_ValueAsString("JP_Subject"))) {
                io.set_ValueNoCheck("JP_Subject", (Object)order.get_ValueAsString("JP_Subject"));
            }
            if (Util.isEmpty((String)io.getDescription())) {
                io.setDescription(order.getDescription());
            }
            if (Util.isEmpty((String)io.get_ValueAsString("JP_Remarks"))) {
                io.set_ValueNoCheck("JP_Remarks", (Object)order.get_ValueAsString("JP_Remarks"));
            }
            if (Util.isEmpty((String)io.get_ValueAsString("JP_CommunicationColumn"))) {
                io.set_ValueNoCheck("JP_CommunicationColumn", (Object)order.get_ValueAsString("JP_CommunicationColumn"));
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        MDocType ioDocType;
        MInOut io;
        int io_PhysicalWarehouse_ID;
        if (!po.get_TableName().equals("M_InOut")) {
            return null;
        }
        if (timing == 1 && MSysConfig.getBooleanValue((String)"JP_INOUT_PHYWH_LOCATOR_CHECK", (boolean)true, (int)po.getAD_Client_ID(), (int)po.getAD_Org_ID()) && (io_PhysicalWarehouse_ID = (io = (MInOut)po).get_ValueAsInt("JP_PhysicalWarehouse_ID")) != 0) {
            MInOutLine[] ioLines = io.getLines();
            MLocator loc = null;
            int loc_PhysicalWarehouse_ID = 0;
            int i = 0;
            while (i < ioLines.length) {
                loc = MLocator.get((Properties)io.getCtx(), (int)ioLines[i].getM_Locator_ID());
                loc_PhysicalWarehouse_ID = loc.get_ValueAsInt("JP_PhysicalWarehouse_ID");
                if (loc_PhysicalWarehouse_ID != 0 && loc_PhysicalWarehouse_ID != io_PhysicalWarehouse_ID) {
                    return String.valueOf(Msg.getMsg((Properties)io.getCtx(), (String)"JP_PhyWarehouseLocatorConflict")) + Msg.getElement((Properties)io.getCtx(), (String)"Line") + " : " + ioLines[i].getLine();
                }
                ++i;
            }
        }
        if (timing == 7) {
            io = (MInOut)po;
            String trxName = po.get_TrxName();
            boolean isReversal = io.isReversal();
            ioDocType = MDocType.get((Properties)po.getCtx(), (int)io.getC_DocType_ID());
            if (!isReversal && ioDocType.get_ValueAsBoolean("IsInspectionInvoiceJP") && io.getC_Order_ID() > 0) {
                MOrder order = new MOrder(po.getCtx(), io.getC_Order_ID(), trxName);
                MDocType orderDocType = MDocType.get((Properties)po.getCtx(), (int)order.getC_DocTypeTarget_ID());
                if (!(orderDocType.getDocSubTypeSO().equals("WI") || orderDocType.getDocSubTypeSO().equals("WR") || orderDocType.getDocSubTypeSO().equals("PR"))) {
                    Timestamp invoiceDate = MDeliveryDays.getInvoiceDate(io, ioDocType.get_ValueAsBoolean("IsHolidayNotInspectionJP"), "ShipDate");
                    io.setDateAcct(invoiceDate);
                    if (MSysConfig.getBooleanValue((String)"JP_INSPECTION_MOVEMENTDATE", (boolean)false, (int)io.getAD_Client_ID(), (int)io.getAD_Org_ID())) {
                        io.setMovementDate(invoiceDate);
                    }
                }
            }
        }
        if (!po.get_ValueAsBoolean("Posted") && (po.get_ValueAsBoolean("IsSOTrx") && timing == MSysConfig.getIntValue((String)"JP_INOUT_TIMING_OF_CREATE_AR_INVOICE", (int)9, (int)po.getAD_Client_ID(), (int)po.getAD_Org_ID()) || !po.get_ValueAsBoolean("IsSOTrx") && timing == MSysConfig.getIntValue((String)"JP_INOUT_TIMING_OF_CREATE_AP_INVOICE", (int)9, (int)po.getAD_Client_ID(), (int)po.getAD_Org_ID()))) {
            io = (MInOut)po;
            String trxName = po.get_TrxName();
            boolean isReversal = io.isReversal();
            ioDocType = MDocType.get((Properties)po.getCtx(), (int)io.getC_DocType_ID());
            if (ioDocType.get_ValueAsBoolean("IsCreateInvoiceJP")) {
                if (io.getC_Order_ID() == 0) {
                    return null;
                }
                MOrder order = new MOrder(po.getCtx(), io.getC_Order_ID(), trxName);
                MDocType orderDocType = MDocType.get((Properties)po.getCtx(), (int)order.getC_DocTypeTarget_ID());
                if (!(orderDocType.getDocSubTypeSO().equals("WI") || orderDocType.getDocSubTypeSO().equals("WR") || orderDocType.getDocSubTypeSO().equals("PR"))) {
                    MPayment payment;
                    if (orderDocType.getC_DocTypeInvoice_ID() == 0) {
                        return null;
                    }
                    MInvoiceJP invoice = new MInvoiceJP(order, orderDocType.getC_DocTypeInvoice_ID(), io.getDateAcct());
                    if (!invoice.save(trxName)) {
                        log.warning("Could not create Invoice: " + io.getDocumentInfo());
                        return null;
                    }
                    MInOutLine[] sLines = io.getLines(false);
                    int i = 0;
                    while (i < sLines.length) {
                        MInOutLine sLine = sLines[i];
                        MInvoiceLine iLine = new MInvoiceLine((MInvoice)invoice);
                        iLine.setShipLine(sLine);
                        iLine.set_ValueNoCheck("JP_ProductExplodeBOM_ID", sLine.get_Value("JP_ProductExplodeBOM_ID"));
                        if (sLine.sameOrderLineUOM()) {
                            iLine.setQtyEntered(sLine.getQtyEntered());
                        } else {
                            iLine.setQtyEntered(sLine.getMovementQty());
                        }
                        iLine.setQtyInvoiced(sLine.getMovementQty());
                        if (!iLine.save(io.get_TrxName())) {
                            log.warning("Could not create Invoice Line from Shipment Line: " + invoice.getDocumentInfo());
                            return null;
                        }
                        sLine.setIsInvoiced(true);
                        if (!sLine.save(trxName)) {
                            log.warning("Could not update Shipment line: " + sLine);
                        }
                        ++i;
                    }
                    if (!invoice.processIt("CO")) {
                        throw new AdempiereException("Failed when processing document - " + invoice.getProcessMsg());
                    }
                    invoice.saveEx(trxName);
                    if (!invoice.getDocStatus().equals("CO")) {
                        log.warning("Could not Completed Invoice: " + invoice.getDocumentInfo());
                        return null;
                    }
                    if (!isReversal && order.getC_Payment_ID() > 0 && !(payment = new MPayment(io.getCtx(), order.getC_Payment_ID(), trxName)).isAllocated() && payment.getC_Order_ID() == order.getC_Order_ID() && payment.isPrepayment() && (payment.getDocStatus().equals("CO") || payment.getDocStatus().equals("CL")) && invoice.getC_Currency_ID() == payment.getC_Currency_ID()) {
                        BigDecimal payAmt = payment.getPayAmt();
                        BigDecimal allocatedAmt = payment.getAllocatedAmt();
                        BigDecimal allocatAmt = payAmt;
                        if (allocatedAmt == null) {
                            allocatedAmt = Env.ZERO;
                        }
                        if (payment.isReceipt()) {
                            allocatAmt = payAmt.subtract(allocatedAmt);
                            allocatAmt = invoice.getGrandTotal().compareTo(allocatAmt) > 0 ? allocatAmt : invoice.getGrandTotal();
                        } else if (!payment.isReceipt()) {
                            allocatAmt = payAmt.add(allocatedAmt);
                            allocatAmt = invoice.getGrandTotal().compareTo(allocatAmt) > 0 ? allocatAmt : invoice.getGrandTotal();
                            allocatAmt = allocatAmt.negate();
                        }
                        if (payment.isReceipt() && allocatAmt.compareTo(Env.ZERO) > 0 || !payment.isReceipt() && allocatAmt.compareTo(Env.ZERO) < 0) {
                            MAllocationHdr alloc = new MAllocationHdr(io.getCtx(), false, invoice.getDateAcct(), invoice.getC_Currency_ID(), String.valueOf(Msg.translate((Properties)io.getCtx(), (String)"C_Payment_ID")) + ": " + payment.getDocumentNo(), trxName);
                            alloc.setAD_Org_ID(invoice.getAD_Org_ID());
                            alloc.setDateAcct(invoice.getDateAcct());
                            if (!alloc.save(trxName)) {
                                log.severe("Allocations not created");
                                return null;
                            }
                            MAllocationLine aLine = new MAllocationLine(alloc, allocatAmt, Env.ZERO, Env.ZERO, Env.ZERO);
                            aLine.setDocInfo(invoice.getC_BPartner_ID(), order.getC_Order_ID(), invoice.getC_Invoice_ID());
                            aLine.setPaymentInfo(payment.getC_Payment_ID(), 0);
                            if (!aLine.save(trxName)) {
                                log.warning("P.Allocations - line not saved");
                            }
                            if (!alloc.processIt("CO")) {
                                throw new AdempiereException("Failed when processing document - " + alloc.getProcessMsg());
                            }
                            if (!alloc.save(trxName)) {
                                log.severe("Allocation not Save after Complete");
                                return null;
                            }
                        }
                    }
                }
            }
        }
        return null;
    }
}

