/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.math.BigDecimal;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.MClient;
import org.compiere.model.MInOutConfirm;
import org.compiere.model.MInOutLine;
import org.compiere.model.MLocator;
import org.compiere.model.MOrderLine;
import org.compiere.model.MSysConfig;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class JPiereInOutLineModelValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(JPiereInOutLineModelValidator.class);
    private int AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("M_InOutLine", (ModelValidator)this);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Initialize JPiereInOutLineModelValidator");
        }
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String modelChange(PO po, int type) throws Exception {
        MInOutLine iol;
        block44: {
            BigDecimal movementQty;
            ProcessInfo pInfo;
            block45: {
                if (type == 1 || type == 2) {
                    MLocator loc;
                    int loc_PhysicalWarehouse_ID;
                    int io_PhysicalWarehouse_ID;
                    MInOutConfirm[] ioConfirms;
                    iol = (MInOutLine)po;
                    if (iol.getC_OrderLine_ID() > 0 && (iol.is_ValueChanged("M_Product_ID") || iol.is_ValueChanged("C_OrderLine_ID")) && iol.getM_Product_ID() != iol.getC_OrderLine().getM_Product_ID()) {
                        return Msg.getMsg((Properties)iol.getCtx(), (String)"JP_ProductOfOrderAndInOutDiffer");
                    }
                    if (MSysConfig.getBooleanValue((String)"JP_CHECK_INOUTLINE_CONFIRM", (boolean)false, (int)iol.getAD_Client_ID(), (int)iol.getAD_Org_ID()) && (ioConfirms = iol.getParent().getConfirmations(true)).length > 0) {
                        if (type == 1) {
                            return Msg.getMsg((Properties)iol.getCtx(), (String)"JP_CanNotAddLineForConfirmations");
                        }
                        if (type == 2 && iol.is_ValueChanged("QtyEntered") && !iol.getParent().getDocAction().equals("VO") && !iol.getParent().getC_DocType().isSplitWhenDifference()) {
                            return Msg.getMsg((Properties)iol.getCtx(), (String)"JP_CanNotChangeQtyForConfirmations");
                        }
                    }
                    if (MSysConfig.getBooleanValue((String)"JP_INOUT_PHYWH_LOCATOR_CHECK", (boolean)true, (int)iol.getAD_Client_ID(), (int)iol.getAD_Org_ID()) && (type == 1 || type == 2 && iol.is_ValueChanged("M_Locator_ID")) && (io_PhysicalWarehouse_ID = iol.getParent().get_ValueAsInt("JP_PhysicalWarehouse_ID")) != 0 && (loc_PhysicalWarehouse_ID = (loc = MLocator.get((Properties)iol.getCtx(), (int)iol.getM_Locator_ID())).get_ValueAsInt("JP_PhysicalWarehouse_ID")) != 0 && loc_PhysicalWarehouse_ID != io_PhysicalWarehouse_ID) {
                        return Msg.getMsg((Properties)iol.getCtx(), (String)"JP_PhyWarehouseLocatorConflict");
                    }
                }
                if ((type == 1 || type == 2 && po.is_ValueChanged("C_OrderLine_ID")) && (iol = (MInOutLine)po).getC_OrderLine_ID() > 0) {
                    if (iol.getParent().getC_DocType().getDocBaseType().equals("MMR")) {
                        if (!iol.getC_OrderLine().getC_Order().getC_DocType().getDocBaseType().equals("POO")) {
                            return String.valueOf(Msg.getMsg((Properties)iol.getCtx(), (String)"JP_Can_Not_Match_Because_DocType")) + Msg.getMsg((Properties)iol.getCtx(), (String)"JP_MMR_MATCH_POO_ONLY");
                        }
                    } else if (!(!iol.getParent().getC_DocType().getDocBaseType().equals("MMS") || iol.getC_OrderLine().getC_Order().getC_DocType().getDocBaseType().equals("SOO") || iol.getParent().isDropShip() && iol.getC_OrderLine().getC_Order().getC_DocType().getDocBaseType().equals("POO") && iol.getC_OrderLine().getLink_OrderLine_ID() > 0)) {
                        return String.valueOf(Msg.getMsg((Properties)iol.getCtx(), (String)"JP_Can_Not_Match_Because_DocType")) + Msg.getMsg((Properties)iol.getCtx(), (String)"JP_MMS_MATCH_SOO_ONLY");
                    }
                }
                if ((type == 1 || type == 2 && po.is_ValueChanged("M_RMALine_ID")) && (iol = (MInOutLine)po).getM_RMALine_ID() > 0 && (iol.getParent().getC_DocType().getDocBaseType().equals("MMR") ? !iol.getM_RMALine().getM_RMA().getC_DocType().getDocBaseType().equals("SOO") || !iol.getM_RMALine().getM_RMA().getC_DocType().getDocSubTypeSO().equals("RM") : iol.getParent().getC_DocType().getDocBaseType().equals("MMS") && (!iol.getM_RMALine().getM_RMA().getC_DocType().getDocBaseType().equals("POO") || !iol.getM_RMALine().getM_RMA().getC_DocType().getDocSubTypeSO().equals("RM")))) {
                    return Msg.getMsg((Properties)iol.getCtx(), (String)"JP_Can_Not_Match_Because_DocType");
                }
                if (type == 1 || type == 2 && po.is_ValueChanged("M_Product_ID")) {
                    iol = (MInOutLine)po;
                    if (iol.getM_Product_ID() == 0) {
                        iol.set_ValueNoCheck("JP_ProductExplodeBOM_ID", null);
                    } else if (iol.getC_OrderLine_ID() > 0) {
                        MOrderLine ol = new MOrderLine(iol.getCtx(), iol.getC_OrderLine_ID(), iol.get_TrxName());
                        if (ol.get_Value("JP_ProductExplodeBOM_ID") != null) {
                            if (iol.getM_Product_ID() != ol.getM_Product_ID()) {
                                return Msg.getMsg((Properties)iol.getCtx(), (String)"JP_ProductOfOrderAndInOutDiffer");
                            }
                            iol.set_ValueNoCheck("JP_ProductExplodeBOM_ID", ol.get_Value("JP_ProductExplodeBOM_ID"));
                        } else {
                            iol.set_ValueNoCheck("JP_ProductExplodeBOM_ID", null);
                        }
                    } else if (iol.getM_RMALine_ID() > 0) {
                        MInOutLine originalIOLine = new MInOutLine(iol.getCtx(), iol.getM_RMALine().getM_InOutLine_ID(), iol.get_TrxName());
                        if (originalIOLine.get_Value("JP_ProductExplodeBOM_ID") != null) {
                            if (iol.getM_Product_ID() != originalIOLine.getM_Product_ID()) {
                                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"M_RMALine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"M_Product_ID");
                                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"M_InOutLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"M_Product_ID");
                                return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1});
                            }
                            iol.set_ValueNoCheck("JP_ProductExplodeBOM_ID", originalIOLine.get_Value("JP_ProductExplodeBOM_ID"));
                        } else {
                            iol.set_ValueNoCheck("JP_ProductExplodeBOM_ID", null);
                        }
                    }
                }
                if (type != 1 && (type != 2 || !po.is_ValueChanged("MovementQty"))) break block44;
                iol = (MInOutLine)po;
                pInfo = Env.getProcessInfo((Properties)Env.getCtx());
                if (pInfo != null || iol.getC_OrderLine_ID() <= 0) break block45;
                movementQty = iol.getMovementQty();
                BigDecimal qtyDelivered = iol.getC_OrderLine().getQtyDelivered();
                BigDecimal qtyOrdered = iol.getC_OrderLine().getQtyOrdered();
                BigDecimal qtyToDelivere = qtyOrdered.subtract(qtyDelivered);
                if (qtyOrdered.signum() >= 0) {
                    if (movementQty.compareTo(qtyToDelivere) > 0) {
                        try {
                            Dialog.info((int)0, null, (String)"JP_ToBeConfirmed", (String)(String.valueOf(Msg.getMsg((Properties)po.getCtx(), (String)"JP_Over_QtyDelivered_Possibility")) + " : " + iol.getParent().getDocumentNo() + " - " + iol.getLine()));
                        }
                        catch (Exception exception) {}
                    }
                    break block44;
                } else if (movementQty.compareTo(qtyToDelivere) < 0) {
                    try {
                        Dialog.info((int)0, null, (String)"JP_ToBeConfirmed", (String)(String.valueOf(Msg.getMsg((Properties)po.getCtx(), (String)"JP_Over_QtyDelivered_Possibility")) + " : " + iol.getParent().getDocumentNo() + " - " + iol.getLine()));
                    }
                    catch (Exception exception) {}
                }
                break block44;
            }
            if (pInfo == null && iol.getM_RMALine_ID() > 0) {
                movementQty = iol.getMovementQty();
                BigDecimal qtyDelivered = iol.getM_RMALine().getQtyDelivered();
                BigDecimal qtyRMA = iol.getM_RMALine().getQty();
                BigDecimal qtyToDeliver = qtyRMA.subtract(qtyDelivered);
                if (qtyRMA.signum() >= 0) {
                    if (movementQty.compareTo(qtyToDeliver) > 0) {
                        try {
                            Dialog.info((int)0, null, (String)"JP_ToBeConfirmed", (String)(String.valueOf(Msg.getMsg((Properties)po.getCtx(), (String)"JP_Over_QtyDelivered_Possibility")) + " : " + iol.getParent().getDocumentNo() + " - " + iol.getLine()));
                        }
                        catch (Exception exception) {}
                    }
                } else if (movementQty.compareTo(qtyToDeliver) < 0) {
                    try {
                        Dialog.info((int)0, null, (String)"JP_ToBeConfirmed", (String)(String.valueOf(Msg.getMsg((Properties)po.getCtx(), (String)"JP_Over_QtyDelivered_Possibility")) + " : " + iol.getParent().getDocumentNo() + " - " + iol.getLine()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if ((type == 1 || po.is_ValueChanged("C_OrderLine_ID")) && (iol = (MInOutLine)po).getC_OrderLine_ID() > 0) {
            MOrderLine order = new MOrderLine(po.getCtx(), iol.getC_OrderLine_ID(), po.get_TrxName());
            if (Util.isEmpty((String)iol.get_ValueAsString("JP_CommunicationColumn"))) {
                iol.set_ValueNoCheck("JP_CommunicationColumn", (Object)order.get_ValueAsString("JP_CommunicationColumn"));
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        return null;
    }
}

