/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MContractProcPeriod;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.FactsValidator;
import org.compiere.model.I_GL_Journal;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MSysConfig;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class JPiereGLJournalModelValidator
implements ModelValidator,
FactsValidator {
    private static CLogger log = CLogger.getCLogger(JPiereGLJournalModelValidator.class);
    private int AD_Client_ID = -1;
    private static final String JP_CONTRACT_ID = "JP_Contract_ID";
    private static final String JP_CONTRACT_CONTENT_ID = "JP_ContractContent_ID";
    private static final String JP_CONTRACT_PROC_PERIOD_ID = "JP_ContractProcPeriod_ID";
    private static final String JP_ORDER_ID = "JP_Order_ID";

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("GL_Journal", (ModelValidator)this);
        engine.addModelChange("GL_JournalLine", (ModelValidator)this);
        engine.addDocValidate("GL_Journal", (ModelValidator)this);
        engine.addFactsValidate("GL_Journal", (FactsValidator)this);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Initialize JPiereGLJournalModelValidator");
        }
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        if (type == 1 || type == 2 && (po.is_ValueChanged(JP_CONTRACT_ID) || po.is_ValueChanged(JP_CONTRACT_CONTENT_ID) || po.is_ValueChanged(JP_CONTRACT_PROC_PERIOD_ID))) {
            int JP_Contract_ID = po.get_ValueAsInt(JP_CONTRACT_ID);
            if (JP_Contract_ID == 0) {
                po.set_ValueNoCheck(JP_CONTRACT_CONTENT_ID, null);
                po.set_ValueNoCheck(JP_CONTRACT_PROC_PERIOD_ID, null);
            } else {
                int JP_ContractContent_ID = po.get_ValueAsInt(JP_CONTRACT_CONTENT_ID);
                if (JP_ContractContent_ID == 0) {
                    po.set_ValueNoCheck(JP_CONTRACT_PROC_PERIOD_ID, null);
                } else {
                    MContractContent m_contractContent = MContractContent.get(po.getCtx(), JP_ContractContent_ID);
                    if (JP_Contract_ID != m_contractContent.getJP_Contract_ID()) {
                        String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)JP_CONTRACT_ID), Msg.getElement((Properties)Env.getCtx(), (String)JP_CONTRACT_CONTENT_ID)});
                        return msg;
                    }
                    int JP_ContractProcPeriod_ID = po.get_ValueAsInt(JP_CONTRACT_PROC_PERIOD_ID);
                    if (JP_ContractProcPeriod_ID != 0) {
                        MContractProcPeriod period = MContractProcPeriod.get(Env.getCtx(), JP_ContractProcPeriod_ID);
                        if (m_contractContent.getJP_ContractCalender_ID() != period.getJP_ContractCalender_ID()) {
                            String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)JP_CONTRACT_CONTENT_ID), Msg.getElement((Properties)Env.getCtx(), (String)JP_CONTRACT_PROC_PERIOD_ID)});
                            return msg;
                        }
                    }
                }
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        if (timing == 1 && po instanceof I_GL_Journal) {
            String postingType;
            I_GL_Journal journal = (I_GL_Journal)po;
            String JP_GL_JOURNAL_BALANCE_CHECK_POSTINGTYPE = MSysConfig.getValue((String)"JP_GL_JOURNAL_BALANCE_CHECK_POSTINGTYPE", (String)"A", (int)po.getAD_Client_ID());
            if (JP_GL_JOURNAL_BALANCE_CHECK_POSTINGTYPE.contains(postingType = journal.getPostingType()) && journal.getTotalDr().compareTo(journal.getTotalCr()) != 0) {
                return Msg.getMsg((Properties)Env.getCtx(), (String)"UnbalancedJornal");
            }
        }
        return null;
    }

    public String factsValidate(MAcctSchema schema, List<Fact> facts, PO po) {
        if (po.get_TableName().equals("GL_Journal")) {
            int JP_Order_ID = po.get_ValueAsInt(JP_ORDER_ID);
            int JP_Contract_ID = po.get_ValueAsInt(JP_CONTRACT_ID);
            int JP_ContractContent_ID = po.get_ValueAsInt(JP_CONTRACT_CONTENT_ID);
            int JP_ContractProcPeriod_ID = po.get_ValueAsInt(JP_CONTRACT_PROC_PERIOD_ID);
            for (Fact fact : facts) {
                FactLine[] factLine = fact.getLines();
                PO m_GLJournalLine = null;
                int i = 0;
                while (i < factLine.length) {
                    if (factLine[i].getDocLine() != null) {
                        m_GLJournalLine = factLine[i].getDocLine().getPO();
                        if (m_GLJournalLine.get_ValueAsInt(JP_ORDER_ID) > 0) {
                            factLine[i].set_ValueNoCheck(JP_ORDER_ID, (Object)m_GLJournalLine.get_ValueAsInt(JP_ORDER_ID));
                        } else if (JP_Order_ID > 0) {
                            factLine[i].set_ValueNoCheck(JP_ORDER_ID, (Object)JP_Order_ID);
                        }
                        if (m_GLJournalLine.get_ValueAsInt(JP_CONTRACT_ID) > 0) {
                            factLine[i].set_ValueNoCheck(JP_CONTRACT_ID, (Object)m_GLJournalLine.get_ValueAsInt(JP_CONTRACT_ID));
                        } else if (JP_Contract_ID > 0) {
                            factLine[i].set_ValueNoCheck(JP_CONTRACT_ID, (Object)JP_Contract_ID);
                        }
                        if (m_GLJournalLine.get_ValueAsInt(JP_CONTRACT_CONTENT_ID) > 0) {
                            factLine[i].set_ValueNoCheck(JP_CONTRACT_CONTENT_ID, (Object)m_GLJournalLine.get_ValueAsInt(JP_CONTRACT_CONTENT_ID));
                        } else if (JP_ContractContent_ID > 0) {
                            factLine[i].set_ValueNoCheck(JP_CONTRACT_CONTENT_ID, (Object)JP_ContractContent_ID);
                        }
                        if (m_GLJournalLine.get_ValueAsInt(JP_CONTRACT_PROC_PERIOD_ID) > 0) {
                            factLine[i].set_ValueNoCheck(JP_CONTRACT_PROC_PERIOD_ID, (Object)m_GLJournalLine.get_ValueAsInt(JP_CONTRACT_PROC_PERIOD_ID));
                        } else if (JP_ContractProcPeriod_ID > 0) {
                            factLine[i].set_ValueNoCheck(JP_CONTRACT_PROC_PERIOD_ID, (Object)JP_ContractProcPeriod_ID);
                        }
                    }
                    ++i;
                }
            }
        }
        return null;
    }
}

