/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.math.BigDecimal;
import java.util.Properties;
import jpiere.base.plugin.org.adempiere.base.IJPiereTaxProvider;
import jpiere.base.plugin.org.adempiere.model.JPiereTaxProvider;
import jpiere.base.plugin.util.JPiereUtil;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MCurrency;
import org.compiere.model.MJournalLine;
import org.compiere.model.MTax;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class JPiereGLJournalLineModelValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(JPiereGLJournalLineModelValidator.class);
    private int AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("GL_JournalLine", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        IJPiereTaxProvider taxCalculater;
        MJournalLine jl;
        if (type == 1 || type == 2 && (po.is_ValueChanged("AmtSourceDr") || po.is_ValueChanged("AmtSourceCr") || po.is_ValueChanged("C_Tax_ID") || po.is_ValueChanged("JP_SOPOType"))) {
            jl = (MJournalLine)po;
            int C_Tax_ID = jl.get_ValueAsInt("C_Tax_ID");
            String JP_SOPOType = jl.get_ValueAsString("JP_SOPOType");
            if (C_Tax_ID == 0) {
                jl.set_ValueNoCheck("JP_SOPOType", null);
                jl.set_ValueNoCheck("JP_TaxBaseAmt", (Object)Env.ZERO);
                jl.set_ValueNoCheck("JP_TaxAmt", (Object)Env.ZERO);
            } else if (Util.isEmpty((String)JP_SOPOType) || "N".equals(JP_SOPOType)) {
                jl.set_ValueNoCheck("JP_SOPOType", (Object)"N");
                if (jl.get_Value("JP_TaxBaseAmt") == null) {
                    jl.set_ValueNoCheck("JP_TaxBaseAmt", (Object)Env.ZERO);
                    jl.set_ValueNoCheck("JP_TaxAmt", (Object)Env.ZERO);
                } else if (jl.get_Value("JP_TaxAmt") == null) {
                    jl.set_ValueNoCheck("JP_TaxAmt", (Object)Env.ZERO);
                }
            } else {
                if (jl.getAmtSourceDr().compareTo(Env.ZERO) != 0 && jl.getAmtSourceCr().compareTo(Env.ZERO) != 0) {
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_GLJournalTax_Either-Debit-Credit");
                }
                if (jl.getAmtSourceDr().compareTo(Env.ZERO) == 0 && jl.getAmtSourceCr().compareTo(Env.ZERO) == 0) {
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_GLJournalTax_Either-Debit-Credit");
                }
                MTax m_tax = MTax.get((int)C_Tax_ID);
                if ("S".equals(JP_SOPOType)) {
                    if (!m_tax.getSOPOType().equals("B") && !m_tax.getSOPOType().equals("S")) {
                        return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_GLJournalTax_SOPOType");
                    }
                } else if ("P".equals(JP_SOPOType) && !m_tax.getSOPOType().equals("B") && !m_tax.getSOPOType().equals("P")) {
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_GLJournalTax_SOPOType");
                }
                if (m_tax.isSummary()) {
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_GLJournalTax_SummaryLevelTax");
                }
                BigDecimal amt = Env.ZERO;
                BigDecimal taxAmt = Env.ZERO;
                if (JP_SOPOType.equals("S")) {
                    amt = jl.getAmtSourceCr().subtract(jl.getAmtSourceDr());
                } else if (JP_SOPOType.equals("P")) {
                    amt = jl.getAmtSourceDr().subtract(jl.getAmtSourceCr());
                }
                if (Env.ZERO.compareTo(amt) == 0) {
                    jl.set_ValueNoCheck("JP_TaxBaseAmt", (Object)Env.ZERO);
                    jl.set_ValueNoCheck("JP_TaxAmt", (Object)Env.ZERO);
                } else {
                    IJPiereTaxProvider taxCalculater2 = JPiereUtil.getJPiereTaxProvider(m_tax);
                    taxAmt = taxCalculater2 != null ? taxCalculater2.calculateTax(m_tax, amt, true, MCurrency.getStdPrecision((Properties)po.getCtx(), (int)jl.getParent().getC_Currency_ID()), JPiereTaxProvider.getRoundingMode(jl.getC_BPartner_ID(), JP_SOPOType == "S", m_tax.getC_TaxProvider())) : m_tax.calculateTax(amt, true, MCurrency.getStdPrecision((Properties)jl.getCtx(), (int)jl.getParent().getC_Currency_ID()));
                    jl.set_ValueNoCheck("JP_TaxBaseAmt", (Object)amt.subtract(taxAmt));
                    jl.set_ValueNoCheck("JP_TaxAmt", (Object)taxAmt);
                }
            }
        }
        if (type == 4 || type == 5) {
            jl = (MJournalLine)po;
            if (type == 4 || jl.is_ValueChanged("C_Tax_ID") || jl.is_ValueChanged("JP_SOPOType") || jl.is_ValueChanged("AmtSourceDr") || jl.is_ValueChanged("AmtSourceCr")) {
                MTax m_tax = new MTax(jl.getCtx(), jl.get_ValueAsInt("C_Tax_ID"), jl.get_TrxName());
                taxCalculater = JPiereUtil.getJPiereTaxProvider(m_tax);
                if (taxCalculater == null) {
                    throw new AdempiereException(Msg.getMsg((Properties)jl.getCtx(), (String)"TaxNoProvider"));
                }
                boolean success = taxCalculater.recalculateTax(null, jl, type == 4);
                if (!success) {
                    return "Error";
                }
            }
        }
        if (type == 6) {
            jl = (MJournalLine)po;
            MTax m_tax = new MTax(jl.getCtx(), jl.get_ValueAsInt("C_Tax_ID"), jl.get_TrxName());
            taxCalculater = JPiereUtil.getJPiereTaxProvider(m_tax);
            if (taxCalculater == null) {
                throw new AdempiereException(Msg.getMsg((Properties)jl.getCtx(), (String)"TaxNoProvider"));
            }
            boolean success = taxCalculater.recalculateTax(null, jl, type == 4);
            if (!success) {
                return "Error";
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        return null;
    }
}

