/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.base.AbstractContractValidator;
import jpiere.base.plugin.org.adempiere.model.MContract;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MContractLine;
import jpiere.base.plugin.org.adempiere.model.MContractProcPeriod;
import jpiere.base.plugin.org.adempiere.model.MRecognition;
import jpiere.base.plugin.org.adempiere.model.MRecognitionLine;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class JPiereContractRecognitionValidator
extends AbstractContractValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(JPiereContractRecognitionValidator.class);
    private int AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("JP_Recognition", (ModelValidator)this);
        engine.addModelChange("JP_RecognitionLine", (ModelValidator)this);
        engine.addDocValidate("JP_Recognition", (ModelValidator)this);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Initialize JPiereContractRecognitionValidator");
        }
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        if (po.get_TableName().equals("JP_Recognition")) {
            return this.recognitionValidate(po, type);
        }
        if (po.get_TableName().equals("JP_RecognitionLine")) {
            return this.recognitionLineValidate(po, type);
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        if (timing == 1) {
            MRecognition recog = (MRecognition)po;
            int JP_Contract_ID = recog.get_ValueAsInt("JP_Contract_ID");
            if (JP_Contract_ID <= 0) {
                return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"JP_Contract_ID");
            }
            MContract contract = MContract.get(Env.getCtx(), JP_Contract_ID);
            if (contract.getJP_ContractType().equals("PDC")) {
                int JP_ContractContent_ID = recog.getJP_ContractContent_ID();
                MContractContent content = MContractContent.get(Env.getCtx(), JP_ContractContent_ID);
                MRecognitionLine[] lines = recog.getLines();
                int JP_ContractLine_ID = 0;
                int JP_ContractProcPeriod_ID = 0;
                int i = 0;
                while (i < lines.length) {
                    JP_ContractLine_ID = lines[i].get_ValueAsInt("JP_ContractLine_ID");
                    JP_ContractProcPeriod_ID = lines[i].get_ValueAsInt("JP_ContractProcPeriod_ID");
                    if (JP_ContractLine_ID > 0 && JP_ContractProcPeriod_ID <= 0 && (content.getJP_CreateDerivativeDocPolicy().equals("IO") || content.getJP_CreateDerivativeDocPolicy().equals("BT"))) {
                        return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID") + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"Line") + " : " + lines[i].getLine();
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    private String recognitionValidate(PO po, int type) {
        String msg = this.derivativeDocHeaderCommonCheck(po, type);
        if (!Util.isEmpty((String)msg)) {
            return msg;
        }
        if (type == 1 || type == 2 && (po.is_ValueChanged("JP_Contract_ID") || po.is_ValueChanged("JP_ContractContent_ID") || po.is_ValueChanged("C_Order_ID") || po.is_ValueChanged("M_RMA_ID"))) {
            MRecognitionLine[] contractInvoiceLines;
            MRecognition recog = (MRecognition)po;
            int JP_Contract_ID = recog.get_ValueAsInt("JP_Contract_ID");
            MContract contract = MContract.get(Env.getCtx(), JP_Contract_ID);
            if (type == 2 && contract.getJP_ContractType().equals("PDC") && (contractInvoiceLines = this.getRecognitionLinesWithContractLine(recog)).length > 0) {
                return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CannotChangeContractInfoForLines");
            }
            if (!contract.getJP_ContractType().equals("PDC") && !contract.getJP_ContractType().equals("STC")) {
                msg = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Invalid")) + " " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_Contract_ID") + "  " + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ToBeConfirmed") + "  " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractType");
                return msg;
            }
            MContractContent content = MContractContent.get(Env.getCtx(), po.get_ValueAsInt("JP_ContractContent_ID"));
            if (!content.getJP_Contract_Acct().isPostingRecognitionDocJP()) {
                msg = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Invalid")) + " " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractContent_ID") + "  " + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ToBeConfirmed") + "  " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_Contract_Acct_ID");
                return msg;
            }
        }
        return null;
    }

    private String recognitionLineValidate(PO po, int type) {
        String msg = this.derivativeDocLineCommonCheck(po, type);
        if (!Util.isEmpty((String)msg)) {
            return msg;
        }
        if (type == 1 || type == 2 && (po.is_ValueChanged("JP_ContractLine_ID") || po.is_ValueChanged("C_OrderLine_ID") || po.is_ValueChanged("M_RMALine_ID"))) {
            MRecognitionLine recogLine = (MRecognitionLine)po;
            int JP_Contract_ID = recogLine.getParent().get_ValueAsInt("JP_Contract_ID");
            int JP_ContractContent_ID = recogLine.getParent().get_ValueAsInt("JP_ContractContent_ID");
            int JP_ContractLine_ID = recogLine.get_ValueAsInt("JP_ContractLine_ID");
            if (JP_Contract_ID <= 0) {
                return null;
            }
            MContract contract = MContract.get(Env.getCtx(), JP_Contract_ID);
            if (!contract.getJP_ContractType().equals("PDC") && !contract.getJP_ContractType().equals("STC")) {
                return null;
            }
            int C_OrderLine_ID = recogLine.getC_OrderLine_ID();
            int M_RMALine_ID = recogLine.getM_RMALine_ID();
            int M_InOutLine_ID = recogLine.getM_InOutLine_ID();
            if (C_OrderLine_ID == 0 && M_RMALine_ID == 0 && M_InOutLine_ID == 0) {
                return null;
            }
            if (C_OrderLine_ID <= 0 && M_RMALine_ID <= 0 && M_InOutLine_ID != 0) {
                Object[] objs = new Object[]{String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"C_OrderLine_ID")) + " or " + Msg.getElement((Properties)Env.getCtx(), (String)"M_RMALine_ID")};
                return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfPeriodContractAndSpotContract")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
            }
            if (recogLine.getParent().getC_Order_ID() > 0 && recogLine.getC_OrderLine_ID() > 0) {
                if (recogLine.getC_OrderLine().getC_Order_ID() != recogLine.getParent().getC_Order_ID()) {
                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfPeriodContractAndSpotContract")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotBundleDifferentOrder");
                }
            } else if (recogLine.getParent().getM_RMA_ID() > 0 && recogLine.getM_RMALine_ID() > 0 && recogLine.getM_RMALine().getM_RMA_ID() != recogLine.getParent().getM_RMA_ID()) {
                return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfPeriodContractAndSpotContract")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotBundleDifferentRMA");
            }
            if (JP_ContractLine_ID <= 0) {
                return null;
            }
            MContractLine contractLine = MContractLine.get(Env.getCtx(), JP_ContractLine_ID);
            if (contractLine.getJP_ContractContent_ID() != JP_ContractContent_ID) {
                return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Invalid")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID") + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Diff_ContractContentLine");
            }
            int recogLine_ContractProcPeriod_ID = recogLine.get_ValueAsInt("JP_ContractProcPeriod_ID");
            MContractContent content = MContractContent.get(Env.getCtx(), JP_ContractContent_ID);
            if (contract.getJP_ContractType().equals("PDC")) {
                if (content.getJP_CreateDerivativeDocPolicy().equals("IO") || content.getJP_CreateDerivativeDocPolicy().equals("BT")) {
                    if (type == 2) {
                        if (recogLine_ContractProcPeriod_ID <= 0) {
                            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID")};
                            return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfCreateDerivativeDocPolicy")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                        }
                        MContractProcPeriod recogLine_ContractProcPeriod = MContractProcPeriod.get(Env.getCtx(), recogLine_ContractProcPeriod_ID);
                        if (recogLine_ContractProcPeriod.getJP_ContractCalender_ID() != contractLine.getJP_ContractCalender_InOut_ID()) {
                            return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_SelectContractProcPeriodBelongToContractLine");
                        }
                        MRecognition recog = recogLine.getParent();
                        MContractProcPeriod recogPeriod = MContractProcPeriod.get(Env.getCtx(), recog.get_ValueAsInt("JP_ContractProcPeriod_ID"));
                        if (recogPeriod.getStartDate().compareTo(recogLine_ContractProcPeriod.getStartDate()) > 0 || recogPeriod.getEndDate() != null && recogPeriod.getEndDate().compareTo(recogLine_ContractProcPeriod.getEndDate()) < 0) {
                            return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_OutsideContractProcessPeriod")) + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"Invalid") + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                        }
                    }
                } else if (po.get_ValueAsInt("JP_ContractProcPeriod_ID") != 0) {
                    po.set_ValueNoCheck("JP_ContractProcPeriod_ID", null);
                    ProcessInfo pInfo = Env.getProcessInfo((Properties)Env.getCtx());
                    if (pInfo == null) {
                        String nonEnterable = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NON-ENTERABLE");
                        String contractPeriod = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                        String toBeConfirmed = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ToBeConfirmed");
                        String createDerivativeDocPolicy = Msg.getElement((Properties)Env.getCtx(), (String)"JP_CreateDerivativeDocPolicy");
                        try {
                            Dialog.info((int)0, null, (String)"JP_ContractManagementInfo", (String)(String.valueOf(nonEnterable) + " " + contractPeriod + " -> " + toBeConfirmed + " : " + createDerivativeDocPolicy));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return null;
    }

    private MRecognitionLine[] getRecognitionLinesWithContractLine(MRecognition recog) {
        String whereClauseFinal = "JP_Recognition_ID=? AND JP_ContractLine_ID IS NOT NULL ";
        List list = new Query(Env.getCtx(), "JP_RecognitionLine", whereClauseFinal, recog.get_TrxName()).setParameters(new Object[]{recog.getM_InOut_ID()}).setOrderBy("Line").list();
        return list.toArray(new MRecognitionLine[list.size()]);
    }
}

