/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.math.BigDecimal;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MRMALine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class JPiereContractRMAValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(JPiereContractRMAValidator.class);
    private int AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("M_RMA", (ModelValidator)this);
        engine.addModelChange("M_RMALine", (ModelValidator)this);
        engine.addDocValidate("M_RMA", (ModelValidator)this);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Initialize JPiereContractRMAValidator");
        }
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        if (po.get_TableName().equals("M_RMA")) {
            return this.rmaValidate(po, type);
        }
        if (po.get_TableName().equals("M_RMALine")) {
            return this.rmaLineValidate(po, type);
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        return null;
    }

    private String rmaValidate(PO po, int type) {
        if (type == 1 || type == 2 && po.is_ValueChanged("InOut_ID")) {
            int M_InOut_ID = po.get_ValueAsInt("InOut_ID");
            if (M_InOut_ID <= 0) {
                po.set_ValueNoCheck("JP_Contract_ID", null);
                po.set_ValueNoCheck("JP_ContractContent_ID", null);
                po.set_ValueNoCheck("JP_ContractProcPeriod_ID", null);
                return null;
            }
            MInOut io = new MInOut(Env.getCtx(), M_InOut_ID, po.get_TrxName());
            int JP_Contract_ID = io.get_ValueAsInt("JP_Contract_ID");
            if (JP_Contract_ID <= 0) {
                po.set_ValueNoCheck("JP_Contract_ID", null);
                po.set_ValueNoCheck("JP_ContractContent_ID", null);
                po.set_ValueNoCheck("JP_ContractProcPeriod_ID", null);
                return null;
            }
            po.set_ValueNoCheck("JP_Contract_ID", (Object)JP_Contract_ID);
            if (io.get_ValueAsInt("JP_ContractContent_ID") > 0) {
                po.set_ValueNoCheck("JP_ContractContent_ID", (Object)io.get_ValueAsInt("JP_ContractContent_ID"));
            } else {
                po.set_ValueNoCheck("JP_ContractContent_ID", null);
            }
            if (io.get_ValueAsInt("JP_ContractProcPeriod_ID") > 0) {
                po.set_ValueNoCheck("JP_ContractProcPeriod_ID", (Object)io.get_ValueAsInt("JP_ContractProcPeriod_ID"));
            } else {
                po.set_ValueNoCheck("JP_ContractProcPeriod_ID", null);
            }
            po.set_ValueNoCheck("JP_Order_ID", (Object)io.getC_Order_ID());
        }
        return null;
    }

    private String rmaLineValidate(PO po, int type) {
        if (type == 2 && po.is_ValueChanged("QtyInvoiced")) {
            MRMALine rmaLine = (MRMALine)po;
            int JP_ContractContent_ID = rmaLine.getParent().get_ValueAsInt("JP_ContractContent_ID");
            if (JP_ContractContent_ID == 0) {
                rmaLine.set_ValueNoCheck("JP_QtyRecognized", (Object)rmaLine.getQtyInvoiced());
            } else {
                MContractContent contractContent = MContractContent.get(Env.getCtx(), JP_ContractContent_ID);
                if (!contractContent.getJP_Contract_Acct().isPostingRecognitionDocJP()) {
                    rmaLine.set_ValueNoCheck("JP_QtyRecognized", (Object)rmaLine.getQtyInvoiced());
                }
            }
        }
        if (type == 2 && (po.is_ValueChanged("Qty") || po.is_ValueChanged("QtyDelivered") || po.is_ValueChanged("QtyInvoiced") || po.is_ValueChanged("JP_QtyRecognized"))) {
            BigDecimal qty = (BigDecimal)po.get_Value("Qty");
            BigDecimal qtyDelivered = (BigDecimal)po.get_Value("QtyDelivered");
            BigDecimal qtyInvoiced = (BigDecimal)po.get_Value("QtyInvoiced");
            BigDecimal qtyRecognized = (BigDecimal)po.get_Value("JP_QtyRecognized");
            if (qty.compareTo(qtyDelivered) == 0 && qty.compareTo(qtyInvoiced) == 0 && qty.compareTo(qtyRecognized) == 0) {
                po.set_ValueNoCheck("IsProcessingRMAJP", (Object)"N");
            } else {
                po.set_ValueNoCheck("IsProcessingRMAJP", (Object)"Y");
            }
            if (po.is_ValueChanged("QtyDelivered") || po.is_ValueChanged("QtyInvoiced") || po.is_ValueChanged("JP_QtyRecognized")) {
                return null;
            }
        }
        if (type == 1 || type == 2 && po.is_ValueChanged("M_InOutLine_ID")) {
            int M_InOutLine_ID = po.get_ValueAsInt("M_InOutLine_ID");
            if (M_InOutLine_ID <= 0) {
                po.set_ValueNoCheck("JP_ContractLine_ID", null);
                po.set_ValueNoCheck("JP_ContractProcPeriod_ID", null);
                return null;
            }
            MInOutLine ioLine = new MInOutLine(Env.getCtx(), M_InOutLine_ID, po.get_TrxName());
            int JP_ContractLine_ID = ioLine.get_ValueAsInt("JP_ContractLine_ID");
            if (JP_ContractLine_ID <= 0) {
                po.set_ValueNoCheck("JP_ContractLine_ID", null);
                po.set_ValueNoCheck("JP_ContractProcPeriod_ID", null);
                return null;
            }
            po.set_ValueNoCheck("JP_ContractLine_ID", (Object)ioLine.get_ValueAsInt("JP_ContractLine_ID"));
            int JP_ContractProcPeriod_ID = ioLine.get_ValueAsInt("JP_ContractProcPeriod_ID");
            if (JP_ContractProcPeriod_ID > 0) {
                po.set_ValueNoCheck("JP_ContractProcPeriod_ID", (Object)JP_ContractProcPeriod_ID);
            } else {
                po.set_ValueNoCheck("JP_ContractProcPeriod_ID", null);
            }
            int JP_OrderLine_ID = ioLine.getC_OrderLine_ID();
            if (JP_OrderLine_ID > 0) {
                po.set_ValueNoCheck("JP_OrderLine_ID", (Object)JP_OrderLine_ID);
            } else {
                po.set_ValueNoCheck("JP_OrderLine_ID", null);
            }
        }
        return null;
    }
}

