/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.base.AbstractContractValidator;
import jpiere.base.plugin.org.adempiere.model.MContract;
import jpiere.base.plugin.org.adempiere.model.MContractAcct;
import jpiere.base.plugin.org.adempiere.model.MContractChargeAcct;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MContractLine;
import jpiere.base.plugin.org.adempiere.model.MContractProcPeriod;
import jpiere.base.plugin.org.adempiere.model.MContractProductAcct;
import jpiere.base.plugin.org.adempiere.model.MContractTaxAcct;
import jpiere.base.plugin.org.adempiere.model.MRecognition;
import jpiere.base.plugin.org.adempiere.model.MRecognitionLine;
import org.adempiere.webui.window.Dialog;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocTax;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.FactsValidator;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MRMA;
import org.compiere.model.MRefList;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.ProductCost;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class JPiereContractInvoiceValidator
extends AbstractContractValidator
implements ModelValidator,
FactsValidator {
    private static CLogger log = CLogger.getCLogger(JPiereContractInvoiceValidator.class);
    private int AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("C_Invoice", (ModelValidator)this);
        engine.addModelChange("C_InvoiceLine", (ModelValidator)this);
        engine.addDocValidate("C_Invoice", (ModelValidator)this);
        engine.addFactsValidate("C_Invoice", (FactsValidator)this);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Initialize JPiereContractInvoiceValidator");
        }
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        if (po.get_TableName().equals("C_Invoice")) {
            return this.invoiceValidate(po, type);
        }
        if (po.get_TableName().equals("C_InvoiceLine")) {
            return this.invoiceLineValidate(po, type);
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        MContractAcct acct;
        MContractContent content;
        int JP_Contract_Acct_ID;
        int JP_ContractContent_ID;
        int JP_ContractContent_ID2;
        MInvoice invoice;
        if (timing == 1) {
            invoice = (MInvoice)po;
            int JP_Contract_ID = invoice.get_ValueAsInt("JP_Contract_ID");
            if (JP_Contract_ID <= 0) {
                return null;
            }
            MContract contract = MContract.get(Env.getCtx(), JP_Contract_ID);
            if (contract.getJP_ContractType().equals("PDC")) {
                int JP_ContractContent_ID3 = invoice.get_ValueAsInt("JP_ContractContent_ID");
                MContractContent content2 = MContractContent.get(Env.getCtx(), JP_ContractContent_ID3);
                MInvoiceLine[] lines = invoice.getLines();
                int JP_ContractLine_ID = 0;
                int JP_ContractProcPeriod_ID = 0;
                int i = 0;
                while (i < lines.length) {
                    JP_ContractLine_ID = lines[i].get_ValueAsInt("JP_ContractLine_ID");
                    JP_ContractProcPeriod_ID = lines[i].get_ValueAsInt("JP_ContractProcPeriod_ID");
                    if (JP_ContractLine_ID > 0 && JP_ContractProcPeriod_ID <= 0 && (content2.getDocBaseType().equals("API") || content2.getDocBaseType().equals("ARI") || content2.getJP_CreateDerivativeDocPolicy() != null && (content2.getJP_CreateDerivativeDocPolicy().equals("IV") || content2.getJP_CreateDerivativeDocPolicy().equals("BT")))) {
                        return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID") + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"Line") + " : " + lines[i].getLine();
                    }
                    ++i;
                }
            }
        }
        if ((timing == 10 || timing == 14 || timing == 13) && (JP_ContractContent_ID2 = (invoice = (MInvoice)po).get_ValueAsInt("JP_ContractContent_ID")) > 0) {
            MContractContent content3 = MContractContent.get(Env.getCtx(), JP_ContractContent_ID2);
            MContractAcct acctInfo = MContractAcct.get(Env.getCtx(), content3.getJP_Contract_Acct_ID());
            if (acctInfo.isPostingContractAcctJP() && acctInfo.isPostingContractAcctJP() && acctInfo.getJP_RecogToInvoicePolicy() != null && !acctInfo.getJP_RecogToInvoicePolicy().equals("NO")) {
                StringBuilder sql = new StringBuilder("UPDATE ").append("JP_Recognition").append(" SET C_Invoice_ID = null WHERE C_Invoice_ID=?");
                DB.executeUpdate((String)sql.toString(), (int)invoice.getC_Invoice_ID(), (String)po.get_TrxName());
                MInvoiceLine[] iLines = invoice.getLines();
                int i = 0;
                while (i < iLines.length) {
                    StringBuilder sqLine = new StringBuilder("UPDATE ").append("JP_RecognitionLine").append(" SET C_InvoiceLine_ID = null WHERE C_InvoiceLine_ID=?");
                    DB.executeUpdate((String)sqLine.toString(), (int)iLines[i].getC_InvoiceLine_ID(), (String)po.get_TrxName());
                    ++i;
                }
            }
        }
        if (timing == 3 && (JP_ContractContent_ID = po.get_ValueAsInt("JP_ContractContent_ID")) > 0 && (JP_Contract_Acct_ID = (content = MContractContent.get(Env.getCtx(), JP_ContractContent_ID)).getJP_Contract_Acct_ID()) > 0 && (acct = MContractAcct.get(Env.getCtx(), JP_Contract_Acct_ID)).isPostingContractAcctJP() && acct.isPostingRecognitionDocJP() && acct.getJP_RecogToInvoicePolicy() != null && acct.getJP_RecogToInvoicePolicy().equals("DD")) {
            int JP_Recognition_ID = po.get_ValueAsInt("JP_Recognition_ID");
            MRecognition recog = new MRecognition(Env.getCtx(), JP_Recognition_ID, po.get_TrxName());
            if (!recog.getDocStatus().equals("CL")) {
                String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_AfterRecognition_InvoiceDocStatusCloseError");
                return msg;
            }
        }
        return null;
    }

    private String invoiceValidate(PO po, int type) {
        int JP_ContractContent_ID;
        MInvoice counterInvoice;
        MInvoice invoice;
        if (type == 1 && (invoice = (MInvoice)po).getRef_Invoice_ID() > 0 && (counterInvoice = new MInvoice(po.getCtx(), invoice.getRef_Invoice_ID(), po.get_TrxName())).get_ValueAsInt("JP_Contract_ID") > 0) {
            MContractContent counterContractContent;
            MContract counterContract = MContract.get(po.getCtx(), counterInvoice.get_ValueAsInt("JP_Contract_ID"));
            if (counterContract != null && counterContract.getJP_Contract_ID() > 0 && counterContract.getJP_CounterContract_ID() > 0) {
                invoice.set_ValueNoCheck("JP_Contract_ID", (Object)counterContract.getJP_CounterContract_ID());
            }
            if (counterInvoice.get_ValueAsInt("JP_ContractContent_ID") > 0 && (counterContractContent = MContractContent.get(po.getCtx(), counterInvoice.get_ValueAsInt("JP_ContractContent_ID"))) != null && counterContractContent.getJP_ContractContent_ID() > 0 && counterContractContent.getJP_CounterContractContent_ID() > 0) {
                invoice.set_ValueNoCheck("JP_ContractContent_ID", (Object)counterContractContent.getJP_CounterContractContent_ID());
            }
            if (counterInvoice.get_ValueAsInt("JP_ContractProcPeriod_ID") > 0) {
                invoice.set_ValueNoCheck("JP_ContractProcPeriod_ID", (Object)counterInvoice.get_ValueAsInt("JP_ContractProcPeriod_ID"));
            }
        }
        if (po.get_ValueAsInt("C_Order_ID") > 0 || po.get_ValueAsInt("M_RMA_ID") > 0) {
            String msg = this.derivativeDocHeaderCommonCheck(po, type);
            if (!Util.isEmpty((String)msg)) {
                return msg;
            }
            return null;
        }
        if (type == 1 || type == 2 && (po.is_ValueChanged("JP_Contract_ID") || po.is_ValueChanged("JP_ContractContent_ID") || po.is_ValueChanged("JP_ContractProcPeriod_ID") || po.is_ValueChanged("C_DocTypeTarget_ID"))) {
            MColumn column;
            String toBeConfirmed;
            MContractContent content;
            MInvoiceLine[] contractInvoiceLines;
            invoice = (MInvoice)po;
            ProcessInfo pInfo = Env.getProcessInfo((Properties)Env.getCtx());
            int JP_Contract_ID = invoice.get_ValueAsInt("JP_Contract_ID");
            if (JP_Contract_ID <= 0) {
                if (invoice.get_ValueAsInt("JP_ContractContent_ID") != 0 || invoice.get_ValueAsInt("JP_ContractProcPeriod_ID") != 0) {
                    invoice.set_ValueNoCheck("JP_ContractContent_ID", null);
                    invoice.set_ValueNoCheck("JP_ContractProcPeriod_ID", null);
                    if (pInfo == null) {
                        String nonEnterable = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NON-ENTERABLE");
                        String contractContent = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractContent_ID");
                        String contractPeriod = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                        String toBeConfirmed2 = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ToBeConfirmed");
                        Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_Contract_ID")};
                        String message = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NOT-INOUT", (Object[])objs);
                        try {
                            Dialog.info((int)0, null, (String)"JP_ContractManagementInfo", (String)(String.valueOf(nonEnterable) + " " + contractContent + " , " + contractPeriod + " -> " + toBeConfirmed2 + " : " + message));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                return null;
            }
            MContract contract = MContract.get(Env.getCtx(), JP_Contract_ID);
            if (type == 2 && contract.getJP_ContractType().equals("PDC") && (contractInvoiceLines = this.getInvoiceLinesWithContractLine(invoice)).length > 0) {
                String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CannotChangeContractInfoForLines");
                return msg;
            }
            if (contract.getJP_ContractType().equals("PDC")) {
                int JP_ContractContent_ID2 = invoice.get_ValueAsInt("JP_ContractContent_ID");
                if (JP_ContractContent_ID2 <= 0) {
                    Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractContent_ID")};
                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfPeriodContract")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                }
                content = MContractContent.get(Env.getCtx(), JP_ContractContent_ID2);
                if (contract.getJP_Contract_ID() != content.getJP_Contract_ID()) {
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Diff_ContractDocument");
                }
                if (content.getC_BPartner_ID() != invoice.getC_BPartner_ID() && content.getBill_BPartner_ID() != invoice.getC_BPartner_ID()) {
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_DifferentBusinessPartner_ContractContent");
                }
                int JP_ContractProcPeriod_ID = invoice.get_ValueAsInt("JP_ContractProcPeriod_ID");
                if (JP_ContractProcPeriod_ID <= 0) {
                    Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID")};
                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfPeriodContract")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                }
                MContractProcPeriod docContractProcPeriod = MContractProcPeriod.get(Env.getCtx(), JP_ContractProcPeriod_ID);
                if (content.getJP_ContractCalender_ID() != docContractProcPeriod.getJP_ContractCalender_ID()) {
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_DifferentContractCalender");
                }
                if (content.getJP_ContractProcDate_To() == null) {
                    if (content.getJP_ContractProcDate_From().compareTo(docContractProcPeriod.getEndDate()) > 0) {
                        return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_OutsideContractProcessPeriod")) + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"Invalid") + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                    }
                } else if (content.getJP_ContractProcDate_From().compareTo(docContractProcPeriod.getEndDate()) > 0 || content.getJP_ContractProcDate_To().compareTo(docContractProcPeriod.getStartDate()) < 0) {
                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_OutsideContractProcessPeriod")) + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"Invalid") + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                }
            } else if (contract.getJP_ContractType().equals("STC")) {
                int JP_ContractContent_ID3 = invoice.get_ValueAsInt("JP_ContractContent_ID");
                if (JP_ContractContent_ID3 <= 0) {
                    Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractContent_ID")};
                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfSpotContract")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                }
                content = MContractContent.get(Env.getCtx(), JP_ContractContent_ID3);
                if (contract.getJP_Contract_ID() != content.getJP_Contract_ID()) {
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Diff_ContractDocument");
                }
                if (content.getC_BPartner_ID() != invoice.getC_BPartner_ID() && content.getBill_BPartner_ID() != invoice.getC_BPartner_ID()) {
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_DifferentBusinessPartner_ContractContent");
                }
                if (invoice.get_ValueAsInt("JP_ContractProcPeriod_ID") != 0) {
                    invoice.set_ValueNoCheck("JP_ContractProcPeriod_ID", null);
                    if (pInfo == null) {
                        String nonEnterable = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NON-ENTERABLE");
                        String contractPeriod = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                        toBeConfirmed = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ToBeConfirmed");
                        column = MColumn.get((Properties)Env.getCtx(), (String)"JP_Contract", (String)"JP_ContractType");
                        String spotContract = MRefList.getListName((Properties)Env.getCtx(), (int)column.getAD_Reference_Value_ID(), (String)"STC");
                        try {
                            Dialog.info((int)0, null, (String)"JP_ContractManagementInfo", (String)(String.valueOf(nonEnterable) + " " + contractPeriod + " -> " + toBeConfirmed + " : " + spotContract));
                        }
                        catch (Exception exception) {}
                    }
                }
            } else if (contract.getJP_ContractType().equals("GLC") && (invoice.get_ValueAsInt("JP_ContractContent_ID") != 0 || invoice.get_ValueAsInt("JP_ContractProcPeriod_ID") != 0)) {
                invoice.set_ValueNoCheck("JP_ContractContent_ID", null);
                invoice.set_ValueNoCheck("JP_ContractProcPeriod_ID", null);
                if (pInfo == null) {
                    String nonEnterable = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NON-ENTERABLE");
                    String contractContent = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractContent_ID");
                    String contractPeriod = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                    toBeConfirmed = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ToBeConfirmed");
                    column = MColumn.get((Properties)Env.getCtx(), (String)"JP_Contract", (String)"JP_ContractType");
                    String generalContract = MRefList.getListName((Properties)Env.getCtx(), (int)column.getAD_Reference_Value_ID(), (String)"GLC");
                    try {
                        Dialog.info((int)0, null, (String)"JP_ContractManagementInfo", (String)(String.valueOf(nonEnterable) + " " + contractContent + " , " + contractPeriod + " -> " + toBeConfirmed + " : " + generalContract));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (type == 6 && (JP_ContractContent_ID = (invoice = (MInvoice)po).get_ValueAsInt("JP_ContractContent_ID")) > 0) {
            MContractContent content = MContractContent.get(Env.getCtx(), JP_ContractContent_ID);
            MContractAcct acctInfo = MContractAcct.get(Env.getCtx(), content.getJP_Contract_Acct_ID());
            if (acctInfo.isPostingContractAcctJP() && acctInfo.isPostingContractAcctJP() && acctInfo.getJP_RecogToInvoicePolicy() != null && !acctInfo.getJP_RecogToInvoicePolicy().equals("NO")) {
                StringBuilder sql = new StringBuilder("UPDATE ").append("JP_Recognition").append(" SET C_Invoice_ID = null WHERE C_Invoice_ID=?");
                DB.executeUpdate((String)sql.toString(), (int)invoice.getC_Invoice_ID(), (String)po.get_TrxName());
                MInvoiceLine[] iLines = invoice.getLines();
                int i = 0;
                while (i < iLines.length) {
                    StringBuilder sqLine = new StringBuilder("UPDATE ").append("JP_RecognitionLine").append(" SET C_InvoiceLine_ID = null WHERE C_InvoiceLine_ID=?");
                    DB.executeUpdate((String)sqLine.toString(), (int)iLines[i].getC_InvoiceLine_ID(), (String)po.get_TrxName());
                    ++i;
                }
            }
        }
        return null;
    }

    private String invoiceLineValidate(PO po, int type) {
        MInvoiceLine iLine;
        MInvoice invoice;
        int JP_ContractContent_ID;
        int JP_RecognitionLine_ID;
        MInvoiceLine invoiceLine;
        if (type == 1 && (invoiceLine = (MInvoiceLine)po).getRef_InvoiceLine_ID() > 0) {
            MContractLine counterContractLine;
            MInvoiceLine counterInvoiceLine = new MInvoiceLine(po.getCtx(), invoiceLine.getRef_InvoiceLine_ID(), po.get_TrxName());
            if (counterInvoiceLine.get_ValueAsInt("JP_ContractLine_ID") > 0 && (counterContractLine = MContractLine.get(po.getCtx(), counterInvoiceLine.get_ValueAsInt("JP_ContractLine_ID"))) != null && counterContractLine.getJP_ContractLine_ID() > 0 && counterContractLine.getJP_CounterContractLine_ID() > 0) {
                invoiceLine.set_ValueNoCheck("JP_ContractLine_ID", (Object)counterContractLine.getJP_CounterContractLine_ID());
            }
            if (counterInvoiceLine.get_ValueAsInt("JP_ContractProcPeriod_ID") > 0) {
                invoiceLine.set_ValueNoCheck("JP_ContractProcPeriod_ID", (Object)counterInvoiceLine.get_ValueAsInt("JP_ContractProcPeriod_ID"));
            }
        }
        if (po.get_ValueAsInt("C_OrderLine_ID") > 0 || po.get_ValueAsInt("M_RMALine_ID") > 0) {
            String msg = this.derivativeDocLineCommonCheck(po, type);
            if (!Util.isEmpty((String)msg)) {
                return msg;
            }
            if (type == 1 || type == 2 && (po.is_ValueChanged("JP_ContractLine_ID") || po.is_ValueChanged("C_OrderLine_ID") || po.is_ValueChanged("M_RMALine_ID"))) {
                MInvoiceLine invoiceLine2 = (MInvoiceLine)po;
                int JP_Contract_ID = invoiceLine2.getParent().get_ValueAsInt("JP_Contract_ID");
                int JP_ContractContent_ID2 = invoiceLine2.getParent().get_ValueAsInt("JP_ContractContent_ID");
                int JP_ContractLine_ID = invoiceLine2.get_ValueAsInt("JP_ContractLine_ID");
                if (JP_Contract_ID <= 0) {
                    return null;
                }
                MContract contract = MContract.get(Env.getCtx(), JP_Contract_ID);
                if (!contract.getJP_ContractType().equals("PDC") && !contract.getJP_ContractType().equals("STC")) {
                    return null;
                }
                int C_OrderLine_ID = invoiceLine2.getC_OrderLine_ID();
                int M_RMALine_ID = invoiceLine2.getM_RMALine_ID();
                if (C_OrderLine_ID <= 0 && M_RMALine_ID <= 0) {
                    return null;
                }
                if (invoiceLine2.getParent().getC_Order_ID() > 0 && invoiceLine2.getC_OrderLine_ID() > 0) {
                    if (invoiceLine2.getC_OrderLine().getC_Order_ID() != invoiceLine2.getParent().getC_Order_ID()) {
                        return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfPeriodContractAndSpotContract")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotBundleDifferentOrder");
                    }
                } else if (invoiceLine2.getParent().getM_RMA_ID() > 0 && invoiceLine2.getM_RMALine_ID() > 0 && invoiceLine2.getM_RMALine().getM_RMA_ID() != invoiceLine2.getParent().getM_RMA_ID()) {
                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfPeriodContractAndSpotContract")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotBundleDifferentRMA");
                }
                if (JP_ContractLine_ID <= 0) {
                    return null;
                }
                MContractLine contractLine = MContractLine.get(Env.getCtx(), JP_ContractLine_ID);
                if (contractLine.getJP_ContractContent_ID() != JP_ContractContent_ID2) {
                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Invalid")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID") + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Diff_ContractContentLine");
                }
                int invoiceLine_ContractProcPeriod_ID = invoiceLine2.get_ValueAsInt("JP_ContractProcPeriod_ID");
                MContractContent content = MContractContent.get(Env.getCtx(), JP_ContractContent_ID2);
                if (contract.getJP_ContractType().equals("PDC")) {
                    if (content.getJP_CreateDerivativeDocPolicy().equals("IV") || content.getJP_CreateDerivativeDocPolicy().equals("BT")) {
                        if (type == 2) {
                            if (invoiceLine_ContractProcPeriod_ID <= 0) {
                                Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID")};
                                return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfCreateDerivativeDocPolicy")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                            }
                            MContractProcPeriod invoiceLine_ContractProcPeriod = MContractProcPeriod.get(Env.getCtx(), invoiceLine_ContractProcPeriod_ID);
                            if (invoiceLine_ContractProcPeriod.getJP_ContractCalender_ID() != contractLine.getJP_ContractCalender_InOut_ID()) {
                                return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_SelectContractProcPeriodBelongToContractLine");
                            }
                            MInvoice invoice2 = invoiceLine2.getParent();
                            MContractProcPeriod invoicePeriod = MContractProcPeriod.get(Env.getCtx(), invoice2.get_ValueAsInt("JP_ContractProcPeriod_ID"));
                            if (invoicePeriod.getStartDate().compareTo(invoiceLine_ContractProcPeriod.getStartDate()) > 0 || invoicePeriod.getEndDate() != null && invoicePeriod.getEndDate().compareTo(invoiceLine_ContractProcPeriod.getEndDate()) < 0) {
                                return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_OutsideContractProcessPeriod")) + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"Invalid") + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                            }
                        }
                    } else if (po.get_ValueAsInt("JP_ContractProcPeriod_ID") != 0) {
                        po.set_ValueNoCheck("JP_ContractProcPeriod_ID", null);
                        ProcessInfo pInfo = Env.getProcessInfo((Properties)Env.getCtx());
                        if (pInfo == null) {
                            String nonEnterable = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NON-ENTERABLE");
                            String contractPeriod = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                            String toBeConfirmed = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ToBeConfirmed");
                            String createDerivativeDocPolicy = Msg.getElement((Properties)Env.getCtx(), (String)"JP_CreateDerivativeDocPolicy");
                            try {
                                Dialog.info((int)0, null, (String)"JP_ContractManagementInfo", (String)(String.valueOf(nonEnterable) + " " + contractPeriod + " -> " + toBeConfirmed + " : " + createDerivativeDocPolicy));
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            }
        } else if (type == 1 || type == 2 && (po.is_ValueChanged("JP_ContractLine_ID") || po.is_ValueChanged("JP_ContractProcPeriod_ID"))) {
            invoiceLine = (MInvoiceLine)po;
            ProcessInfo pInfo = Env.getProcessInfo((Properties)Env.getCtx());
            int JP_ContractLine_ID = invoiceLine.get_ValueAsInt("JP_ContractLine_ID");
            if (JP_ContractLine_ID > 0) {
                MContractLine contractLine = MContractLine.get(Env.getCtx(), JP_ContractLine_ID);
                MContract contract = contractLine.getParent().getParent();
                if (contractLine.getJP_ContractContent_ID() != invoiceLine.getParent().get_ValueAsInt("JP_ContractContent_ID")) {
                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID") + " : " + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Diff_ContractContentLine");
                }
                if (contract.getJP_ContractType().equals("PDC")) {
                    int JP_ContractProcPeriod_ID = invoiceLine.get_ValueAsInt("JP_ContractProcPeriod_ID");
                    int parent_ContractProcPeriod_ID = invoiceLine.getParent().get_ValueAsInt("JP_ContractProcPeriod_ID");
                    if (JP_ContractProcPeriod_ID <= 0) {
                        invoiceLine.set_ValueOfColumn("JP_ContractProcPeriod_ID", (Object)parent_ContractProcPeriod_ID);
                    } else if (JP_ContractProcPeriod_ID != parent_ContractProcPeriod_ID) {
                        return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_DifferentContractProcPeriod");
                    }
                } else if (contract.getJP_ContractType().equals("STC")) {
                    if (invoiceLine.get_ValueAsInt("JP_ContractProcPeriod_ID") != 0) {
                        invoiceLine.set_ValueNoCheck("JP_ContractProcPeriod_ID", null);
                        if (pInfo == null) {
                            String nonEnterable = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NON-ENTERABLE");
                            String contractPeriod = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                            String toBeConfirmed = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ToBeConfirmed");
                            MColumn column = MColumn.get((Properties)Env.getCtx(), (String)"JP_Contract", (String)"JP_ContractType");
                            String spotContract = MRefList.getListName((Properties)Env.getCtx(), (int)column.getAD_Reference_Value_ID(), (String)"STC");
                            try {
                                Dialog.info((int)0, null, (String)"JP_ContractManagementInfo", (String)(String.valueOf(nonEnterable) + " " + contractPeriod + " -> " + toBeConfirmed + " : " + spotContract));
                            }
                            catch (Exception content) {}
                        }
                    }
                } else if (contract.getJP_ContractType().equals("GLC") && (invoiceLine.get_ValueAsInt("JP_ContractLine_ID") != 0 || invoiceLine.get_ValueAsInt("JP_ContractProcPeriod_ID") != 0)) {
                    invoiceLine.set_ValueNoCheck("JP_ContractLine_ID", null);
                    invoiceLine.set_ValueNoCheck("JP_ContractProcPeriod_ID", null);
                    if (pInfo == null) {
                        String nonEnterable = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NON-ENTERABLE");
                        String cLine = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID");
                        String contractPeriod = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                        String toBeConfirmed = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ToBeConfirmed");
                        MColumn column = MColumn.get((Properties)Env.getCtx(), (String)"JP_Contract", (String)"JP_ContractType");
                        String generalContract = MRefList.getListName((Properties)Env.getCtx(), (int)column.getAD_Reference_Value_ID(), (String)"GLC");
                        try {
                            Dialog.info((int)0, null, (String)"JP_ContractManagementInfo", (String)(String.valueOf(nonEnterable) + " " + cLine + " , " + contractPeriod + " -> " + toBeConfirmed + " : " + generalContract));
                        }
                        catch (Exception exception) {}
                    }
                }
            } else if (invoiceLine.get_ValueAsInt("JP_ContractProcPeriod_ID") != 0) {
                invoiceLine.set_ValueNoCheck("JP_ContractProcPeriod_ID", null);
                if (pInfo == null) {
                    String nonEnterable = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NON-ENTERABLE");
                    String contractPeriod = Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcPeriod_ID");
                    String toBeConfirmed = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ToBeConfirmed");
                    Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractLine_ID")};
                    String message = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NOT-INOUT", (Object[])objs);
                    try {
                        Dialog.info((int)0, null, (String)"JP_ContractManagementInfo", (String)(String.valueOf(nonEnterable) + " " + contractPeriod + " -> " + toBeConfirmed + " : " + message));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if ((type == 1 || type == 2) && (JP_RecognitionLine_ID = po.get_ValueAsInt("JP_RecognitionLine_ID")) > 0 && (type == 1 || po.is_ValueChanged("QtyEntered") || po.is_ValueChanged("QtyInvoiced") || po.is_ValueChanged("JP_RecognitionLine_ID"))) {
            MInvoiceLine iLine2 = (MInvoiceLine)po;
            MRecognitionLine rLine = new MRecognitionLine(Env.getCtx(), JP_RecognitionLine_ID, po.get_TrxName());
            BigDecimal rLine_QtyInvoiced = rLine.getQtyInvoiced();
            BigDecimal iLine_QtyInvoiced = iLine2.getQtyInvoiced();
            if (rLine_QtyInvoiced.abs().compareTo(iLine_QtyInvoiced.abs()) != 0 && iLine_QtyInvoiced.compareTo(Env.ZERO) != 0) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"QtyInvoiced");
                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_RecognitionLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_QtyRecognized");
                return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_DifferentQty", (Object[])new Object[]{msg0, msg1});
            }
        }
        if (type == 6 && (JP_ContractContent_ID = (invoice = (iLine = (MInvoiceLine)po).getParent()).get_ValueAsInt("JP_ContractContent_ID")) > 0) {
            MContractContent content = MContractContent.get(Env.getCtx(), JP_ContractContent_ID);
            MContractAcct acctInfo = MContractAcct.get(Env.getCtx(), content.getJP_Contract_Acct_ID());
            if (acctInfo.isPostingContractAcctJP() && acctInfo.isPostingContractAcctJP() && acctInfo.getJP_RecogToInvoicePolicy() != null && !acctInfo.getJP_RecogToInvoicePolicy().equals("NO")) {
                StringBuilder sqLine = new StringBuilder("UPDATE ").append("JP_RecognitionLine").append(" SET C_InvoiceLine_ID = null WHERE C_InvoiceLine_ID=?");
                DB.executeUpdate((String)sqLine.toString(), (int)iLine.getC_InvoiceLine_ID(), (String)po.get_TrxName());
            }
        }
        return null;
    }

    private MInvoiceLine[] getInvoiceLinesWithContractLine(MInvoice invoice) {
        String whereClauseFinal = "C_Invoice_ID=? AND JP_ContractLine_ID IS NOT NULL ";
        List list = new Query(Env.getCtx(), "C_InvoiceLine", whereClauseFinal, invoice.get_TrxName()).setParameters(new Object[]{invoice.getC_Invoice_ID()}).setOrderBy("Line").list();
        return list.toArray(new MInvoiceLine[list.size()]);
    }

    public String factsValidate(MAcctSchema schema, List<Fact> facts, PO po) {
        String msg;
        MContractAcct m_ContractAcct;
        MContractContent m_Content;
        int JP_Contract_Acct_ID;
        int JP_ContractContent_ID;
        if (po.get_TableName().equals("C_Invoice")) {
            MInvoice invoice = (MInvoice)po;
            int JP_Contract_ID = invoice.get_ValueAsInt("JP_Contract_ID");
            int JP_ContractContent_ID2 = invoice.get_ValueAsInt("JP_ContractContent_ID");
            int JP_ContractProcPeriod_ID = invoice.get_ValueAsInt("JP_ContractProcPeriod_ID");
            int JP_Order_ID = 0;
            if (invoice.getC_Order_ID() > 0) {
                JP_Order_ID = invoice.getC_Order_ID();
            } else if (invoice.getM_RMA_ID() > 0) {
                int M_RMA_ID = invoice.getM_RMA_ID();
                MRMA rma = new MRMA(Env.getCtx(), M_RMA_ID, invoice.get_TrxName());
                JP_Order_ID = rma.get_ValueAsInt("JP_Order_ID");
            }
            for (Fact fact : facts) {
                FactLine[] factLine = fact.getLines();
                int i = 0;
                while (i < factLine.length) {
                    factLine[i].set_ValueNoCheck("JP_Invoice_ID", (Object)invoice.getC_Invoice_ID());
                    if (JP_Order_ID > 0) {
                        factLine[i].set_ValueNoCheck("JP_Order_ID", (Object)JP_Order_ID);
                    }
                    if (JP_Contract_ID > 0) {
                        factLine[i].set_ValueNoCheck("JP_Contract_ID", (Object)JP_Contract_ID);
                    }
                    if (JP_ContractContent_ID2 > 0) {
                        factLine[i].set_ValueNoCheck("JP_ContractContent_ID", (Object)JP_ContractContent_ID2);
                    }
                    if (JP_ContractProcPeriod_ID > 0) {
                        factLine[i].set_ValueNoCheck("JP_ContractProcPeriod_ID", (Object)JP_ContractProcPeriod_ID);
                    }
                    ++i;
                }
            }
        }
        if (!po.get_ValueAsBoolean("Posted") && (JP_ContractContent_ID = po.get_ValueAsInt("JP_ContractContent_ID")) > 0 && (JP_Contract_Acct_ID = (m_Content = MContractContent.get(Env.getCtx(), JP_ContractContent_ID)).getJP_Contract_Acct_ID()) > 0 && (m_ContractAcct = MContractAcct.get(Env.getCtx(), JP_Contract_Acct_ID)).isPostingContractAcctJP() && m_ContractAcct.isPostingGLJournalJP() && "BT".equals(m_ContractAcct.getJP_GLJournal_JournalPolicy()) && !Util.isEmpty((String)(msg = this.createGLJournal((MInvoice)po, m_ContractAcct, schema, facts)))) {
            return msg;
        }
        return null;
    }

    private String createGLJournal(MInvoice m_Invoice, MContractAcct m_ContractAcct, MAcctSchema m_AcctSchema, List<Fact> facts) {
        MDocType docType = MDocType.get((int)m_Invoice.getC_DocTypeTarget_ID());
        if (!docType.getDocBaseType().equals("ARI") && !docType.getDocBaseType().equals("API")) {
            return null;
        }
        if (!this.isCreateGLJournal(m_Invoice, m_ContractAcct, m_AcctSchema)) {
            return null;
        }
        int JP_DocTypeGLJournal_ID = docType.get_ValueAsInt("JP_DocTypeGLJournal_ID");
        if (JP_DocTypeGLJournal_ID == 0) {
            JP_DocTypeGLJournal_ID = MDocType.getDocType((String)"GLJ");
        }
        MDocType docTypeGL = MDocType.get((int)JP_DocTypeGLJournal_ID);
        Timestamp p_DateDoc = null;
        if ("FX".equals(m_ContractAcct.getJP_GLJournal_DateDocSelect())) {
            p_DateDoc = m_ContractAcct.getJP_GLJournal_DateDoc();
        } else if ("IV".equals(m_ContractAcct.getJP_GLJournal_DateDocSelect())) {
            p_DateDoc = m_Invoice.getDateAcct();
        }
        Timestamp p_DateAcct = null;
        if ("FX".equals(m_ContractAcct.getJP_GLJournal_DateAcctSelect())) {
            p_DateAcct = m_ContractAcct.getJP_GLJournal_DateAcct();
        } else if ("IV".equals(m_ContractAcct.getJP_GLJournal_DateAcctSelect())) {
            p_DateAcct = m_Invoice.getDateAcct();
        }
        int C_Period_ID = MPeriod.getC_Period_ID((Properties)m_Invoice.getCtx(), (Timestamp)p_DateAcct, (int)m_Invoice.getAD_Org_ID());
        if (C_Period_ID == 0) {
            return String.valueOf(Msg.getMsg((Properties)m_Invoice.getCtx(), (String)"PeriodNotFound")) + " : " + DisplayType.getDateFormat().format(p_DateAcct);
        }
        Fact fact = null;
        for (Fact f : facts) {
            if (m_AcctSchema.getC_AcctSchema_ID() != f.getAcctSchema().getC_AcctSchema_ID()) continue;
            fact = f;
        }
        MJournal m_Journal = new MJournal(m_Invoice.getCtx(), 0, m_Invoice.get_TrxName());
        PO.copyValues((PO)m_Invoice, (PO)m_Journal);
        m_Journal.setAD_Org_ID(m_Invoice.getAD_Org_ID());
        m_Journal.setC_AcctSchema_ID(m_AcctSchema.getC_AcctSchema_ID());
        m_Journal.setC_DocType_ID(JP_DocTypeGLJournal_ID);
        if (docTypeGL.isDocNoControlled()) {
            m_Journal.setDocumentNo(null);
        } else {
            m_Journal.setDocumentNo(String.valueOf(m_Invoice.getDocumentNo()) + "-" + m_AcctSchema.getC_AcctSchema_ID());
        }
        m_Journal.setGL_Category_ID(docTypeGL.getGL_Category_ID());
        m_Journal.setPostingType("A");
        m_Journal.setDateDoc(p_DateDoc);
        m_Journal.setDateAcct(p_DateAcct);
        m_Journal.setC_Period_ID(C_Period_ID);
        m_Journal.setDescription(m_Invoice.getDocumentInfo());
        m_Journal.setC_Currency_ID(m_AcctSchema.getC_Currency_ID());
        m_Journal.setDocStatus("DR");
        m_Journal.setDocAction("CO");
        int columnIndex = m_Journal.get_ColumnIndex("JP_Order_ID");
        if (columnIndex > -1) {
            m_Journal.set_ValueNoCheck("JP_Order_ID", m_Invoice.getC_Order_ID() == 0 ? null : Integer.valueOf(m_Invoice.getC_Order_ID()));
        }
        if ((columnIndex = m_Journal.get_ColumnIndex("JP_Invoice_ID")) > -1) {
            m_Journal.set_ValueNoCheck("JP_Invoice_ID", m_Invoice.getC_Invoice_ID() == 0 ? null : Integer.valueOf(m_Invoice.getC_Invoice_ID()));
        }
        m_Journal.saveEx(m_Invoice.get_TrxName());
        FactLine[] factLines = fact.getLines();
        MInvoiceLine[] iLines = m_Invoice.getLines();
        MAccount m_AccountReverse = null;
        MAccount m_AccountTransfer = null;
        int lineNo = 1;
        MInvoiceLine[] mInvoiceLineArray = iLines;
        int n = iLines.length;
        int n2 = 0;
        while (n2 < n) {
            MInvoiceLine iLine = mInvoiceLineArray[n2];
            FactLine[] factLineArray = factLines;
            int n3 = factLines.length;
            int n4 = 0;
            while (n4 < n3) {
                FactLine factLine = factLineArray[n4];
                if (iLine.getC_InvoiceLine_ID() == factLine.getLine_ID() && this.isCreateGLJournalLine(m_Invoice, iLine, m_ContractAcct, m_AcctSchema)) {
                    if (m_Invoice.isSOTrx()) {
                        if (iLine.getM_Product_ID() > 0) {
                            m_AccountReverse = this.getP_Revenue_Acct(m_Invoice, iLine, m_ContractAcct, m_AcctSchema);
                            m_AccountTransfer = this.getJP_GL_Revenue_Acct(m_Invoice, iLine, m_ContractAcct, m_AcctSchema);
                            if (factLine.getAccount_ID() != m_AccountReverse.getAccount_ID()) {
                                if (!m_AcctSchema.isTradeDiscountPosted()) {
                                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_UnexpectedError")) + " : Unexpected Account of Product - !MAcctSchema[" + m_AcctSchema.getName() + "].isTradeDiscountPosted()";
                                }
                                m_AccountReverse = this.getP_TradeDiscountGrant_Acct(m_Invoice, iLine, m_ContractAcct, m_AcctSchema);
                                if (factLine.getAccount_ID() != m_AccountReverse.getAccount_ID()) {
                                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_UnexpectedError")) + " : Unexpected Account of Product - FactLine.getAccount_ID() != P_TradeDiscountGrant_Acct";
                                }
                                m_AccountTransfer = this.getJP_GL_TradeDiscountGrant_Acct(m_Invoice, iLine, m_ContractAcct, m_AcctSchema, factLine);
                            }
                        } else if (iLine.getC_Charge_ID() > 0) {
                            m_AccountReverse = this.getCh_Expense_Acct(m_Invoice, iLine, m_ContractAcct, m_AcctSchema);
                            m_AccountTransfer = this.getJP_GL_Ch_Expense_Acct(m_Invoice, iLine, m_ContractAcct, m_AcctSchema);
                            if (factLine.getAccount_ID() != m_AccountReverse.getAccount_ID()) {
                                if (!m_AcctSchema.isTradeDiscountPosted()) {
                                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_UnexpectedError")) + " : Unexpected Account of Charge - !MAcctSchema[" + m_AcctSchema.getName() + "]+.isTradeDiscountPosted()";
                                }
                                m_AccountReverse = this.getP_TradeDiscountGrant_Acct(m_Invoice, iLine, m_ContractAcct, m_AcctSchema);
                                if (factLine.getAccount_ID() != m_AccountReverse.getAccount_ID()) {
                                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_UnexpectedError")) + " : Unexpected Account of Charge - FactLine.getAccount_ID() != P_TradeDiscountGrant_Acct";
                                }
                                m_AccountTransfer = this.getJP_GL_TradeDiscountGrant_Acct(m_Invoice, iLine, m_ContractAcct, m_AcctSchema, factLine);
                            }
                        }
                        if (this.createGLJournalLine(m_Journal, m_Invoice, iLine, null, factLine, m_AccountReverse, lineNo++, true) == null) {
                            return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_UnexpectedError")) + " Could Not Create GL Journal Line " + "- AR Invoice Dr";
                        }
                        if (this.createGLJournalLine(m_Journal, m_Invoice, iLine, null, factLine, m_AccountTransfer, lineNo++, false) == null) {
                            return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_UnexpectedError")) + " Could Not Create GL Journal Line " + "- AR Invoice Cr";
                        }
                    } else {
                        if (iLine.getM_Product_ID() > 0) {
                            m_AccountReverse = this.getP_Expense_Acct(m_Invoice, iLine, m_ContractAcct, m_AcctSchema);
                            m_AccountTransfer = this.getJP_GL_Expense_Acct(m_Invoice, iLine, m_ContractAcct, m_AcctSchema);
                            if (factLine.getAccount_ID() != m_AccountReverse.getAccount_ID()) {
                                if (!m_AcctSchema.isTradeDiscountPosted()) {
                                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_UnexpectedError")) + " : Unexpected Account of Product - !MAcctSchema[" + m_AcctSchema.getName() + "].isTradeDiscountPosted()";
                                }
                                m_AccountReverse = this.getP_TradeDiscountRec_Acct(m_Invoice, iLine, m_ContractAcct, m_AcctSchema);
                                if (factLine.getAccount_ID() != m_AccountReverse.getAccount_ID()) {
                                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_UnexpectedError")) + " : Unexpected Account of Product - FactLine.getAccount_ID() != P_TradeDiscountRec_Acct";
                                }
                                m_AccountTransfer = this.getJP_GL_TradeDiscountRec_Acct(m_Invoice, iLine, m_ContractAcct, m_AcctSchema, factLine);
                            }
                        } else if (iLine.getC_Charge_ID() > 0) {
                            m_AccountReverse = this.getCh_Expense_Acct(m_Invoice, iLine, m_ContractAcct, m_AcctSchema);
                            m_AccountTransfer = this.getJP_GL_Ch_Expense_Acct(m_Invoice, iLine, m_ContractAcct, m_AcctSchema);
                            if (factLine.getAccount_ID() != m_AccountReverse.getAccount_ID()) {
                                if (!m_AcctSchema.isTradeDiscountPosted()) {
                                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_UnexpectedError")) + " : Unexpected Account of Charge - !MAcctSchema[" + m_AcctSchema.getName() + "].isTradeDiscountPosted()";
                                }
                                m_AccountReverse = this.getP_TradeDiscountRec_Acct(m_Invoice, iLine, m_ContractAcct, m_AcctSchema);
                                if (factLine.getAccount_ID() != m_AccountReverse.getAccount_ID()) {
                                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_UnexpectedError")) + " : Unexpected Account of Charge - FactLine.getAccount_ID() != P_TradeDiscountRec_Acct";
                                }
                                m_AccountTransfer = this.getJP_GL_TradeDiscountRec_Acct(m_Invoice, iLine, m_ContractAcct, m_AcctSchema, factLine);
                            }
                        }
                        if (this.createGLJournalLine(m_Journal, m_Invoice, iLine, null, factLine, m_AccountTransfer, lineNo++, false) == null) {
                            return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_UnexpectedError")) + " Could Not Create GL Journal Line " + "- AP Invoice Dr";
                        }
                        if (this.createGLJournalLine(m_Journal, m_Invoice, iLine, null, factLine, m_AccountReverse, lineNo++, true) == null) {
                            return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_UnexpectedError")) + " Could Not Create GL Journal Line " + "- AP Invoice Cr";
                        }
                    }
                }
                ++n4;
            }
            ++n2;
        }
        if (this.isCreateTaxAdjustGLJournalLine(m_Invoice, m_ContractAcct, m_AcctSchema)) {
            MInvoiceTax[] iTaxes;
            MInvoiceTax[] mInvoiceTaxArray = iTaxes = m_Invoice.getTaxes(true);
            int n5 = iTaxes.length;
            n = 0;
            while (n < n5) {
                MInvoiceTax iTax = mInvoiceTaxArray[n];
                if (iTax.getTaxAmt().compareTo(Env.ZERO) != 0) {
                    FactLine factLine = null;
                    int i = 0;
                    while (i < factLines.length) {
                        if (iTax.getC_Tax_ID() == factLines[i].getC_Tax_ID() && factLines[i].getLine_ID() == 0) {
                            factLine = factLines[i];
                            break;
                        }
                        ++i;
                    }
                    if (factLine != null) {
                        if (m_Invoice.isSOTrx()) {
                            m_AccountTransfer = this.getJP_GL_TaxDue_Acct(m_Invoice, iTax, m_ContractAcct, m_AcctSchema);
                            if (m_AccountTransfer != null) {
                                m_AccountReverse = this.getT_TaxDue_Acct(m_Invoice, iTax, m_ContractAcct, m_AcctSchema);
                                if (this.createGLJournalLine(m_Journal, m_Invoice, null, iTax, factLine, m_AccountReverse, lineNo++, true) == null) {
                                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_UnexpectedError")) + " Could Not Create GL Journal Line " + "- AR Tax adjust Dr";
                                }
                                if (this.createGLJournalLine(m_Journal, m_Invoice, null, iTax, factLine, m_AccountTransfer, lineNo++, false) == null) {
                                    return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_UnexpectedError")) + " Could Not Create GL Journal Line " + "- AR Tax adjust Cr";
                                }
                            }
                        } else if (!(!iTax.getC_Tax().isSalesTax() ? (m_AccountTransfer = this.getJP_GL_TaxCredit_Acct(m_Invoice, iTax, m_ContractAcct, m_AcctSchema)) == null : (m_AccountTransfer = this.getJP_GL_TaxExpense_Acct(m_Invoice, iTax, m_ContractAcct, m_AcctSchema)) == null)) {
                            m_AccountReverse = iTax.getC_Tax().isSalesTax() ? this.getT_TaxExpense_Acct(m_Invoice, iTax, m_ContractAcct, m_AcctSchema) : this.getT_TaxCredit_Acct(m_Invoice, iTax, m_ContractAcct, m_AcctSchema);
                            if (this.createGLJournalLine(m_Journal, m_Invoice, null, iTax, factLine, m_AccountTransfer, lineNo++, false) == null) {
                                return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_UnexpectedError")) + " Could Not Create GL Journal Line " + "- AP Tax adjust Dr";
                            }
                            if (this.createGLJournalLine(m_Journal, m_Invoice, null, iTax, factLine, m_AccountReverse, lineNo++, true) == null) {
                                return String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_UnexpectedError")) + " Could Not Create GL Journal Line " + "- AP Tax adjust Cr";
                            }
                        }
                    }
                }
                ++n;
            }
        }
        return null;
    }

    private MJournalLine createGLJournalLine(MJournal m_Journal, MInvoice m_Invoice, MInvoiceLine m_InvoiceLine, MInvoiceTax iTax, FactLine factLine, MAccount m_Account, int lineNo, boolean isReverse) {
        if (m_Journal == null || m_Journal.getGL_Journal_ID() == 0 || m_Invoice == null | factLine == null) {
            return null;
        }
        if (!isReverse && m_Account == null) {
            return null;
        }
        MJournalLine glLine = new MJournalLine(m_Journal.getCtx(), 0, m_Journal.get_TrxName());
        PO.copyValues((PO)factLine, (PO)glLine);
        glLine.setAD_OrgTrx_ID(factLine.getAD_OrgTrx_ID());
        glLine.setC_BPartner_ID(factLine.getC_BPartner_ID());
        glLine.setM_Product_ID(factLine.getM_Product_ID());
        glLine.setC_SalesRegion_ID(factLine.getC_SalesRegion_ID());
        glLine.setC_Activity_ID(factLine.getC_Activity_ID());
        glLine.setC_Campaign_ID(factLine.getC_Campaign_ID());
        glLine.setC_Project_ID(factLine.getC_Project_ID());
        glLine.setC_LocFrom_ID(factLine.getC_LocFrom_ID());
        glLine.setC_LocTo_ID(factLine.getC_LocTo_ID());
        glLine.setUser1_ID(factLine.getUser1_ID());
        glLine.setUser2_ID(factLine.getUser2_ID());
        glLine.setLine(lineNo * 10);
        glLine.setAD_Org_ID(m_Journal.getAD_Org_ID());
        glLine.setGL_Journal_ID(m_Journal.getGL_Journal_ID());
        glLine.setDateAcct(m_Journal.getDateAcct());
        glLine.setCurrencyRate(Env.ONE);
        glLine.setC_Currency_ID(m_Journal.getC_Currency_ID());
        if (glLine.getC_BPartner_ID() == 0) {
            glLine.setC_BPartner_ID(m_Invoice.getC_BPartner_ID());
        }
        if (glLine.get_ColumnIndex("JP_Order_ID") > -1 && m_Journal.get_ColumnIndex("JP_Order_ID") > -1) {
            glLine.set_ValueNoCheck("JP_Order_ID", m_Journal.get_Value("JP_Order_ID"));
        }
        if (glLine.get_ColumnIndex("JP_Contract_ID") > -1 && m_Journal.get_ColumnIndex("JP_Contract_ID") > -1) {
            glLine.set_ValueNoCheck("JP_Contract_ID", m_Journal.get_Value("JP_Contract_ID"));
        }
        if (glLine.get_ColumnIndex("JP_ContractContent_ID") > -1 && m_Journal.get_ColumnIndex("JP_ContractContent_ID") > -1) {
            glLine.set_ValueNoCheck("JP_ContractContent_ID", m_Journal.get_Value("JP_ContractContent_ID"));
        }
        if (glLine.get_ColumnIndex("JP_ContractProcPeriod_ID") > -1 && m_Journal.get_ColumnIndex("JP_ContractProcPeriod_ID") > -1) {
            glLine.set_ValueNoCheck("JP_ContractProcPeriod_ID", m_Journal.get_Value("JP_ContractProcPeriod_ID"));
        }
        if (m_InvoiceLine != null) {
            glLine.set_ValueNoCheck("JP_PriceActual", (Object)m_InvoiceLine.getPriceActual());
            if (glLine.get_ColumnIndex("JP_InvoiceLine_ID") > -1) {
                glLine.set_ValueNoCheck("JP_InvoiceLine_ID", m_InvoiceLine.get_Value("C_InvoiceLine_ID"));
            }
            if (glLine.get_ColumnIndex("JP_ContractLine_ID") > -1 && m_InvoiceLine.get_ColumnIndex("JP_ContractLine_ID") > -1) {
                glLine.set_ValueNoCheck("JP_ContractLine_ID", m_InvoiceLine.get_Value("JP_ContractLine_ID"));
            }
        }
        if (iTax != null) {
            glLine.set_ValueNoCheck("C_Tax_ID", (Object)iTax.getC_Tax_ID());
            glLine.set_ValueNoCheck("JP_SOPOType", (Object)"N");
        }
        if (isReverse) {
            glLine.setAccount_ID(factLine.getAccount_ID());
            glLine.setQty(factLine.getQty().negate());
            glLine.setAmtSourceDr(factLine.getAmtAcctCr());
            glLine.setAmtAcctDr(factLine.getAmtAcctCr());
            glLine.setAmtSourceCr(factLine.getAmtAcctDr());
            glLine.setAmtAcctCr(factLine.getAmtAcctDr());
            if (iTax != null) {
                glLine.set_ValueNoCheck("JP_TaxBaseAmt", (Object)iTax.getTaxBaseAmt().negate());
                glLine.set_ValueNoCheck("JP_TaxAmt", (Object)iTax.getTaxAmt().negate());
            }
        } else {
            glLine.setAccount_ID(m_Account.getAccount_ID());
            glLine.setQty(factLine.getQty());
            glLine.setAmtSourceDr(factLine.getAmtAcctDr());
            glLine.setAmtAcctDr(factLine.getAmtAcctDr());
            glLine.setAmtSourceCr(factLine.getAmtAcctCr());
            glLine.setAmtAcctCr(factLine.getAmtAcctCr());
            if (iTax != null) {
                glLine.set_ValueNoCheck("JP_TaxBaseAmt", (Object)iTax.getTaxBaseAmt());
                glLine.set_ValueNoCheck("JP_TaxAmt", (Object)iTax.getTaxAmt());
            }
        }
        glLine.saveEx(m_Journal.get_TrxName());
        return glLine;
    }

    private boolean isCreateGLJournal(MInvoice m_Invoice, MContractAcct m_ContractAcct, MAcctSchema m_AcctSchema) {
        MInvoiceLine[] lines;
        boolean isCreateGLJournal = false;
        MInvoiceLine[] mInvoiceLineArray = lines = m_Invoice.getLines();
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            MInvoiceLine line = mInvoiceLineArray[n2];
            if (this.isCreateGLJournalLine(m_Invoice, line, m_ContractAcct, m_AcctSchema)) {
                isCreateGLJournal = true;
                break;
            }
            ++n2;
        }
        if (isCreateGLJournal) {
            return true;
        }
        return this.isCreateTaxAdjustGLJournalLine(m_Invoice, m_ContractAcct, m_AcctSchema);
    }

    private boolean isCreateGLJournalLine(MInvoice m_Invoice, MInvoiceLine m_InvoiceLine, MContractAcct m_ContractAcct, MAcctSchema m_AcctSchema) {
        int M_Product_ID = m_InvoiceLine.getM_Product_ID();
        int C_Charge_ID = m_InvoiceLine.getC_Charge_ID();
        MAccount m_Account = null;
        if (m_Invoice.isSOTrx()) {
            if (M_Product_ID > 0) {
                m_Account = this.getJP_GL_Revenue_Acct(m_Invoice, m_InvoiceLine, m_ContractAcct, m_AcctSchema);
            } else if (C_Charge_ID > 0) {
                m_Account = this.getJP_GL_Ch_Expense_Acct(m_Invoice, m_InvoiceLine, m_ContractAcct, m_AcctSchema);
            }
        } else if (M_Product_ID > 0) {
            m_Account = this.getJP_GL_Expense_Acct(m_Invoice, m_InvoiceLine, m_ContractAcct, m_AcctSchema);
        } else if (C_Charge_ID > 0) {
            m_Account = this.getJP_GL_Ch_Expense_Acct(m_Invoice, m_InvoiceLine, m_ContractAcct, m_AcctSchema);
        }
        return m_Account != null;
    }

    private boolean isCreateTaxAdjustGLJournalLine(MInvoice m_Invoice, MContractAcct m_ContractAcct, MAcctSchema m_AcctSchema) {
        MInvoiceTax[] iTaxes = m_Invoice.getTaxes(true);
        if (iTaxes.length == 0) {
            return false;
        }
        boolean isCreateTaxAdjustGLJournalLine = false;
        MAccount m_Account = null;
        MInvoiceTax[] mInvoiceTaxArray = iTaxes;
        int n = iTaxes.length;
        int n2 = 0;
        while (n2 < n) {
            MInvoiceTax iTax = mInvoiceTaxArray[n2];
            if (iTax.getTaxAmt().compareTo(Env.ZERO) != 0 && (m_Account = m_Invoice.isSOTrx() ? this.getJP_GL_TaxDue_Acct(m_Invoice, iTax, m_ContractAcct, m_AcctSchema) : (iTax.getC_Tax().isSalesTax() ? this.getJP_GL_TaxExpense_Acct(m_Invoice, iTax, m_ContractAcct, m_AcctSchema) : this.getJP_GL_TaxCredit_Acct(m_Invoice, iTax, m_ContractAcct, m_AcctSchema))) != null) {
                isCreateTaxAdjustGLJournalLine = true;
                break;
            }
            ++n2;
        }
        return isCreateTaxAdjustGLJournalLine;
    }

    private MAccount getJP_GL_Revenue_Acct(MInvoice m_Invoice, MInvoiceLine m_InvoiceLine, MContractAcct m_ContractAcct, MAcctSchema m_AcctSchema) {
        int M_Product_ID = m_InvoiceLine.getM_Product_ID();
        if (M_Product_ID > 0) {
            MProduct m_Product = MProduct.get((int)M_Product_ID);
            if ("I".equals(m_Product.getProductType())) {
                return null;
            }
            MContractProductAcct m_ContractProductAcct = m_ContractAcct.getContractProductAcct(m_Product.getM_Product_Category_ID(), m_AcctSchema.getC_AcctSchema_ID(), false);
            if (m_ContractProductAcct == null) {
                return null;
            }
            int JP_GL_Revenue_Acct = m_ContractProductAcct.getJP_GL_Revenue_Acct();
            if (JP_GL_Revenue_Acct == 0) {
                return null;
            }
            return MAccount.get((Properties)m_Invoice.getCtx(), (int)JP_GL_Revenue_Acct);
        }
        return null;
    }

    private MAccount getJP_GL_TradeDiscountGrant_Acct(MInvoice m_Invoice, MInvoiceLine m_InvoiceLine, MContractAcct m_ContractAcct, MAcctSchema m_AcctSchema, FactLine factLine) {
        int M_Product_ID = m_InvoiceLine.getM_Product_ID();
        if (M_Product_ID > 0) {
            MProduct m_Product = MProduct.get((int)M_Product_ID);
            if ("I".equals(m_Product.getProductType())) {
                return null;
            }
            MContractProductAcct m_ContractProductAcct = m_ContractAcct.getContractProductAcct(m_Product.getM_Product_Category_ID(), m_AcctSchema.getC_AcctSchema_ID(), false);
            if (m_ContractProductAcct == null) {
                return null;
            }
            int JP_GL_TradeDiscountGrant_Acct = m_ContractProductAcct.getJP_GL_TradeDiscountGrant_Acct();
            if (JP_GL_TradeDiscountGrant_Acct == 0) {
                return this.getP_TradeDiscountGrant_Acct(m_Invoice, m_InvoiceLine, m_ContractAcct, m_AcctSchema);
            }
            return MAccount.get((Properties)m_Invoice.getCtx(), (int)JP_GL_TradeDiscountGrant_Acct);
        }
        return factLine.getAccount();
    }

    private MAccount getP_Revenue_Acct(MInvoice m_Invoice, MInvoiceLine m_InvoiceLine, MContractAcct m_ContractAcct, MAcctSchema m_AcctSchema) {
        int M_Product_ID = m_InvoiceLine.getM_Product_ID();
        if (M_Product_ID > 0) {
            MProduct m_Product = MProduct.get((int)M_Product_ID);
            if ("I".equals(m_Product.getProductType())) {
                return null;
            }
            MContractProductAcct m_ContractProductAcct = m_ContractAcct.getContractProductAcct(m_Product.getM_Product_Category_ID(), m_AcctSchema.getC_AcctSchema_ID(), false);
            if (m_ContractProductAcct == null) {
                return null;
            }
            int P_Revenue_Acct = m_ContractProductAcct.getP_Revenue_Acct();
            if (P_Revenue_Acct == 0) {
                return this.getProductCost(m_InvoiceLine).getAccount(1, m_AcctSchema);
            }
            return MAccount.get((Properties)m_Invoice.getCtx(), (int)P_Revenue_Acct);
        }
        return null;
    }

    private MAccount getP_TradeDiscountGrant_Acct(MInvoice m_Invoice, MInvoiceLine m_InvoiceLine, MContractAcct m_ContractAcct, MAcctSchema m_AcctSchema) {
        if (m_InvoiceLine.getM_Product_ID() > 0) {
            MContractProductAcct contractProductAcct = m_ContractAcct.getContractProductAcct(m_InvoiceLine.getM_Product().getM_Product_Category_ID(), m_AcctSchema.getC_AcctSchema_ID(), false);
            if (contractProductAcct != null && contractProductAcct.getP_TradeDiscountGrant_Acct() > 0) {
                return MAccount.get((Properties)m_Invoice.getCtx(), (int)contractProductAcct.getP_TradeDiscountGrant_Acct());
            }
            DocLine docLine = new DocLine((PO)m_InvoiceLine, null);
            return docLine.getAccount(8, m_AcctSchema);
        }
        return MAccount.get((Properties)m_Invoice.getCtx(), (int)m_AcctSchema.getAcctSchemaDefault().getP_TradeDiscountGrant_Acct());
    }

    private MAccount getJP_GL_Expense_Acct(MInvoice m_Invoice, MInvoiceLine m_InvoiceLine, MContractAcct m_ContractAcct, MAcctSchema m_AcctSchema) {
        int M_Product_ID = m_InvoiceLine.getM_Product_ID();
        if (M_Product_ID > 0) {
            MProduct m_Product = MProduct.get((int)M_Product_ID);
            if ("I".equals(m_Product.getProductType())) {
                return null;
            }
            MContractProductAcct m_ContractProductAcct = m_ContractAcct.getContractProductAcct(m_Product.getM_Product_Category_ID(), m_AcctSchema.getC_AcctSchema_ID(), false);
            if (m_ContractProductAcct == null) {
                return null;
            }
            int JP_GL_Expense_Acct = m_ContractProductAcct.getJP_GL_Expense_Acct();
            if (JP_GL_Expense_Acct == 0) {
                return null;
            }
            return MAccount.get((Properties)m_Invoice.getCtx(), (int)JP_GL_Expense_Acct);
        }
        return null;
    }

    private MAccount getP_Expense_Acct(MInvoice m_Invoice, MInvoiceLine m_InvoiceLine, MContractAcct m_ContractAcct, MAcctSchema m_AcctSchema) {
        int M_Product_ID = m_InvoiceLine.getM_Product_ID();
        if (M_Product_ID > 0) {
            MProduct m_Product = MProduct.get((int)M_Product_ID);
            if ("I".equals(m_Product.getProductType())) {
                return null;
            }
            MContractProductAcct m_ContractProductAcct = m_ContractAcct.getContractProductAcct(m_Product.getM_Product_Category_ID(), m_AcctSchema.getC_AcctSchema_ID(), false);
            if (m_ContractProductAcct == null) {
                return null;
            }
            int P_Expense_Acct = m_ContractProductAcct.getP_Expense_Acct();
            if (P_Expense_Acct == 0) {
                return this.getProductCost(m_InvoiceLine).getAccount(2, m_AcctSchema);
            }
            return MAccount.get((Properties)m_Invoice.getCtx(), (int)P_Expense_Acct);
        }
        return null;
    }

    private MAccount getP_TradeDiscountRec_Acct(MInvoice m_Invoice, MInvoiceLine m_InvoiceLine, MContractAcct m_ContractAcct, MAcctSchema m_AcctSchema) {
        if (m_InvoiceLine.getM_Product_ID() > 0) {
            MContractProductAcct contractProductAcct = m_ContractAcct.getContractProductAcct(m_InvoiceLine.getM_Product().getM_Product_Category_ID(), m_AcctSchema.getC_AcctSchema_ID(), false);
            if (contractProductAcct != null && contractProductAcct.getP_TradeDiscountRec_Acct() > 0) {
                return MAccount.get((Properties)m_Invoice.getCtx(), (int)contractProductAcct.getP_TradeDiscountRec_Acct());
            }
            DocLine docLine = new DocLine((PO)m_InvoiceLine, null);
            return docLine.getAccount(7, m_AcctSchema);
        }
        return MAccount.get((Properties)m_Invoice.getCtx(), (int)m_AcctSchema.getAcctSchemaDefault().getP_TradeDiscountRec_Acct());
    }

    private MAccount getJP_GL_TradeDiscountRec_Acct(MInvoice m_Invoice, MInvoiceLine m_InvoiceLine, MContractAcct m_ContractAcct, MAcctSchema m_AcctSchema, FactLine factLine) {
        int M_Product_ID = m_InvoiceLine.getM_Product_ID();
        if (M_Product_ID > 0) {
            MProduct m_Product = MProduct.get((int)M_Product_ID);
            if ("I".equals(m_Product.getProductType())) {
                return null;
            }
            MContractProductAcct m_ContractProductAcct = m_ContractAcct.getContractProductAcct(m_Product.getM_Product_Category_ID(), m_AcctSchema.getC_AcctSchema_ID(), false);
            if (m_ContractProductAcct == null) {
                return null;
            }
            int JP_GL_TradeDiscountRec_Acct = m_ContractProductAcct.getJP_GL_TradeDiscountRec_Acct();
            if (JP_GL_TradeDiscountRec_Acct == 0) {
                return this.getP_TradeDiscountRec_Acct(m_Invoice, m_InvoiceLine, m_ContractAcct, m_AcctSchema);
            }
            return MAccount.get((Properties)m_Invoice.getCtx(), (int)JP_GL_TradeDiscountRec_Acct);
        }
        return factLine.getAccount();
    }

    private MAccount getJP_GL_Ch_Expense_Acct(MInvoice m_Invoice, MInvoiceLine m_InvoiceLine, MContractAcct m_ContractAcct, MAcctSchema m_AcctSchema) {
        MContractChargeAcct m_ContractChargeAcct = m_ContractAcct.getContracChargeAcct(m_InvoiceLine.getC_Charge_ID(), m_AcctSchema.getC_AcctSchema_ID(), false);
        if (m_ContractChargeAcct == null) {
            return null;
        }
        int JP_GL_Ch_Expense_Acct = m_ContractChargeAcct.getJP_GL_Ch_Expense_Acct();
        if (JP_GL_Ch_Expense_Acct == 0) {
            return null;
        }
        return MAccount.get((Properties)m_Invoice.getCtx(), (int)JP_GL_Ch_Expense_Acct);
    }

    private MAccount getCh_Expense_Acct(MInvoice m_Invoice, MInvoiceLine m_InvoiceLine, MContractAcct m_ContractAcct, MAcctSchema m_AcctSchema) {
        MContractChargeAcct m_ContractChargeAcct = m_ContractAcct.getContracChargeAcct(m_InvoiceLine.getC_Charge_ID(), m_AcctSchema.getC_AcctSchema_ID(), false);
        if (m_ContractChargeAcct == null || m_ContractChargeAcct.getCh_Expense_Acct() == 0) {
            return this.getProductCost(m_InvoiceLine).getAccount(2, m_AcctSchema);
        }
        return MAccount.get((Properties)m_Invoice.getCtx(), (int)m_ContractChargeAcct.getCh_Expense_Acct());
    }

    private MAccount getJP_GL_TaxDue_Acct(MInvoice m_Invoice, MInvoiceTax m_InvoiceTax, MContractAcct m_ContractAcct, MAcctSchema m_AcctSchema) {
        MContractTaxAcct m_ContractTaxAcct = m_ContractAcct.getContracTaxAcct(m_InvoiceTax.getC_Tax_ID(), m_AcctSchema.getC_AcctSchema_ID(), false);
        if (m_ContractTaxAcct == null) {
            return null;
        }
        int JP_GL_TaxDue_Acct = m_ContractTaxAcct.getJP_GL_TaxDue_Acct();
        if (JP_GL_TaxDue_Acct == 0) {
            return null;
        }
        return MAccount.get((Properties)m_Invoice.getCtx(), (int)JP_GL_TaxDue_Acct);
    }

    private MAccount getT_TaxDue_Acct(MInvoice m_Invoice, MInvoiceTax m_InvoiceTax, MContractAcct m_ContractAcct, MAcctSchema m_AcctSchema) {
        MContractTaxAcct m_ContractTaxAcct = m_ContractAcct.getContracTaxAcct(m_InvoiceTax.getC_Tax_ID(), m_AcctSchema.getC_AcctSchema_ID(), false);
        if (m_ContractTaxAcct != null && m_ContractTaxAcct.getT_Due_Acct() > 0) {
            return MAccount.get((Properties)m_Invoice.getCtx(), (int)m_ContractTaxAcct.getT_Due_Acct());
        }
        DocTax docTax = new DocTax(m_InvoiceTax.getC_Tax_ID(), "", Env.ZERO, Env.ZERO, Env.ZERO, m_Invoice.isSOTrx());
        return docTax.getAccount(0, m_AcctSchema);
    }

    private MAccount getJP_GL_TaxCredit_Acct(MInvoice m_Invoice, MInvoiceTax m_InvoiceTax, MContractAcct m_ContractAcct, MAcctSchema m_AcctSchema) {
        MContractTaxAcct m_ContractTaxAcct = m_ContractAcct.getContracTaxAcct(m_InvoiceTax.getC_Tax_ID(), m_AcctSchema.getC_AcctSchema_ID(), false);
        if (m_ContractTaxAcct == null) {
            return null;
        }
        int JP_GL_TaxCredit_Acct = m_ContractTaxAcct.getJP_GL_TaxCredit_Acct();
        if (JP_GL_TaxCredit_Acct == 0) {
            return null;
        }
        return MAccount.get((Properties)m_Invoice.getCtx(), (int)JP_GL_TaxCredit_Acct);
    }

    private MAccount getT_TaxCredit_Acct(MInvoice m_Invoice, MInvoiceTax m_InvoiceTax, MContractAcct m_ContractAcct, MAcctSchema m_AcctSchema) {
        MContractTaxAcct m_ContractTaxAcct = m_ContractAcct.getContracTaxAcct(m_InvoiceTax.getC_Tax_ID(), m_AcctSchema.getC_AcctSchema_ID(), false);
        if (m_ContractTaxAcct != null && m_ContractTaxAcct.getT_Credit_Acct() > 0) {
            return MAccount.get((Properties)m_Invoice.getCtx(), (int)m_ContractTaxAcct.getT_Credit_Acct());
        }
        DocTax docTax = new DocTax(m_InvoiceTax.getC_Tax_ID(), "", Env.ZERO, Env.ZERO, Env.ZERO, m_Invoice.isSOTrx());
        return docTax.getAccount(1, m_AcctSchema);
    }

    private MAccount getJP_GL_TaxExpense_Acct(MInvoice m_Invoice, MInvoiceTax m_InvoiceTax, MContractAcct m_ContractAcct, MAcctSchema m_AcctSchema) {
        MContractTaxAcct m_ContractTaxAcct = m_ContractAcct.getContracTaxAcct(m_InvoiceTax.getC_Tax_ID(), m_AcctSchema.getC_AcctSchema_ID(), false);
        if (m_ContractTaxAcct == null) {
            return null;
        }
        int JP_GL_TaxExpense_Acct = m_ContractTaxAcct.getJP_GL_TaxExpense_Acct();
        if (JP_GL_TaxExpense_Acct == 0) {
            return null;
        }
        return MAccount.get((Properties)m_Invoice.getCtx(), (int)JP_GL_TaxExpense_Acct);
    }

    private MAccount getT_TaxExpense_Acct(MInvoice m_Invoice, MInvoiceTax m_InvoiceTax, MContractAcct m_ContractAcct, MAcctSchema m_AcctSchema) {
        MContractTaxAcct m_ContractTaxAcct = m_ContractAcct.getContracTaxAcct(m_InvoiceTax.getC_Tax_ID(), m_AcctSchema.getC_AcctSchema_ID(), false);
        if (m_ContractTaxAcct != null && m_ContractTaxAcct.getT_Expense_Acct() > 0) {
            return MAccount.get((Properties)m_Invoice.getCtx(), (int)m_ContractTaxAcct.getT_Expense_Acct());
        }
        DocTax docTax = new DocTax(m_InvoiceTax.getC_Tax_ID(), "", Env.ZERO, Env.ZERO, Env.ZERO, m_Invoice.isSOTrx());
        return docTax.getAccount(2, m_AcctSchema);
    }

    private ProductCost getProductCost(MInvoiceLine m_InvoiceLine) {
        ProductCost m_productCost = new ProductCost(Env.getCtx(), m_InvoiceLine.getM_Product_ID(), m_InvoiceLine.getM_AttributeSetInstance_ID(), m_InvoiceLine.get_TrxName());
        return m_productCost;
    }
}

